# Release Notes

## [Preview Release 5.2.0-preview1.23109.1] - 2023-04-20

This update brings the below changes over the previous release:

### Contributors
Thanks to the following public contributors. Their efforts toward this project are very much appreciated.
- [Wraith2](https://github.com/Wraith2)
- [ErikEJ](https://github.com/ErikEJ)
- [kant2002](https://github.com/kant2002)
- [mattjohnsonpint](https://github.com/mattjohnsonpint)

### Added

- Added support of `SqlDiagnosticListener` on **.NET Standard**. [#1931](https://github.com/dotnet/SqlClient/pull/1931)

### Fixed

- Fixed AE enclave retry logic for async queries. [#1988](https://github.com/dotnet/SqlClient/pull/1988)
- Fixed activity correlator to continue use of same GUID for connection activity. [#1997](https://github.com/dotnet/SqlClient/pull/1997)
- Fixed behavior when error class is greater than 20 on connection retry. [#1953](https://github.com/dotnet/SqlClient/pull/1953)
- Fixed error message when symmetric key decryption failed using Always Encrypted. [#1948](https://github.com/dotnet/SqlClient/pull/1948)
- Fixed TransactionScope connection issue when Enlist is enable, Pooling is disabled and network connection type is Redirect. [#1960](https://github.com/dotnet/SqlClient/pull/1960)
- Fixed TDS RPC error on large queries in SqlCommand.ExecuteReaderAsync. [#1936](https://github.com/dotnet/SqlClient/pull/1936)
- Fixed throttling of token requests by calling AcquireTokenSilent. [#1925](https://github.com/dotnet/SqlClient/pull/1925)
- Fixed Linux code coverage result in Build proj. [#1950](https://github.com/dotnet/SqlClient/pull/1950)
- Fixed NullReferenceException in GetBytesAsync. [#1906](https://github.com/dotnet/SqlClient/pull/1906)
- Fixed Transient fault handling issue with OpenAsync. [#1983](https://github.com/dotnet/SqlClient/pull/1983)
- Fixed invariant mode checks. [#1917](https://github.com/dotnet/SqlClient/pull/1917)
- Fixed GC behavior in TdsParser by adding array rental capability in TryReadPlpUnicodeChars. [#1866](https://github.com/dotnet/SqlClient/pull/1866)

### Changed

- Updated Azure Identity version from 1.7.0 to 1.8.0. [#1921](https://github.com/dotnet/SqlClient/pull/1921)
- Improved parsing buffered characters in `TdsParser`. [#1544](https://github.com/dotnet/SqlClient/pull/1544)
- Removed reference to Microsoft.Win32.Registry since it's shipped starting with .NET 6.0. [#1974](https://github.com/dotnet/SqlClient/pull/1974)
- Added Microsoft.SqlServer.Types to verify support for SqlHierarchyId and Spatial for .NET Core. [#1848](https://github.com/dotnet/SqlClient/pull/1848)
- Code health improvements:[#1943](https://github.com/dotnet/SqlClient/pull/1943)[#1949](https://github.com/dotnet/SqlClient/pull/1949)[#1198](https://github.com/dotnet/SqlClient/pull/1198)[#1829](https://github.com/dotnet/SqlClient/pull/1829)

## Target Platform Support

- .NET Framework 4.6.2+ (Windows x86, Windows x64)
- .NET 6.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 5.1.0
- Azure.Identity 1.8.0
- Microsoft.Identity.Client 4.47.2
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.IO 4.3.0
- System.Runtime.InteropServices.RuntimeInformation 4.3.0
- System.Security.Cryptography.Algorithms 4.3.1
- System.Security.Cryptography.Primitives 4.3.0
- System.Text.Encoding.Web 6.0.0

#### .NET

- Microsoft.Data.SqlClient.SNI 5.1.0
- Azure.Identity 1.8.0
- Microsoft.Identity.Client 4.47.2
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- Microsoft.SqlServer.Server 1.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.Diagnostics.DiagnosticSource 6.0.0
- System.IO 4.3.0
- System.Runtime.Caching 6.0.0
- System.Text.Encoding.CodePages 6.0.0
- System.Text.Encodings.Web 6.0.0
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI 5.1.0
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.47.2
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.IO 4.3.0
- System.Runtime.Caching 6.0.0
- System.Text.Encoding.CodePages 6.0.0
- System.Text.Encodings.Web 6.0.0
- System.Runtime.Loader 4.3.0
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0
