# Release Notes

## Microsoft.Data.SqlClient.AlwaysEncrypted.AzureKeyVaultProvider
_**1.0.0-preview1.19295.2 released 22 October 2019**_

### Fixed

- Fixed missing NuGet package dependency on Microsoft.Data.SqlClient and updated maximum version attribute for other dependencies.

_**1.0.0-preview1.19292.1 released 18 October 2019**_

This is the initial public preview release of the new Microsoft.Data.SqlClient.AlwaysEncrypted.AzureKeyVaultProvider namespace. This library contains the implementation of `Microsoft.Data.SqlClient.SqlColumnEncryptionKeyStoreProvider` for accessing Azure Key Vault, and the provider class is named as `SqlColumnEncryptionAzureKeyVaultProvider`.

### Working with SQLColumnEncryptionAzureKeyVaultProvider
`SqlColumnEncryptionAzureKeyVaultProvider` is implemented for `Microsoft.Data.SqlClient` driver and supports .NET Framework 4.6+ and .NET Core 2.1+. This provider name identifier for this library is "**AZURE_KEY_VAULT**" and it is not registered in driver by default. Client applications must call `SqlConnection.RegisterColumnEncryptionKeyStoreProviders()` API only once in the lifetime of driver to register this custom provider by implementing a custom Authentication Callback mechanism.

Once the provider is registered, it can used to perform Always Encrypted operations by creating Column Master Key using Azure Key Vault Key Identifier URL.

A sample C# application to demonstrate Always Encrypted with Azure Key Vault can be download from samples directory: [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/master/doc/samples/AzureKeyVaultProviderExample.cs)


## Target Platform Support

- .NET Framework 4.6+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Azure.KeyVault 3.0.4
- Microsoft.Azure.KeyVault.WebKey 3.0.4
- Microsoft.Data.SqlClient 1.0.19269.1
- Microsoft.Rest.ClientRuntime 2.3.20
- Microsoft.Rest.ClientRuntime.Azure 3.3.19

#### .NET Core

- Microsoft.Azure.KeyVault 3.0.4
- Microsoft.Azure.KeyVault.WebKey 3.0.4
- Microsoft.Data.SqlClient 1.0.19269.1
- Microsoft.Rest.ClientRuntime 2.3.20
- Microsoft.Rest.ClientRuntime.Azure 3.3.19
