# Release Notes

## General Availability of Microsoft.Data.SqlClient.AlwaysEncrypted.AzureKeyVaultProvider
_**1.0.0 released 19 November 2019**_

This is the initial public stable release of the new Microsoft.Data.SqlClient.AlwaysEncrypted.AzureKeyVaultProvider namespace. This library contains the implementation of `Microsoft.Data.SqlClient.SqlColumnEncryptionKeyStoreProvider` for accessing Azure Key Vault, and the provider class is named `SqlColumnEncryptionAzureKeyVaultProvider`.

### Working with SQLColumnEncryptionAzureKeyVaultProvider
`SqlColumnEncryptionAzureKeyVaultProvider` is implemented against `Microsoft.Data.SqlClient` and supports .NET Framework 4.6+ and .NET Core 2.1+. The provider name identifier for this library is "**AZURE_KEY_VAULT**" and it is not registered in the driver by default. Client applications may call the `SqlConnection.RegisterColumnEncryptionKeyStoreProviders()` API once in the lifetime of the driver to register this custom provider by implementing a custom Authentication Callback mechanism.

Once the provider is registered, it can used to perform Always Encrypted operations by creating a Column Master Key using the Azure Key Vault Key Identifier URL.

A sample C# application to demonstrate Always Encrypted with Azure Key Vault can be download from the samples directory: [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/master/doc/samples/AzureKeyVaultProviderExample.cs)

## Target Platform Support

- .NET Framework 4.6+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Azure.KeyVault 3.0.4
- Microsoft.Azure.KeyVault.WebKey 3.0.4
- Microsoft.Data.SqlClient 1.0.19269.1
- Microsoft.Rest.ClientRuntime 2.3.20
- Microsoft.Rest.ClientRuntime.Azure 3.3.19

#### .NET Core

- Microsoft.Azure.KeyVault 3.0.4
- Microsoft.Azure.KeyVault.WebKey 3.0.4
- Microsoft.Data.SqlClient 1.0.19269.1
- Microsoft.Rest.ClientRuntime 2.3.20
- Microsoft.Rest.ClientRuntime.Azure 3.3.19
