# Release Notes

## General Availability of Microsoft.Data.SqlClient.AlwaysEncrypted.AzureKeyVaultProvider
_**1.2.0 released 01 December 2020**_

This library contains the implementation of `Microsoft.Data.SqlClient.SqlColumnEncryptionKeyStoreProvider` for accessing Azure Key Vault, and the provider class is named `SqlColumnEncryptionAzureKeyVaultProvider`.

### Added

- Added support for .NET Standard 2.0. This requires Microsoft.Data.SqlClient v2.1.0 and above. [#823](https://github.com/dotnet/SqlClient/pull/823)
- Added new HSM endpoints. [#750](https://github.com/dotnet/SqlClient/pull/750)
- Added source linked PDBs for easier debugging of the package. [#789](https://github.com/dotnet/SqlClient/pull/789)

### Working with SQLColumnEncryptionAzureKeyVaultProvider
`SqlColumnEncryptionAzureKeyVaultProvider` is implemented against `Microsoft.Data.SqlClient` and supports .NET Framework 4.6+, .NET Core 2.1+, and .NET Standard 2.0+. The provider name identifier for this library is "**AZURE_KEY_VAULT**" and it is not registered in the driver by default. Client applications may call the `SqlConnection.RegisterColumnEncryptionKeyStoreProviders()` API once in the lifetime of the driver to register this custom provider by implementing a custom Authentication Callback mechanism.

Once the provider is registered, it can be used to perform Always Encrypted operations by creating a Column Master Key using the Azure Key Vault Key Identifier URL.

A sample C# application to demonstrate Always Encrypted with Azure Key Vault can be download from the samples directory: [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/master/doc/samples/AzureKeyVaultProviderExample.cs)

## Target Platform Support

- .NET Framework 4.6+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
- .NET Standard 2.0+

### Dependencies

#### .NET Framework

- Microsoft.Azure.KeyVault 3.0.4
- Microsoft.Azure.KeyVault.WebKey 3.0.4
- Microsoft.Data.SqlClient 1.0.19269.1
- Microsoft.Rest.ClientRuntime 2.3.20
- Microsoft.Rest.ClientRuntime.Azure 3.3.19

#### .NET Core

- Microsoft.Azure.KeyVault 3.0.4
- Microsoft.Azure.KeyVault.WebKey 3.0.4
- Microsoft.Data.SqlClient 1.0.19269.1
- Microsoft.Rest.ClientRuntime 2.3.20
- Microsoft.Rest.ClientRuntime.Azure 3.3.19

#### .NET Standard

- Microsoft.Azure.KeyVault 3.0.4
- Microsoft.Azure.KeyVault.WebKey 3.0.4
- Microsoft.Data.SqlClient 2.1.0
- Microsoft.Rest.ClientRuntime 2.3.20
- Microsoft.Rest.ClientRuntime.Azure 3.3.19
