# Release Notes

## General Availability of Microsoft.Data.SqlClient.AlwaysEncrypted.AzureKeyVaultProvider

_**3.0.0 released 14 June 2021**_

This library contains the implementation of `Microsoft.Data.SqlClient.SqlColumnEncryptionKeyStoreProvider` for accessing Azure Key Vault, and the provider class is named `SqlColumnEncryptionAzureKeyVaultProvider`.

### Added

- Introduces column encryption key caching support [#1056](https://github.com/dotnet/SqlClient/pull/1056)

### Breaking Changes

- Microsoft.Data.SqlClient dependency version upgraded to **v3.0.0+** [#1111](https://github.com/dotnet/SqlClient/pull/1111)

### Working with SQLColumnEncryptionAzureKeyVaultProvider

`SqlColumnEncryptionAzureKeyVaultProvider` **v3.0** is implemented against `Microsoft.Data.SqlClient` **v3.0** and supports .NET Framework 4.6.1+, .NET Core 2.1+, and .NET Standard 2.0+. The provider name identifier for this library is "**AZURE_KEY_VAULT**" and it is not registered in the driver by default. Client applications may initialize this provider by providing an `Azure.Core.TokenCredential` and registering it with the driver using any of the below APIs:

- [SqlConnection.RegisterColumnEncryptionKeyStoreProviders](https://docs.microsoft.com/dotnet/api/microsoft.data.sqlclient.sqlconnection.registercolumnencryptionkeystoreproviders?view=sqlclient-dotnet-3.0)
- [SqlConnection.RegisterColumnEncryptionKeyStoreProvidersOnConnection](https://docs.microsoft.com/dotnet/api/microsoft.data.sqlclient.sqlconnection.registercolumnencryptionkeystoreprovidersonconnection?view=sqlclient-dotnet-3.0) (Added in version 3.0.0)
- [SqlCommand.RegisterColumnEncryptionKeyStoreProvidersOnCommand](https://docs.microsoft.com/dotnet/api/microsoft.data.sqlclient.sqlcommand.registercolumnencryptionkeystoreprovidersoncommand?view=sqlclient-dotnet-3.0) (Added in version 3.0.0)

Once the provider is registered, it can be used to perform Always Encrypted operations by creating a Column Master Key using the Azure Key Vault Key Identifier URL.

The linked C# samples below demonstrate using Always Encrypted with secure enclaves with Azure Key Vault:

- Legacy API support (Always Encrypted): [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/AzureKeyVaultProviderLegacyExample_2_0.cs)
- New API support (Always Encrypted): [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/AzureKeyVaultProviderExample_2_0.cs)
- Legacy API support (Always Encrypted with secure enclaves): [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/doc\samples\AzureKeyVaultProviderWithEnclaveProviderExample.cs)
- New API support (Always Encrypted with secure enclaves): [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/doc\samples\AzureKeyVaultProviderWithEnclaveProviderExample_2_0.cs)
- Column Encryption Key cache scope example: [AzureKeyVaultProvider_ColumnEncryptionKeyCacheScope.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/AzureKeyVaultProvider_ColumnEncryptionKeyCacheScope.cs)
- Registering custom key store provider - Connection Precedence: [RegisterCustomKeyStoreProvider_ConnectionPrecedence.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/RegisterCustomKeyStoreProvider_ConnectionPrecedence.cs)
- Registering custom key store provider - Command Precedence: [RegisterCustomKeyStoreProvider_CommandPrecedence.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/RegisterCustomKeyStoreProvider_CommandPrecedence.cs)

For further details, refer to [Using the Azure Key Vault provider](https://docs.microsoft.com/sql/connect/ado-net/sql/sqlclient-support-always-encrypted#using-the-azure-key-vault-provider)

## Target Platform Support

- .NET Framework 4.6.1+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
- .NET Standard 2.0+

### Dependencies

#### .NET Framework

- Azure.Core 1.6.0
- Azure.Security.KeyVault.Keys 4.0.3
- Microsoft.Data.SqlClient 3.0.0
- System.Text.Encodings.Web 4.7.2
- Microsoft.Extensions.Caching.Memory 5.0.0

#### .NET Core

- Azure.Core 1.6.0
- Azure.Security.KeyVault.Keys 4.0.3
- Microsoft.Data.SqlClient 3.0.0
- System.Text.Encodings.Web 4.7.2
- Microsoft.Extensions.Caching.Memory 5.0.0

#### .NET Standard

- Azure.Core 1.6.0
- Azure.Security.KeyVault.Keys 4.0.3
- Microsoft.Data.SqlClient 3.0.0
- System.Text.Encodings.Web 4.7.2
- Microsoft.Extensions.Caching.Memory 5.0.0
