# Licensed to the .NET Foundation under one or more agreements.
# The .NET Foundation licenses this file to you under the MIT license.
# See the LICENSE file in the project root for more information.
# Script: GenerateResourceStringsSource.ps1
# Author: Keerat Singh
# Date:   25-Jan-2019
# Comments: This Reads the resources from the resx file and converts them
# into strongly typed const strings
#

param(
    [Parameter(Mandatory=$true)]
    [string]$ResxFileDir,
    [Parameter(Mandatory=$true)]
    [string]$ResxFileName,
    [Parameter(Mandatory=$true)]
    [string]$OutputPath,
    [string]$GeneratedSourceFileName
    )

# Read the resx file
$XmlFilePath = "${ResxFileDir}${ResxFileName}.resx"
[xml]$XmlDocument  = Get-Content -Path "$XmlFilePath"

# Initial content for the Source File.
$GeneratedSourceFileContent= "
//------------------------------------------------------------------------------
//     This code was auto-generated by msbuild target.
//     Changes to this file may cause incorrect behavior and will be lost if the code is regenerated.
//------------------------------------------------------------------------------

using System;
using System.Globalization;
using System.Resources;
using System.Threading;
    
namespace Microsoft.Data
{
    internal partial class StringsHelper : $ResxFileName
    {
        internal class ResourceNames
        {`n"
ForEach($node in $XmlDocument.root.data)
{
    $ResourceName = $node.name
    # Escape the Double Quotes in the resource string value.
    $ResourceValue = $node.value -replace '"','""'
    # Convert Resource Name and Value to internal const string
    $GeneratedSourceFileContent= $GeneratedSourceFileContent + "          internal const string $ResourceName = @`"$ResourceValue`";`n"
}

$GeneratedSourceFileContent= $GeneratedSourceFileContent +  "        }`n}`n}"

# Output to File
$GeneratedSourceFileContent | Out-File "${OutputPath}${GeneratedSourceFileName}"