<img src="https://gw.alipayobjects.com/zos/k/1n/skNlgh.jpg" width="800" />  

<small>封面图为家里汤圆的新窝，最近老喜欢躺在「JavaScript 权威指南」上睡觉，看来也想写前端。</small>  

> **记录每周看到的前端潮流技术，筛选后用接地气方式发布于此~**  

## 前端技术

**使用 Whistle 作为你的 Web 调试工具**  
<https://zhuanlan.zhihu.com/p/79037633>  
替代 Charles 调试的一个好工具，而且时开源的，看看这篇文章他怎么使用的。

**常识性概念图谱建设以及在美团场景中的应用**  
<https://tech.meituan.com/2021/06/24/nature-language-process-nlp-knowledge-graph.html>  
帮助机器做好自然语言文本的理解工作，建立知识体系则是一种直接的方式，能够帮助自然语言理解得更准确。

**一文了解 AsyncHooks**  
<https://mp.weixin.qq.com/s/08AVmJLMdMNm4yNWQwk-DA>  
好吧，这个特性我第一次看到，「async_hooks 模块提供了用于跟踪异步资源的 API」。

**手写简易浏览器 - html parser 篇**  
<https://mp.weixin.qq.com/s/ku6yNZqIKH9wBSGbUdhW0A>  
先不看，假如让你写一个简单的 html parser 转换器，你怎么写？

## 潮流开源

**fzf：命令行模糊查找器**  
<https://github.com/junegunn/fzf>  
<img src="https://cdn.fliggy.com/upic/VO9evM.jpg" width="800" />  

**lowdb：小项目用的微型数据库**  
<https://github.com/typicode/lowdb>  
支持浏览器、Node、Electron，超级轻量直接用 JSON 的方式。

```js
import { join } from 'path';
import { Low, JSONFile } from 'lowdb';
const file = join(__dirname, 'db.json');
const adapter = new JSONFile(file);
const db = new Low(adapter);

await db.read();

db.data ||= { posts: [] };

db.data.posts.push('hello world');
db.data.posts[0];

const { posts } = db.data;
posts.push('hello world');

await db.write();
```

**sucrase：超快的 babel 可替换工具**  
<https://github.com/alangpierce/sucrase>  
提升本地开发构建速度的工具，还有一个新工具[snowpackjs/astro](https://github.com/snowpackjs/astro)也可以试试。

<img src="https://cdn.fliggy.com/upic/wRqFqh.jpg" width="800" />  

**rustdesk：另一个远程桌面软件**  
<https://github.com/rustdesk/rustdesk>  
开箱即用的远程桌面软件，无需任何配置，替代 TeamViewer 和 AnyDesk。

**Node Cli 开发最佳实践**  
<https://github.com/lirantal/nodejs-cli-apps-best-practices>  
对于写工具的同学，可以将里面的一个建议给看看。

## 他山之石

**把毛选和鲁迅全集喂给 AI 后，写出来的高考作文太对味**  
<https://zhuanlan.zhihu.com/p/384410563>  
鲁迅写的文章关我周树人什么事情？

**SHEIN：长期主义的胜利**  
<https://www.huxiu.com/article/437382.html>  
本文将从流量、供应链和管理三个维度出发，对 SHEIN 做一次深度解读。

**帮 UI 设计师极大提升效率的 10 款 Figma 插件**  
<https://www.uisdc.com/10-figma-plugins-save-time>  
「飞个马」这个工具不少人都说很好用，当时我学习了下还是习惯 sketch，可能还是不习惯的缘故。

**互动营销类产品有哪些动效超好用？**  
**https://www.uisdc.com/marketing-dynamic-effect**  
挺好看的，结合业务用途的方式来弄动效设计。
