<img src="https://gw.alipayobjects.com/zos/k/w3/GOoYKt.jpg" width="800" />  

<small>封面图摄于乌鲁木齐红山公园，那天阳光很大，红字超级清晰，对于开发工程师而言，你的初心是啥？</small>  

> **记录每周看到的接地气的前端潮流技术，筛选后发布于此，觉得不错可关注此专栏，方便获取更新通知**  

## 前端技术

**高频 Linux 命令大总结，可以记住**  
<https://segmentfault.com/a/1190000040222932>  
很是不错，我特地练习了一遍辅助记录，有必要记住常用的，毕竟不少和 Mac 互通，不过遇到那种开机关机的就可以不要试了。

**利用机器学习通过网页预提取技术加快网站加载速度**  
<https://mp.weixin.qq.com/s/S1Yg6wiYkK2lN-5aTp2dqQ>  
这个思路好，感觉可以应用到我们的一些场景中，而且还很潮流。

**手把手教你设计一个任务调度器**  
<https://mp.weixin.qq.com/s/O6fAOodJq6pyJnqy1IuqEg>  
这篇文章从业务现状出发，考虑需要覆盖的场景，设计调度器需要提供的角色。 然后确定了调度器的关键接口，同时给出了简单实现。

**深入了解现代浏览器**  
<https://mp.weixin.qq.com/s/XN9wUM-FdWbE1m66jkEgIg>  
是一个合集中的最后一篇，可以在尾部看到其他几篇的链接。

**CSS ::marker 让文字序号更有意思**  
<https://segmentfault.com/a/1190000040175019>  
越来越觉得，随着 JS 框架越用越久，普遍很多同学不太 care css 的一个好玩的东西。

## 潮流开源

**DoraemonKit：泛前端产品研发全生命周期的工具**  
<https://github.com/didi/DoraemonKit>  
个人觉得这个介绍不是很好，可以理解成 App 上测试版本的开发调试小工具。  
<img src="https://cdn.fliggy.com/upic/tx4GIQ.jpg" width="800" />  

**vuejs/petite-vue：用于渐进增强的只有 5k 的 Vue**  
<https://github.com/vuejs/petite-vue>  
感觉这个思路很潮流，很适合开发一些小页面，让你回到当时 jquery 的体验，一把梭，看代码你就懂了。

```html
<body>  
  <script src="https://unpkg.com/petite-vue" defer init></script>  
  <div v-scope="{ count: 0 }">  
    <button @click="count--">-</button>  
    <span>{{ count }}</span>  
    <button @click="count++">+</button>  
  </div>  
</body>  
```

**solid：声明式的 UI 框架**  
<https://github.com/solidjs/solid>  
这样的写法：

```jsx
const _tmpl$ = template(`<div>Hello </div>`);

const HelloMessage = (props) => {
  const _el$ = _tmpl$.cloneNode(true);
  insert(_el$, () => props.name);
  return _el$;
};

render(
  () => createComponent(HelloMessage, { name: 'Taylor' }),
  document.getElementById('hello-example'),
);
```

**tiptap：面向 Web 工程师的无头编辑器**  
<https://github.com/ueberdosis/tiptap>  
支持主流的语言框架，效果还是挺好的。  
<img src="https://cdn.fliggy.com/upic/V5cCTX.jpg" width="800" />  

**MonitorControl：在 Mac 上控制外部显示器的亮度和音量**  
<https://github.com/MonitorControl/MonitorControl>  
一条命令就安装好了。

```shell
brew install --cask monitorcontrol
```

## 他山之石

**写给 Node 开发同学看的 Rust 介绍**  
<https://itnext.io/deep-dive-into-rust-for-node-js-developers-5faace6dc71f>  
英文版本，不过代入 Node 其实笔记好理解。

**在 iOS 客户端上通过 bitcode 为第三方库修复 bug**  
<https://mp.weixin.qq.com/s/BuDnfl1ZbUtiZBhy8_Z7wA>  
本文主要记录了 iOS 移动端的一个疑难 bug 的排查过程，以及介绍通过给 bitcode 打补丁重新生成机器码，为有问题的第三方库修复 bug 的方法。

**如今的飞机餐，为什么变得越来越难吃了？**  
<https://www.huxiu.com/article/440281.html>  
我也觉得，想起鸡肉饭和牛肉面来了。看这个的解释[你吃过哪些难吃的飞机餐？](https://www.zhihu.com/question/35768349)

**工业和信息化部大力推进 APP 开屏弹窗信息骚扰用户问题整治**  
<https://www.miit.gov.cn/xwdt/gxdt/sjdt/art/2021/art_71269fd7c4de4182836e4ddf1863ad30.html>  
传说中的社会主义的铁拳，期待我这篇 [为啥国内两年前的 APP 这么好用？](https://zhuanlan.zhihu.com/p/384811471)成为过去式。

**为什么要使用 Go 语言？Go 语言的优势在哪里？**  
<https://www.zhihu.com/question/21409296>  
最近想学习一个新语言，可能会是 GO。
