# Sending events to Splunk from Auth0

[Splunk](http://splunk.com) provides a platform to easily get insights into all the information generated by your IT infrastructure.

This example shows how you can very easily connect Auth0 to __Splunk__ and stream `signup` and `login` events with user contextual information.

Implementing this with Auth0 is very easy, only taking a few lines of code.

![](https://docs.google.com/drawings/d/14L8PGy6obMZEvTgyzZOGsjW_sdEjTd_Vvrs0TPIkL6c/pub?w=833&amp;h=372)

### 1. Recording a __SignUp__ or __Login__ event in Splunk:

This Auth0 rule uses the [Splunk REST API](http://dev.splunk.com/view/rest-api-overview/SP-CAAADP8) to record `signup` and `login` events from users to your apps. This is tracked with the `user.signedUp` property. If the property is present then we assume this is a `login` event, otherwise we assume a new `signup`.

You can send any number of properties. This sample sends contextual information like the user IP address (can be used for location), the application, username, etc.

Splunk's API supports basic & token based auth. For simplicity, we use basic auth, with credentials in the rule. You can store these credentials securely in Auth0 using standard settings on the dashbaord.

When enabled, this rule will start sending events that will show up on Splunk's dashboard:

![](/media/articles/scenarios/splunk/splunk-dashbaord.png)

```
function(user, context, callback) {

  var splunkBaseUrl = 'YOUR SPLUNK SERVER, like: https://your server:8089';

  //Add any interesting info to the event
  var event = {
    message: user.signedUp ? 'Login' : 'SignUp',
    application: context.clientName,
    clientIP: context.request.ip,
    protocol: context.protocol,
    userName: user.name,
    userId: user.user_id
  };

  request.post( {
                  url: splunkBaseUrl + '/services/receivers/simple?source=auth0&sourcetype=auth0_activity',
                  auth: {
                      'user': 'YOUR SPLUNK USER',
                      'pass': 'YOUR SPLUNK PASSWORD',
                    },
                  body: JSON.stringify(event)
                },
                function(e,r,b) {
                    if( e ) { return callback(e) };
                    if( r.statusCode !== 200 ) return callback('Invalid operation');
                    if( !user.signedUp ) { persistent.signedUp = true }; //Signal signup for next time
                    return callback(e,user,context);
                 });
}
```
> Notice that if all calls are successful, we signal the user as signed up. So next time we record `login`.

Check out our [repository of Auth0 Rules](https://github.com/auth0/rules) for more great examples:

* Rules for access control
* Integration with other services: [Firebase](http://firebase.com), [Rapleaf](http://rapleaf.com), [Parse](http://parse.com)
