package curves

import "github.com/genshinsim/gcsim/pkg/core"

type WeaponBase struct {
	AtkCurve         WeaponStatCurve
	SpecializedCurve WeaponStatCurve
	BaseAtk          float64
	BaseSpecialized  float64
	Specialized      core.StatType
	PromotionBonus   []PromoData
}

// WeaponStatGrowthMult provide multiplier for each lvl with 0 being lvl 1 (up to 100)
var WeaponStatGrowthMult = []map[WeaponStatCurve]float64{
	{
		GROW_CURVE_ATTACK_101:   1,
		GROW_CURVE_ATTACK_102:   1,
		GROW_CURVE_ATTACK_103:   1,
		GROW_CURVE_ATTACK_104:   1,
		GROW_CURVE_ATTACK_105:   1,
		GROW_CURVE_CRITICAL_101: 1,
		GROW_CURVE_ATTACK_201:   1,
		GROW_CURVE_ATTACK_202:   1,
		GROW_CURVE_ATTACK_203:   1,
		GROW_CURVE_ATTACK_204:   1,
		GROW_CURVE_ATTACK_205:   1,
		GROW_CURVE_CRITICAL_201: 1,
		GROW_CURVE_ATTACK_301:   1,
		GROW_CURVE_ATTACK_302:   1,
		GROW_CURVE_ATTACK_303:   1,
		GROW_CURVE_ATTACK_304:   1,
		GROW_CURVE_ATTACK_305:   1,
		GROW_CURVE_CRITICAL_301: 1,
	},
	{
		GROW_CURVE_ATTACK_101:   1.0759999752044678,
		GROW_CURVE_ATTACK_102:   1.0809999704360962,
		GROW_CURVE_ATTACK_103:   1.0859999656677246,
		GROW_CURVE_ATTACK_104:   1.0709999799728394,
		GROW_CURVE_ATTACK_105:   1.065000057220459,
		GROW_CURVE_CRITICAL_101: 1,
		GROW_CURVE_ATTACK_201:   1.0829999446868896,
		GROW_CURVE_ATTACK_202:   1.0880000591278076,
		GROW_CURVE_ATTACK_203:   1.093000054359436,
		GROW_CURVE_ATTACK_204:   1.0770000219345093,
		GROW_CURVE_ATTACK_205:   1.0709999799728394,
		GROW_CURVE_CRITICAL_201: 1,
		GROW_CURVE_ATTACK_301:   1.0859999656677246,
		GROW_CURVE_ATTACK_302:   1.090999960899353,
		GROW_CURVE_ATTACK_303:   1.097000002861023,
		GROW_CURVE_ATTACK_304:   1.0789999961853027,
		GROW_CURVE_ATTACK_305:   1.0729999542236328,
		GROW_CURVE_CRITICAL_301: 1,
	},
	{
		GROW_CURVE_ATTACK_101:   1.1519999504089355,
		GROW_CURVE_ATTACK_102:   1.1619999408721924,
		GROW_CURVE_ATTACK_103:   1.1720000505447388,
		GROW_CURVE_ATTACK_104:   1.1410000324249268,
		GROW_CURVE_ATTACK_105:   1.128999948501587,
		GROW_CURVE_CRITICAL_101: 1,
		GROW_CURVE_ATTACK_201:   1.1649999618530273,
		GROW_CURVE_ATTACK_202:   1.1759999990463257,
		GROW_CURVE_ATTACK_203:   1.1859999895095825,
		GROW_CURVE_ATTACK_204:   1.1540000438690186,
		GROW_CURVE_ATTACK_205:   1.1410000324249268,
		GROW_CURVE_CRITICAL_201: 1,
		GROW_CURVE_ATTACK_301:   1.1710000038146973,
		GROW_CURVE_ATTACK_302:   1.1829999685287476,
		GROW_CURVE_ATTACK_303:   1.194000005722046,
		GROW_CURVE_ATTACK_304:   1.159000039100647,
		GROW_CURVE_ATTACK_305:   1.1449999809265137,
		GROW_CURVE_CRITICAL_301: 1,
	},
	{
		GROW_CURVE_ATTACK_101:   1.2280000448226929,
		GROW_CURVE_ATTACK_102:   1.24399995803833,
		GROW_CURVE_ATTACK_103:   1.2589999437332153,
		GROW_CURVE_ATTACK_104:   1.2109999656677246,
		GROW_CURVE_ATTACK_105:   1.1929999589920044,
		GROW_CURVE_CRITICAL_101: 1,
		GROW_CURVE_ATTACK_201:   1.2480000257492065,
		GROW_CURVE_ATTACK_202:   1.2640000581741333,
		GROW_CURVE_ATTACK_203:   1.2799999713897705,
		GROW_CURVE_ATTACK_204:   1.2300000190734863,
		GROW_CURVE_ATTACK_205:   1.2109999656677246,
		GROW_CURVE_CRITICAL_201: 1,
		GROW_CURVE_ATTACK_301:   1.2569999694824219,
		GROW_CURVE_ATTACK_302:   1.274999976158142,
		GROW_CURVE_ATTACK_303:   1.2920000553131104,
		GROW_CURVE_ATTACK_304:   1.2380000352859497,
		GROW_CURVE_ATTACK_305:   1.2170000076293945,
		GROW_CURVE_CRITICAL_301: 1,
	},
	{
		GROW_CURVE_ATTACK_101:   1.3029999732971191,
		GROW_CURVE_ATTACK_102:   1.3250000476837158,
		GROW_CURVE_ATTACK_103:   1.3459999561309814,
		GROW_CURVE_ATTACK_104:   1.2799999713897705,
		GROW_CURVE_ATTACK_105:   1.2549999952316284,
		GROW_CURVE_CRITICAL_101: 1.1619999408721924,
		GROW_CURVE_ATTACK_201:   1.3300000429153442,
		GROW_CURVE_ATTACK_202:   1.3530000448226929,
		GROW_CURVE_ATTACK_203:   1.3739999532699585,
		GROW_CURVE_ATTACK_204:   1.305999994277954,
		GROW_CURVE_ATTACK_205:   1.2799999713897705,
		GROW_CURVE_CRITICAL_201: 1.1619999408721924,
		GROW_CURVE_ATTACK_301:   1.343000054359436,
		GROW_CURVE_ATTACK_302:   1.3680000305175781,
		GROW_CURVE_ATTACK_303:   1.3910000324249268,
		GROW_CURVE_ATTACK_304:   1.3170000314712524,
		GROW_CURVE_ATTACK_305:   1.2879999876022339,
		GROW_CURVE_CRITICAL_301: 1.1619999408721924,
	},
	{
		GROW_CURVE_ATTACK_101:   1.378999948501587,
		GROW_CURVE_ATTACK_102:   1.406999945640564,
		GROW_CURVE_ATTACK_103:   1.4329999685287476,
		GROW_CURVE_ATTACK_104:   1.3489999771118164,
		GROW_CURVE_ATTACK_105:   1.3170000314712524,
		GROW_CURVE_CRITICAL_101: 1.1619999408721924,
		GROW_CURVE_ATTACK_201:   1.4129999876022339,
		GROW_CURVE_ATTACK_202:   1.4420000314712524,
		GROW_CURVE_ATTACK_203:   1.468999981880188,
		GROW_CURVE_ATTACK_204:   1.3819999694824219,
		GROW_CURVE_ATTACK_205:   1.3489999771118164,
		GROW_CURVE_CRITICAL_201: 1.1619999408721924,
		GROW_CURVE_ATTACK_301:   1.4290000200271606,
		GROW_CURVE_ATTACK_302:   1.4609999656677246,
		GROW_CURVE_ATTACK_303:   1.4900000095367432,
		GROW_CURVE_ATTACK_304:   1.3949999809265137,
		GROW_CURVE_ATTACK_305:   1.3589999675750732,
		GROW_CURVE_CRITICAL_301: 1.1619999408721924,
	},
	{
		GROW_CURVE_ATTACK_101:   1.4539999961853027,
		GROW_CURVE_ATTACK_102:   1.4889999628067017,
		GROW_CURVE_ATTACK_103:   1.5210000276565552,
		GROW_CURVE_ATTACK_104:   1.4170000553131104,
		GROW_CURVE_ATTACK_105:   1.378999948501587,
		GROW_CURVE_CRITICAL_101: 1.1619999408721924,
		GROW_CURVE_ATTACK_201:   1.4950000047683716,
		GROW_CURVE_ATTACK_202:   1.531000018119812,
		GROW_CURVE_ATTACK_203:   1.565000057220459,
		GROW_CURVE_ATTACK_204:   1.4570000171661377,
		GROW_CURVE_ATTACK_205:   1.4170000553131104,
		GROW_CURVE_CRITICAL_201: 1.1619999408721924,
		GROW_CURVE_ATTACK_301:   1.5160000324249268,
		GROW_CURVE_ATTACK_302:   1.5540000200271606,
		GROW_CURVE_ATTACK_303:   1.590999960899353,
		GROW_CURVE_ATTACK_304:   1.4739999771118164,
		GROW_CURVE_ATTACK_305:   1.4290000200271606,
		GROW_CURVE_CRITICAL_301: 1.1619999408721924,
	},
	{
		GROW_CURVE_ATTACK_101:   1.5290000438690186,
		GROW_CURVE_ATTACK_102:   1.5700000524520874,
		GROW_CURVE_ATTACK_103:   1.6089999675750732,
		GROW_CURVE_ATTACK_104:   1.4859999418258667,
		GROW_CURVE_ATTACK_105:   1.4390000104904175,
		GROW_CURVE_CRITICAL_101: 1.1619999408721924,
		GROW_CURVE_ATTACK_201:   1.5779999494552612,
		GROW_CURVE_ATTACK_202:   1.621000051498413,
		GROW_CURVE_ATTACK_203:   1.6610000133514404,
		GROW_CURVE_ATTACK_204:   1.5329999923706055,
		GROW_CURVE_ATTACK_205:   1.4839999675750732,
		GROW_CURVE_CRITICAL_201: 1.1619999408721924,
		GROW_CURVE_ATTACK_301:   1.6019999980926514,
		GROW_CURVE_ATTACK_302:   1.6480000019073486,
		GROW_CURVE_ATTACK_303:   1.6920000314712524,
		GROW_CURVE_ATTACK_304:   1.5520000457763672,
		GROW_CURVE_ATTACK_305:   1.4989999532699585,
		GROW_CURVE_CRITICAL_301: 1.1619999408721924,
	},
	{
		GROW_CURVE_ATTACK_101:   1.6039999723434448,
		GROW_CURVE_ATTACK_102:   1.6519999504089355,
		GROW_CURVE_ATTACK_103:   1.6979999542236328,
		GROW_CURVE_ATTACK_104:   1.5529999732971191,
		GROW_CURVE_ATTACK_105:   1.4989999532699585,
		GROW_CURVE_CRITICAL_101: 1.1619999408721924,
		GROW_CURVE_ATTACK_201:   1.6610000133514404,
		GROW_CURVE_ATTACK_202:   1.7100000381469727,
		GROW_CURVE_ATTACK_203:   1.7569999694824219,
		GROW_CURVE_ATTACK_204:   1.6069999933242798,
		GROW_CURVE_ATTACK_205:   1.5509999990463257,
		GROW_CURVE_CRITICAL_201: 1.1619999408721924,
		GROW_CURVE_ATTACK_301:   1.6890000104904175,
		GROW_CURVE_ATTACK_302:   1.7430000305175781,
		GROW_CURVE_ATTACK_303:   1.7929999828338623,
		GROW_CURVE_ATTACK_304:   1.63100004196167,
		GROW_CURVE_ATTACK_305:   1.5679999589920044,
		GROW_CURVE_CRITICAL_301: 1.1619999408721924,
	},
	{
		GROW_CURVE_ATTACK_101:   1.6790000200271606,
		GROW_CURVE_ATTACK_102:   1.7339999675750732,
		GROW_CURVE_ATTACK_103:   1.7860000133514404,
		GROW_CURVE_ATTACK_104:   1.621000051498413,
		GROW_CURVE_ATTACK_105:   1.5579999685287476,
		GROW_CURVE_CRITICAL_101: 1.3630000352859497,
		GROW_CURVE_ATTACK_201:   1.7430000305175781,
		GROW_CURVE_ATTACK_202:   1.7999999523162842,
		GROW_CURVE_ATTACK_203:   1.8539999723434448,
		GROW_CURVE_ATTACK_204:   1.6820000410079956,
		GROW_CURVE_ATTACK_205:   1.6169999837875366,
		GROW_CURVE_CRITICAL_201: 1.3630000352859497,
		GROW_CURVE_ATTACK_301:   1.774999976158142,
		GROW_CURVE_ATTACK_302:   1.8370000123977661,
		GROW_CURVE_ATTACK_303:   1.8949999809265137,
		GROW_CURVE_ATTACK_304:   1.7089999914169312,
		GROW_CURVE_ATTACK_305:   1.6369999647140503,
		GROW_CURVE_CRITICAL_301: 1.3630000352859497,
	},
	{
		GROW_CURVE_ATTACK_101:   1.753999948501587,
		GROW_CURVE_ATTACK_102:   1.815999984741211,
		GROW_CURVE_ATTACK_103:   1.875,
		GROW_CURVE_ATTACK_104:   1.687999963760376,
		GROW_CURVE_ATTACK_105:   1.6169999837875366,
		GROW_CURVE_CRITICAL_101: 1.3630000352859497,
		GROW_CURVE_ATTACK_201:   1.8259999752044678,
		GROW_CURVE_ATTACK_202:   1.8910000324249268,
		GROW_CURVE_ATTACK_203:   1.9520000219345093,
		GROW_CURVE_ATTACK_204:   1.7569999694824219,
		GROW_CURVE_ATTACK_205:   1.6829999685287476,
		GROW_CURVE_CRITICAL_201: 1.3630000352859497,
		GROW_CURVE_ATTACK_301:   1.8619999885559082,
		GROW_CURVE_ATTACK_302:   1.9329999685287476,
		GROW_CURVE_ATTACK_303:   1.9980000257492065,
		GROW_CURVE_ATTACK_304:   1.7869999408721924,
		GROW_CURVE_ATTACK_305:   1.7059999704360962,
		GROW_CURVE_CRITICAL_301: 1.3630000352859497,
	},
	{
		GROW_CURVE_ATTACK_101:   1.8279999494552612,
		GROW_CURVE_ATTACK_102:   1.8980000019073486,
		GROW_CURVE_ATTACK_103:   1.965000033378601,
		GROW_CURVE_ATTACK_104:   1.753999948501587,
		GROW_CURVE_ATTACK_105:   1.6749999523162842,
		GROW_CURVE_CRITICAL_101: 1.3630000352859497,
		GROW_CURVE_ATTACK_201:   1.9079999923706055,
		GROW_CURVE_ATTACK_202:   1.9809999465942383,
		GROW_CURVE_ATTACK_203:   2.0490000247955322,
		GROW_CURVE_ATTACK_204:   1.8309999704360962,
		GROW_CURVE_ATTACK_205:   1.7480000257492065,
		GROW_CURVE_CRITICAL_201: 1.3630000352859497,
		GROW_CURVE_ATTACK_301:   1.9490000009536743,
		GROW_CURVE_ATTACK_302:   2.0280001163482666,
		GROW_CURVE_ATTACK_303:   2.1019999980926514,
		GROW_CURVE_ATTACK_304:   1.8650000095367432,
		GROW_CURVE_ATTACK_305:   1.7740000486373901,
		GROW_CURVE_CRITICAL_301: 1.3630000352859497,
	},
	{
		GROW_CURVE_ATTACK_101:   1.902999997138977,
		GROW_CURVE_ATTACK_102:   1.9809999465942383,
		GROW_CURVE_ATTACK_103:   2.053999900817871,
		GROW_CURVE_ATTACK_104:   1.8200000524520874,
		GROW_CURVE_ATTACK_105:   1.7330000400543213,
		GROW_CURVE_CRITICAL_101: 1.3630000352859497,
		GROW_CURVE_ATTACK_201:   1.9910000562667847,
		GROW_CURVE_ATTACK_202:   2.072000026702881,
		GROW_CURVE_ATTACK_203:   2.1470000743865967,
		GROW_CURVE_ATTACK_204:   1.9049999713897705,
		GROW_CURVE_ATTACK_205:   1.812999963760376,
		GROW_CURVE_CRITICAL_201: 1.3630000352859497,
		GROW_CURVE_ATTACK_301:   2.0360000133514404,
		GROW_CURVE_ATTACK_302:   2.124000072479248,
		GROW_CURVE_ATTACK_303:   2.2060000896453857,
		GROW_CURVE_ATTACK_304:   1.9420000314712524,
		GROW_CURVE_ATTACK_305:   1.840999960899353,
		GROW_CURVE_CRITICAL_301: 1.3630000352859497,
	},
	{
		GROW_CURVE_ATTACK_101:   1.9769999980926514,
		GROW_CURVE_ATTACK_102:   2.062999963760376,
		GROW_CURVE_ATTACK_103:   2.1440000534057617,
		GROW_CURVE_ATTACK_104:   1.8860000371932983,
		GROW_CURVE_ATTACK_105:   1.7899999618530273,
		GROW_CURVE_CRITICAL_101: 1.3630000352859497,
		GROW_CURVE_ATTACK_201:   2.072999954223633,
		GROW_CURVE_ATTACK_202:   2.1619999408721924,
		GROW_CURVE_ATTACK_203:   2.246000051498413,
		GROW_CURVE_ATTACK_204:   1.9789999723434448,
		GROW_CURVE_ATTACK_205:   1.878000020980835,
		GROW_CURVE_CRITICAL_201: 1.3630000352859497,
		GROW_CURVE_ATTACK_301:   2.124000072479248,
		GROW_CURVE_ATTACK_302:   2.2200000286102295,
		GROW_CURVE_ATTACK_303:   2.309999942779541,
		GROW_CURVE_ATTACK_304:   2.0199999809265137,
		GROW_CURVE_ATTACK_305:   1.909000039100647,
		GROW_CURVE_CRITICAL_301: 1.3630000352859497,
	},
	{
		GROW_CURVE_ATTACK_101:   2.0510001182556152,
		GROW_CURVE_ATTACK_102:   2.1449999809265137,
		GROW_CURVE_ATTACK_103:   2.2339999675750732,
		GROW_CURVE_ATTACK_104:   1.9520000219345093,
		GROW_CURVE_ATTACK_105:   1.8459999561309814,
		GROW_CURVE_CRITICAL_101: 1.565000057220459,
		GROW_CURVE_ATTACK_201:   2.1559998989105225,
		GROW_CURVE_ATTACK_202:   2.253000020980835,
		GROW_CURVE_ATTACK_203:   2.3450000286102295,
		GROW_CURVE_ATTACK_204:   2.052000045776367,
		GROW_CURVE_ATTACK_205:   1.9420000314712524,
		GROW_CURVE_CRITICAL_201: 1.565000057220459,
		GROW_CURVE_ATTACK_301:   2.2109999656677246,
		GROW_CURVE_ATTACK_302:   2.316999912261963,
		GROW_CURVE_ATTACK_303:   2.4149999618530273,
		GROW_CURVE_ATTACK_304:   2.0980000495910645,
		GROW_CURVE_ATTACK_305:   1.9759999513626099,
		GROW_CURVE_CRITICAL_301: 1.565000057220459,
	},
	{
		GROW_CURVE_ATTACK_101:   2.125,
		GROW_CURVE_ATTACK_102:   2.2269999980926514,
		GROW_CURVE_ATTACK_103:   2.3239998817443848,
		GROW_CURVE_ATTACK_104:   2.0169999599456787,
		GROW_CURVE_ATTACK_105:   1.9019999504089355,
		GROW_CURVE_CRITICAL_101: 1.565000057220459,
		GROW_CURVE_ATTACK_201:   2.239000082015991,
		GROW_CURVE_ATTACK_202:   2.3450000286102295,
		GROW_CURVE_ATTACK_203:   2.444000005722046,
		GROW_CURVE_ATTACK_204:   2.125999927520752,
		GROW_CURVE_ATTACK_205:   2.005000114440918,
		GROW_CURVE_CRITICAL_201: 1.565000057220459,
		GROW_CURVE_ATTACK_301:   2.2990000247955322,
		GROW_CURVE_ATTACK_302:   2.4140000343322754,
		GROW_CURVE_ATTACK_303:   2.5209999084472656,
		GROW_CURVE_ATTACK_304:   2.174999952316284,
		GROW_CURVE_ATTACK_305:   2.0429999828338623,
		GROW_CURVE_CRITICAL_301: 1.565000057220459,
	},
	{
		GROW_CURVE_ATTACK_101:   2.1989998817443848,
		GROW_CURVE_ATTACK_102:   2.309999942779541,
		GROW_CURVE_ATTACK_103:   2.4140000343322754,
		GROW_CURVE_ATTACK_104:   2.0820000171661377,
		GROW_CURVE_ATTACK_105:   1.9579999446868896,
		GROW_CURVE_CRITICAL_101: 1.565000057220459,
		GROW_CURVE_ATTACK_201:   2.321000099182129,
		GROW_CURVE_ATTACK_202:   2.436000108718872,
		GROW_CURVE_ATTACK_203:   2.5439999103546143,
		GROW_CURVE_ATTACK_204:   2.1989998817443848,
		GROW_CURVE_ATTACK_205:   2.068000078201294,
		GROW_CURVE_CRITICAL_201: 1.565000057220459,
		GROW_CURVE_ATTACK_301:   2.385999917984009,
		GROW_CURVE_ATTACK_302:   2.510999917984009,
		GROW_CURVE_ATTACK_303:   2.627000093460083,
		GROW_CURVE_ATTACK_304:   2.253000020980835,
		GROW_CURVE_ATTACK_305:   2.1089999675750732,
		GROW_CURVE_CRITICAL_301: 1.565000057220459,
	},
	{
		GROW_CURVE_ATTACK_101:   2.2730000019073486,
		GROW_CURVE_ATTACK_102:   2.3919999599456787,
		GROW_CURVE_ATTACK_103:   2.505000114440918,
		GROW_CURVE_ATTACK_104:   2.1470000743865967,
		GROW_CURVE_ATTACK_105:   2.013000011444092,
		GROW_CURVE_CRITICAL_101: 1.565000057220459,
		GROW_CURVE_ATTACK_201:   2.4040000438690186,
		GROW_CURVE_ATTACK_202:   2.5269999504089355,
		GROW_CURVE_ATTACK_203:   2.6440000534057617,
		GROW_CURVE_ATTACK_204:   2.2720000743865967,
		GROW_CURVE_ATTACK_205:   2.13100004196167,
		GROW_CURVE_CRITICAL_201: 1.565000057220459,
		GROW_CURVE_ATTACK_301:   2.4739999771118164,
		GROW_CURVE_ATTACK_302:   2.6080000400543213,
		GROW_CURVE_ATTACK_303:   2.7339999675750732,
		GROW_CURVE_ATTACK_304:   2.3299999237060547,
		GROW_CURVE_ATTACK_305:   2.174999952316284,
		GROW_CURVE_CRITICAL_301: 1.565000057220459,
	},
	{
		GROW_CURVE_ATTACK_101:   2.3469998836517334,
		GROW_CURVE_ATTACK_102:   2.4739999771118164,
		GROW_CURVE_ATTACK_103:   2.5950000286102295,
		GROW_CURVE_ATTACK_104:   2.2109999656677246,
		GROW_CURVE_ATTACK_105:   2.066999912261963,
		GROW_CURVE_CRITICAL_101: 1.565000057220459,
		GROW_CURVE_ATTACK_201:   2.4860000610351562,
		GROW_CURVE_ATTACK_202:   2.61899995803833,
		GROW_CURVE_ATTACK_203:   2.74399995803833,
		GROW_CURVE_ATTACK_204:   2.3450000286102295,
		GROW_CURVE_ATTACK_205:   2.194000005722046,
		GROW_CURVE_CRITICAL_201: 1.565000057220459,
		GROW_CURVE_ATTACK_301:   2.562000036239624,
		GROW_CURVE_ATTACK_302:   2.7060000896453857,
		GROW_CURVE_ATTACK_303:   2.8410000801086426,
		GROW_CURVE_ATTACK_304:   2.4079999923706055,
		GROW_CURVE_ATTACK_305:   2.240999937057495,
		GROW_CURVE_CRITICAL_301: 1.565000057220459,
	},
	{
		GROW_CURVE_ATTACK_101:   2.4200000762939453,
		GROW_CURVE_ATTACK_102:   2.556999921798706,
		GROW_CURVE_ATTACK_103:   2.686000108718872,
		GROW_CURVE_ATTACK_104:   2.2750000953674316,
		GROW_CURVE_ATTACK_105:   2.121000051498413,
		GROW_CURVE_CRITICAL_101: 1.7669999599456787,
		GROW_CURVE_ATTACK_201:   2.569000005722046,
		GROW_CURVE_ATTACK_202:   2.7109999656677246,
		GROW_CURVE_ATTACK_203:   2.8450000286102295,
		GROW_CURVE_ATTACK_204:   2.4170000553131104,
		GROW_CURVE_ATTACK_205:   2.25600004196167,
		GROW_CURVE_CRITICAL_201: 1.7669999599456787,
		GROW_CURVE_ATTACK_301:   2.6500000953674316,
		GROW_CURVE_ATTACK_302:   2.803999900817871,
		GROW_CURVE_ATTACK_303:   2.9489998817443848,
		GROW_CURVE_ATTACK_304:   2.484999895095825,
		GROW_CURVE_ATTACK_305:   2.306999921798706,
		GROW_CURVE_CRITICAL_301: 1.7669999599456787,
	},
	{
		GROW_CURVE_ATTACK_101:   2.493000030517578,
		GROW_CURVE_ATTACK_102:   2.6389999389648438,
		GROW_CURVE_ATTACK_103:   2.7769999504089355,
		GROW_CURVE_ATTACK_104:   2.3389999866485596,
		GROW_CURVE_ATTACK_105:   2.174999952316284,
		GROW_CURVE_CRITICAL_101: 1.7669999599456787,
		GROW_CURVE_ATTACK_201:   2.6510000228881836,
		GROW_CURVE_ATTACK_202:   2.802999973297119,
		GROW_CURVE_ATTACK_203:   2.946000099182129,
		GROW_CURVE_ATTACK_204:   2.490000009536743,
		GROW_CURVE_ATTACK_205:   2.318000078201294,
		GROW_CURVE_CRITICAL_201: 1.7669999599456787,
		GROW_CURVE_ATTACK_301:   2.73799991607666,
		GROW_CURVE_ATTACK_302:   2.9030001163482666,
		GROW_CURVE_ATTACK_303:   3.056999921798706,
		GROW_CURVE_ATTACK_304:   2.562000036239624,
		GROW_CURVE_ATTACK_305:   2.372999906539917,
		GROW_CURVE_CRITICAL_301: 1.7669999599456787,
	},
	{
		GROW_CURVE_ATTACK_101:   2.566999912261963,
		GROW_CURVE_ATTACK_102:   2.7219998836517334,
		GROW_CURVE_ATTACK_103:   2.868000030517578,
		GROW_CURVE_ATTACK_104:   2.4019999504089355,
		GROW_CURVE_ATTACK_105:   2.2279999256134033,
		GROW_CURVE_CRITICAL_101: 1.7669999599456787,
		GROW_CURVE_ATTACK_201:   2.7339999675750732,
		GROW_CURVE_ATTACK_202:   2.8949999809265137,
		GROW_CURVE_ATTACK_203:   3.046999931335449,
		GROW_CURVE_ATTACK_204:   2.562000036239624,
		GROW_CURVE_ATTACK_205:   2.378999948501587,
		GROW_CURVE_CRITICAL_201: 1.7669999599456787,
		GROW_CURVE_ATTACK_301:   2.8269999027252197,
		GROW_CURVE_ATTACK_302:   3.002000093460083,
		GROW_CURVE_ATTACK_303:   3.1649999618530273,
		GROW_CURVE_ATTACK_304:   2.6389999389648438,
		GROW_CURVE_ATTACK_305:   2.437999963760376,
		GROW_CURVE_CRITICAL_301: 1.7669999599456787,
	},
	{
		GROW_CURVE_ATTACK_101:   2.640000104904175,
		GROW_CURVE_ATTACK_102:   2.803999900817871,
		GROW_CURVE_ATTACK_103:   2.9600000381469727,
		GROW_CURVE_ATTACK_104:   2.4660000801086426,
		GROW_CURVE_ATTACK_105:   2.2799999713897705,
		GROW_CURVE_CRITICAL_101: 1.7669999599456787,
		GROW_CURVE_ATTACK_201:   2.816999912261963,
		GROW_CURVE_ATTACK_202:   2.986999988555908,
		GROW_CURVE_ATTACK_203:   3.1480000019073486,
		GROW_CURVE_ATTACK_204:   2.634000062942505,
		GROW_CURVE_ATTACK_205:   2.440000057220459,
		GROW_CURVE_CRITICAL_201: 1.7669999599456787,
		GROW_CURVE_ATTACK_301:   2.9149999618530273,
		GROW_CURVE_ATTACK_302:   3.1010000705718994,
		GROW_CURVE_ATTACK_303:   3.2739999294281006,
		GROW_CURVE_ATTACK_304:   2.7170000076293945,
		GROW_CURVE_ATTACK_305:   2.503000020980835,
		GROW_CURVE_CRITICAL_301: 1.7669999599456787,
	},
	{
		GROW_CURVE_ATTACK_101:   2.7130000591278076,
		GROW_CURVE_ATTACK_102:   2.88700008392334,
		GROW_CURVE_ATTACK_103:   3.0510001182556152,
		GROW_CURVE_ATTACK_104:   2.5290000438690186,
		GROW_CURVE_ATTACK_105:   2.3329999446868896,
		GROW_CURVE_CRITICAL_101: 1.7669999599456787,
		GROW_CURVE_ATTACK_201:   2.8989999294281006,
		GROW_CURVE_ATTACK_202:   3.0799999237060547,
		GROW_CURVE_ATTACK_203:   3.25,
		GROW_CURVE_ATTACK_204:   2.7070000171661377,
		GROW_CURVE_ATTACK_205:   2.500999927520752,
		GROW_CURVE_CRITICAL_201: 1.7669999599456787,
		GROW_CURVE_ATTACK_301:   3.003999948501587,
		GROW_CURVE_ATTACK_302:   3.200000047683716,
		GROW_CURVE_ATTACK_303:   3.384000062942505,
		GROW_CURVE_ATTACK_304:   2.7939999103546143,
		GROW_CURVE_ATTACK_305:   2.568000078201294,
		GROW_CURVE_CRITICAL_301: 1.7669999599456787,
	},
	{
		GROW_CURVE_ATTACK_101:   2.7860000133514404,
		GROW_CURVE_ATTACK_102:   2.9690001010894775,
		GROW_CURVE_ATTACK_103:   3.1429998874664307,
		GROW_CURVE_ATTACK_104:   2.5910000801086426,
		GROW_CURVE_ATTACK_105:   2.384999990463257,
		GROW_CURVE_CRITICAL_101: 1.968999981880188,
		GROW_CURVE_ATTACK_201:   2.9820001125335693,
		GROW_CURVE_ATTACK_202:   3.171999931335449,
		GROW_CURVE_ATTACK_203:   3.3519999980926514,
		GROW_CURVE_ATTACK_204:   2.7780001163482666,
		GROW_CURVE_ATTACK_205:   2.562000036239624,
		GROW_CURVE_CRITICAL_201: 1.968999981880188,
		GROW_CURVE_ATTACK_301:   3.0929999351501465,
		GROW_CURVE_ATTACK_302:   3.299999952316284,
		GROW_CURVE_ATTACK_303:   3.493000030517578,
		GROW_CURVE_ATTACK_304:   2.871000051498413,
		GROW_CURVE_ATTACK_305:   2.632999897003174,
		GROW_CURVE_CRITICAL_301: 1.968999981880188,
	},
	{
		GROW_CURVE_ATTACK_101:   2.8589999675750732,
		GROW_CURVE_ATTACK_102:   3.052000045776367,
		GROW_CURVE_ATTACK_103:   3.2339999675750732,
		GROW_CURVE_ATTACK_104:   2.6540000438690186,
		GROW_CURVE_ATTACK_105:   2.436000108718872,
		GROW_CURVE_CRITICAL_101: 1.968999981880188,
		GROW_CURVE_ATTACK_201:   3.063999891281128,
		GROW_CURVE_ATTACK_202:   3.265000104904175,
		GROW_CURVE_ATTACK_203:   3.4539999961853027,
		GROW_CURVE_ATTACK_204:   2.8499999046325684,
		GROW_CURVE_ATTACK_205:   2.621999979019165,
		GROW_CURVE_CRITICAL_201: 1.968999981880188,
		GROW_CURVE_ATTACK_301:   3.181999921798706,
		GROW_CURVE_ATTACK_302:   3.4000000953674316,
		GROW_CURVE_ATTACK_303:   3.6040000915527344,
		GROW_CURVE_ATTACK_304:   2.947999954223633,
		GROW_CURVE_ATTACK_305:   2.697000026702881,
		GROW_CURVE_CRITICAL_301: 1.968999981880188,
	},
	{
		GROW_CURVE_ATTACK_101:   2.930999994277954,
		GROW_CURVE_ATTACK_102:   3.134000062942505,
		GROW_CURVE_ATTACK_103:   3.3259999752044678,
		GROW_CURVE_ATTACK_104:   2.7160000801086426,
		GROW_CURVE_ATTACK_105:   2.486999988555908,
		GROW_CURVE_CRITICAL_101: 1.968999981880188,
		GROW_CURVE_ATTACK_201:   3.1470000743865967,
		GROW_CURVE_ATTACK_202:   3.3580000400543213,
		GROW_CURVE_ATTACK_203:   3.556999921798706,
		GROW_CURVE_ATTACK_204:   2.921999931335449,
		GROW_CURVE_ATTACK_205:   2.681999921798706,
		GROW_CURVE_CRITICAL_201: 1.968999981880188,
		GROW_CURVE_ATTACK_301:   3.2709999084472656,
		GROW_CURVE_ATTACK_302:   3.5,
		GROW_CURVE_ATTACK_303:   3.7139999866485596,
		GROW_CURVE_ATTACK_304:   3.0260000228881836,
		GROW_CURVE_ATTACK_305:   2.76200008392334,
		GROW_CURVE_CRITICAL_301: 1.968999981880188,
	},
	{
		GROW_CURVE_ATTACK_101:   3.003999948501587,
		GROW_CURVE_ATTACK_102:   3.2170000076293945,
		GROW_CURVE_ATTACK_103:   3.4179999828338623,
		GROW_CURVE_ATTACK_104:   2.7780001163482666,
		GROW_CURVE_ATTACK_105:   2.5380001068115234,
		GROW_CURVE_CRITICAL_101: 1.968999981880188,
		GROW_CURVE_ATTACK_201:   3.2290000915527344,
		GROW_CURVE_ATTACK_202:   3.4509999752044678,
		GROW_CURVE_ATTACK_203:   3.6600000858306885,
		GROW_CURVE_ATTACK_204:   2.993000030517578,
		GROW_CURVE_ATTACK_205:   2.740999937057495,
		GROW_CURVE_CRITICAL_201: 1.968999981880188,
		GROW_CURVE_ATTACK_301:   3.359999895095825,
		GROW_CURVE_ATTACK_302:   3.6010000705718994,
		GROW_CURVE_ATTACK_303:   3.825000047683716,
		GROW_CURVE_ATTACK_304:   3.1029999256134033,
		GROW_CURVE_ATTACK_305:   2.8259999752044678,
		GROW_CURVE_CRITICAL_301: 1.968999981880188,
	},
	{
		GROW_CURVE_ATTACK_101:   3.0759999752044678,
		GROW_CURVE_ATTACK_102:   3.2990000247955322,
		GROW_CURVE_ATTACK_103:   3.509999990463257,
		GROW_CURVE_ATTACK_104:   2.8399999141693115,
		GROW_CURVE_ATTACK_105:   2.5880000591278076,
		GROW_CURVE_CRITICAL_101: 1.968999981880188,
		GROW_CURVE_ATTACK_201:   3.312000036239624,
		GROW_CURVE_ATTACK_202:   3.5439999103546143,
		GROW_CURVE_ATTACK_203:   3.76200008392334,
		GROW_CURVE_ATTACK_204:   3.065000057220459,
		GROW_CURVE_ATTACK_205:   2.8010001182556152,
		GROW_CURVE_CRITICAL_201: 1.968999981880188,
		GROW_CURVE_ATTACK_301:   3.450000047683716,
		GROW_CURVE_ATTACK_302:   3.7009999752044678,
		GROW_CURVE_ATTACK_303:   3.937000036239624,
		GROW_CURVE_ATTACK_304:   3.180000066757202,
		GROW_CURVE_ATTACK_305:   2.890000104904175,
		GROW_CURVE_CRITICAL_301: 1.968999981880188,
	},
	{
		GROW_CURVE_ATTACK_101:   3.1480000019073486,
		GROW_CURVE_ATTACK_102:   3.381999969482422,
		GROW_CURVE_ATTACK_103:   3.6019999980926514,
		GROW_CURVE_ATTACK_104:   2.9010000228881836,
		GROW_CURVE_ATTACK_105:   2.638000011444092,
		GROW_CURVE_CRITICAL_101: 2.1710000038146973,
		GROW_CURVE_ATTACK_201:   3.3940000534057617,
		GROW_CURVE_ATTACK_202:   3.63700008392334,
		GROW_CURVE_ATTACK_203:   3.865999937057495,
		GROW_CURVE_ATTACK_204:   3.135999917984009,
		GROW_CURVE_ATTACK_205:   2.859999895095825,
		GROW_CURVE_CRITICAL_201: 2.1710000038146973,
		GROW_CURVE_ATTACK_301:   3.5390000343322754,
		GROW_CURVE_ATTACK_302:   3.802999973297119,
		GROW_CURVE_ATTACK_303:   4.048999786376953,
		GROW_CURVE_ATTACK_304:   3.256999969482422,
		GROW_CURVE_ATTACK_305:   2.9539999961853027,
		GROW_CURVE_CRITICAL_301: 2.1710000038146973,
	},
	{
		GROW_CURVE_ATTACK_101:   3.2209999561309814,
		GROW_CURVE_ATTACK_102:   3.4639999866485596,
		GROW_CURVE_ATTACK_103:   3.694000005722046,
		GROW_CURVE_ATTACK_104:   2.9619998931884766,
		GROW_CURVE_ATTACK_105:   2.687999963760376,
		GROW_CURVE_CRITICAL_101: 2.1710000038146973,
		GROW_CURVE_ATTACK_201:   3.4769999980926514,
		GROW_CURVE_ATTACK_202:   3.7309999465942383,
		GROW_CURVE_ATTACK_203:   3.9690001010894775,
		GROW_CURVE_ATTACK_204:   3.2070000171661377,
		GROW_CURVE_ATTACK_205:   2.9189999103546143,
		GROW_CURVE_CRITICAL_201: 2.1710000038146973,
		GROW_CURVE_ATTACK_301:   3.628999948501587,
		GROW_CURVE_ATTACK_302:   3.9040000438690186,
		GROW_CURVE_ATTACK_303:   4.160999774932861,
		GROW_CURVE_ATTACK_304:   3.3340001106262207,
		GROW_CURVE_ATTACK_305:   3.0179998874664307,
		GROW_CURVE_CRITICAL_301: 2.1710000038146973,
	},
	{
		GROW_CURVE_ATTACK_101:   3.2929999828338623,
		GROW_CURVE_ATTACK_102:   3.546999931335449,
		GROW_CURVE_ATTACK_103:   3.7869999408721924,
		GROW_CURVE_ATTACK_104:   3.0230000019073486,
		GROW_CURVE_ATTACK_105:   2.736999988555908,
		GROW_CURVE_CRITICAL_101: 2.1710000038146973,
		GROW_CURVE_ATTACK_201:   3.559999942779541,
		GROW_CURVE_ATTACK_202:   3.8239998817443848,
		GROW_CURVE_ATTACK_203:   4.072999954223633,
		GROW_CURVE_ATTACK_204:   3.2780001163482666,
		GROW_CURVE_ATTACK_205:   2.9779999256134033,
		GROW_CURVE_CRITICAL_201: 2.1710000038146973,
		GROW_CURVE_ATTACK_301:   3.7190001010894775,
		GROW_CURVE_ATTACK_302:   4.005000114440918,
		GROW_CURVE_ATTACK_303:   4.2729997634887695,
		GROW_CURVE_ATTACK_304:   3.4119999408721924,
		GROW_CURVE_ATTACK_305:   3.0820000171661377,
		GROW_CURVE_CRITICAL_301: 2.1710000038146973,
	},
	{
		GROW_CURVE_ATTACK_101:   3.365000009536743,
		GROW_CURVE_ATTACK_102:   3.628999948501587,
		GROW_CURVE_ATTACK_103:   3.878999948501587,
		GROW_CURVE_ATTACK_104:   3.0840001106262207,
		GROW_CURVE_ATTACK_105:   2.7860000133514404,
		GROW_CURVE_CRITICAL_101: 2.1710000038146973,
		GROW_CURVE_ATTACK_201:   3.6419999599456787,
		GROW_CURVE_ATTACK_202:   3.9179999828338623,
		GROW_CURVE_ATTACK_203:   4.177000045776367,
		GROW_CURVE_ATTACK_204:   3.3489999771118164,
		GROW_CURVE_ATTACK_205:   3.0360000133514404,
		GROW_CURVE_CRITICAL_201: 2.1710000038146973,
		GROW_CURVE_ATTACK_301:   3.809000015258789,
		GROW_CURVE_ATTACK_302:   4.10699987411499,
		GROW_CURVE_ATTACK_303:   4.386000156402588,
		GROW_CURVE_ATTACK_304:   3.489000082015991,
		GROW_CURVE_ATTACK_305:   3.1449999809265137,
		GROW_CURVE_CRITICAL_301: 2.1710000038146973,
	},
	{
		GROW_CURVE_ATTACK_101:   3.437000036239624,
		GROW_CURVE_ATTACK_102:   3.7119998931884766,
		GROW_CURVE_ATTACK_103:   3.9719998836517334,
		GROW_CURVE_ATTACK_104:   3.1449999809265137,
		GROW_CURVE_ATTACK_105:   2.8350000381469727,
		GROW_CURVE_CRITICAL_101: 2.1710000038146973,
		GROW_CURVE_ATTACK_201:   3.7249999046325684,
		GROW_CURVE_ATTACK_202:   4.011000156402588,
		GROW_CURVE_ATTACK_203:   4.281000137329102,
		GROW_CURVE_ATTACK_204:   3.4200000762939453,
		GROW_CURVE_ATTACK_205:   3.0940001010894775,
		GROW_CURVE_CRITICAL_201: 2.1710000038146973,
		GROW_CURVE_ATTACK_301:   3.8989999294281006,
		GROW_CURVE_ATTACK_302:   4.209000110626221,
		GROW_CURVE_ATTACK_303:   4.499000072479248,
		GROW_CURVE_ATTACK_304:   3.565999984741211,
		GROW_CURVE_ATTACK_305:   3.2090001106262207,
		GROW_CURVE_CRITICAL_301: 2.1710000038146973,
	},
	{
		GROW_CURVE_ATTACK_101:   3.507999897003174,
		GROW_CURVE_ATTACK_102:   3.7939999103546143,
		GROW_CURVE_ATTACK_103:   4.064000129699707,
		GROW_CURVE_ATTACK_104:   3.2049999237060547,
		GROW_CURVE_ATTACK_105:   2.882999897003174,
		GROW_CURVE_CRITICAL_101: 2.372999906539917,
		GROW_CURVE_ATTACK_201:   3.806999921798706,
		GROW_CURVE_ATTACK_202:   4.105000019073486,
		GROW_CURVE_ATTACK_203:   4.385000228881836,
		GROW_CURVE_ATTACK_204:   3.490000009536743,
		GROW_CURVE_ATTACK_205:   3.1519999504089355,
		GROW_CURVE_CRITICAL_201: 2.372999906539917,
		GROW_CURVE_ATTACK_301:   3.989000082015991,
		GROW_CURVE_ATTACK_302:   4.311999797821045,
		GROW_CURVE_ATTACK_303:   4.61299991607666,
		GROW_CURVE_ATTACK_304:   3.6440000534057617,
		GROW_CURVE_ATTACK_305:   3.2720000743865967,
		GROW_CURVE_CRITICAL_301: 2.372999906539917,
	},
	{
		GROW_CURVE_ATTACK_101:   3.5799999237060547,
		GROW_CURVE_ATTACK_102:   3.877000093460083,
		GROW_CURVE_ATTACK_103:   4.1570000648498535,
		GROW_CURVE_ATTACK_104:   3.265000104904175,
		GROW_CURVE_ATTACK_105:   2.930999994277954,
		GROW_CURVE_CRITICAL_101: 2.372999906539917,
		GROW_CURVE_ATTACK_201:   3.890000104904175,
		GROW_CURVE_ATTACK_202:   4.198999881744385,
		GROW_CURVE_ATTACK_203:   4.488999843597412,
		GROW_CURVE_ATTACK_204:   3.561000108718872,
		GROW_CURVE_ATTACK_205:   3.2100000381469727,
		GROW_CURVE_CRITICAL_201: 2.372999906539917,
		GROW_CURVE_ATTACK_301:   4.079999923706055,
		GROW_CURVE_ATTACK_302:   4.414000034332275,
		GROW_CURVE_ATTACK_303:   4.7270002365112305,
		GROW_CURVE_ATTACK_304:   3.7209999561309814,
		GROW_CURVE_ATTACK_305:   3.3359999656677246,
		GROW_CURVE_CRITICAL_301: 2.372999906539917,
	},
	{
		GROW_CURVE_ATTACK_101:   3.6519999504089355,
		GROW_CURVE_ATTACK_102:   3.9590001106262207,
		GROW_CURVE_ATTACK_103:   4.25,
		GROW_CURVE_ATTACK_104:   3.325000047683716,
		GROW_CURVE_ATTACK_105:   2.9790000915527344,
		GROW_CURVE_CRITICAL_101: 2.372999906539917,
		GROW_CURVE_ATTACK_201:   3.9719998836517334,
		GROW_CURVE_ATTACK_202:   4.293000221252441,
		GROW_CURVE_ATTACK_203:   4.593999862670898,
		GROW_CURVE_ATTACK_204:   3.631999969482422,
		GROW_CURVE_ATTACK_205:   3.2679998874664307,
		GROW_CURVE_CRITICAL_201: 2.372999906539917,
		GROW_CURVE_ATTACK_301:   4.170000076293945,
		GROW_CURVE_ATTACK_302:   4.517000198364258,
		GROW_CURVE_ATTACK_303:   4.841000080108643,
		GROW_CURVE_ATTACK_304:   3.7980000972747803,
		GROW_CURVE_ATTACK_305:   3.3989999294281006,
		GROW_CURVE_CRITICAL_301: 2.372999906539917,
	},
	{
		GROW_CURVE_ATTACK_101:   3.7230000495910645,
		GROW_CURVE_ATTACK_102:   4.041999816894531,
		GROW_CURVE_ATTACK_103:   4.3420000076293945,
		GROW_CURVE_ATTACK_104:   3.384999990463257,
		GROW_CURVE_ATTACK_105:   3.0269999504089355,
		GROW_CURVE_CRITICAL_101: 2.372999906539917,
		GROW_CURVE_ATTACK_201:   4.054999828338623,
		GROW_CURVE_ATTACK_202:   4.38700008392334,
		GROW_CURVE_ATTACK_203:   4.698999881744385,
		GROW_CURVE_ATTACK_204:   3.7019999027252197,
		GROW_CURVE_ATTACK_205:   3.325000047683716,
		GROW_CURVE_CRITICAL_201: 2.372999906539917,
		GROW_CURVE_ATTACK_301:   4.261000156402588,
		GROW_CURVE_ATTACK_302:   4.619999885559082,
		GROW_CURVE_ATTACK_303:   4.955999851226807,
		GROW_CURVE_ATTACK_304:   3.875999927520752,
		GROW_CURVE_ATTACK_305:   3.4619998931884766,
		GROW_CURVE_CRITICAL_301: 2.372999906539917,
	},
	{
		GROW_CURVE_ATTACK_101:   3.7939999103546143,
		GROW_CURVE_ATTACK_102:   4.124000072479248,
		GROW_CURVE_ATTACK_103:   4.434999942779541,
		GROW_CURVE_ATTACK_104:   3.444999933242798,
		GROW_CURVE_ATTACK_105:   3.0739998817443848,
		GROW_CURVE_CRITICAL_101: 2.372999906539917,
		GROW_CURVE_ATTACK_201:   4.138000011444092,
		GROW_CURVE_ATTACK_202:   4.480999946594238,
		GROW_CURVE_ATTACK_203:   4.802999973297119,
		GROW_CURVE_ATTACK_204:   3.7720000743865967,
		GROW_CURVE_ATTACK_205:   3.381999969482422,
		GROW_CURVE_CRITICAL_201: 2.372999906539917,
		GROW_CURVE_ATTACK_301:   4.3520002365112305,
		GROW_CURVE_ATTACK_302:   4.7230000495910645,
		GROW_CURVE_ATTACK_303:   5.071000099182129,
		GROW_CURVE_ATTACK_304:   3.953000068664551,
		GROW_CURVE_ATTACK_305:   3.5250000953674316,
		GROW_CURVE_CRITICAL_301: 2.372999906539917,
	},
	{
		GROW_CURVE_ATTACK_101:   3.865999937057495,
		GROW_CURVE_ATTACK_102:   4.205999851226807,
		GROW_CURVE_ATTACK_103:   4.5279998779296875,
		GROW_CURVE_ATTACK_104:   3.503999948501587,
		GROW_CURVE_ATTACK_105:   3.121000051498413,
		GROW_CURVE_CRITICAL_101: 2.575000047683716,
		GROW_CURVE_ATTACK_201:   4.21999979019165,
		GROW_CURVE_ATTACK_202:   4.574999809265137,
		GROW_CURVE_ATTACK_203:   4.908999919891357,
		GROW_CURVE_ATTACK_204:   3.8420000076293945,
		GROW_CURVE_ATTACK_205:   3.438999891281128,
		GROW_CURVE_CRITICAL_201: 2.575000047683716,
		GROW_CURVE_ATTACK_301:   4.442999839782715,
		GROW_CURVE_ATTACK_302:   4.827000141143799,
		GROW_CURVE_ATTACK_303:   5.185999870300293,
		GROW_CURVE_ATTACK_304:   4.031000137329102,
		GROW_CURVE_ATTACK_305:   3.5880000591278076,
		GROW_CURVE_CRITICAL_301: 2.575000047683716,
	},
	{
		GROW_CURVE_ATTACK_101:   3.937000036239624,
		GROW_CURVE_ATTACK_102:   4.289000034332275,
		GROW_CURVE_ATTACK_103:   4.620999813079834,
		GROW_CURVE_ATTACK_104:   3.563999891281128,
		GROW_CURVE_ATTACK_105:   3.1670000553131104,
		GROW_CURVE_CRITICAL_101: 2.575000047683716,
		GROW_CURVE_ATTACK_201:   4.302999973297119,
		GROW_CURVE_ATTACK_202:   4.669000148773193,
		GROW_CURVE_ATTACK_203:   5.013999938964844,
		GROW_CURVE_ATTACK_204:   3.9130001068115234,
		GROW_CURVE_ATTACK_205:   3.496000051498413,
		GROW_CURVE_CRITICAL_201: 2.575000047683716,
		GROW_CURVE_ATTACK_301:   4.533999919891357,
		GROW_CURVE_ATTACK_302:   4.931000232696533,
		GROW_CURVE_ATTACK_303:   5.301000118255615,
		GROW_CURVE_ATTACK_304:   4.109000205993652,
		GROW_CURVE_ATTACK_305:   3.6510000228881836,
		GROW_CURVE_CRITICAL_301: 2.575000047683716,
	},
	{
		GROW_CURVE_ATTACK_101:   4.007999897003174,
		GROW_CURVE_ATTACK_102:   4.370999813079834,
		GROW_CURVE_ATTACK_103:   4.714000225067139,
		GROW_CURVE_ATTACK_104:   3.622999906539917,
		GROW_CURVE_ATTACK_105:   3.2139999866485596,
		GROW_CURVE_CRITICAL_101: 2.575000047683716,
		GROW_CURVE_ATTACK_201:   4.385000228881836,
		GROW_CURVE_ATTACK_202:   4.763000011444092,
		GROW_CURVE_ATTACK_203:   5.11899995803833,
		GROW_CURVE_ATTACK_204:   3.9830000400543213,
		GROW_CURVE_ATTACK_205:   3.552999973297119,
		GROW_CURVE_CRITICAL_201: 2.575000047683716,
		GROW_CURVE_ATTACK_301:   4.625,
		GROW_CURVE_ATTACK_302:   5.034999847412109,
		GROW_CURVE_ATTACK_303:   5.416999816894531,
		GROW_CURVE_ATTACK_304:   4.185999870300293,
		GROW_CURVE_ATTACK_305:   3.7139999866485596,
		GROW_CURVE_CRITICAL_301: 2.575000047683716,
	},
	{
		GROW_CURVE_ATTACK_101:   4.078999996185303,
		GROW_CURVE_ATTACK_102:   4.453999996185303,
		GROW_CURVE_ATTACK_103:   4.808000087738037,
		GROW_CURVE_ATTACK_104:   3.681999921798706,
		GROW_CURVE_ATTACK_105:   3.259999990463257,
		GROW_CURVE_CRITICAL_101: 2.575000047683716,
		GROW_CURVE_ATTACK_201:   4.4679999351501465,
		GROW_CURVE_ATTACK_202:   4.857999801635742,
		GROW_CURVE_ATTACK_203:   5.224999904632568,
		GROW_CURVE_ATTACK_204:   4.052999973297119,
		GROW_CURVE_ATTACK_205:   3.6089999675750732,
		GROW_CURVE_CRITICAL_201: 2.575000047683716,
		GROW_CURVE_ATTACK_301:   4.7170000076293945,
		GROW_CURVE_ATTACK_302:   5.138999938964844,
		GROW_CURVE_ATTACK_303:   5.5329999923706055,
		GROW_CURVE_ATTACK_304:   4.263999938964844,
		GROW_CURVE_ATTACK_305:   3.7769999504089355,
		GROW_CURVE_CRITICAL_301: 2.575000047683716,
	},
	{
		GROW_CURVE_ATTACK_101:   4.150000095367432,
		GROW_CURVE_ATTACK_102:   4.535999774932861,
		GROW_CURVE_ATTACK_103:   4.901000022888184,
		GROW_CURVE_ATTACK_104:   3.740999937057495,
		GROW_CURVE_ATTACK_105:   3.305999994277954,
		GROW_CURVE_CRITICAL_101: 2.575000047683716,
		GROW_CURVE_ATTACK_201:   4.550000190734863,
		GROW_CURVE_ATTACK_202:   4.952000141143799,
		GROW_CURVE_ATTACK_203:   5.329999923706055,
		GROW_CURVE_ATTACK_204:   4.122000217437744,
		GROW_CURVE_ATTACK_205:   3.6659998893737793,
		GROW_CURVE_CRITICAL_201: 2.575000047683716,
		GROW_CURVE_ATTACK_301:   4.808000087738037,
		GROW_CURVE_ATTACK_302:   5.243000030517578,
		GROW_CURVE_ATTACK_303:   5.650000095367432,
		GROW_CURVE_ATTACK_304:   4.3420000076293945,
		GROW_CURVE_ATTACK_305:   3.8399999141693115,
		GROW_CURVE_CRITICAL_301: 2.575000047683716,
	},
	{
		GROW_CURVE_ATTACK_101:   4.2210001945495605,
		GROW_CURVE_ATTACK_102:   4.618000030517578,
		GROW_CURVE_ATTACK_103:   4.99399995803833,
		GROW_CURVE_ATTACK_104:   3.7990000247955322,
		GROW_CURVE_ATTACK_105:   3.3510000705718994,
		GROW_CURVE_CRITICAL_101: 2.7769999504089355,
		GROW_CURVE_ATTACK_201:   4.632999897003174,
		GROW_CURVE_ATTACK_202:   5.046999931335449,
		GROW_CURVE_ATTACK_203:   5.435999870300293,
		GROW_CURVE_ATTACK_204:   4.191999912261963,
		GROW_CURVE_ATTACK_205:   3.7219998836517334,
		GROW_CURVE_CRITICAL_201: 2.7769999504089355,
		GROW_CURVE_ATTACK_301:   4.900000095367432,
		GROW_CURVE_ATTACK_302:   5.3480000495910645,
		GROW_CURVE_ATTACK_303:   5.767000198364258,
		GROW_CURVE_ATTACK_304:   4.419000148773193,
		GROW_CURVE_ATTACK_305:   3.9030001163482666,
		GROW_CURVE_CRITICAL_301: 2.7769999504089355,
	},
	{
		GROW_CURVE_ATTACK_101:   4.290999889373779,
		GROW_CURVE_ATTACK_102:   4.701000213623047,
		GROW_CURVE_ATTACK_103:   5.086999893188477,
		GROW_CURVE_ATTACK_104:   3.8580000400543213,
		GROW_CURVE_ATTACK_105:   3.3970000743865967,
		GROW_CURVE_CRITICAL_101: 2.7769999504089355,
		GROW_CURVE_ATTACK_201:   4.716000080108643,
		GROW_CURVE_ATTACK_202:   5.142000198364258,
		GROW_CURVE_ATTACK_203:   5.541999816894531,
		GROW_CURVE_ATTACK_204:   4.26200008392334,
		GROW_CURVE_ATTACK_205:   3.7780001163482666,
		GROW_CURVE_CRITICAL_201: 2.7769999504089355,
		GROW_CURVE_ATTACK_301:   4.992000102996826,
		GROW_CURVE_ATTACK_302:   5.453000068664551,
		GROW_CURVE_ATTACK_303:   5.883999824523926,
		GROW_CURVE_ATTACK_304:   4.497000217437744,
		GROW_CURVE_ATTACK_305:   3.9660000801086426,
		GROW_CURVE_CRITICAL_301: 2.7769999504089355,
	},
	{
		GROW_CURVE_ATTACK_101:   4.361999988555908,
		GROW_CURVE_ATTACK_102:   4.7829999923706055,
		GROW_CURVE_ATTACK_103:   5.181000232696533,
		GROW_CURVE_ATTACK_104:   3.9159998893737793,
		GROW_CURVE_ATTACK_105:   3.441999912261963,
		GROW_CURVE_CRITICAL_101: 2.7769999504089355,
		GROW_CURVE_ATTACK_201:   4.797999858856201,
		GROW_CURVE_ATTACK_202:   5.236000061035156,
		GROW_CURVE_ATTACK_203:   5.6479997634887695,
		GROW_CURVE_ATTACK_204:   4.331999778747559,
		GROW_CURVE_ATTACK_205:   3.8340001106262207,
		GROW_CURVE_CRITICAL_201: 2.7769999504089355,
		GROW_CURVE_ATTACK_301:   5.084000110626221,
		GROW_CURVE_ATTACK_302:   5.558000087738037,
		GROW_CURVE_ATTACK_303:   6.000999927520752,
		GROW_CURVE_ATTACK_304:   4.574999809265137,
		GROW_CURVE_ATTACK_305:   4.0289998054504395,
		GROW_CURVE_CRITICAL_301: 2.7769999504089355,
	},
	{
		GROW_CURVE_ATTACK_101:   4.433000087738037,
		GROW_CURVE_ATTACK_102:   4.864999771118164,
		GROW_CURVE_ATTACK_103:   5.27400016784668,
		GROW_CURVE_ATTACK_104:   3.9739999771118164,
		GROW_CURVE_ATTACK_105:   3.486999988555908,
		GROW_CURVE_CRITICAL_101: 2.7769999504089355,
		GROW_CURVE_ATTACK_201:   4.88100004196167,
		GROW_CURVE_ATTACK_202:   5.330999851226807,
		GROW_CURVE_ATTACK_203:   5.755000114440918,
		GROW_CURVE_ATTACK_204:   4.401000022888184,
		GROW_CURVE_ATTACK_205:   3.8889999389648438,
		GROW_CURVE_CRITICAL_201: 2.7769999504089355,
		GROW_CURVE_ATTACK_301:   5.176000118255615,
		GROW_CURVE_ATTACK_302:   5.663000106811523,
		GROW_CURVE_ATTACK_303:   6.118000030517578,
		GROW_CURVE_ATTACK_304:   4.6529998779296875,
		GROW_CURVE_ATTACK_305:   4.0920000076293945,
		GROW_CURVE_CRITICAL_301: 2.7769999504089355,
	},
	{
		GROW_CURVE_ATTACK_101:   4.502999782562256,
		GROW_CURVE_ATTACK_102:   4.947999954223633,
		GROW_CURVE_ATTACK_103:   5.367000102996826,
		GROW_CURVE_ATTACK_104:   4.0320000648498535,
		GROW_CURVE_ATTACK_105:   3.5320000648498535,
		GROW_CURVE_CRITICAL_101: 2.7769999504089355,
		GROW_CURVE_ATTACK_201:   4.9629998207092285,
		GROW_CURVE_ATTACK_202:   5.426000118255615,
		GROW_CURVE_ATTACK_203:   5.861000061035156,
		GROW_CURVE_ATTACK_204:   4.4710001945495605,
		GROW_CURVE_ATTACK_205:   3.944999933242798,
		GROW_CURVE_CRITICAL_201: 2.7769999504089355,
		GROW_CURVE_ATTACK_301:   5.26800012588501,
		GROW_CURVE_ATTACK_302:   5.76800012588501,
		GROW_CURVE_ATTACK_303:   6.236000061035156,
		GROW_CURVE_ATTACK_304:   4.730999946594238,
		GROW_CURVE_ATTACK_305:   4.15500020980835,
		GROW_CURVE_CRITICAL_301: 2.7769999504089355,
	},
	{
		GROW_CURVE_ATTACK_101:   4.573999881744385,
		GROW_CURVE_ATTACK_102:   5.03000020980835,
		GROW_CURVE_ATTACK_103:   5.460999965667725,
		GROW_CURVE_ATTACK_104:   4.090000152587891,
		GROW_CURVE_ATTACK_105:   3.5759999752044678,
		GROW_CURVE_CRITICAL_101: 2.9790000915527344,
		GROW_CURVE_ATTACK_201:   5.046000003814697,
		GROW_CURVE_ATTACK_202:   5.520999908447266,
		GROW_CURVE_ATTACK_203:   5.9679999351501465,
		GROW_CURVE_ATTACK_204:   4.539999961853027,
		GROW_CURVE_ATTACK_205:   4,
		GROW_CURVE_CRITICAL_201: 2.9790000915527344,
		GROW_CURVE_ATTACK_301:   5.360000133514404,
		GROW_CURVE_ATTACK_302:   5.874000072479248,
		GROW_CURVE_ATTACK_303:   6.354000091552734,
		GROW_CURVE_ATTACK_304:   4.809999942779541,
		GROW_CURVE_ATTACK_305:   4.2170000076293945,
		GROW_CURVE_CRITICAL_301: 2.9790000915527344,
	},
	{
		GROW_CURVE_ATTACK_101:   4.644000053405762,
		GROW_CURVE_ATTACK_102:   5.111999988555908,
		GROW_CURVE_ATTACK_103:   5.553999900817871,
		GROW_CURVE_ATTACK_104:   4.1479997634887695,
		GROW_CURVE_ATTACK_105:   3.619999885559082,
		GROW_CURVE_CRITICAL_101: 2.9790000915527344,
		GROW_CURVE_ATTACK_201:   5.127999782562256,
		GROW_CURVE_ATTACK_202:   5.616000175476074,
		GROW_CURVE_ATTACK_203:   6.073999881744385,
		GROW_CURVE_ATTACK_204:   4.609000205993652,
		GROW_CURVE_ATTACK_205:   4.056000232696533,
		GROW_CURVE_CRITICAL_201: 2.9790000915527344,
		GROW_CURVE_ATTACK_301:   5.453000068664551,
		GROW_CURVE_ATTACK_302:   5.980000019073486,
		GROW_CURVE_ATTACK_303:   6.4730000495910645,
		GROW_CURVE_ATTACK_304:   4.888000011444092,
		GROW_CURVE_ATTACK_305:   4.28000020980835,
		GROW_CURVE_CRITICAL_301: 2.9790000915527344,
	},
	{
		GROW_CURVE_ATTACK_101:   4.714000225067139,
		GROW_CURVE_ATTACK_102:   5.193999767303467,
		GROW_CURVE_ATTACK_103:   5.6479997634887695,
		GROW_CURVE_ATTACK_104:   4.204999923706055,
		GROW_CURVE_ATTACK_105:   3.6649999618530273,
		GROW_CURVE_CRITICAL_101: 2.9790000915527344,
		GROW_CURVE_ATTACK_201:   5.210999965667725,
		GROW_CURVE_ATTACK_202:   5.710999965667725,
		GROW_CURVE_ATTACK_203:   6.181000232696533,
		GROW_CURVE_ATTACK_204:   4.678999900817871,
		GROW_CURVE_ATTACK_205:   4.111000061035156,
		GROW_CURVE_CRITICAL_201: 2.9790000915527344,
		GROW_CURVE_ATTACK_301:   5.546000003814697,
		GROW_CURVE_ATTACK_302:   6.085999965667725,
		GROW_CURVE_ATTACK_303:   6.5920000076293945,
		GROW_CURVE_ATTACK_304:   4.966000080108643,
		GROW_CURVE_ATTACK_305:   4.3429999351501465,
		GROW_CURVE_CRITICAL_301: 2.9790000915527344,
	},
	{
		GROW_CURVE_ATTACK_101:   4.783999919891357,
		GROW_CURVE_ATTACK_102:   5.2769999504089355,
		GROW_CURVE_ATTACK_103:   5.742000102996826,
		GROW_CURVE_ATTACK_104:   4.263000011444092,
		GROW_CURVE_ATTACK_105:   3.7079999446868896,
		GROW_CURVE_CRITICAL_101: 2.9790000915527344,
		GROW_CURVE_ATTACK_201:   5.294000148773193,
		GROW_CURVE_ATTACK_202:   5.806000232696533,
		GROW_CURVE_ATTACK_203:   6.288000106811523,
		GROW_CURVE_ATTACK_204:   4.748000144958496,
		GROW_CURVE_ATTACK_205:   4.165999889373779,
		GROW_CURVE_CRITICAL_201: 2.9790000915527344,
		GROW_CURVE_ATTACK_301:   5.638000011444092,
		GROW_CURVE_ATTACK_302:   6.191999912261963,
		GROW_CURVE_ATTACK_303:   6.710000038146973,
		GROW_CURVE_ATTACK_304:   5.044000148773193,
		GROW_CURVE_ATTACK_305:   4.406000137329102,
		GROW_CURVE_CRITICAL_301: 2.9790000915527344,
	},
	{
		GROW_CURVE_ATTACK_101:   4.855000019073486,
		GROW_CURVE_ATTACK_102:   5.359000205993652,
		GROW_CURVE_ATTACK_103:   5.835000038146973,
		GROW_CURVE_ATTACK_104:   4.320000171661377,
		GROW_CURVE_ATTACK_105:   3.752000093460083,
		GROW_CURVE_CRITICAL_101: 2.9790000915527344,
		GROW_CURVE_ATTACK_201:   5.375999927520752,
		GROW_CURVE_ATTACK_202:   5.901000022888184,
		GROW_CURVE_ATTACK_203:   6.394999980926514,
		GROW_CURVE_ATTACK_204:   4.816999912261963,
		GROW_CURVE_ATTACK_205:   4.2210001945495605,
		GROW_CURVE_CRITICAL_201: 2.9790000915527344,
		GROW_CURVE_ATTACK_301:   5.730999946594238,
		GROW_CURVE_ATTACK_302:   6.298999786376953,
		GROW_CURVE_ATTACK_303:   6.829999923706055,
		GROW_CURVE_ATTACK_304:   5.123000144958496,
		GROW_CURVE_ATTACK_305:   4.468999862670898,
		GROW_CURVE_CRITICAL_301: 2.9790000915527344,
	},
	{
		GROW_CURVE_ATTACK_101:   4.925000190734863,
		GROW_CURVE_ATTACK_102:   5.440999984741211,
		GROW_CURVE_ATTACK_103:   5.928999900817871,
		GROW_CURVE_ATTACK_104:   4.376999855041504,
		GROW_CURVE_ATTACK_105:   3.7960000038146973,
		GROW_CURVE_CRITICAL_101: 3.180999994277954,
		GROW_CURVE_ATTACK_201:   5.459000110626221,
		GROW_CURVE_ATTACK_202:   5.995999813079834,
		GROW_CURVE_ATTACK_203:   6.501999855041504,
		GROW_CURVE_ATTACK_204:   4.886000156402588,
		GROW_CURVE_ATTACK_205:   4.275000095367432,
		GROW_CURVE_CRITICAL_201: 3.180999994277954,
		GROW_CURVE_ATTACK_301:   5.824999809265137,
		GROW_CURVE_ATTACK_302:   6.406000137329102,
		GROW_CURVE_ATTACK_303:   6.948999881744385,
		GROW_CURVE_ATTACK_304:   5.201000213623047,
		GROW_CURVE_ATTACK_305:   4.5320000648498535,
		GROW_CURVE_CRITICAL_301: 3.180999994277954,
	},
	{
		GROW_CURVE_ATTACK_101:   4.994999885559082,
		GROW_CURVE_ATTACK_102:   5.5229997634887695,
		GROW_CURVE_ATTACK_103:   6.0229997634887695,
		GROW_CURVE_ATTACK_104:   4.434000015258789,
		GROW_CURVE_ATTACK_105:   3.8389999866485596,
		GROW_CURVE_CRITICAL_101: 3.180999994277954,
		GROW_CURVE_ATTACK_201:   5.540999889373779,
		GROW_CURVE_ATTACK_202:   6.0920000076293945,
		GROW_CURVE_ATTACK_203:   6.609000205993652,
		GROW_CURVE_ATTACK_204:   4.954999923706055,
		GROW_CURVE_ATTACK_205:   4.329999923706055,
		GROW_CURVE_CRITICAL_201: 3.180999994277954,
		GROW_CURVE_ATTACK_301:   5.918000221252441,
		GROW_CURVE_ATTACK_302:   6.513000011444092,
		GROW_CURVE_ATTACK_303:   7.068999767303467,
		GROW_CURVE_ATTACK_304:   5.28000020980835,
		GROW_CURVE_ATTACK_305:   4.593999862670898,
		GROW_CURVE_CRITICAL_301: 3.180999994277954,
	},
	{
		GROW_CURVE_ATTACK_101:   5.065000057220459,
		GROW_CURVE_ATTACK_102:   5.605000019073486,
		GROW_CURVE_ATTACK_103:   6.116000175476074,
		GROW_CURVE_ATTACK_104:   4.491000175476074,
		GROW_CURVE_ATTACK_105:   3.881999969482422,
		GROW_CURVE_CRITICAL_101: 3.180999994277954,
		GROW_CURVE_ATTACK_201:   5.624000072479248,
		GROW_CURVE_ATTACK_202:   6.186999797821045,
		GROW_CURVE_ATTACK_203:   6.7170000076293945,
		GROW_CURVE_ATTACK_204:   5.02400016784668,
		GROW_CURVE_ATTACK_205:   4.383999824523926,
		GROW_CURVE_CRITICAL_201: 3.180999994277954,
		GROW_CURVE_ATTACK_301:   6.011000156402588,
		GROW_CURVE_ATTACK_302:   6.619999885559082,
		GROW_CURVE_ATTACK_303:   7.189000129699707,
		GROW_CURVE_ATTACK_304:   5.359000205993652,
		GROW_CURVE_ATTACK_305:   4.6570000648498535,
		GROW_CURVE_CRITICAL_301: 3.180999994277954,
	},
	{
		GROW_CURVE_ATTACK_101:   5.133999824523926,
		GROW_CURVE_ATTACK_102:   5.688000202178955,
		GROW_CURVE_ATTACK_103:   6.210000038146973,
		GROW_CURVE_ATTACK_104:   4.547999858856201,
		GROW_CURVE_ATTACK_105:   3.924999952316284,
		GROW_CURVE_CRITICAL_101: 3.180999994277954,
		GROW_CURVE_ATTACK_201:   5.705999851226807,
		GROW_CURVE_ATTACK_202:   6.2820000648498535,
		GROW_CURVE_ATTACK_203:   6.823999881744385,
		GROW_CURVE_ATTACK_204:   5.0929999351501465,
		GROW_CURVE_ATTACK_205:   4.439000129699707,
		GROW_CURVE_CRITICAL_201: 3.180999994277954,
		GROW_CURVE_ATTACK_301:   6.105000019073486,
		GROW_CURVE_ATTACK_302:   6.7270002365112305,
		GROW_CURVE_ATTACK_303:   7.309000015258789,
		GROW_CURVE_ATTACK_304:   5.436999797821045,
		GROW_CURVE_ATTACK_305:   4.71999979019165,
		GROW_CURVE_CRITICAL_301: 3.180999994277954,
	},
	{
		GROW_CURVE_ATTACK_101:   5.203999996185303,
		GROW_CURVE_ATTACK_102:   5.769999980926514,
		GROW_CURVE_ATTACK_103:   6.303999900817871,
		GROW_CURVE_ATTACK_104:   4.605000019073486,
		GROW_CURVE_ATTACK_105:   3.9679999351501465,
		GROW_CURVE_CRITICAL_101: 3.180999994277954,
		GROW_CURVE_ATTACK_201:   5.789000034332275,
		GROW_CURVE_ATTACK_202:   6.377999782562256,
		GROW_CURVE_ATTACK_203:   6.932000160217285,
		GROW_CURVE_ATTACK_204:   5.1620001792907715,
		GROW_CURVE_ATTACK_205:   4.493000030517578,
		GROW_CURVE_CRITICAL_201: 3.180999994277954,
		GROW_CURVE_ATTACK_301:   6.197999954223633,
		GROW_CURVE_ATTACK_302:   6.835000038146973,
		GROW_CURVE_ATTACK_303:   7.428999900817871,
		GROW_CURVE_ATTACK_304:   5.515999794006348,
		GROW_CURVE_ATTACK_305:   4.7829999923706055,
		GROW_CURVE_CRITICAL_301: 3.180999994277954,
	},
	{
		GROW_CURVE_ATTACK_101:   5.27400016784668,
		GROW_CURVE_ATTACK_102:   5.8520002365112305,
		GROW_CURVE_ATTACK_103:   6.3979997634887695,
		GROW_CURVE_ATTACK_104:   4.660999774932861,
		GROW_CURVE_ATTACK_105:   4.010000228881836,
		GROW_CURVE_CRITICAL_101: 3.382999897003174,
		GROW_CURVE_ATTACK_201:   5.872000217437744,
		GROW_CURVE_ATTACK_202:   6.4730000495910645,
		GROW_CURVE_ATTACK_203:   7.039000034332275,
		GROW_CURVE_ATTACK_204:   5.230999946594238,
		GROW_CURVE_ATTACK_205:   4.546999931335449,
		GROW_CURVE_CRITICAL_201: 3.382999897003174,
		GROW_CURVE_ATTACK_301:   6.291999816894531,
		GROW_CURVE_ATTACK_302:   6.941999912261963,
		GROW_CURVE_ATTACK_303:   7.550000190734863,
		GROW_CURVE_ATTACK_304:   5.59499979019165,
		GROW_CURVE_ATTACK_305:   4.8460001945495605,
		GROW_CURVE_CRITICAL_301: 3.382999897003174,
	},
	{
		GROW_CURVE_ATTACK_101:   5.343999862670898,
		GROW_CURVE_ATTACK_102:   5.934000015258789,
		GROW_CURVE_ATTACK_103:   6.492000102996826,
		GROW_CURVE_ATTACK_104:   4.7179999351501465,
		GROW_CURVE_ATTACK_105:   4.052999973297119,
		GROW_CURVE_CRITICAL_101: 3.382999897003174,
		GROW_CURVE_ATTACK_201:   5.953999996185303,
		GROW_CURVE_ATTACK_202:   6.568999767303467,
		GROW_CURVE_ATTACK_203:   7.146999835968018,
		GROW_CURVE_ATTACK_204:   5.300000190734863,
		GROW_CURVE_ATTACK_205:   4.60099983215332,
		GROW_CURVE_CRITICAL_201: 3.382999897003174,
		GROW_CURVE_ATTACK_301:   6.386000156402588,
		GROW_CURVE_ATTACK_302:   7.050000190734863,
		GROW_CURVE_ATTACK_303:   7.671000003814697,
		GROW_CURVE_ATTACK_304:   5.673999786376953,
		GROW_CURVE_ATTACK_305:   4.908999919891357,
		GROW_CURVE_CRITICAL_301: 3.382999897003174,
	},
	{
		GROW_CURVE_ATTACK_101:   5.413000106811523,
		GROW_CURVE_ATTACK_102:   6.015999794006348,
		GROW_CURVE_ATTACK_103:   6.585999965667725,
		GROW_CURVE_ATTACK_104:   4.77400016784668,
		GROW_CURVE_ATTACK_105:   4.09499979019165,
		GROW_CURVE_CRITICAL_101: 3.382999897003174,
		GROW_CURVE_ATTACK_201:   6.0370001792907715,
		GROW_CURVE_ATTACK_202:   6.664000034332275,
		GROW_CURVE_ATTACK_203:   7.255000114440918,
		GROW_CURVE_ATTACK_204:   5.368000030517578,
		GROW_CURVE_ATTACK_205:   4.65500020980835,
		GROW_CURVE_CRITICAL_201: 3.382999897003174,
		GROW_CURVE_ATTACK_301:   6.480000019073486,
		GROW_CURVE_ATTACK_302:   7.1579999923706055,
		GROW_CURVE_ATTACK_303:   7.791999816894531,
		GROW_CURVE_ATTACK_304:   5.752999782562256,
		GROW_CURVE_ATTACK_305:   4.9720001220703125,
		GROW_CURVE_CRITICAL_301: 3.382999897003174,
	},
	{
		GROW_CURVE_ATTACK_101:   5.482999801635742,
		GROW_CURVE_ATTACK_102:   6.0980000495910645,
		GROW_CURVE_ATTACK_103:   6.679999828338623,
		GROW_CURVE_ATTACK_104:   4.829999923706055,
		GROW_CURVE_ATTACK_105:   4.13700008392334,
		GROW_CURVE_CRITICAL_101: 3.382999897003174,
		GROW_CURVE_ATTACK_201:   6.11899995803833,
		GROW_CURVE_ATTACK_202:   6.760000228881836,
		GROW_CURVE_ATTACK_203:   7.36299991607666,
		GROW_CURVE_ATTACK_204:   5.436999797821045,
		GROW_CURVE_ATTACK_205:   4.709000110626221,
		GROW_CURVE_CRITICAL_201: 3.382999897003174,
		GROW_CURVE_ATTACK_301:   6.574999809265137,
		GROW_CURVE_ATTACK_302:   7.267000198364258,
		GROW_CURVE_ATTACK_303:   7.913000106811523,
		GROW_CURVE_ATTACK_304:   5.833000183105469,
		GROW_CURVE_ATTACK_305:   5.034999847412109,
		GROW_CURVE_CRITICAL_301: 3.382999897003174,
	},
	{
		GROW_CURVE_ATTACK_101:   5.552000045776367,
		GROW_CURVE_ATTACK_102:   6.179999828338623,
		GROW_CURVE_ATTACK_103:   6.77400016784668,
		GROW_CURVE_ATTACK_104:   4.88700008392334,
		GROW_CURVE_ATTACK_105:   4.178999900817871,
		GROW_CURVE_CRITICAL_101: 3.382999897003174,
		GROW_CURVE_ATTACK_201:   6.202000141143799,
		GROW_CURVE_ATTACK_202:   6.855999946594238,
		GROW_CURVE_ATTACK_203:   7.4710001945495605,
		GROW_CURVE_ATTACK_204:   5.50600004196167,
		GROW_CURVE_ATTACK_205:   4.763000011444092,
		GROW_CURVE_CRITICAL_201: 3.382999897003174,
		GROW_CURVE_ATTACK_301:   6.669000148773193,
		GROW_CURVE_ATTACK_302:   7.375,
		GROW_CURVE_ATTACK_303:   8.03499984741211,
		GROW_CURVE_ATTACK_304:   5.9120001792907715,
		GROW_CURVE_ATTACK_305:   5.0980000495910645,
		GROW_CURVE_CRITICAL_301: 3.382999897003174,
	},
	{
		GROW_CURVE_ATTACK_101:   5.622000217437744,
		GROW_CURVE_ATTACK_102:   6.26200008392334,
		GROW_CURVE_ATTACK_103:   6.868000030517578,
		GROW_CURVE_ATTACK_104:   4.942999839782715,
		GROW_CURVE_ATTACK_105:   4.2210001945495605,
		GROW_CURVE_CRITICAL_101: 3.5850000381469727,
		GROW_CURVE_ATTACK_201:   6.283999919891357,
		GROW_CURVE_ATTACK_202:   6.951000213623047,
		GROW_CURVE_ATTACK_203:   7.578999996185303,
		GROW_CURVE_ATTACK_204:   5.573999881744385,
		GROW_CURVE_ATTACK_205:   4.815999984741211,
		GROW_CURVE_CRITICAL_201: 3.5850000381469727,
		GROW_CURVE_ATTACK_301:   6.763000011444092,
		GROW_CURVE_ATTACK_302:   7.484000205993652,
		GROW_CURVE_ATTACK_303:   8.156999588012695,
		GROW_CURVE_ATTACK_304:   5.991000175476074,
		GROW_CURVE_ATTACK_305:   5.160999774932861,
		GROW_CURVE_CRITICAL_301: 3.5850000381469727,
	},
	{
		GROW_CURVE_ATTACK_101:   5.690999984741211,
		GROW_CURVE_ATTACK_102:   6.343999862670898,
		GROW_CURVE_ATTACK_103:   6.961999893188477,
		GROW_CURVE_ATTACK_104:   4.999000072479248,
		GROW_CURVE_ATTACK_105:   4.263000011444092,
		GROW_CURVE_CRITICAL_101: 3.5850000381469727,
		GROW_CURVE_ATTACK_201:   6.367000102996826,
		GROW_CURVE_ATTACK_202:   7.046999931335449,
		GROW_CURVE_ATTACK_203:   7.686999797821045,
		GROW_CURVE_ATTACK_204:   5.64300012588501,
		GROW_CURVE_ATTACK_205:   4.869999885559082,
		GROW_CURVE_CRITICAL_201: 3.5850000381469727,
		GROW_CURVE_ATTACK_301:   6.857999801635742,
		GROW_CURVE_ATTACK_302:   7.5920000076293945,
		GROW_CURVE_ATTACK_303:   8.279000282287598,
		GROW_CURVE_ATTACK_304:   6.071000099182129,
		GROW_CURVE_ATTACK_305:   5.224999904632568,
		GROW_CURVE_CRITICAL_301: 3.5850000381469727,
	},
	{
		GROW_CURVE_ATTACK_101:   5.761000156402588,
		GROW_CURVE_ATTACK_102:   6.427000045776367,
		GROW_CURVE_ATTACK_103:   7.056000232696533,
		GROW_CURVE_ATTACK_104:   5.053999900817871,
		GROW_CURVE_ATTACK_105:   4.303999900817871,
		GROW_CURVE_CRITICAL_101: 3.5850000381469727,
		GROW_CURVE_ATTACK_201:   6.449999809265137,
		GROW_CURVE_ATTACK_202:   7.14300012588501,
		GROW_CURVE_ATTACK_203:   7.795000076293945,
		GROW_CURVE_ATTACK_204:   5.710999965667725,
		GROW_CURVE_ATTACK_205:   4.922999858856201,
		GROW_CURVE_CRITICAL_201: 3.5850000381469727,
		GROW_CURVE_ATTACK_301:   6.953000068664551,
		GROW_CURVE_ATTACK_302:   7.701000213623047,
		GROW_CURVE_ATTACK_303:   8.401000022888184,
		GROW_CURVE_ATTACK_304:   6.150000095367432,
		GROW_CURVE_ATTACK_305:   5.288000106811523,
		GROW_CURVE_CRITICAL_301: 3.5850000381469727,
	},
	{
		GROW_CURVE_ATTACK_101:   5.829999923706055,
		GROW_CURVE_ATTACK_102:   6.508999824523926,
		GROW_CURVE_ATTACK_103:   7.150000095367432,
		GROW_CURVE_ATTACK_104:   5.110000133514404,
		GROW_CURVE_ATTACK_105:   4.3460001945495605,
		GROW_CURVE_CRITICAL_101: 3.5850000381469727,
		GROW_CURVE_ATTACK_201:   6.5320000648498535,
		GROW_CURVE_ATTACK_202:   7.238999843597412,
		GROW_CURVE_ATTACK_203:   7.9039998054504395,
		GROW_CURVE_ATTACK_204:   5.78000020980835,
		GROW_CURVE_ATTACK_205:   4.9770002365112305,
		GROW_CURVE_CRITICAL_201: 3.5850000381469727,
		GROW_CURVE_ATTACK_301:   7.047999858856201,
		GROW_CURVE_ATTACK_302:   7.810999870300293,
		GROW_CURVE_ATTACK_303:   8.52400016784668,
		GROW_CURVE_ATTACK_304:   6.230000019073486,
		GROW_CURVE_ATTACK_305:   5.35099983215332,
		GROW_CURVE_CRITICAL_301: 3.5850000381469727,
	},
	{
		GROW_CURVE_ATTACK_101:   5.89900016784668,
		GROW_CURVE_ATTACK_102:   6.591000080108643,
		GROW_CURVE_ATTACK_103:   7.24399995803833,
		GROW_CURVE_ATTACK_104:   5.165999889373779,
		GROW_CURVE_ATTACK_105:   4.38700008392334,
		GROW_CURVE_CRITICAL_101: 3.5850000381469727,
		GROW_CURVE_ATTACK_201:   6.614999771118164,
		GROW_CURVE_ATTACK_202:   7.335000038146973,
		GROW_CURVE_ATTACK_203:   8.01200008392334,
		GROW_CURVE_ATTACK_204:   5.8480000495910645,
		GROW_CURVE_ATTACK_205:   5.03000020980835,
		GROW_CURVE_CRITICAL_201: 3.5850000381469727,
		GROW_CURVE_ATTACK_301:   7.14300012588501,
		GROW_CURVE_ATTACK_302:   7.920000076293945,
		GROW_CURVE_ATTACK_303:   8.645999908447266,
		GROW_CURVE_ATTACK_304:   6.309999942779541,
		GROW_CURVE_ATTACK_305:   5.414000034332275,
		GROW_CURVE_CRITICAL_301: 3.5850000381469727,
	},
	{
		GROW_CURVE_ATTACK_101:   5.9679999351501465,
		GROW_CURVE_ATTACK_102:   6.672999858856201,
		GROW_CURVE_ATTACK_103:   7.3379998207092285,
		GROW_CURVE_ATTACK_104:   5.2220001220703125,
		GROW_CURVE_ATTACK_105:   4.427999973297119,
		GROW_CURVE_CRITICAL_101: 3.7860000133514404,
		GROW_CURVE_ATTACK_201:   6.697000026702881,
		GROW_CURVE_ATTACK_202:   7.431000232696533,
		GROW_CURVE_ATTACK_203:   8.119999885559082,
		GROW_CURVE_ATTACK_204:   5.915999889373779,
		GROW_CURVE_ATTACK_205:   5.083000183105469,
		GROW_CURVE_CRITICAL_201: 3.7860000133514404,
		GROW_CURVE_ATTACK_301:   7.23799991607666,
		GROW_CURVE_ATTACK_302:   8.029999732971191,
		GROW_CURVE_ATTACK_303:   8.769000053405762,
		GROW_CURVE_ATTACK_304:   6.389999866485596,
		GROW_CURVE_ATTACK_305:   5.478000164031982,
		GROW_CURVE_CRITICAL_301: 3.7860000133514404,
	},
	{
		GROW_CURVE_ATTACK_101:   6.038000106811523,
		GROW_CURVE_ATTACK_102:   6.755000114440918,
		GROW_CURVE_ATTACK_103:   7.432000160217285,
		GROW_CURVE_ATTACK_104:   5.2769999504089355,
		GROW_CURVE_ATTACK_105:   4.468999862670898,
		GROW_CURVE_CRITICAL_101: 3.7860000133514404,
		GROW_CURVE_ATTACK_201:   6.78000020980835,
		GROW_CURVE_ATTACK_202:   7.5269999504089355,
		GROW_CURVE_ATTACK_203:   8.229000091552734,
		GROW_CURVE_ATTACK_204:   5.985000133514404,
		GROW_CURVE_ATTACK_205:   5.136000156402588,
		GROW_CURVE_CRITICAL_201: 3.7860000133514404,
		GROW_CURVE_ATTACK_301:   7.334000110626221,
		GROW_CURVE_ATTACK_302:   8.138999938964844,
		GROW_CURVE_ATTACK_303:   8.892999649047852,
		GROW_CURVE_ATTACK_304:   6.46999979019165,
		GROW_CURVE_ATTACK_305:   5.540999889373779,
		GROW_CURVE_CRITICAL_301: 3.7860000133514404,
	},
	{
		GROW_CURVE_ATTACK_101:   6.10699987411499,
		GROW_CURVE_ATTACK_102:   6.836999893188477,
		GROW_CURVE_ATTACK_103:   7.5269999504089355,
		GROW_CURVE_ATTACK_104:   5.333000183105469,
		GROW_CURVE_ATTACK_105:   4.510000228881836,
		GROW_CURVE_CRITICAL_101: 3.7860000133514404,
		GROW_CURVE_ATTACK_201:   6.861999988555908,
		GROW_CURVE_ATTACK_202:   7.623000144958496,
		GROW_CURVE_ATTACK_203:   8.338000297546387,
		GROW_CURVE_ATTACK_204:   6.052999973297119,
		GROW_CURVE_ATTACK_205:   5.189000129699707,
		GROW_CURVE_CRITICAL_201: 3.7860000133514404,
		GROW_CURVE_ATTACK_301:   7.428999900817871,
		GROW_CURVE_ATTACK_302:   8.24899959564209,
		GROW_CURVE_ATTACK_303:   9.015999794006348,
		GROW_CURVE_ATTACK_304:   6.550000190734863,
		GROW_CURVE_ATTACK_305:   5.605000019073486,
		GROW_CURVE_CRITICAL_301: 3.7860000133514404,
	},
	{
		GROW_CURVE_ATTACK_101:   6.176000118255615,
		GROW_CURVE_ATTACK_102:   6.919000148773193,
		GROW_CURVE_ATTACK_103:   7.620999813079834,
		GROW_CURVE_ATTACK_104:   5.388000011444092,
		GROW_CURVE_ATTACK_105:   4.551000118255615,
		GROW_CURVE_CRITICAL_101: 3.7860000133514404,
		GROW_CURVE_ATTACK_201:   6.945000171661377,
		GROW_CURVE_ATTACK_202:   7.718999862670898,
		GROW_CURVE_ATTACK_203:   8.446000099182129,
		GROW_CURVE_ATTACK_204:   6.120999813079834,
		GROW_CURVE_ATTACK_205:   5.242000102996826,
		GROW_CURVE_CRITICAL_201: 3.7860000133514404,
		GROW_CURVE_ATTACK_301:   7.525000095367432,
		GROW_CURVE_ATTACK_302:   8.359000205993652,
		GROW_CURVE_ATTACK_303:   9.140000343322754,
		GROW_CURVE_ATTACK_304:   6.630000114440918,
		GROW_CURVE_ATTACK_305:   5.668000221252441,
		GROW_CURVE_CRITICAL_301: 3.7860000133514404,
	},
	{
		GROW_CURVE_ATTACK_101:   6.244999885559082,
		GROW_CURVE_ATTACK_102:   7.000999927520752,
		GROW_CURVE_ATTACK_103:   7.715000152587891,
		GROW_CURVE_ATTACK_104:   5.442999839782715,
		GROW_CURVE_ATTACK_105:   4.5920000076293945,
		GROW_CURVE_CRITICAL_101: 3.7860000133514404,
		GROW_CURVE_ATTACK_201:   7.0279998779296875,
		GROW_CURVE_ATTACK_202:   7.815000057220459,
		GROW_CURVE_ATTACK_203:   8.555000305175781,
		GROW_CURVE_ATTACK_204:   6.189000129699707,
		GROW_CURVE_ATTACK_205:   5.295000076293945,
		GROW_CURVE_CRITICAL_201: 3.7860000133514404,
		GROW_CURVE_ATTACK_301:   7.620999813079834,
		GROW_CURVE_ATTACK_302:   8.470000267028809,
		GROW_CURVE_ATTACK_303:   9.262999534606934,
		GROW_CURVE_ATTACK_304:   6.710000038146973,
		GROW_CURVE_ATTACK_305:   5.73199987411499,
		GROW_CURVE_CRITICAL_301: 3.7860000133514404,
	},
	{
		GROW_CURVE_ATTACK_101:   6.314000129699707,
		GROW_CURVE_ATTACK_102:   7.083000183105469,
		GROW_CURVE_ATTACK_103:   7.809999942779541,
		GROW_CURVE_ATTACK_104:   5.498000144958496,
		GROW_CURVE_ATTACK_105:   4.631999969482422,
		GROW_CURVE_CRITICAL_101: 3.98799991607666,
		GROW_CURVE_ATTACK_201:   7.110000133514404,
		GROW_CURVE_ATTACK_202:   7.910999774932861,
		GROW_CURVE_ATTACK_203:   8.663999557495117,
		GROW_CURVE_ATTACK_204:   6.256999969482422,
		GROW_CURVE_ATTACK_205:   5.3470001220703125,
		GROW_CURVE_CRITICAL_201: 3.98799991607666,
		GROW_CURVE_ATTACK_301:   7.7170000076293945,
		GROW_CURVE_ATTACK_302:   8.579999923706055,
		GROW_CURVE_ATTACK_303:   9.38700008392334,
		GROW_CURVE_ATTACK_304:   6.790999889373779,
		GROW_CURVE_ATTACK_305:   5.796000003814697,
		GROW_CURVE_CRITICAL_301: 3.98799991607666,
	},
	{
		GROW_CURVE_ATTACK_101:   6.382999897003174,
		GROW_CURVE_ATTACK_102:   7.164999961853027,
		GROW_CURVE_ATTACK_103:   7.9039998054504395,
		GROW_CURVE_ATTACK_104:   5.553999900817871,
		GROW_CURVE_ATTACK_105:   4.672999858856201,
		GROW_CURVE_CRITICAL_101: 3.98799991607666,
		GROW_CURVE_ATTACK_201:   7.192999839782715,
		GROW_CURVE_ATTACK_202:   8.006999969482422,
		GROW_CURVE_ATTACK_203:   8.77299976348877,
		GROW_CURVE_ATTACK_204:   6.326000213623047,
		GROW_CURVE_ATTACK_205:   5.400000095367432,
		GROW_CURVE_CRITICAL_201: 3.98799991607666,
		GROW_CURVE_ATTACK_301:   7.813000202178955,
		GROW_CURVE_ATTACK_302:   8.690999984741211,
		GROW_CURVE_ATTACK_303:   9.51200008392334,
		GROW_CURVE_ATTACK_304:   6.870999813079834,
		GROW_CURVE_ATTACK_305:   5.859000205993652,
		GROW_CURVE_CRITICAL_301: 3.98799991607666,
	},
	{
		GROW_CURVE_ATTACK_101:   6.452000141143799,
		GROW_CURVE_ATTACK_102:   7.247000217437744,
		GROW_CURVE_ATTACK_103:   7.998000144958496,
		GROW_CURVE_ATTACK_104:   5.609000205993652,
		GROW_CURVE_ATTACK_105:   4.7129998207092285,
		GROW_CURVE_CRITICAL_101: 3.98799991607666,
		GROW_CURVE_ATTACK_201:   7.275000095367432,
		GROW_CURVE_ATTACK_202:   8.102999687194824,
		GROW_CURVE_ATTACK_203:   8.881999969482422,
		GROW_CURVE_ATTACK_204:   6.394000053405762,
		GROW_CURVE_ATTACK_205:   5.453000068664551,
		GROW_CURVE_CRITICAL_201: 3.98799991607666,
		GROW_CURVE_ATTACK_301:   7.908999919891357,
		GROW_CURVE_ATTACK_302:   8.802000045776367,
		GROW_CURVE_ATTACK_303:   9.63599967956543,
		GROW_CURVE_ATTACK_304:   6.952000141143799,
		GROW_CURVE_ATTACK_305:   5.922999858856201,
		GROW_CURVE_CRITICAL_301: 3.98799991607666,
	},
	{
		GROW_CURVE_ATTACK_101:   6.520999908447266,
		GROW_CURVE_ATTACK_102:   7.328999996185303,
		GROW_CURVE_ATTACK_103:   8.093000411987305,
		GROW_CURVE_ATTACK_104:   5.664000034332275,
		GROW_CURVE_ATTACK_105:   4.752999782562256,
		GROW_CURVE_CRITICAL_101: 3.98799991607666,
		GROW_CURVE_ATTACK_201:   7.357999801635742,
		GROW_CURVE_ATTACK_202:   8.199000358581543,
		GROW_CURVE_ATTACK_203:   8.991000175476074,
		GROW_CURVE_ATTACK_204:   6.461999893188477,
		GROW_CURVE_ATTACK_205:   5.505000114440918,
		GROW_CURVE_CRITICAL_201: 3.98799991607666,
		GROW_CURVE_ATTACK_301:   8.005000114440918,
		GROW_CURVE_ATTACK_302:   8.913000106811523,
		GROW_CURVE_ATTACK_303:   9.76099967956543,
		GROW_CURVE_ATTACK_304:   7.0329999923706055,
		GROW_CURVE_ATTACK_305:   5.986999988555908,
		GROW_CURVE_CRITICAL_301: 3.98799991607666,
	},
	{
		GROW_CURVE_ATTACK_101:   6.590000152587891,
		GROW_CURVE_ATTACK_102:   7.410999774932861,
		GROW_CURVE_ATTACK_103:   8.187000274658203,
		GROW_CURVE_ATTACK_104:   5.718999862670898,
		GROW_CURVE_ATTACK_105:   4.793000221252441,
		GROW_CURVE_CRITICAL_101: 3.98799991607666,
		GROW_CURVE_ATTACK_201:   7.440000057220459,
		GROW_CURVE_ATTACK_202:   8.295999526977539,
		GROW_CURVE_ATTACK_203:   9.100000381469727,
		GROW_CURVE_ATTACK_204:   6.53000020980835,
		GROW_CURVE_ATTACK_205:   5.558000087738037,
		GROW_CURVE_CRITICAL_201: 3.98799991607666,
		GROW_CURVE_ATTACK_301:   8.10200023651123,
		GROW_CURVE_ATTACK_302:   9.02400016784668,
		GROW_CURVE_ATTACK_303:   9.88599967956543,
		GROW_CURVE_ATTACK_304:   7.11299991607666,
		GROW_CURVE_ATTACK_305:   6.051000118255615,
		GROW_CURVE_CRITICAL_301: 3.98799991607666,
	},
	{
		GROW_CURVE_ATTACK_101:   6.658999919891357,
		GROW_CURVE_ATTACK_102:   7.493000030517578,
		GROW_CURVE_ATTACK_103:   8.281999588012695,
		GROW_CURVE_ATTACK_104:   5.77400016784668,
		GROW_CURVE_ATTACK_105:   4.834000110626221,
		GROW_CURVE_CRITICAL_101: 4.190000057220459,
		GROW_CURVE_ATTACK_201:   7.5229997634887695,
		GROW_CURVE_ATTACK_202:   8.392000198364258,
		GROW_CURVE_ATTACK_203:   9.208999633789062,
		GROW_CURVE_ATTACK_204:   6.5980000495910645,
		GROW_CURVE_ATTACK_205:   5.610000133514404,
		GROW_CURVE_CRITICAL_201: 4.190000057220459,
		GROW_CURVE_ATTACK_301:   8.199000358581543,
		GROW_CURVE_ATTACK_302:   9.135000228881836,
		GROW_CURVE_ATTACK_303:   10.01099967956543,
		GROW_CURVE_ATTACK_304:   7.193999767303467,
		GROW_CURVE_ATTACK_305:   6.114999771118164,
		GROW_CURVE_CRITICAL_301: 4.190000057220459,
	},
	{
		GROW_CURVE_ATTACK_101:   6.7270002365112305,
		GROW_CURVE_ATTACK_102:   7.574999809265137,
		GROW_CURVE_ATTACK_103:   8.37600040435791,
		GROW_CURVE_ATTACK_104:   5.828000068664551,
		GROW_CURVE_ATTACK_105:   4.873000144958496,
		GROW_CURVE_CRITICAL_101: 4.190000057220459,
		GROW_CURVE_ATTACK_201:   7.605999946594238,
		GROW_CURVE_ATTACK_202:   8.48799991607666,
		GROW_CURVE_ATTACK_203:   9.319000244140625,
		GROW_CURVE_ATTACK_204:   6.664999961853027,
		GROW_CURVE_ATTACK_205:   5.6620001792907715,
		GROW_CURVE_CRITICAL_201: 4.190000057220459,
		GROW_CURVE_ATTACK_301:   8.295000076293945,
		GROW_CURVE_ATTACK_302:   9.246999740600586,
		GROW_CURVE_ATTACK_303:   10.13599967956543,
		GROW_CURVE_ATTACK_304:   7.275000095367432,
		GROW_CURVE_ATTACK_305:   6.178999900817871,
		GROW_CURVE_CRITICAL_301: 4.190000057220459,
	},
	{
		GROW_CURVE_ATTACK_101:   6.796000003814697,
		GROW_CURVE_ATTACK_102:   7.6570000648498535,
		GROW_CURVE_ATTACK_103:   8.470999717712402,
		GROW_CURVE_ATTACK_104:   5.882999897003174,
		GROW_CURVE_ATTACK_105:   4.913000106811523,
		GROW_CURVE_CRITICAL_101: 4.190000057220459,
		GROW_CURVE_ATTACK_201:   7.688000202178955,
		GROW_CURVE_ATTACK_202:   8.585000038146973,
		GROW_CURVE_ATTACK_203:   9.428000450134277,
		GROW_CURVE_ATTACK_204:   6.732999801635742,
		GROW_CURVE_ATTACK_205:   5.715000152587891,
		GROW_CURVE_CRITICAL_201: 4.190000057220459,
		GROW_CURVE_ATTACK_301:   8.392000198364258,
		GROW_CURVE_ATTACK_302:   9.357999801635742,
		GROW_CURVE_ATTACK_303:   10.26099967956543,
		GROW_CURVE_ATTACK_304:   7.35699987411499,
		GROW_CURVE_ATTACK_305:   6.243000030517578,
		GROW_CURVE_CRITICAL_301: 4.190000057220459,
	},
	{
		GROW_CURVE_ATTACK_101:   6.864999771118164,
		GROW_CURVE_ATTACK_102:   7.738999843597412,
		GROW_CURVE_ATTACK_103:   8.5649995803833,
		GROW_CURVE_ATTACK_104:   5.938000202178955,
		GROW_CURVE_ATTACK_105:   4.953000068664551,
		GROW_CURVE_CRITICAL_101: 4.190000057220459,
		GROW_CURVE_ATTACK_201:   7.770999908447266,
		GROW_CURVE_ATTACK_202:   8.680999755859375,
		GROW_CURVE_ATTACK_203:   9.536999702453613,
		GROW_CURVE_ATTACK_204:   6.801000118255615,
		GROW_CURVE_ATTACK_205:   5.767000198364258,
		GROW_CURVE_CRITICAL_201: 4.190000057220459,
		GROW_CURVE_ATTACK_301:   8.48900032043457,
		GROW_CURVE_ATTACK_302:   9.470000267028809,
		GROW_CURVE_ATTACK_303:   10.38700008392334,
		GROW_CURVE_ATTACK_304:   7.438000202178955,
		GROW_CURVE_ATTACK_305:   6.308000087738037,
		GROW_CURVE_CRITICAL_301: 4.190000057220459,
	},
	{
		GROW_CURVE_ATTACK_101:   6.934000015258789,
		GROW_CURVE_ATTACK_102:   7.821000099182129,
		GROW_CURVE_ATTACK_103:   8.65999984741211,
		GROW_CURVE_ATTACK_104:   5.993000030517578,
		GROW_CURVE_ATTACK_105:   4.993000030517578,
		GROW_CURVE_CRITICAL_101: 4.190000057220459,
		GROW_CURVE_ATTACK_201:   7.853000164031982,
		GROW_CURVE_ATTACK_202:   8.777000427246094,
		GROW_CURVE_ATTACK_203:   9.647000312805176,
		GROW_CURVE_ATTACK_204:   6.86899995803833,
		GROW_CURVE_ATTACK_205:   5.818999767303467,
		GROW_CURVE_CRITICAL_201: 4.190000057220459,
		GROW_CURVE_ATTACK_301:   8.586999893188477,
		GROW_CURVE_ATTACK_302:   9.581999778747559,
		GROW_CURVE_ATTACK_303:   10.512999534606934,
		GROW_CURVE_ATTACK_304:   7.519000053405762,
		GROW_CURVE_ATTACK_305:   6.372000217437744,
		GROW_CURVE_CRITICAL_301: 4.190000057220459,
	},
	{
		GROW_CURVE_ATTACK_101:   7.002999782562256,
		GROW_CURVE_ATTACK_102:   7.9039998054504395,
		GROW_CURVE_ATTACK_103:   8.755000114440918,
		GROW_CURVE_ATTACK_104:   6.046999931335449,
		GROW_CURVE_ATTACK_105:   5.0320000648498535,
		GROW_CURVE_CRITICAL_101: 4.392000198364258,
		GROW_CURVE_ATTACK_201:   7.935999870300293,
		GROW_CURVE_ATTACK_202:   8.87399959564209,
		GROW_CURVE_ATTACK_203:   9.755999565124512,
		GROW_CURVE_ATTACK_204:   6.936999797821045,
		GROW_CURVE_ATTACK_205:   5.870999813079834,
		GROW_CURVE_CRITICAL_201: 4.392000198364258,
		GROW_CURVE_ATTACK_301:   8.684000015258789,
		GROW_CURVE_ATTACK_302:   9.694000244140625,
		GROW_CURVE_ATTACK_303:   10.638999938964844,
		GROW_CURVE_ATTACK_304:   7.60099983215332,
		GROW_CURVE_ATTACK_305:   6.435999870300293,
		GROW_CURVE_CRITICAL_301: 4.392000198364258,
	},
	{
		GROW_CURVE_ATTACK_101:   7.071000099182129,
		GROW_CURVE_ATTACK_102:   7.986000061035156,
		GROW_CURVE_ATTACK_103:   8.848999977111816,
		GROW_CURVE_ATTACK_104:   6.1020002365112305,
		GROW_CURVE_ATTACK_105:   5.072000026702881,
		GROW_CURVE_CRITICAL_101: 4.392000198364258,
		GROW_CURVE_ATTACK_201:   8.017999649047852,
		GROW_CURVE_ATTACK_202:   8.970000267028809,
		GROW_CURVE_ATTACK_203:   9.866000175476074,
		GROW_CURVE_ATTACK_204:   7.005000114440918,
		GROW_CURVE_ATTACK_205:   5.922999858856201,
		GROW_CURVE_CRITICAL_201: 4.392000198364258,
		GROW_CURVE_ATTACK_301:   8.781999588012695,
		GROW_CURVE_ATTACK_302:   9.807000160217285,
		GROW_CURVE_ATTACK_303:   10.765000343322754,
		GROW_CURVE_ATTACK_304:   7.682000160217285,
		GROW_CURVE_ATTACK_305:   6.500999927520752,
		GROW_CURVE_CRITICAL_301: 4.392000198364258,
	},
	{
		GROW_CURVE_ATTACK_101:   7.139999866485596,
		GROW_CURVE_ATTACK_102:   8.067999839782715,
		GROW_CURVE_ATTACK_103:   8.944000244140625,
		GROW_CURVE_ATTACK_104:   6.156000137329102,
		GROW_CURVE_ATTACK_105:   5.111000061035156,
		GROW_CURVE_CRITICAL_101: 4.392000198364258,
		GROW_CURVE_ATTACK_201:   8.10099983215332,
		GROW_CURVE_ATTACK_202:   9.067000389099121,
		GROW_CURVE_ATTACK_203:   9.975000381469727,
		GROW_CURVE_ATTACK_204:   7.072000026702881,
		GROW_CURVE_ATTACK_205:   5.974999904632568,
		GROW_CURVE_CRITICAL_201: 4.392000198364258,
		GROW_CURVE_ATTACK_301:   8.878999710083008,
		GROW_CURVE_ATTACK_302:   9.918999671936035,
		GROW_CURVE_ATTACK_303:   10.892000198364258,
		GROW_CURVE_ATTACK_304:   7.763999938964844,
		GROW_CURVE_ATTACK_305:   6.565000057220459,
		GROW_CURVE_CRITICAL_301: 4.392000198364258,
	},
	{
		GROW_CURVE_ATTACK_101:   7.209000110626221,
		GROW_CURVE_ATTACK_102:   8.149999618530273,
		GROW_CURVE_ATTACK_103:   9.038999557495117,
		GROW_CURVE_ATTACK_104:   6.210999965667725,
		GROW_CURVE_ATTACK_105:   5.151000022888184,
		GROW_CURVE_CRITICAL_101: 4.392000198364258,
		GROW_CURVE_ATTACK_201:   8.182999610900879,
		GROW_CURVE_ATTACK_202:   9.163000106811523,
		GROW_CURVE_ATTACK_203:   10.085000038146973,
		GROW_CURVE_ATTACK_204:   7.139999866485596,
		GROW_CURVE_ATTACK_205:   6.0269999504089355,
		GROW_CURVE_CRITICAL_201: 4.392000198364258,
		GROW_CURVE_ATTACK_301:   8.97700023651123,
		GROW_CURVE_ATTACK_302:   10.031999588012695,
		GROW_CURVE_ATTACK_303:   11.017999649047852,
		GROW_CURVE_ATTACK_304:   7.8460001945495605,
		GROW_CURVE_ATTACK_305:   6.630000114440918,
		GROW_CURVE_CRITICAL_301: 4.392000198364258,
	},
	{
		GROW_CURVE_ATTACK_101:   7.2769999504089355,
		GROW_CURVE_ATTACK_102:   8.232000350952148,
		GROW_CURVE_ATTACK_103:   9.133999824523926,
		GROW_CURVE_ATTACK_104:   6.264999866485596,
		GROW_CURVE_ATTACK_105:   5.190000057220459,
		GROW_CURVE_CRITICAL_101: 4.392000198364258,
		GROW_CURVE_ATTACK_201:   8.265999794006348,
		GROW_CURVE_ATTACK_202:   9.260000228881836,
		GROW_CURVE_ATTACK_203:   10.194999694824219,
		GROW_CURVE_ATTACK_204:   7.208000183105469,
		GROW_CURVE_ATTACK_205:   6.078000068664551,
		GROW_CURVE_CRITICAL_201: 4.392000198364258,
		GROW_CURVE_ATTACK_301:   9.074999809265137,
		GROW_CURVE_ATTACK_302:   10.145000457763672,
		GROW_CURVE_ATTACK_303:   11.145000457763672,
		GROW_CURVE_ATTACK_304:   7.927999973297119,
		GROW_CURVE_ATTACK_305:   6.695000171661377,
		GROW_CURVE_CRITICAL_301: 4.392000198364258,
	},
	{
		GROW_CURVE_ATTACK_101:   7.3460001945495605,
		GROW_CURVE_ATTACK_102:   8.314000129699707,
		GROW_CURVE_ATTACK_103:   9.229000091552734,
		GROW_CURVE_ATTACK_104:   6.320000171661377,
		GROW_CURVE_ATTACK_105:   5.229000091552734,
		GROW_CURVE_CRITICAL_101: 4.593999862670898,
		GROW_CURVE_ATTACK_201:   8.348999977111816,
		GROW_CURVE_ATTACK_202:   9.355999946594238,
		GROW_CURVE_ATTACK_203:   10.305000305175781,
		GROW_CURVE_ATTACK_204:   7.275000095367432,
		GROW_CURVE_ATTACK_205:   6.130000114440918,
		GROW_CURVE_CRITICAL_201: 4.593999862670898,
		GROW_CURVE_ATTACK_301:   9.17300033569336,
		GROW_CURVE_ATTACK_302:   10.258000373840332,
		GROW_CURVE_ATTACK_303:   11.272000312805176,
		GROW_CURVE_ATTACK_304:   8.010000228881836,
		GROW_CURVE_ATTACK_305:   6.760000228881836,
		GROW_CURVE_CRITICAL_301: 4.593999862670898,
	},
	{
		GROW_CURVE_ATTACK_101:   7.414999961853027,
		GROW_CURVE_ATTACK_102:   8.395999908447266,
		GROW_CURVE_ATTACK_103:   9.324000358581543,
		GROW_CURVE_ATTACK_104:   6.374000072479248,
		GROW_CURVE_ATTACK_105:   5.269000053405762,
		GROW_CURVE_CRITICAL_101: 4.593999862670898,
		GROW_CURVE_ATTACK_201:   8.430999755859375,
		GROW_CURVE_ATTACK_202:   9.45300006866455,
		GROW_CURVE_ATTACK_203:   10.413999557495117,
		GROW_CURVE_ATTACK_204:   7.3429999351501465,
		GROW_CURVE_ATTACK_205:   6.182000160217285,
		GROW_CURVE_CRITICAL_201: 4.593999862670898,
		GROW_CURVE_ATTACK_301:   9.270999908447266,
		GROW_CURVE_ATTACK_302:   10.371000289916992,
		GROW_CURVE_ATTACK_303:   11.39900016784668,
		GROW_CURVE_ATTACK_304:   8.092000007629395,
		GROW_CURVE_ATTACK_305:   6.824999809265137,
		GROW_CURVE_CRITICAL_301: 4.593999862670898,
	},
	{
		GROW_CURVE_ATTACK_101:   7.482999801635742,
		GROW_CURVE_ATTACK_102:   8.477999687194824,
		GROW_CURVE_ATTACK_103:   9.418000221252441,
		GROW_CURVE_ATTACK_104:   6.427999973297119,
		GROW_CURVE_ATTACK_105:   5.308000087738037,
		GROW_CURVE_CRITICAL_101: 4.593999862670898,
		GROW_CURVE_ATTACK_201:   8.513999938964844,
		GROW_CURVE_ATTACK_202:   9.550000190734863,
		GROW_CURVE_ATTACK_203:   10.52400016784668,
		GROW_CURVE_ATTACK_204:   7.410999774932861,
		GROW_CURVE_ATTACK_205:   6.232999801635742,
		GROW_CURVE_CRITICAL_201: 4.593999862670898,
		GROW_CURVE_ATTACK_301:   9.369999885559082,
		GROW_CURVE_ATTACK_302:   10.484999656677246,
		GROW_CURVE_ATTACK_303:   11.527000427246094,
		GROW_CURVE_ATTACK_304:   8.173999786376953,
		GROW_CURVE_ATTACK_305:   6.889999866485596,
		GROW_CURVE_CRITICAL_301: 4.593999862670898,
	},
	{
		GROW_CURVE_ATTACK_101:   7.552000045776367,
		GROW_CURVE_ATTACK_102:   8.560999870300293,
		GROW_CURVE_ATTACK_103:   9.512999534606934,
		GROW_CURVE_ATTACK_104:   6.482999801635742,
		GROW_CURVE_ATTACK_105:   5.3470001220703125,
		GROW_CURVE_CRITICAL_101: 4.593999862670898,
		GROW_CURVE_ATTACK_201:   8.595999717712402,
		GROW_CURVE_ATTACK_202:   9.645999908447266,
		GROW_CURVE_ATTACK_203:   10.633999824523926,
		GROW_CURVE_ATTACK_204:   7.478000164031982,
		GROW_CURVE_ATTACK_205:   6.284999847412109,
		GROW_CURVE_CRITICAL_201: 4.593999862670898,
		GROW_CURVE_ATTACK_301:   9.468000411987305,
		GROW_CURVE_ATTACK_302:   10.597999572753906,
		GROW_CURVE_ATTACK_303:   11.654000282287598,
		GROW_CURVE_ATTACK_304:   8.256999969482422,
		GROW_CURVE_ATTACK_305:   6.954999923706055,
		GROW_CURVE_CRITICAL_301: 4.593999862670898,
	},
	{
		GROW_CURVE_ATTACK_101:   7.620999813079834,
		GROW_CURVE_ATTACK_102:   8.642999649047852,
		GROW_CURVE_ATTACK_103:   9.607999801635742,
		GROW_CURVE_ATTACK_104:   6.5370001792907715,
		GROW_CURVE_ATTACK_105:   5.386000156402588,
		GROW_CURVE_CRITICAL_101: 4.593999862670898,
		GROW_CURVE_ATTACK_201:   8.678999900817871,
		GROW_CURVE_ATTACK_202:   9.743000030517578,
		GROW_CURVE_ATTACK_203:   10.744000434875488,
		GROW_CURVE_ATTACK_204:   7.546000003814697,
		GROW_CURVE_ATTACK_205:   6.335999965667725,
		GROW_CURVE_CRITICAL_201: 4.593999862670898,
		GROW_CURVE_ATTACK_301:   9.567000389099121,
		GROW_CURVE_ATTACK_302:   10.711999893188477,
		GROW_CURVE_ATTACK_303:   11.781999588012695,
		GROW_CURVE_ATTACK_304:   8.33899974822998,
		GROW_CURVE_ATTACK_305:   7.019999980926514,
		GROW_CURVE_CRITICAL_301: 4.593999862670898,
	},
	{
		GROW_CURVE_ATTACK_101:   7.689000129699707,
		GROW_CURVE_ATTACK_102:   8.725000381469727,
		GROW_CURVE_ATTACK_103:   9.704000473022461,
		GROW_CURVE_ATTACK_104:   6.591000080108643,
		GROW_CURVE_ATTACK_105:   5.425000190734863,
		GROW_CURVE_CRITICAL_101: 4.796000003814697,
		GROW_CURVE_ATTACK_201:   8.76099967956543,
		GROW_CURVE_ATTACK_202:   9.84000015258789,
		GROW_CURVE_ATTACK_203:   10.854000091552734,
		GROW_CURVE_ATTACK_204:   7.61299991607666,
		GROW_CURVE_ATTACK_205:   6.388000011444092,
		GROW_CURVE_CRITICAL_201: 4.796000003814697,
		GROW_CURVE_ATTACK_301:   9.666000366210938,
		GROW_CURVE_ATTACK_302:   10.826000213623047,
		GROW_CURVE_ATTACK_303:   11.90999984741211,
		GROW_CURVE_ATTACK_304:   8.42199993133545,
		GROW_CURVE_ATTACK_305:   7.085000038146973,
		GROW_CURVE_CRITICAL_301: 4.796000003814697,
	},
	{
		GROW_CURVE_ATTACK_101:   7.757999897003174,
		GROW_CURVE_ATTACK_102:   8.807000160217285,
		GROW_CURVE_ATTACK_103:   9.798999786376953,
		GROW_CURVE_ATTACK_104:   6.645999908447266,
		GROW_CURVE_ATTACK_105:   5.464000225067139,
		GROW_CURVE_CRITICAL_101: 4.796000003814697,
		GROW_CURVE_ATTACK_201:   8.843999862670898,
		GROW_CURVE_ATTACK_202:   9.935999870300293,
		GROW_CURVE_ATTACK_203:   10.96399974822998,
		GROW_CURVE_ATTACK_204:   7.681000232696533,
		GROW_CURVE_ATTACK_205:   6.439000129699707,
		GROW_CURVE_CRITICAL_201: 4.796000003814697,
		GROW_CURVE_ATTACK_301:   9.765000343322754,
		GROW_CURVE_ATTACK_302:   10.9399995803833,
		GROW_CURVE_ATTACK_303:   12.038000106811523,
		GROW_CURVE_ATTACK_304:   8.505000114440918,
		GROW_CURVE_ATTACK_305:   7.151000022888184,
		GROW_CURVE_CRITICAL_301: 4.796000003814697,
	},
	{
		GROW_CURVE_ATTACK_101:   7.827000141143799,
		GROW_CURVE_ATTACK_102:   8.890000343322754,
		GROW_CURVE_ATTACK_103:   9.894000053405762,
		GROW_CURVE_ATTACK_104:   6.699999809265137,
		GROW_CURVE_ATTACK_105:   5.502999782562256,
		GROW_CURVE_CRITICAL_101: 4.796000003814697,
		GROW_CURVE_ATTACK_201:   8.927000045776367,
		GROW_CURVE_ATTACK_202:   10.032999992370605,
		GROW_CURVE_ATTACK_203:   11.074000358581543,
		GROW_CURVE_ATTACK_204:   7.748000144958496,
		GROW_CURVE_ATTACK_205:   6.491000175476074,
		GROW_CURVE_CRITICAL_201: 4.796000003814697,
		GROW_CURVE_ATTACK_301:   9.86400032043457,
		GROW_CURVE_ATTACK_302:   11.053999900817871,
		GROW_CURVE_ATTACK_303:   12.166000366210938,
		GROW_CURVE_ATTACK_304:   8.588000297546387,
		GROW_CURVE_ATTACK_305:   7.216000080108643,
		GROW_CURVE_CRITICAL_301: 4.796000003814697,
	},
	{
		GROW_CURVE_ATTACK_101:   7.894999980926514,
		GROW_CURVE_ATTACK_102:   8.972000122070312,
		GROW_CURVE_ATTACK_103:   9.98900032043457,
		GROW_CURVE_ATTACK_104:   6.754000186920166,
		GROW_CURVE_ATTACK_105:   5.541999816894531,
		GROW_CURVE_CRITICAL_101: 4.796000003814697,
		GROW_CURVE_ATTACK_201:   9.008999824523926,
		GROW_CURVE_ATTACK_202:   10.130000114440918,
		GROW_CURVE_ATTACK_203:   11.184000015258789,
		GROW_CURVE_ATTACK_204:   7.815999984741211,
		GROW_CURVE_ATTACK_205:   6.541999816894531,
		GROW_CURVE_CRITICAL_201: 4.796000003814697,
		GROW_CURVE_ATTACK_301:   9.963000297546387,
		GROW_CURVE_ATTACK_302:   11.168000221252441,
		GROW_CURVE_ATTACK_303:   12.295000076293945,
		GROW_CURVE_ATTACK_304:   8.670999526977539,
		GROW_CURVE_ATTACK_305:   7.2820000648498535,
		GROW_CURVE_CRITICAL_301: 4.796000003814697,
	},
	{
		GROW_CURVE_ATTACK_101:   7.964000225067139,
		GROW_CURVE_ATTACK_102:   9.053999900817871,
		GROW_CURVE_ATTACK_103:   10.083999633789062,
		GROW_CURVE_ATTACK_104:   6.808000087738037,
		GROW_CURVE_ATTACK_105:   5.579999923706055,
		GROW_CURVE_CRITICAL_101: 4.796000003814697,
		GROW_CURVE_ATTACK_201:   9.092000007629395,
		GROW_CURVE_ATTACK_202:   10.22700023651123,
		GROW_CURVE_ATTACK_203:   11.295000076293945,
		GROW_CURVE_ATTACK_204:   7.882999897003174,
		GROW_CURVE_ATTACK_205:   6.5929999351501465,
		GROW_CURVE_CRITICAL_201: 4.796000003814697,
		GROW_CURVE_ATTACK_301:   10.062000274658203,
		GROW_CURVE_ATTACK_302:   11.282999992370605,
		GROW_CURVE_ATTACK_303:   12.423999786376953,
		GROW_CURVE_ATTACK_304:   8.753999710083008,
		GROW_CURVE_ATTACK_305:   7.3470001220703125,
		GROW_CURVE_CRITICAL_301: 4.796000003814697,
	},
	{
		GROW_CURVE_ATTACK_101:   8.032999992370605,
		GROW_CURVE_ATTACK_102:   9.13700008392334,
		GROW_CURVE_ATTACK_103:   10.180000305175781,
		GROW_CURVE_ATTACK_104:   6.861999988555908,
		GROW_CURVE_ATTACK_105:   5.61899995803833,
		GROW_CURVE_CRITICAL_101: 4.998000144958496,
		GROW_CURVE_ATTACK_201:   9.173999786376953,
		GROW_CURVE_ATTACK_202:   10.324000358581543,
		GROW_CURVE_ATTACK_203:   11.404999732971191,
		GROW_CURVE_ATTACK_204:   7.949999809265137,
		GROW_CURVE_ATTACK_205:   6.644000053405762,
		GROW_CURVE_CRITICAL_201: 4.998000144958496,
		GROW_CURVE_ATTACK_301:   10.161999702453613,
		GROW_CURVE_ATTACK_302:   11.397000312805176,
		GROW_CURVE_ATTACK_303:   12.552000045776367,
		GROW_CURVE_ATTACK_304:   8.836999893188477,
		GROW_CURVE_ATTACK_305:   7.413000106811523,
		GROW_CURVE_CRITICAL_301: 4.998000144958496,
	},
}
