// Code generated by go-swagger; DO NOT EDIT.

package alerts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetQueriesAlertsV1Params creates a new GetQueriesAlertsV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetQueriesAlertsV1Params() *GetQueriesAlertsV1Params {
	return &GetQueriesAlertsV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetQueriesAlertsV1ParamsWithTimeout creates a new GetQueriesAlertsV1Params object
// with the ability to set a timeout on a request.
func NewGetQueriesAlertsV1ParamsWithTimeout(timeout time.Duration) *GetQueriesAlertsV1Params {
	return &GetQueriesAlertsV1Params{
		timeout: timeout,
	}
}

// NewGetQueriesAlertsV1ParamsWithContext creates a new GetQueriesAlertsV1Params object
// with the ability to set a context for a request.
func NewGetQueriesAlertsV1ParamsWithContext(ctx context.Context) *GetQueriesAlertsV1Params {
	return &GetQueriesAlertsV1Params{
		Context: ctx,
	}
}

// NewGetQueriesAlertsV1ParamsWithHTTPClient creates a new GetQueriesAlertsV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewGetQueriesAlertsV1ParamsWithHTTPClient(client *http.Client) *GetQueriesAlertsV1Params {
	return &GetQueriesAlertsV1Params{
		HTTPClient: client,
	}
}

/*
GetQueriesAlertsV1Params contains all the parameters to send to the API endpoint

	for the get queries alerts v1 operation.

	Typically these are written to a http.Request.
*/
type GetQueriesAlertsV1Params struct {

	/* Filter.

	     Filter detections using a query in Falcon Query Language (FQL). An asterisk wildcard `*` includes all results.

	The full list of valid filter options is extensive. Review it in our [documentation inside the Falcon console](https://falcon.crowdstrike.com/documentation/45/falcon-query-language-fql).
	*/
	Filter *string

	/* Limit.

	   The maximum number of detections to return in this response (default: 100; max: 10000). Use with the `offset` parameter to manage pagination of results.
	*/
	Limit *int64

	/* Offset.

	   The first detection to return, where `0` is the latest detection. Use with the `offset` parameter to manage pagination of results.
	*/
	Offset *int64

	/* Q.

	   Search all detection metadata for the provided string
	*/
	Q *string

	/* Sort.

	   Sort detections in either `asc` (ascending) or `desc` (descending) order. For example: `status|asc` or `status|desc`.
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get queries alerts v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetQueriesAlertsV1Params) WithDefaults() *GetQueriesAlertsV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get queries alerts v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetQueriesAlertsV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) WithTimeout(timeout time.Duration) *GetQueriesAlertsV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) WithContext(ctx context.Context) *GetQueriesAlertsV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) WithHTTPClient(client *http.Client) *GetQueriesAlertsV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) WithFilter(filter *string) *GetQueriesAlertsV1Params {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) WithLimit(limit *int64) *GetQueriesAlertsV1Params {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) WithOffset(offset *int64) *GetQueriesAlertsV1Params {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithQ adds the q to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) WithQ(q *string) *GetQueriesAlertsV1Params {
	o.SetQ(q)
	return o
}

// SetQ adds the q to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) SetQ(q *string) {
	o.Q = q
}

// WithSort adds the sort to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) WithSort(sort *string) *GetQueriesAlertsV1Params {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the get queries alerts v1 params
func (o *GetQueriesAlertsV1Params) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *GetQueriesAlertsV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Q != nil {

		// query param q
		var qrQ string

		if o.Q != nil {
			qrQ = *o.Q
		}
		qQ := qrQ
		if qQ != "" {

			if err := r.SetQueryParam("q", qQ); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
