// Code generated by go-swagger; DO NOT EDIT.

package cloud_connect_aws

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateOrUpdateAWSSettingsReader is a Reader for the CreateOrUpdateAWSSettings structure.
type CreateOrUpdateAWSSettingsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateOrUpdateAWSSettingsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreateOrUpdateAWSSettingsCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateOrUpdateAWSSettingsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateOrUpdateAWSSettingsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateOrUpdateAWSSettingsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateOrUpdateAWSSettingsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /cloud-connect-aws/entities/settings/v1] CreateOrUpdateAWSSettings", response, response.Code())
	}
}

// NewCreateOrUpdateAWSSettingsCreated creates a CreateOrUpdateAWSSettingsCreated with default headers values
func NewCreateOrUpdateAWSSettingsCreated() *CreateOrUpdateAWSSettingsCreated {
	return &CreateOrUpdateAWSSettingsCreated{}
}

/*
CreateOrUpdateAWSSettingsCreated describes a response with status code 201, with default header values.

Created
*/
type CreateOrUpdateAWSSettingsCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsCustomerConfigurationsV1
}

// IsSuccess returns true when this create or update a w s settings created response has a 2xx status code
func (o *CreateOrUpdateAWSSettingsCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create or update a w s settings created response has a 3xx status code
func (o *CreateOrUpdateAWSSettingsCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create or update a w s settings created response has a 4xx status code
func (o *CreateOrUpdateAWSSettingsCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create or update a w s settings created response has a 5xx status code
func (o *CreateOrUpdateAWSSettingsCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create or update a w s settings created response a status code equal to that given
func (o *CreateOrUpdateAWSSettingsCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create or update a w s settings created response
func (o *CreateOrUpdateAWSSettingsCreated) Code() int {
	return 201
}

func (o *CreateOrUpdateAWSSettingsCreated) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/settings/v1][%d] createOrUpdateAWSSettingsCreated  %+v", 201, o.Payload)
}

func (o *CreateOrUpdateAWSSettingsCreated) String() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/settings/v1][%d] createOrUpdateAWSSettingsCreated  %+v", 201, o.Payload)
}

func (o *CreateOrUpdateAWSSettingsCreated) GetPayload() *models.ModelsCustomerConfigurationsV1 {
	return o.Payload
}

func (o *CreateOrUpdateAWSSettingsCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsCustomerConfigurationsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateOrUpdateAWSSettingsBadRequest creates a CreateOrUpdateAWSSettingsBadRequest with default headers values
func NewCreateOrUpdateAWSSettingsBadRequest() *CreateOrUpdateAWSSettingsBadRequest {
	return &CreateOrUpdateAWSSettingsBadRequest{}
}

/*
CreateOrUpdateAWSSettingsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreateOrUpdateAWSSettingsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsCustomerConfigurationsV1
}

// IsSuccess returns true when this create or update a w s settings bad request response has a 2xx status code
func (o *CreateOrUpdateAWSSettingsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create or update a w s settings bad request response has a 3xx status code
func (o *CreateOrUpdateAWSSettingsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create or update a w s settings bad request response has a 4xx status code
func (o *CreateOrUpdateAWSSettingsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create or update a w s settings bad request response has a 5xx status code
func (o *CreateOrUpdateAWSSettingsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create or update a w s settings bad request response a status code equal to that given
func (o *CreateOrUpdateAWSSettingsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create or update a w s settings bad request response
func (o *CreateOrUpdateAWSSettingsBadRequest) Code() int {
	return 400
}

func (o *CreateOrUpdateAWSSettingsBadRequest) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/settings/v1][%d] createOrUpdateAWSSettingsBadRequest  %+v", 400, o.Payload)
}

func (o *CreateOrUpdateAWSSettingsBadRequest) String() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/settings/v1][%d] createOrUpdateAWSSettingsBadRequest  %+v", 400, o.Payload)
}

func (o *CreateOrUpdateAWSSettingsBadRequest) GetPayload() *models.ModelsCustomerConfigurationsV1 {
	return o.Payload
}

func (o *CreateOrUpdateAWSSettingsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsCustomerConfigurationsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateOrUpdateAWSSettingsForbidden creates a CreateOrUpdateAWSSettingsForbidden with default headers values
func NewCreateOrUpdateAWSSettingsForbidden() *CreateOrUpdateAWSSettingsForbidden {
	return &CreateOrUpdateAWSSettingsForbidden{}
}

/*
CreateOrUpdateAWSSettingsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateOrUpdateAWSSettingsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create or update a w s settings forbidden response has a 2xx status code
func (o *CreateOrUpdateAWSSettingsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create or update a w s settings forbidden response has a 3xx status code
func (o *CreateOrUpdateAWSSettingsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create or update a w s settings forbidden response has a 4xx status code
func (o *CreateOrUpdateAWSSettingsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create or update a w s settings forbidden response has a 5xx status code
func (o *CreateOrUpdateAWSSettingsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create or update a w s settings forbidden response a status code equal to that given
func (o *CreateOrUpdateAWSSettingsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create or update a w s settings forbidden response
func (o *CreateOrUpdateAWSSettingsForbidden) Code() int {
	return 403
}

func (o *CreateOrUpdateAWSSettingsForbidden) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/settings/v1][%d] createOrUpdateAWSSettingsForbidden  %+v", 403, o.Payload)
}

func (o *CreateOrUpdateAWSSettingsForbidden) String() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/settings/v1][%d] createOrUpdateAWSSettingsForbidden  %+v", 403, o.Payload)
}

func (o *CreateOrUpdateAWSSettingsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateOrUpdateAWSSettingsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateOrUpdateAWSSettingsTooManyRequests creates a CreateOrUpdateAWSSettingsTooManyRequests with default headers values
func NewCreateOrUpdateAWSSettingsTooManyRequests() *CreateOrUpdateAWSSettingsTooManyRequests {
	return &CreateOrUpdateAWSSettingsTooManyRequests{}
}

/*
CreateOrUpdateAWSSettingsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateOrUpdateAWSSettingsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create or update a w s settings too many requests response has a 2xx status code
func (o *CreateOrUpdateAWSSettingsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create or update a w s settings too many requests response has a 3xx status code
func (o *CreateOrUpdateAWSSettingsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create or update a w s settings too many requests response has a 4xx status code
func (o *CreateOrUpdateAWSSettingsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create or update a w s settings too many requests response has a 5xx status code
func (o *CreateOrUpdateAWSSettingsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create or update a w s settings too many requests response a status code equal to that given
func (o *CreateOrUpdateAWSSettingsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create or update a w s settings too many requests response
func (o *CreateOrUpdateAWSSettingsTooManyRequests) Code() int {
	return 429
}

func (o *CreateOrUpdateAWSSettingsTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/settings/v1][%d] createOrUpdateAWSSettingsTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateOrUpdateAWSSettingsTooManyRequests) String() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/settings/v1][%d] createOrUpdateAWSSettingsTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateOrUpdateAWSSettingsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateOrUpdateAWSSettingsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateOrUpdateAWSSettingsInternalServerError creates a CreateOrUpdateAWSSettingsInternalServerError with default headers values
func NewCreateOrUpdateAWSSettingsInternalServerError() *CreateOrUpdateAWSSettingsInternalServerError {
	return &CreateOrUpdateAWSSettingsInternalServerError{}
}

/*
CreateOrUpdateAWSSettingsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CreateOrUpdateAWSSettingsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsCustomerConfigurationsV1
}

// IsSuccess returns true when this create or update a w s settings internal server error response has a 2xx status code
func (o *CreateOrUpdateAWSSettingsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create or update a w s settings internal server error response has a 3xx status code
func (o *CreateOrUpdateAWSSettingsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create or update a w s settings internal server error response has a 4xx status code
func (o *CreateOrUpdateAWSSettingsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create or update a w s settings internal server error response has a 5xx status code
func (o *CreateOrUpdateAWSSettingsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create or update a w s settings internal server error response a status code equal to that given
func (o *CreateOrUpdateAWSSettingsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create or update a w s settings internal server error response
func (o *CreateOrUpdateAWSSettingsInternalServerError) Code() int {
	return 500
}

func (o *CreateOrUpdateAWSSettingsInternalServerError) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/settings/v1][%d] createOrUpdateAWSSettingsInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateOrUpdateAWSSettingsInternalServerError) String() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/settings/v1][%d] createOrUpdateAWSSettingsInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateOrUpdateAWSSettingsInternalServerError) GetPayload() *models.ModelsCustomerConfigurationsV1 {
	return o.Payload
}

func (o *CreateOrUpdateAWSSettingsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsCustomerConfigurationsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
