// Code generated by go-swagger; DO NOT EDIT.

package cloud_connect_aws

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteAWSAccountsParams creates a new DeleteAWSAccountsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteAWSAccountsParams() *DeleteAWSAccountsParams {
	return &DeleteAWSAccountsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteAWSAccountsParamsWithTimeout creates a new DeleteAWSAccountsParams object
// with the ability to set a timeout on a request.
func NewDeleteAWSAccountsParamsWithTimeout(timeout time.Duration) *DeleteAWSAccountsParams {
	return &DeleteAWSAccountsParams{
		timeout: timeout,
	}
}

// NewDeleteAWSAccountsParamsWithContext creates a new DeleteAWSAccountsParams object
// with the ability to set a context for a request.
func NewDeleteAWSAccountsParamsWithContext(ctx context.Context) *DeleteAWSAccountsParams {
	return &DeleteAWSAccountsParams{
		Context: ctx,
	}
}

// NewDeleteAWSAccountsParamsWithHTTPClient creates a new DeleteAWSAccountsParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteAWSAccountsParamsWithHTTPClient(client *http.Client) *DeleteAWSAccountsParams {
	return &DeleteAWSAccountsParams{
		HTTPClient: client,
	}
}

/*
DeleteAWSAccountsParams contains all the parameters to send to the API endpoint

	for the delete a w s accounts operation.

	Typically these are written to a http.Request.
*/
type DeleteAWSAccountsParams struct {

	/* Ids.

	   IDs of accounts to remove
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete a w s accounts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteAWSAccountsParams) WithDefaults() *DeleteAWSAccountsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete a w s accounts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteAWSAccountsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete a w s accounts params
func (o *DeleteAWSAccountsParams) WithTimeout(timeout time.Duration) *DeleteAWSAccountsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete a w s accounts params
func (o *DeleteAWSAccountsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete a w s accounts params
func (o *DeleteAWSAccountsParams) WithContext(ctx context.Context) *DeleteAWSAccountsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete a w s accounts params
func (o *DeleteAWSAccountsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete a w s accounts params
func (o *DeleteAWSAccountsParams) WithHTTPClient(client *http.Client) *DeleteAWSAccountsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete a w s accounts params
func (o *DeleteAWSAccountsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the delete a w s accounts params
func (o *DeleteAWSAccountsParams) WithIds(ids []string) *DeleteAWSAccountsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the delete a w s accounts params
func (o *DeleteAWSAccountsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteAWSAccountsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDeleteAWSAccounts binds the parameter ids
func (o *DeleteAWSAccountsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
