// Code generated by go-swagger; DO NOT EDIT.

package cloud_connect_aws

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// DeleteAWSAccountsReader is a Reader for the DeleteAWSAccounts structure.
type DeleteAWSAccountsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteAWSAccountsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteAWSAccountsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteAWSAccountsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteAWSAccountsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewDeleteAWSAccountsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteAWSAccountsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /cloud-connect-aws/entities/accounts/v1] DeleteAWSAccounts", response, response.Code())
	}
}

// NewDeleteAWSAccountsOK creates a DeleteAWSAccountsOK with default headers values
func NewDeleteAWSAccountsOK() *DeleteAWSAccountsOK {
	return &DeleteAWSAccountsOK{}
}

/*
DeleteAWSAccountsOK describes a response with status code 200, with default header values.

OK
*/
type DeleteAWSAccountsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsBaseResponseV1
}

// IsSuccess returns true when this delete a w s accounts o k response has a 2xx status code
func (o *DeleteAWSAccountsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete a w s accounts o k response has a 3xx status code
func (o *DeleteAWSAccountsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete a w s accounts o k response has a 4xx status code
func (o *DeleteAWSAccountsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete a w s accounts o k response has a 5xx status code
func (o *DeleteAWSAccountsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete a w s accounts o k response a status code equal to that given
func (o *DeleteAWSAccountsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete a w s accounts o k response
func (o *DeleteAWSAccountsOK) Code() int {
	return 200
}

func (o *DeleteAWSAccountsOK) Error() string {
	return fmt.Sprintf("[DELETE /cloud-connect-aws/entities/accounts/v1][%d] deleteAWSAccountsOK  %+v", 200, o.Payload)
}

func (o *DeleteAWSAccountsOK) String() string {
	return fmt.Sprintf("[DELETE /cloud-connect-aws/entities/accounts/v1][%d] deleteAWSAccountsOK  %+v", 200, o.Payload)
}

func (o *DeleteAWSAccountsOK) GetPayload() *models.ModelsBaseResponseV1 {
	return o.Payload
}

func (o *DeleteAWSAccountsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsBaseResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteAWSAccountsBadRequest creates a DeleteAWSAccountsBadRequest with default headers values
func NewDeleteAWSAccountsBadRequest() *DeleteAWSAccountsBadRequest {
	return &DeleteAWSAccountsBadRequest{}
}

/*
DeleteAWSAccountsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type DeleteAWSAccountsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsBaseResponseV1
}

// IsSuccess returns true when this delete a w s accounts bad request response has a 2xx status code
func (o *DeleteAWSAccountsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete a w s accounts bad request response has a 3xx status code
func (o *DeleteAWSAccountsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete a w s accounts bad request response has a 4xx status code
func (o *DeleteAWSAccountsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete a w s accounts bad request response has a 5xx status code
func (o *DeleteAWSAccountsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete a w s accounts bad request response a status code equal to that given
func (o *DeleteAWSAccountsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete a w s accounts bad request response
func (o *DeleteAWSAccountsBadRequest) Code() int {
	return 400
}

func (o *DeleteAWSAccountsBadRequest) Error() string {
	return fmt.Sprintf("[DELETE /cloud-connect-aws/entities/accounts/v1][%d] deleteAWSAccountsBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteAWSAccountsBadRequest) String() string {
	return fmt.Sprintf("[DELETE /cloud-connect-aws/entities/accounts/v1][%d] deleteAWSAccountsBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteAWSAccountsBadRequest) GetPayload() *models.ModelsBaseResponseV1 {
	return o.Payload
}

func (o *DeleteAWSAccountsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsBaseResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteAWSAccountsForbidden creates a DeleteAWSAccountsForbidden with default headers values
func NewDeleteAWSAccountsForbidden() *DeleteAWSAccountsForbidden {
	return &DeleteAWSAccountsForbidden{}
}

/*
DeleteAWSAccountsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeleteAWSAccountsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete a w s accounts forbidden response has a 2xx status code
func (o *DeleteAWSAccountsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete a w s accounts forbidden response has a 3xx status code
func (o *DeleteAWSAccountsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete a w s accounts forbidden response has a 4xx status code
func (o *DeleteAWSAccountsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete a w s accounts forbidden response has a 5xx status code
func (o *DeleteAWSAccountsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete a w s accounts forbidden response a status code equal to that given
func (o *DeleteAWSAccountsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete a w s accounts forbidden response
func (o *DeleteAWSAccountsForbidden) Code() int {
	return 403
}

func (o *DeleteAWSAccountsForbidden) Error() string {
	return fmt.Sprintf("[DELETE /cloud-connect-aws/entities/accounts/v1][%d] deleteAWSAccountsForbidden  %+v", 403, o.Payload)
}

func (o *DeleteAWSAccountsForbidden) String() string {
	return fmt.Sprintf("[DELETE /cloud-connect-aws/entities/accounts/v1][%d] deleteAWSAccountsForbidden  %+v", 403, o.Payload)
}

func (o *DeleteAWSAccountsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeleteAWSAccountsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteAWSAccountsTooManyRequests creates a DeleteAWSAccountsTooManyRequests with default headers values
func NewDeleteAWSAccountsTooManyRequests() *DeleteAWSAccountsTooManyRequests {
	return &DeleteAWSAccountsTooManyRequests{}
}

/*
DeleteAWSAccountsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type DeleteAWSAccountsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete a w s accounts too many requests response has a 2xx status code
func (o *DeleteAWSAccountsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete a w s accounts too many requests response has a 3xx status code
func (o *DeleteAWSAccountsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete a w s accounts too many requests response has a 4xx status code
func (o *DeleteAWSAccountsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete a w s accounts too many requests response has a 5xx status code
func (o *DeleteAWSAccountsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this delete a w s accounts too many requests response a status code equal to that given
func (o *DeleteAWSAccountsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the delete a w s accounts too many requests response
func (o *DeleteAWSAccountsTooManyRequests) Code() int {
	return 429
}

func (o *DeleteAWSAccountsTooManyRequests) Error() string {
	return fmt.Sprintf("[DELETE /cloud-connect-aws/entities/accounts/v1][%d] deleteAWSAccountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteAWSAccountsTooManyRequests) String() string {
	return fmt.Sprintf("[DELETE /cloud-connect-aws/entities/accounts/v1][%d] deleteAWSAccountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteAWSAccountsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeleteAWSAccountsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteAWSAccountsInternalServerError creates a DeleteAWSAccountsInternalServerError with default headers values
func NewDeleteAWSAccountsInternalServerError() *DeleteAWSAccountsInternalServerError {
	return &DeleteAWSAccountsInternalServerError{}
}

/*
DeleteAWSAccountsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type DeleteAWSAccountsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsBaseResponseV1
}

// IsSuccess returns true when this delete a w s accounts internal server error response has a 2xx status code
func (o *DeleteAWSAccountsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete a w s accounts internal server error response has a 3xx status code
func (o *DeleteAWSAccountsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete a w s accounts internal server error response has a 4xx status code
func (o *DeleteAWSAccountsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete a w s accounts internal server error response has a 5xx status code
func (o *DeleteAWSAccountsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete a w s accounts internal server error response a status code equal to that given
func (o *DeleteAWSAccountsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete a w s accounts internal server error response
func (o *DeleteAWSAccountsInternalServerError) Code() int {
	return 500
}

func (o *DeleteAWSAccountsInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /cloud-connect-aws/entities/accounts/v1][%d] deleteAWSAccountsInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteAWSAccountsInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /cloud-connect-aws/entities/accounts/v1][%d] deleteAWSAccountsInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteAWSAccountsInternalServerError) GetPayload() *models.ModelsBaseResponseV1 {
	return o.Payload
}

func (o *DeleteAWSAccountsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsBaseResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
