// Code generated by go-swagger; DO NOT EDIT.

package cloud_connect_aws

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetAWSSettingsReader is a Reader for the GetAWSSettings structure.
type GetAWSSettingsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAWSSettingsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAWSSettingsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetAWSSettingsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetAWSSettingsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetAWSSettingsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetAWSSettingsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloud-connect-aws/combined/settings/v1] GetAWSSettings", response, response.Code())
	}
}

// NewGetAWSSettingsOK creates a GetAWSSettingsOK with default headers values
func NewGetAWSSettingsOK() *GetAWSSettingsOK {
	return &GetAWSSettingsOK{}
}

/*
GetAWSSettingsOK describes a response with status code 200, with default header values.

OK
*/
type GetAWSSettingsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsCustomerConfigurationsV1
}

// IsSuccess returns true when this get a w s settings o k response has a 2xx status code
func (o *GetAWSSettingsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get a w s settings o k response has a 3xx status code
func (o *GetAWSSettingsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get a w s settings o k response has a 4xx status code
func (o *GetAWSSettingsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get a w s settings o k response has a 5xx status code
func (o *GetAWSSettingsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get a w s settings o k response a status code equal to that given
func (o *GetAWSSettingsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get a w s settings o k response
func (o *GetAWSSettingsOK) Code() int {
	return 200
}

func (o *GetAWSSettingsOK) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/settings/v1][%d] getAWSSettingsOK  %+v", 200, o.Payload)
}

func (o *GetAWSSettingsOK) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/settings/v1][%d] getAWSSettingsOK  %+v", 200, o.Payload)
}

func (o *GetAWSSettingsOK) GetPayload() *models.ModelsCustomerConfigurationsV1 {
	return o.Payload
}

func (o *GetAWSSettingsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsCustomerConfigurationsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAWSSettingsBadRequest creates a GetAWSSettingsBadRequest with default headers values
func NewGetAWSSettingsBadRequest() *GetAWSSettingsBadRequest {
	return &GetAWSSettingsBadRequest{}
}

/*
GetAWSSettingsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetAWSSettingsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsCustomerConfigurationsV1
}

// IsSuccess returns true when this get a w s settings bad request response has a 2xx status code
func (o *GetAWSSettingsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get a w s settings bad request response has a 3xx status code
func (o *GetAWSSettingsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get a w s settings bad request response has a 4xx status code
func (o *GetAWSSettingsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get a w s settings bad request response has a 5xx status code
func (o *GetAWSSettingsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get a w s settings bad request response a status code equal to that given
func (o *GetAWSSettingsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get a w s settings bad request response
func (o *GetAWSSettingsBadRequest) Code() int {
	return 400
}

func (o *GetAWSSettingsBadRequest) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/settings/v1][%d] getAWSSettingsBadRequest  %+v", 400, o.Payload)
}

func (o *GetAWSSettingsBadRequest) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/settings/v1][%d] getAWSSettingsBadRequest  %+v", 400, o.Payload)
}

func (o *GetAWSSettingsBadRequest) GetPayload() *models.ModelsCustomerConfigurationsV1 {
	return o.Payload
}

func (o *GetAWSSettingsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsCustomerConfigurationsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAWSSettingsForbidden creates a GetAWSSettingsForbidden with default headers values
func NewGetAWSSettingsForbidden() *GetAWSSettingsForbidden {
	return &GetAWSSettingsForbidden{}
}

/*
GetAWSSettingsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetAWSSettingsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get a w s settings forbidden response has a 2xx status code
func (o *GetAWSSettingsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get a w s settings forbidden response has a 3xx status code
func (o *GetAWSSettingsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get a w s settings forbidden response has a 4xx status code
func (o *GetAWSSettingsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get a w s settings forbidden response has a 5xx status code
func (o *GetAWSSettingsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get a w s settings forbidden response a status code equal to that given
func (o *GetAWSSettingsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get a w s settings forbidden response
func (o *GetAWSSettingsForbidden) Code() int {
	return 403
}

func (o *GetAWSSettingsForbidden) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/settings/v1][%d] getAWSSettingsForbidden  %+v", 403, o.Payload)
}

func (o *GetAWSSettingsForbidden) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/settings/v1][%d] getAWSSettingsForbidden  %+v", 403, o.Payload)
}

func (o *GetAWSSettingsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAWSSettingsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAWSSettingsTooManyRequests creates a GetAWSSettingsTooManyRequests with default headers values
func NewGetAWSSettingsTooManyRequests() *GetAWSSettingsTooManyRequests {
	return &GetAWSSettingsTooManyRequests{}
}

/*
GetAWSSettingsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetAWSSettingsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get a w s settings too many requests response has a 2xx status code
func (o *GetAWSSettingsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get a w s settings too many requests response has a 3xx status code
func (o *GetAWSSettingsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get a w s settings too many requests response has a 4xx status code
func (o *GetAWSSettingsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get a w s settings too many requests response has a 5xx status code
func (o *GetAWSSettingsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get a w s settings too many requests response a status code equal to that given
func (o *GetAWSSettingsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get a w s settings too many requests response
func (o *GetAWSSettingsTooManyRequests) Code() int {
	return 429
}

func (o *GetAWSSettingsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/settings/v1][%d] getAWSSettingsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAWSSettingsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/settings/v1][%d] getAWSSettingsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAWSSettingsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAWSSettingsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAWSSettingsInternalServerError creates a GetAWSSettingsInternalServerError with default headers values
func NewGetAWSSettingsInternalServerError() *GetAWSSettingsInternalServerError {
	return &GetAWSSettingsInternalServerError{}
}

/*
GetAWSSettingsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetAWSSettingsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsCustomerConfigurationsV1
}

// IsSuccess returns true when this get a w s settings internal server error response has a 2xx status code
func (o *GetAWSSettingsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get a w s settings internal server error response has a 3xx status code
func (o *GetAWSSettingsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get a w s settings internal server error response has a 4xx status code
func (o *GetAWSSettingsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get a w s settings internal server error response has a 5xx status code
func (o *GetAWSSettingsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get a w s settings internal server error response a status code equal to that given
func (o *GetAWSSettingsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get a w s settings internal server error response
func (o *GetAWSSettingsInternalServerError) Code() int {
	return 500
}

func (o *GetAWSSettingsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/settings/v1][%d] getAWSSettingsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAWSSettingsInternalServerError) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/settings/v1][%d] getAWSSettingsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAWSSettingsInternalServerError) GetPayload() *models.ModelsCustomerConfigurationsV1 {
	return o.Payload
}

func (o *GetAWSSettingsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsCustomerConfigurationsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
