// Code generated by go-swagger; DO NOT EDIT.

package cloud_connect_aws

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewProvisionAWSAccountsParams creates a new ProvisionAWSAccountsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewProvisionAWSAccountsParams() *ProvisionAWSAccountsParams {
	return &ProvisionAWSAccountsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewProvisionAWSAccountsParamsWithTimeout creates a new ProvisionAWSAccountsParams object
// with the ability to set a timeout on a request.
func NewProvisionAWSAccountsParamsWithTimeout(timeout time.Duration) *ProvisionAWSAccountsParams {
	return &ProvisionAWSAccountsParams{
		timeout: timeout,
	}
}

// NewProvisionAWSAccountsParamsWithContext creates a new ProvisionAWSAccountsParams object
// with the ability to set a context for a request.
func NewProvisionAWSAccountsParamsWithContext(ctx context.Context) *ProvisionAWSAccountsParams {
	return &ProvisionAWSAccountsParams{
		Context: ctx,
	}
}

// NewProvisionAWSAccountsParamsWithHTTPClient creates a new ProvisionAWSAccountsParams object
// with the ability to set a custom HTTPClient for a request.
func NewProvisionAWSAccountsParamsWithHTTPClient(client *http.Client) *ProvisionAWSAccountsParams {
	return &ProvisionAWSAccountsParams{
		HTTPClient: client,
	}
}

/*
ProvisionAWSAccountsParams contains all the parameters to send to the API endpoint

	for the provision a w s accounts operation.

	Typically these are written to a http.Request.
*/
type ProvisionAWSAccountsParams struct {

	// Body.
	Body *models.ModelsCreateAWSAccountsV1

	/* Mode.

	   Mode for provisioning. Allowed values are `manual` or `cloudformation`. Defaults to manual if not defined.

	   Default: "manual"
	*/
	Mode *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the provision a w s accounts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ProvisionAWSAccountsParams) WithDefaults() *ProvisionAWSAccountsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the provision a w s accounts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ProvisionAWSAccountsParams) SetDefaults() {
	var (
		modeDefault = string("manual")
	)

	val := ProvisionAWSAccountsParams{
		Mode: &modeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the provision a w s accounts params
func (o *ProvisionAWSAccountsParams) WithTimeout(timeout time.Duration) *ProvisionAWSAccountsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the provision a w s accounts params
func (o *ProvisionAWSAccountsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the provision a w s accounts params
func (o *ProvisionAWSAccountsParams) WithContext(ctx context.Context) *ProvisionAWSAccountsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the provision a w s accounts params
func (o *ProvisionAWSAccountsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the provision a w s accounts params
func (o *ProvisionAWSAccountsParams) WithHTTPClient(client *http.Client) *ProvisionAWSAccountsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the provision a w s accounts params
func (o *ProvisionAWSAccountsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the provision a w s accounts params
func (o *ProvisionAWSAccountsParams) WithBody(body *models.ModelsCreateAWSAccountsV1) *ProvisionAWSAccountsParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the provision a w s accounts params
func (o *ProvisionAWSAccountsParams) SetBody(body *models.ModelsCreateAWSAccountsV1) {
	o.Body = body
}

// WithMode adds the mode to the provision a w s accounts params
func (o *ProvisionAWSAccountsParams) WithMode(mode *string) *ProvisionAWSAccountsParams {
	o.SetMode(mode)
	return o
}

// SetMode adds the mode to the provision a w s accounts params
func (o *ProvisionAWSAccountsParams) SetMode(mode *string) {
	o.Mode = mode
}

// WriteToRequest writes these params to a swagger request
func (o *ProvisionAWSAccountsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.Mode != nil {

		// query param mode
		var qrMode string

		if o.Mode != nil {
			qrMode = *o.Mode
		}
		qMode := qrMode
		if qMode != "" {

			if err := r.SetQueryParam("mode", qMode); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
