// Code generated by go-swagger; DO NOT EDIT.

package cloud_connect_aws

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// ProvisionAWSAccountsReader is a Reader for the ProvisionAWSAccounts structure.
type ProvisionAWSAccountsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProvisionAWSAccountsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewProvisionAWSAccountsCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewProvisionAWSAccountsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewProvisionAWSAccountsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewProvisionAWSAccountsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewProvisionAWSAccountsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /cloud-connect-aws/entities/accounts/v1] ProvisionAWSAccounts", response, response.Code())
	}
}

// NewProvisionAWSAccountsCreated creates a ProvisionAWSAccountsCreated with default headers values
func NewProvisionAWSAccountsCreated() *ProvisionAWSAccountsCreated {
	return &ProvisionAWSAccountsCreated{}
}

/*
ProvisionAWSAccountsCreated describes a response with status code 201, with default header values.

Created
*/
type ProvisionAWSAccountsCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsAWSAccountsV1
}

// IsSuccess returns true when this provision a w s accounts created response has a 2xx status code
func (o *ProvisionAWSAccountsCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this provision a w s accounts created response has a 3xx status code
func (o *ProvisionAWSAccountsCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this provision a w s accounts created response has a 4xx status code
func (o *ProvisionAWSAccountsCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this provision a w s accounts created response has a 5xx status code
func (o *ProvisionAWSAccountsCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this provision a w s accounts created response a status code equal to that given
func (o *ProvisionAWSAccountsCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the provision a w s accounts created response
func (o *ProvisionAWSAccountsCreated) Code() int {
	return 201
}

func (o *ProvisionAWSAccountsCreated) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/accounts/v1][%d] provisionAWSAccountsCreated  %+v", 201, o.Payload)
}

func (o *ProvisionAWSAccountsCreated) String() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/accounts/v1][%d] provisionAWSAccountsCreated  %+v", 201, o.Payload)
}

func (o *ProvisionAWSAccountsCreated) GetPayload() *models.ModelsAWSAccountsV1 {
	return o.Payload
}

func (o *ProvisionAWSAccountsCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsAWSAccountsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProvisionAWSAccountsBadRequest creates a ProvisionAWSAccountsBadRequest with default headers values
func NewProvisionAWSAccountsBadRequest() *ProvisionAWSAccountsBadRequest {
	return &ProvisionAWSAccountsBadRequest{}
}

/*
ProvisionAWSAccountsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type ProvisionAWSAccountsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsAWSAccountsV1
}

// IsSuccess returns true when this provision a w s accounts bad request response has a 2xx status code
func (o *ProvisionAWSAccountsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this provision a w s accounts bad request response has a 3xx status code
func (o *ProvisionAWSAccountsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this provision a w s accounts bad request response has a 4xx status code
func (o *ProvisionAWSAccountsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this provision a w s accounts bad request response has a 5xx status code
func (o *ProvisionAWSAccountsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this provision a w s accounts bad request response a status code equal to that given
func (o *ProvisionAWSAccountsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the provision a w s accounts bad request response
func (o *ProvisionAWSAccountsBadRequest) Code() int {
	return 400
}

func (o *ProvisionAWSAccountsBadRequest) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/accounts/v1][%d] provisionAWSAccountsBadRequest  %+v", 400, o.Payload)
}

func (o *ProvisionAWSAccountsBadRequest) String() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/accounts/v1][%d] provisionAWSAccountsBadRequest  %+v", 400, o.Payload)
}

func (o *ProvisionAWSAccountsBadRequest) GetPayload() *models.ModelsAWSAccountsV1 {
	return o.Payload
}

func (o *ProvisionAWSAccountsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsAWSAccountsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProvisionAWSAccountsForbidden creates a ProvisionAWSAccountsForbidden with default headers values
func NewProvisionAWSAccountsForbidden() *ProvisionAWSAccountsForbidden {
	return &ProvisionAWSAccountsForbidden{}
}

/*
ProvisionAWSAccountsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ProvisionAWSAccountsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this provision a w s accounts forbidden response has a 2xx status code
func (o *ProvisionAWSAccountsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this provision a w s accounts forbidden response has a 3xx status code
func (o *ProvisionAWSAccountsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this provision a w s accounts forbidden response has a 4xx status code
func (o *ProvisionAWSAccountsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this provision a w s accounts forbidden response has a 5xx status code
func (o *ProvisionAWSAccountsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this provision a w s accounts forbidden response a status code equal to that given
func (o *ProvisionAWSAccountsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the provision a w s accounts forbidden response
func (o *ProvisionAWSAccountsForbidden) Code() int {
	return 403
}

func (o *ProvisionAWSAccountsForbidden) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/accounts/v1][%d] provisionAWSAccountsForbidden  %+v", 403, o.Payload)
}

func (o *ProvisionAWSAccountsForbidden) String() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/accounts/v1][%d] provisionAWSAccountsForbidden  %+v", 403, o.Payload)
}

func (o *ProvisionAWSAccountsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ProvisionAWSAccountsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProvisionAWSAccountsTooManyRequests creates a ProvisionAWSAccountsTooManyRequests with default headers values
func NewProvisionAWSAccountsTooManyRequests() *ProvisionAWSAccountsTooManyRequests {
	return &ProvisionAWSAccountsTooManyRequests{}
}

/*
ProvisionAWSAccountsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type ProvisionAWSAccountsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this provision a w s accounts too many requests response has a 2xx status code
func (o *ProvisionAWSAccountsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this provision a w s accounts too many requests response has a 3xx status code
func (o *ProvisionAWSAccountsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this provision a w s accounts too many requests response has a 4xx status code
func (o *ProvisionAWSAccountsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this provision a w s accounts too many requests response has a 5xx status code
func (o *ProvisionAWSAccountsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this provision a w s accounts too many requests response a status code equal to that given
func (o *ProvisionAWSAccountsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the provision a w s accounts too many requests response
func (o *ProvisionAWSAccountsTooManyRequests) Code() int {
	return 429
}

func (o *ProvisionAWSAccountsTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/accounts/v1][%d] provisionAWSAccountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *ProvisionAWSAccountsTooManyRequests) String() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/accounts/v1][%d] provisionAWSAccountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *ProvisionAWSAccountsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ProvisionAWSAccountsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProvisionAWSAccountsInternalServerError creates a ProvisionAWSAccountsInternalServerError with default headers values
func NewProvisionAWSAccountsInternalServerError() *ProvisionAWSAccountsInternalServerError {
	return &ProvisionAWSAccountsInternalServerError{}
}

/*
ProvisionAWSAccountsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type ProvisionAWSAccountsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsAWSAccountsV1
}

// IsSuccess returns true when this provision a w s accounts internal server error response has a 2xx status code
func (o *ProvisionAWSAccountsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this provision a w s accounts internal server error response has a 3xx status code
func (o *ProvisionAWSAccountsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this provision a w s accounts internal server error response has a 4xx status code
func (o *ProvisionAWSAccountsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this provision a w s accounts internal server error response has a 5xx status code
func (o *ProvisionAWSAccountsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this provision a w s accounts internal server error response a status code equal to that given
func (o *ProvisionAWSAccountsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the provision a w s accounts internal server error response
func (o *ProvisionAWSAccountsInternalServerError) Code() int {
	return 500
}

func (o *ProvisionAWSAccountsInternalServerError) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/accounts/v1][%d] provisionAWSAccountsInternalServerError  %+v", 500, o.Payload)
}

func (o *ProvisionAWSAccountsInternalServerError) String() string {
	return fmt.Sprintf("[POST /cloud-connect-aws/entities/accounts/v1][%d] provisionAWSAccountsInternalServerError  %+v", 500, o.Payload)
}

func (o *ProvisionAWSAccountsInternalServerError) GetPayload() *models.ModelsAWSAccountsV1 {
	return o.Payload
}

func (o *ProvisionAWSAccountsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsAWSAccountsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
