// Code generated by go-swagger; DO NOT EDIT.

package cloud_connect_aws

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryAWSAccountsForIDsParams creates a new QueryAWSAccountsForIDsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryAWSAccountsForIDsParams() *QueryAWSAccountsForIDsParams {
	return &QueryAWSAccountsForIDsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryAWSAccountsForIDsParamsWithTimeout creates a new QueryAWSAccountsForIDsParams object
// with the ability to set a timeout on a request.
func NewQueryAWSAccountsForIDsParamsWithTimeout(timeout time.Duration) *QueryAWSAccountsForIDsParams {
	return &QueryAWSAccountsForIDsParams{
		timeout: timeout,
	}
}

// NewQueryAWSAccountsForIDsParamsWithContext creates a new QueryAWSAccountsForIDsParams object
// with the ability to set a context for a request.
func NewQueryAWSAccountsForIDsParamsWithContext(ctx context.Context) *QueryAWSAccountsForIDsParams {
	return &QueryAWSAccountsForIDsParams{
		Context: ctx,
	}
}

// NewQueryAWSAccountsForIDsParamsWithHTTPClient creates a new QueryAWSAccountsForIDsParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryAWSAccountsForIDsParamsWithHTTPClient(client *http.Client) *QueryAWSAccountsForIDsParams {
	return &QueryAWSAccountsForIDsParams{
		HTTPClient: client,
	}
}

/*
QueryAWSAccountsForIDsParams contains all the parameters to send to the API endpoint

	for the query a w s accounts for i ds operation.

	Typically these are written to a http.Request.
*/
type QueryAWSAccountsForIDsParams struct {

	/* Filter.

	   The filter expression that should be used to limit the results
	*/
	Filter *string

	/* Limit.

	   The maximum records to return. [1-1000]. Defaults to 100.

	   Default: 100
	*/
	Limit *int64

	/* Offset.

	   The offset to start retrieving records from
	*/
	Offset *int64

	/* Sort.

	   The property to sort by (e.g. alias.desc or state.asc)
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query a w s accounts for i ds params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryAWSAccountsForIDsParams) WithDefaults() *QueryAWSAccountsForIDsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query a w s accounts for i ds params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryAWSAccountsForIDsParams) SetDefaults() {
	var (
		limitDefault = int64(100)
	)

	val := QueryAWSAccountsForIDsParams{
		Limit: &limitDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) WithTimeout(timeout time.Duration) *QueryAWSAccountsForIDsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) WithContext(ctx context.Context) *QueryAWSAccountsForIDsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) WithHTTPClient(client *http.Client) *QueryAWSAccountsForIDsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) WithFilter(filter *string) *QueryAWSAccountsForIDsParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) WithLimit(limit *int64) *QueryAWSAccountsForIDsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) WithOffset(offset *int64) *QueryAWSAccountsForIDsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) WithSort(sort *string) *QueryAWSAccountsForIDsParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query a w s accounts for i ds params
func (o *QueryAWSAccountsForIDsParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryAWSAccountsForIDsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
