// Code generated by go-swagger; DO NOT EDIT.

package cloud_connect_aws

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryAWSAccountsForIDsReader is a Reader for the QueryAWSAccountsForIDs structure.
type QueryAWSAccountsForIDsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryAWSAccountsForIDsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryAWSAccountsForIDsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryAWSAccountsForIDsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryAWSAccountsForIDsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryAWSAccountsForIDsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryAWSAccountsForIDsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloud-connect-aws/queries/accounts/v1] QueryAWSAccountsForIDs", response, response.Code())
	}
}

// NewQueryAWSAccountsForIDsOK creates a QueryAWSAccountsForIDsOK with default headers values
func NewQueryAWSAccountsForIDsOK() *QueryAWSAccountsForIDsOK {
	return &QueryAWSAccountsForIDsOK{}
}

/*
QueryAWSAccountsForIDsOK describes a response with status code 200, with default header values.

OK
*/
type QueryAWSAccountsForIDsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query a w s accounts for i ds o k response has a 2xx status code
func (o *QueryAWSAccountsForIDsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query a w s accounts for i ds o k response has a 3xx status code
func (o *QueryAWSAccountsForIDsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query a w s accounts for i ds o k response has a 4xx status code
func (o *QueryAWSAccountsForIDsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query a w s accounts for i ds o k response has a 5xx status code
func (o *QueryAWSAccountsForIDsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query a w s accounts for i ds o k response a status code equal to that given
func (o *QueryAWSAccountsForIDsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query a w s accounts for i ds o k response
func (o *QueryAWSAccountsForIDsOK) Code() int {
	return 200
}

func (o *QueryAWSAccountsForIDsOK) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/queries/accounts/v1][%d] queryAWSAccountsForIDsOK  %+v", 200, o.Payload)
}

func (o *QueryAWSAccountsForIDsOK) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/queries/accounts/v1][%d] queryAWSAccountsForIDsOK  %+v", 200, o.Payload)
}

func (o *QueryAWSAccountsForIDsOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryAWSAccountsForIDsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryAWSAccountsForIDsBadRequest creates a QueryAWSAccountsForIDsBadRequest with default headers values
func NewQueryAWSAccountsForIDsBadRequest() *QueryAWSAccountsForIDsBadRequest {
	return &QueryAWSAccountsForIDsBadRequest{}
}

/*
QueryAWSAccountsForIDsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryAWSAccountsForIDsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query a w s accounts for i ds bad request response has a 2xx status code
func (o *QueryAWSAccountsForIDsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query a w s accounts for i ds bad request response has a 3xx status code
func (o *QueryAWSAccountsForIDsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query a w s accounts for i ds bad request response has a 4xx status code
func (o *QueryAWSAccountsForIDsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query a w s accounts for i ds bad request response has a 5xx status code
func (o *QueryAWSAccountsForIDsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query a w s accounts for i ds bad request response a status code equal to that given
func (o *QueryAWSAccountsForIDsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query a w s accounts for i ds bad request response
func (o *QueryAWSAccountsForIDsBadRequest) Code() int {
	return 400
}

func (o *QueryAWSAccountsForIDsBadRequest) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/queries/accounts/v1][%d] queryAWSAccountsForIDsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryAWSAccountsForIDsBadRequest) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/queries/accounts/v1][%d] queryAWSAccountsForIDsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryAWSAccountsForIDsBadRequest) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryAWSAccountsForIDsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryAWSAccountsForIDsForbidden creates a QueryAWSAccountsForIDsForbidden with default headers values
func NewQueryAWSAccountsForIDsForbidden() *QueryAWSAccountsForIDsForbidden {
	return &QueryAWSAccountsForIDsForbidden{}
}

/*
QueryAWSAccountsForIDsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryAWSAccountsForIDsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query a w s accounts for i ds forbidden response has a 2xx status code
func (o *QueryAWSAccountsForIDsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query a w s accounts for i ds forbidden response has a 3xx status code
func (o *QueryAWSAccountsForIDsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query a w s accounts for i ds forbidden response has a 4xx status code
func (o *QueryAWSAccountsForIDsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query a w s accounts for i ds forbidden response has a 5xx status code
func (o *QueryAWSAccountsForIDsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query a w s accounts for i ds forbidden response a status code equal to that given
func (o *QueryAWSAccountsForIDsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query a w s accounts for i ds forbidden response
func (o *QueryAWSAccountsForIDsForbidden) Code() int {
	return 403
}

func (o *QueryAWSAccountsForIDsForbidden) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/queries/accounts/v1][%d] queryAWSAccountsForIDsForbidden  %+v", 403, o.Payload)
}

func (o *QueryAWSAccountsForIDsForbidden) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/queries/accounts/v1][%d] queryAWSAccountsForIDsForbidden  %+v", 403, o.Payload)
}

func (o *QueryAWSAccountsForIDsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryAWSAccountsForIDsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryAWSAccountsForIDsTooManyRequests creates a QueryAWSAccountsForIDsTooManyRequests with default headers values
func NewQueryAWSAccountsForIDsTooManyRequests() *QueryAWSAccountsForIDsTooManyRequests {
	return &QueryAWSAccountsForIDsTooManyRequests{}
}

/*
QueryAWSAccountsForIDsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryAWSAccountsForIDsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query a w s accounts for i ds too many requests response has a 2xx status code
func (o *QueryAWSAccountsForIDsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query a w s accounts for i ds too many requests response has a 3xx status code
func (o *QueryAWSAccountsForIDsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query a w s accounts for i ds too many requests response has a 4xx status code
func (o *QueryAWSAccountsForIDsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query a w s accounts for i ds too many requests response has a 5xx status code
func (o *QueryAWSAccountsForIDsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query a w s accounts for i ds too many requests response a status code equal to that given
func (o *QueryAWSAccountsForIDsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query a w s accounts for i ds too many requests response
func (o *QueryAWSAccountsForIDsTooManyRequests) Code() int {
	return 429
}

func (o *QueryAWSAccountsForIDsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/queries/accounts/v1][%d] queryAWSAccountsForIDsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryAWSAccountsForIDsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/queries/accounts/v1][%d] queryAWSAccountsForIDsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryAWSAccountsForIDsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryAWSAccountsForIDsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryAWSAccountsForIDsInternalServerError creates a QueryAWSAccountsForIDsInternalServerError with default headers values
func NewQueryAWSAccountsForIDsInternalServerError() *QueryAWSAccountsForIDsInternalServerError {
	return &QueryAWSAccountsForIDsInternalServerError{}
}

/*
QueryAWSAccountsForIDsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryAWSAccountsForIDsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query a w s accounts for i ds internal server error response has a 2xx status code
func (o *QueryAWSAccountsForIDsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query a w s accounts for i ds internal server error response has a 3xx status code
func (o *QueryAWSAccountsForIDsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query a w s accounts for i ds internal server error response has a 4xx status code
func (o *QueryAWSAccountsForIDsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query a w s accounts for i ds internal server error response has a 5xx status code
func (o *QueryAWSAccountsForIDsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query a w s accounts for i ds internal server error response a status code equal to that given
func (o *QueryAWSAccountsForIDsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query a w s accounts for i ds internal server error response
func (o *QueryAWSAccountsForIDsInternalServerError) Code() int {
	return 500
}

func (o *QueryAWSAccountsForIDsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/queries/accounts/v1][%d] queryAWSAccountsForIDsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryAWSAccountsForIDsInternalServerError) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/queries/accounts/v1][%d] queryAWSAccountsForIDsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryAWSAccountsForIDsInternalServerError) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryAWSAccountsForIDsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
