// Code generated by go-swagger; DO NOT EDIT.

package cloud_connect_aws

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryAWSAccountsReader is a Reader for the QueryAWSAccounts structure.
type QueryAWSAccountsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryAWSAccountsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryAWSAccountsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryAWSAccountsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryAWSAccountsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryAWSAccountsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryAWSAccountsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloud-connect-aws/combined/accounts/v1] QueryAWSAccounts", response, response.Code())
	}
}

// NewQueryAWSAccountsOK creates a QueryAWSAccountsOK with default headers values
func NewQueryAWSAccountsOK() *QueryAWSAccountsOK {
	return &QueryAWSAccountsOK{}
}

/*
QueryAWSAccountsOK describes a response with status code 200, with default header values.

OK
*/
type QueryAWSAccountsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsAWSAccountsV1
}

// IsSuccess returns true when this query a w s accounts o k response has a 2xx status code
func (o *QueryAWSAccountsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query a w s accounts o k response has a 3xx status code
func (o *QueryAWSAccountsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query a w s accounts o k response has a 4xx status code
func (o *QueryAWSAccountsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query a w s accounts o k response has a 5xx status code
func (o *QueryAWSAccountsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query a w s accounts o k response a status code equal to that given
func (o *QueryAWSAccountsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query a w s accounts o k response
func (o *QueryAWSAccountsOK) Code() int {
	return 200
}

func (o *QueryAWSAccountsOK) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/accounts/v1][%d] queryAWSAccountsOK  %+v", 200, o.Payload)
}

func (o *QueryAWSAccountsOK) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/accounts/v1][%d] queryAWSAccountsOK  %+v", 200, o.Payload)
}

func (o *QueryAWSAccountsOK) GetPayload() *models.ModelsAWSAccountsV1 {
	return o.Payload
}

func (o *QueryAWSAccountsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsAWSAccountsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryAWSAccountsBadRequest creates a QueryAWSAccountsBadRequest with default headers values
func NewQueryAWSAccountsBadRequest() *QueryAWSAccountsBadRequest {
	return &QueryAWSAccountsBadRequest{}
}

/*
QueryAWSAccountsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryAWSAccountsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsAWSAccountsV1
}

// IsSuccess returns true when this query a w s accounts bad request response has a 2xx status code
func (o *QueryAWSAccountsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query a w s accounts bad request response has a 3xx status code
func (o *QueryAWSAccountsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query a w s accounts bad request response has a 4xx status code
func (o *QueryAWSAccountsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query a w s accounts bad request response has a 5xx status code
func (o *QueryAWSAccountsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query a w s accounts bad request response a status code equal to that given
func (o *QueryAWSAccountsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query a w s accounts bad request response
func (o *QueryAWSAccountsBadRequest) Code() int {
	return 400
}

func (o *QueryAWSAccountsBadRequest) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/accounts/v1][%d] queryAWSAccountsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryAWSAccountsBadRequest) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/accounts/v1][%d] queryAWSAccountsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryAWSAccountsBadRequest) GetPayload() *models.ModelsAWSAccountsV1 {
	return o.Payload
}

func (o *QueryAWSAccountsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsAWSAccountsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryAWSAccountsForbidden creates a QueryAWSAccountsForbidden with default headers values
func NewQueryAWSAccountsForbidden() *QueryAWSAccountsForbidden {
	return &QueryAWSAccountsForbidden{}
}

/*
QueryAWSAccountsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryAWSAccountsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query a w s accounts forbidden response has a 2xx status code
func (o *QueryAWSAccountsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query a w s accounts forbidden response has a 3xx status code
func (o *QueryAWSAccountsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query a w s accounts forbidden response has a 4xx status code
func (o *QueryAWSAccountsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query a w s accounts forbidden response has a 5xx status code
func (o *QueryAWSAccountsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query a w s accounts forbidden response a status code equal to that given
func (o *QueryAWSAccountsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query a w s accounts forbidden response
func (o *QueryAWSAccountsForbidden) Code() int {
	return 403
}

func (o *QueryAWSAccountsForbidden) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/accounts/v1][%d] queryAWSAccountsForbidden  %+v", 403, o.Payload)
}

func (o *QueryAWSAccountsForbidden) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/accounts/v1][%d] queryAWSAccountsForbidden  %+v", 403, o.Payload)
}

func (o *QueryAWSAccountsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryAWSAccountsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryAWSAccountsTooManyRequests creates a QueryAWSAccountsTooManyRequests with default headers values
func NewQueryAWSAccountsTooManyRequests() *QueryAWSAccountsTooManyRequests {
	return &QueryAWSAccountsTooManyRequests{}
}

/*
QueryAWSAccountsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryAWSAccountsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query a w s accounts too many requests response has a 2xx status code
func (o *QueryAWSAccountsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query a w s accounts too many requests response has a 3xx status code
func (o *QueryAWSAccountsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query a w s accounts too many requests response has a 4xx status code
func (o *QueryAWSAccountsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query a w s accounts too many requests response has a 5xx status code
func (o *QueryAWSAccountsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query a w s accounts too many requests response a status code equal to that given
func (o *QueryAWSAccountsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query a w s accounts too many requests response
func (o *QueryAWSAccountsTooManyRequests) Code() int {
	return 429
}

func (o *QueryAWSAccountsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/accounts/v1][%d] queryAWSAccountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryAWSAccountsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/accounts/v1][%d] queryAWSAccountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryAWSAccountsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryAWSAccountsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryAWSAccountsInternalServerError creates a QueryAWSAccountsInternalServerError with default headers values
func NewQueryAWSAccountsInternalServerError() *QueryAWSAccountsInternalServerError {
	return &QueryAWSAccountsInternalServerError{}
}

/*
QueryAWSAccountsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryAWSAccountsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsAWSAccountsV1
}

// IsSuccess returns true when this query a w s accounts internal server error response has a 2xx status code
func (o *QueryAWSAccountsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query a w s accounts internal server error response has a 3xx status code
func (o *QueryAWSAccountsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query a w s accounts internal server error response has a 4xx status code
func (o *QueryAWSAccountsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query a w s accounts internal server error response has a 5xx status code
func (o *QueryAWSAccountsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query a w s accounts internal server error response a status code equal to that given
func (o *QueryAWSAccountsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query a w s accounts internal server error response
func (o *QueryAWSAccountsInternalServerError) Code() int {
	return 500
}

func (o *QueryAWSAccountsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/accounts/v1][%d] queryAWSAccountsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryAWSAccountsInternalServerError) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/combined/accounts/v1][%d] queryAWSAccountsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryAWSAccountsInternalServerError) GetPayload() *models.ModelsAWSAccountsV1 {
	return o.Payload
}

func (o *QueryAWSAccountsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsAWSAccountsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
