// Code generated by go-swagger; DO NOT EDIT.

package cloud_connect_aws

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateAWSAccountsReader is a Reader for the UpdateAWSAccounts structure.
type UpdateAWSAccountsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateAWSAccountsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateAWSAccountsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateAWSAccountsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateAWSAccountsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateAWSAccountsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateAWSAccountsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateAWSAccountsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /cloud-connect-aws/entities/accounts/v1] UpdateAWSAccounts", response, response.Code())
	}
}

// NewUpdateAWSAccountsOK creates a UpdateAWSAccountsOK with default headers values
func NewUpdateAWSAccountsOK() *UpdateAWSAccountsOK {
	return &UpdateAWSAccountsOK{}
}

/*
UpdateAWSAccountsOK describes a response with status code 200, with default header values.

OK
*/
type UpdateAWSAccountsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsAWSAccountsV1
}

// IsSuccess returns true when this update a w s accounts o k response has a 2xx status code
func (o *UpdateAWSAccountsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update a w s accounts o k response has a 3xx status code
func (o *UpdateAWSAccountsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update a w s accounts o k response has a 4xx status code
func (o *UpdateAWSAccountsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update a w s accounts o k response has a 5xx status code
func (o *UpdateAWSAccountsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update a w s accounts o k response a status code equal to that given
func (o *UpdateAWSAccountsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update a w s accounts o k response
func (o *UpdateAWSAccountsOK) Code() int {
	return 200
}

func (o *UpdateAWSAccountsOK) Error() string {
	return fmt.Sprintf("[PATCH /cloud-connect-aws/entities/accounts/v1][%d] updateAWSAccountsOK  %+v", 200, o.Payload)
}

func (o *UpdateAWSAccountsOK) String() string {
	return fmt.Sprintf("[PATCH /cloud-connect-aws/entities/accounts/v1][%d] updateAWSAccountsOK  %+v", 200, o.Payload)
}

func (o *UpdateAWSAccountsOK) GetPayload() *models.ModelsAWSAccountsV1 {
	return o.Payload
}

func (o *UpdateAWSAccountsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsAWSAccountsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAWSAccountsBadRequest creates a UpdateAWSAccountsBadRequest with default headers values
func NewUpdateAWSAccountsBadRequest() *UpdateAWSAccountsBadRequest {
	return &UpdateAWSAccountsBadRequest{}
}

/*
UpdateAWSAccountsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateAWSAccountsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsAWSAccountsV1
}

// IsSuccess returns true when this update a w s accounts bad request response has a 2xx status code
func (o *UpdateAWSAccountsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update a w s accounts bad request response has a 3xx status code
func (o *UpdateAWSAccountsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update a w s accounts bad request response has a 4xx status code
func (o *UpdateAWSAccountsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update a w s accounts bad request response has a 5xx status code
func (o *UpdateAWSAccountsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update a w s accounts bad request response a status code equal to that given
func (o *UpdateAWSAccountsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update a w s accounts bad request response
func (o *UpdateAWSAccountsBadRequest) Code() int {
	return 400
}

func (o *UpdateAWSAccountsBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /cloud-connect-aws/entities/accounts/v1][%d] updateAWSAccountsBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateAWSAccountsBadRequest) String() string {
	return fmt.Sprintf("[PATCH /cloud-connect-aws/entities/accounts/v1][%d] updateAWSAccountsBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateAWSAccountsBadRequest) GetPayload() *models.ModelsAWSAccountsV1 {
	return o.Payload
}

func (o *UpdateAWSAccountsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsAWSAccountsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAWSAccountsForbidden creates a UpdateAWSAccountsForbidden with default headers values
func NewUpdateAWSAccountsForbidden() *UpdateAWSAccountsForbidden {
	return &UpdateAWSAccountsForbidden{}
}

/*
UpdateAWSAccountsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateAWSAccountsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update a w s accounts forbidden response has a 2xx status code
func (o *UpdateAWSAccountsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update a w s accounts forbidden response has a 3xx status code
func (o *UpdateAWSAccountsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update a w s accounts forbidden response has a 4xx status code
func (o *UpdateAWSAccountsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update a w s accounts forbidden response has a 5xx status code
func (o *UpdateAWSAccountsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update a w s accounts forbidden response a status code equal to that given
func (o *UpdateAWSAccountsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update a w s accounts forbidden response
func (o *UpdateAWSAccountsForbidden) Code() int {
	return 403
}

func (o *UpdateAWSAccountsForbidden) Error() string {
	return fmt.Sprintf("[PATCH /cloud-connect-aws/entities/accounts/v1][%d] updateAWSAccountsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateAWSAccountsForbidden) String() string {
	return fmt.Sprintf("[PATCH /cloud-connect-aws/entities/accounts/v1][%d] updateAWSAccountsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateAWSAccountsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateAWSAccountsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAWSAccountsNotFound creates a UpdateAWSAccountsNotFound with default headers values
func NewUpdateAWSAccountsNotFound() *UpdateAWSAccountsNotFound {
	return &UpdateAWSAccountsNotFound{}
}

/*
UpdateAWSAccountsNotFound describes a response with status code 404, with default header values.

Not Found
*/
type UpdateAWSAccountsNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsAWSAccountsV1
}

// IsSuccess returns true when this update a w s accounts not found response has a 2xx status code
func (o *UpdateAWSAccountsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update a w s accounts not found response has a 3xx status code
func (o *UpdateAWSAccountsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update a w s accounts not found response has a 4xx status code
func (o *UpdateAWSAccountsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update a w s accounts not found response has a 5xx status code
func (o *UpdateAWSAccountsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update a w s accounts not found response a status code equal to that given
func (o *UpdateAWSAccountsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update a w s accounts not found response
func (o *UpdateAWSAccountsNotFound) Code() int {
	return 404
}

func (o *UpdateAWSAccountsNotFound) Error() string {
	return fmt.Sprintf("[PATCH /cloud-connect-aws/entities/accounts/v1][%d] updateAWSAccountsNotFound  %+v", 404, o.Payload)
}

func (o *UpdateAWSAccountsNotFound) String() string {
	return fmt.Sprintf("[PATCH /cloud-connect-aws/entities/accounts/v1][%d] updateAWSAccountsNotFound  %+v", 404, o.Payload)
}

func (o *UpdateAWSAccountsNotFound) GetPayload() *models.ModelsAWSAccountsV1 {
	return o.Payload
}

func (o *UpdateAWSAccountsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsAWSAccountsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAWSAccountsTooManyRequests creates a UpdateAWSAccountsTooManyRequests with default headers values
func NewUpdateAWSAccountsTooManyRequests() *UpdateAWSAccountsTooManyRequests {
	return &UpdateAWSAccountsTooManyRequests{}
}

/*
UpdateAWSAccountsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateAWSAccountsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update a w s accounts too many requests response has a 2xx status code
func (o *UpdateAWSAccountsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update a w s accounts too many requests response has a 3xx status code
func (o *UpdateAWSAccountsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update a w s accounts too many requests response has a 4xx status code
func (o *UpdateAWSAccountsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update a w s accounts too many requests response has a 5xx status code
func (o *UpdateAWSAccountsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update a w s accounts too many requests response a status code equal to that given
func (o *UpdateAWSAccountsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update a w s accounts too many requests response
func (o *UpdateAWSAccountsTooManyRequests) Code() int {
	return 429
}

func (o *UpdateAWSAccountsTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /cloud-connect-aws/entities/accounts/v1][%d] updateAWSAccountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateAWSAccountsTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /cloud-connect-aws/entities/accounts/v1][%d] updateAWSAccountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateAWSAccountsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateAWSAccountsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAWSAccountsInternalServerError creates a UpdateAWSAccountsInternalServerError with default headers values
func NewUpdateAWSAccountsInternalServerError() *UpdateAWSAccountsInternalServerError {
	return &UpdateAWSAccountsInternalServerError{}
}

/*
UpdateAWSAccountsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UpdateAWSAccountsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ModelsAWSAccountsV1
}

// IsSuccess returns true when this update a w s accounts internal server error response has a 2xx status code
func (o *UpdateAWSAccountsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update a w s accounts internal server error response has a 3xx status code
func (o *UpdateAWSAccountsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update a w s accounts internal server error response has a 4xx status code
func (o *UpdateAWSAccountsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update a w s accounts internal server error response has a 5xx status code
func (o *UpdateAWSAccountsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update a w s accounts internal server error response a status code equal to that given
func (o *UpdateAWSAccountsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update a w s accounts internal server error response
func (o *UpdateAWSAccountsInternalServerError) Code() int {
	return 500
}

func (o *UpdateAWSAccountsInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /cloud-connect-aws/entities/accounts/v1][%d] updateAWSAccountsInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateAWSAccountsInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /cloud-connect-aws/entities/accounts/v1][%d] updateAWSAccountsInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateAWSAccountsInternalServerError) GetPayload() *models.ModelsAWSAccountsV1 {
	return o.Payload
}

func (o *UpdateAWSAccountsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ModelsAWSAccountsV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
