// Code generated by go-swagger; DO NOT EDIT.

package configuration_assessment

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetCombinedAssessmentsQueryParams creates a new GetCombinedAssessmentsQueryParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetCombinedAssessmentsQueryParams() *GetCombinedAssessmentsQueryParams {
	return &GetCombinedAssessmentsQueryParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetCombinedAssessmentsQueryParamsWithTimeout creates a new GetCombinedAssessmentsQueryParams object
// with the ability to set a timeout on a request.
func NewGetCombinedAssessmentsQueryParamsWithTimeout(timeout time.Duration) *GetCombinedAssessmentsQueryParams {
	return &GetCombinedAssessmentsQueryParams{
		timeout: timeout,
	}
}

// NewGetCombinedAssessmentsQueryParamsWithContext creates a new GetCombinedAssessmentsQueryParams object
// with the ability to set a context for a request.
func NewGetCombinedAssessmentsQueryParamsWithContext(ctx context.Context) *GetCombinedAssessmentsQueryParams {
	return &GetCombinedAssessmentsQueryParams{
		Context: ctx,
	}
}

// NewGetCombinedAssessmentsQueryParamsWithHTTPClient creates a new GetCombinedAssessmentsQueryParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetCombinedAssessmentsQueryParamsWithHTTPClient(client *http.Client) *GetCombinedAssessmentsQueryParams {
	return &GetCombinedAssessmentsQueryParams{
		HTTPClient: client,
	}
}

/*
GetCombinedAssessmentsQueryParams contains all the parameters to send to the API endpoint

	for the get combined assessments query operation.

	Typically these are written to a http.Request.
*/
type GetCombinedAssessmentsQueryParams struct {

	/* After.

	   A pagination token used with the `limit` parameter to manage pagination of results. On your first request, don't provide an `after` token. On subsequent requests, provide the `after` token from the previous response to continue from that place in the results.
	*/
	After *string

	/* Facet.

	     Select various details blocks to be returned for each assessment entity. Supported values:

	<ul><li>host</li><li>finding.rule</li><li>finding.evaluation_logic</li></ul>
	*/
	Facet []string

	/* Filter.

	     Filter items using a query in Falcon Query Language (FQL). Wildcards * are unsupported.

	Common filter options include:

	<ul><li>created_timestamp:>'2019-11-25T22:36:12Z'</li><li>updated_timestamp:>'2019-11-25T22:36:12Z'</li><li>aid:'8e7656b27d8c49a34a1af416424d6231'</li></ul>
	*/
	Filter string

	/* Limit.

	   The number of items to return in this response (default: 100, max: 5000). Use with the after parameter to manage pagination of results.
	*/
	Limit *int64

	/* Sort.

	     Sort assessment by their properties. Common sort options include:

	<ul><li>created_timestamp|desc</li><li>updated_timestamp|asc</li></ul>
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get combined assessments query params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetCombinedAssessmentsQueryParams) WithDefaults() *GetCombinedAssessmentsQueryParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get combined assessments query params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetCombinedAssessmentsQueryParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) WithTimeout(timeout time.Duration) *GetCombinedAssessmentsQueryParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) WithContext(ctx context.Context) *GetCombinedAssessmentsQueryParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) WithHTTPClient(client *http.Client) *GetCombinedAssessmentsQueryParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAfter adds the after to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) WithAfter(after *string) *GetCombinedAssessmentsQueryParams {
	o.SetAfter(after)
	return o
}

// SetAfter adds the after to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) SetAfter(after *string) {
	o.After = after
}

// WithFacet adds the facet to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) WithFacet(facet []string) *GetCombinedAssessmentsQueryParams {
	o.SetFacet(facet)
	return o
}

// SetFacet adds the facet to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) SetFacet(facet []string) {
	o.Facet = facet
}

// WithFilter adds the filter to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) WithFilter(filter string) *GetCombinedAssessmentsQueryParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) SetFilter(filter string) {
	o.Filter = filter
}

// WithLimit adds the limit to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) WithLimit(limit *int64) *GetCombinedAssessmentsQueryParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithSort adds the sort to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) WithSort(sort *string) *GetCombinedAssessmentsQueryParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the get combined assessments query params
func (o *GetCombinedAssessmentsQueryParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *GetCombinedAssessmentsQueryParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.After != nil {

		// query param after
		var qrAfter string

		if o.After != nil {
			qrAfter = *o.After
		}
		qAfter := qrAfter
		if qAfter != "" {

			if err := r.SetQueryParam("after", qAfter); err != nil {
				return err
			}
		}
	}

	if o.Facet != nil {

		// binding items for facet
		joinedFacet := o.bindParamFacet(reg)

		// query array param facet
		if err := r.SetQueryParam("facet", joinedFacet...); err != nil {
			return err
		}
	}

	// query param filter
	qrFilter := o.Filter
	qFilter := qrFilter
	if qFilter != "" {

		if err := r.SetQueryParam("filter", qFilter); err != nil {
			return err
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetCombinedAssessmentsQuery binds the parameter facet
func (o *GetCombinedAssessmentsQueryParams) bindParamFacet(formats strfmt.Registry) []string {
	facetIR := o.Facet

	var facetIC []string
	for _, facetIIR := range facetIR { // explode []string

		facetIIV := facetIIR // string as string
		facetIC = append(facetIC, facetIIV)
	}

	// items.CollectionFormat: "multi"
	facetIS := swag.JoinByFormat(facetIC, "multi")

	return facetIS
}
