// Code generated by go-swagger; DO NOT EDIT.

package configuration_assessment

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetCombinedAssessmentsQueryReader is a Reader for the GetCombinedAssessmentsQuery structure.
type GetCombinedAssessmentsQueryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCombinedAssessmentsQueryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCombinedAssessmentsQueryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetCombinedAssessmentsQueryBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetCombinedAssessmentsQueryForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetCombinedAssessmentsQueryTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCombinedAssessmentsQueryInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /configuration-assessment/combined/assessments/v1] getCombinedAssessmentsQuery", response, response.Code())
	}
}

// NewGetCombinedAssessmentsQueryOK creates a GetCombinedAssessmentsQueryOK with default headers values
func NewGetCombinedAssessmentsQueryOK() *GetCombinedAssessmentsQueryOK {
	return &GetCombinedAssessmentsQueryOK{}
}

/*
GetCombinedAssessmentsQueryOK describes a response with status code 200, with default header values.

OK
*/
type GetCombinedAssessmentsQueryOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPICombinedFindingsResponseV1
}

// IsSuccess returns true when this get combined assessments query o k response has a 2xx status code
func (o *GetCombinedAssessmentsQueryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get combined assessments query o k response has a 3xx status code
func (o *GetCombinedAssessmentsQueryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined assessments query o k response has a 4xx status code
func (o *GetCombinedAssessmentsQueryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get combined assessments query o k response has a 5xx status code
func (o *GetCombinedAssessmentsQueryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined assessments query o k response a status code equal to that given
func (o *GetCombinedAssessmentsQueryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get combined assessments query o k response
func (o *GetCombinedAssessmentsQueryOK) Code() int {
	return 200
}

func (o *GetCombinedAssessmentsQueryOK) Error() string {
	return fmt.Sprintf("[GET /configuration-assessment/combined/assessments/v1][%d] getCombinedAssessmentsQueryOK  %+v", 200, o.Payload)
}

func (o *GetCombinedAssessmentsQueryOK) String() string {
	return fmt.Sprintf("[GET /configuration-assessment/combined/assessments/v1][%d] getCombinedAssessmentsQueryOK  %+v", 200, o.Payload)
}

func (o *GetCombinedAssessmentsQueryOK) GetPayload() *models.DomainAPICombinedFindingsResponseV1 {
	return o.Payload
}

func (o *GetCombinedAssessmentsQueryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPICombinedFindingsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedAssessmentsQueryBadRequest creates a GetCombinedAssessmentsQueryBadRequest with default headers values
func NewGetCombinedAssessmentsQueryBadRequest() *GetCombinedAssessmentsQueryBadRequest {
	return &GetCombinedAssessmentsQueryBadRequest{}
}

/*
GetCombinedAssessmentsQueryBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetCombinedAssessmentsQueryBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPICombinedFindingsResponseV1
}

// IsSuccess returns true when this get combined assessments query bad request response has a 2xx status code
func (o *GetCombinedAssessmentsQueryBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined assessments query bad request response has a 3xx status code
func (o *GetCombinedAssessmentsQueryBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined assessments query bad request response has a 4xx status code
func (o *GetCombinedAssessmentsQueryBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get combined assessments query bad request response has a 5xx status code
func (o *GetCombinedAssessmentsQueryBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined assessments query bad request response a status code equal to that given
func (o *GetCombinedAssessmentsQueryBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get combined assessments query bad request response
func (o *GetCombinedAssessmentsQueryBadRequest) Code() int {
	return 400
}

func (o *GetCombinedAssessmentsQueryBadRequest) Error() string {
	return fmt.Sprintf("[GET /configuration-assessment/combined/assessments/v1][%d] getCombinedAssessmentsQueryBadRequest  %+v", 400, o.Payload)
}

func (o *GetCombinedAssessmentsQueryBadRequest) String() string {
	return fmt.Sprintf("[GET /configuration-assessment/combined/assessments/v1][%d] getCombinedAssessmentsQueryBadRequest  %+v", 400, o.Payload)
}

func (o *GetCombinedAssessmentsQueryBadRequest) GetPayload() *models.DomainAPICombinedFindingsResponseV1 {
	return o.Payload
}

func (o *GetCombinedAssessmentsQueryBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPICombinedFindingsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedAssessmentsQueryForbidden creates a GetCombinedAssessmentsQueryForbidden with default headers values
func NewGetCombinedAssessmentsQueryForbidden() *GetCombinedAssessmentsQueryForbidden {
	return &GetCombinedAssessmentsQueryForbidden{}
}

/*
GetCombinedAssessmentsQueryForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetCombinedAssessmentsQueryForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get combined assessments query forbidden response has a 2xx status code
func (o *GetCombinedAssessmentsQueryForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined assessments query forbidden response has a 3xx status code
func (o *GetCombinedAssessmentsQueryForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined assessments query forbidden response has a 4xx status code
func (o *GetCombinedAssessmentsQueryForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get combined assessments query forbidden response has a 5xx status code
func (o *GetCombinedAssessmentsQueryForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined assessments query forbidden response a status code equal to that given
func (o *GetCombinedAssessmentsQueryForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get combined assessments query forbidden response
func (o *GetCombinedAssessmentsQueryForbidden) Code() int {
	return 403
}

func (o *GetCombinedAssessmentsQueryForbidden) Error() string {
	return fmt.Sprintf("[GET /configuration-assessment/combined/assessments/v1][%d] getCombinedAssessmentsQueryForbidden  %+v", 403, o.Payload)
}

func (o *GetCombinedAssessmentsQueryForbidden) String() string {
	return fmt.Sprintf("[GET /configuration-assessment/combined/assessments/v1][%d] getCombinedAssessmentsQueryForbidden  %+v", 403, o.Payload)
}

func (o *GetCombinedAssessmentsQueryForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCombinedAssessmentsQueryForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedAssessmentsQueryTooManyRequests creates a GetCombinedAssessmentsQueryTooManyRequests with default headers values
func NewGetCombinedAssessmentsQueryTooManyRequests() *GetCombinedAssessmentsQueryTooManyRequests {
	return &GetCombinedAssessmentsQueryTooManyRequests{}
}

/*
GetCombinedAssessmentsQueryTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetCombinedAssessmentsQueryTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get combined assessments query too many requests response has a 2xx status code
func (o *GetCombinedAssessmentsQueryTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined assessments query too many requests response has a 3xx status code
func (o *GetCombinedAssessmentsQueryTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined assessments query too many requests response has a 4xx status code
func (o *GetCombinedAssessmentsQueryTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get combined assessments query too many requests response has a 5xx status code
func (o *GetCombinedAssessmentsQueryTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined assessments query too many requests response a status code equal to that given
func (o *GetCombinedAssessmentsQueryTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get combined assessments query too many requests response
func (o *GetCombinedAssessmentsQueryTooManyRequests) Code() int {
	return 429
}

func (o *GetCombinedAssessmentsQueryTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /configuration-assessment/combined/assessments/v1][%d] getCombinedAssessmentsQueryTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCombinedAssessmentsQueryTooManyRequests) String() string {
	return fmt.Sprintf("[GET /configuration-assessment/combined/assessments/v1][%d] getCombinedAssessmentsQueryTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCombinedAssessmentsQueryTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCombinedAssessmentsQueryTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedAssessmentsQueryInternalServerError creates a GetCombinedAssessmentsQueryInternalServerError with default headers values
func NewGetCombinedAssessmentsQueryInternalServerError() *GetCombinedAssessmentsQueryInternalServerError {
	return &GetCombinedAssessmentsQueryInternalServerError{}
}

/*
GetCombinedAssessmentsQueryInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetCombinedAssessmentsQueryInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPICombinedFindingsResponseV1
}

// IsSuccess returns true when this get combined assessments query internal server error response has a 2xx status code
func (o *GetCombinedAssessmentsQueryInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined assessments query internal server error response has a 3xx status code
func (o *GetCombinedAssessmentsQueryInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined assessments query internal server error response has a 4xx status code
func (o *GetCombinedAssessmentsQueryInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get combined assessments query internal server error response has a 5xx status code
func (o *GetCombinedAssessmentsQueryInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get combined assessments query internal server error response a status code equal to that given
func (o *GetCombinedAssessmentsQueryInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get combined assessments query internal server error response
func (o *GetCombinedAssessmentsQueryInternalServerError) Code() int {
	return 500
}

func (o *GetCombinedAssessmentsQueryInternalServerError) Error() string {
	return fmt.Sprintf("[GET /configuration-assessment/combined/assessments/v1][%d] getCombinedAssessmentsQueryInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCombinedAssessmentsQueryInternalServerError) String() string {
	return fmt.Sprintf("[GET /configuration-assessment/combined/assessments/v1][%d] getCombinedAssessmentsQueryInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCombinedAssessmentsQueryInternalServerError) GetPayload() *models.DomainAPICombinedFindingsResponseV1 {
	return o.Payload
}

func (o *GetCombinedAssessmentsQueryInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPICombinedFindingsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
