// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// AzureDownloadCertificateReader is a Reader for the AzureDownloadCertificate structure.
type AzureDownloadCertificateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AzureDownloadCertificateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAzureDownloadCertificateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewAzureDownloadCertificateBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAzureDownloadCertificateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewAzureDownloadCertificateTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAzureDownloadCertificateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloud-connect-cspm-azure/entities/download-certificate/v1] AzureDownloadCertificate", response, response.Code())
	}
}

// NewAzureDownloadCertificateOK creates a AzureDownloadCertificateOK with default headers values
func NewAzureDownloadCertificateOK() *AzureDownloadCertificateOK {
	return &AzureDownloadCertificateOK{}
}

/*
AzureDownloadCertificateOK describes a response with status code 200, with default header values.

OK
*/
type AzureDownloadCertificateOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureDownloadCertificateResponseV1
}

// IsSuccess returns true when this azure download certificate o k response has a 2xx status code
func (o *AzureDownloadCertificateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this azure download certificate o k response has a 3xx status code
func (o *AzureDownloadCertificateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this azure download certificate o k response has a 4xx status code
func (o *AzureDownloadCertificateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this azure download certificate o k response has a 5xx status code
func (o *AzureDownloadCertificateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this azure download certificate o k response a status code equal to that given
func (o *AzureDownloadCertificateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the azure download certificate o k response
func (o *AzureDownloadCertificateOK) Code() int {
	return 200
}

func (o *AzureDownloadCertificateOK) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-azure/entities/download-certificate/v1][%d] azureDownloadCertificateOK  %+v", 200, o.Payload)
}

func (o *AzureDownloadCertificateOK) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-azure/entities/download-certificate/v1][%d] azureDownloadCertificateOK  %+v", 200, o.Payload)
}

func (o *AzureDownloadCertificateOK) GetPayload() *models.RegistrationAzureDownloadCertificateResponseV1 {
	return o.Payload
}

func (o *AzureDownloadCertificateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureDownloadCertificateResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAzureDownloadCertificateBadRequest creates a AzureDownloadCertificateBadRequest with default headers values
func NewAzureDownloadCertificateBadRequest() *AzureDownloadCertificateBadRequest {
	return &AzureDownloadCertificateBadRequest{}
}

/*
AzureDownloadCertificateBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type AzureDownloadCertificateBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureDownloadCertificateResponseV1
}

// IsSuccess returns true when this azure download certificate bad request response has a 2xx status code
func (o *AzureDownloadCertificateBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this azure download certificate bad request response has a 3xx status code
func (o *AzureDownloadCertificateBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this azure download certificate bad request response has a 4xx status code
func (o *AzureDownloadCertificateBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this azure download certificate bad request response has a 5xx status code
func (o *AzureDownloadCertificateBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this azure download certificate bad request response a status code equal to that given
func (o *AzureDownloadCertificateBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the azure download certificate bad request response
func (o *AzureDownloadCertificateBadRequest) Code() int {
	return 400
}

func (o *AzureDownloadCertificateBadRequest) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-azure/entities/download-certificate/v1][%d] azureDownloadCertificateBadRequest  %+v", 400, o.Payload)
}

func (o *AzureDownloadCertificateBadRequest) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-azure/entities/download-certificate/v1][%d] azureDownloadCertificateBadRequest  %+v", 400, o.Payload)
}

func (o *AzureDownloadCertificateBadRequest) GetPayload() *models.RegistrationAzureDownloadCertificateResponseV1 {
	return o.Payload
}

func (o *AzureDownloadCertificateBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureDownloadCertificateResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAzureDownloadCertificateForbidden creates a AzureDownloadCertificateForbidden with default headers values
func NewAzureDownloadCertificateForbidden() *AzureDownloadCertificateForbidden {
	return &AzureDownloadCertificateForbidden{}
}

/*
AzureDownloadCertificateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AzureDownloadCertificateForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this azure download certificate forbidden response has a 2xx status code
func (o *AzureDownloadCertificateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this azure download certificate forbidden response has a 3xx status code
func (o *AzureDownloadCertificateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this azure download certificate forbidden response has a 4xx status code
func (o *AzureDownloadCertificateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this azure download certificate forbidden response has a 5xx status code
func (o *AzureDownloadCertificateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this azure download certificate forbidden response a status code equal to that given
func (o *AzureDownloadCertificateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the azure download certificate forbidden response
func (o *AzureDownloadCertificateForbidden) Code() int {
	return 403
}

func (o *AzureDownloadCertificateForbidden) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-azure/entities/download-certificate/v1][%d] azureDownloadCertificateForbidden  %+v", 403, o.Payload)
}

func (o *AzureDownloadCertificateForbidden) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-azure/entities/download-certificate/v1][%d] azureDownloadCertificateForbidden  %+v", 403, o.Payload)
}

func (o *AzureDownloadCertificateForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AzureDownloadCertificateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAzureDownloadCertificateTooManyRequests creates a AzureDownloadCertificateTooManyRequests with default headers values
func NewAzureDownloadCertificateTooManyRequests() *AzureDownloadCertificateTooManyRequests {
	return &AzureDownloadCertificateTooManyRequests{}
}

/*
AzureDownloadCertificateTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type AzureDownloadCertificateTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this azure download certificate too many requests response has a 2xx status code
func (o *AzureDownloadCertificateTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this azure download certificate too many requests response has a 3xx status code
func (o *AzureDownloadCertificateTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this azure download certificate too many requests response has a 4xx status code
func (o *AzureDownloadCertificateTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this azure download certificate too many requests response has a 5xx status code
func (o *AzureDownloadCertificateTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this azure download certificate too many requests response a status code equal to that given
func (o *AzureDownloadCertificateTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the azure download certificate too many requests response
func (o *AzureDownloadCertificateTooManyRequests) Code() int {
	return 429
}

func (o *AzureDownloadCertificateTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-azure/entities/download-certificate/v1][%d] azureDownloadCertificateTooManyRequests  %+v", 429, o.Payload)
}

func (o *AzureDownloadCertificateTooManyRequests) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-azure/entities/download-certificate/v1][%d] azureDownloadCertificateTooManyRequests  %+v", 429, o.Payload)
}

func (o *AzureDownloadCertificateTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AzureDownloadCertificateTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAzureDownloadCertificateInternalServerError creates a AzureDownloadCertificateInternalServerError with default headers values
func NewAzureDownloadCertificateInternalServerError() *AzureDownloadCertificateInternalServerError {
	return &AzureDownloadCertificateInternalServerError{}
}

/*
AzureDownloadCertificateInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type AzureDownloadCertificateInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureDownloadCertificateResponseV1
}

// IsSuccess returns true when this azure download certificate internal server error response has a 2xx status code
func (o *AzureDownloadCertificateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this azure download certificate internal server error response has a 3xx status code
func (o *AzureDownloadCertificateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this azure download certificate internal server error response has a 4xx status code
func (o *AzureDownloadCertificateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this azure download certificate internal server error response has a 5xx status code
func (o *AzureDownloadCertificateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this azure download certificate internal server error response a status code equal to that given
func (o *AzureDownloadCertificateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the azure download certificate internal server error response
func (o *AzureDownloadCertificateInternalServerError) Code() int {
	return 500
}

func (o *AzureDownloadCertificateInternalServerError) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-azure/entities/download-certificate/v1][%d] azureDownloadCertificateInternalServerError  %+v", 500, o.Payload)
}

func (o *AzureDownloadCertificateInternalServerError) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-azure/entities/download-certificate/v1][%d] azureDownloadCertificateInternalServerError  %+v", 500, o.Payload)
}

func (o *AzureDownloadCertificateInternalServerError) GetPayload() *models.RegistrationAzureDownloadCertificateResponseV1 {
	return o.Payload
}

func (o *AzureDownloadCertificateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureDownloadCertificateResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
