// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteCSPMAwsAccountParams creates a new DeleteCSPMAwsAccountParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteCSPMAwsAccountParams() *DeleteCSPMAwsAccountParams {
	return &DeleteCSPMAwsAccountParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteCSPMAwsAccountParamsWithTimeout creates a new DeleteCSPMAwsAccountParams object
// with the ability to set a timeout on a request.
func NewDeleteCSPMAwsAccountParamsWithTimeout(timeout time.Duration) *DeleteCSPMAwsAccountParams {
	return &DeleteCSPMAwsAccountParams{
		timeout: timeout,
	}
}

// NewDeleteCSPMAwsAccountParamsWithContext creates a new DeleteCSPMAwsAccountParams object
// with the ability to set a context for a request.
func NewDeleteCSPMAwsAccountParamsWithContext(ctx context.Context) *DeleteCSPMAwsAccountParams {
	return &DeleteCSPMAwsAccountParams{
		Context: ctx,
	}
}

// NewDeleteCSPMAwsAccountParamsWithHTTPClient creates a new DeleteCSPMAwsAccountParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteCSPMAwsAccountParamsWithHTTPClient(client *http.Client) *DeleteCSPMAwsAccountParams {
	return &DeleteCSPMAwsAccountParams{
		HTTPClient: client,
	}
}

/*
DeleteCSPMAwsAccountParams contains all the parameters to send to the API endpoint

	for the delete c s p m aws account operation.

	Typically these are written to a http.Request.
*/
type DeleteCSPMAwsAccountParams struct {

	/* Ids.

	   AWS account IDs to remove
	*/
	Ids []string

	/* OrganizationIds.

	   AWS organization IDs to remove
	*/
	OrganizationIds []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete c s p m aws account params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteCSPMAwsAccountParams) WithDefaults() *DeleteCSPMAwsAccountParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete c s p m aws account params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteCSPMAwsAccountParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete c s p m aws account params
func (o *DeleteCSPMAwsAccountParams) WithTimeout(timeout time.Duration) *DeleteCSPMAwsAccountParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete c s p m aws account params
func (o *DeleteCSPMAwsAccountParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete c s p m aws account params
func (o *DeleteCSPMAwsAccountParams) WithContext(ctx context.Context) *DeleteCSPMAwsAccountParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete c s p m aws account params
func (o *DeleteCSPMAwsAccountParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete c s p m aws account params
func (o *DeleteCSPMAwsAccountParams) WithHTTPClient(client *http.Client) *DeleteCSPMAwsAccountParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete c s p m aws account params
func (o *DeleteCSPMAwsAccountParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the delete c s p m aws account params
func (o *DeleteCSPMAwsAccountParams) WithIds(ids []string) *DeleteCSPMAwsAccountParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the delete c s p m aws account params
func (o *DeleteCSPMAwsAccountParams) SetIds(ids []string) {
	o.Ids = ids
}

// WithOrganizationIds adds the organizationIds to the delete c s p m aws account params
func (o *DeleteCSPMAwsAccountParams) WithOrganizationIds(organizationIds []string) *DeleteCSPMAwsAccountParams {
	o.SetOrganizationIds(organizationIds)
	return o
}

// SetOrganizationIds adds the organizationIds to the delete c s p m aws account params
func (o *DeleteCSPMAwsAccountParams) SetOrganizationIds(organizationIds []string) {
	o.OrganizationIds = organizationIds
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteCSPMAwsAccountParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if o.OrganizationIds != nil {

		// binding items for organization-ids
		joinedOrganizationIds := o.bindParamOrganizationIds(reg)

		// query array param organization-ids
		if err := r.SetQueryParam("organization-ids", joinedOrganizationIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDeleteCSPMAwsAccount binds the parameter ids
func (o *DeleteCSPMAwsAccountParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}

// bindParamDeleteCSPMAwsAccount binds the parameter organization-ids
func (o *DeleteCSPMAwsAccountParams) bindParamOrganizationIds(formats strfmt.Registry) []string {
	organizationIdsIR := o.OrganizationIds

	var organizationIdsIC []string
	for _, organizationIdsIIR := range organizationIdsIR { // explode []string

		organizationIdsIIV := organizationIdsIIR // string as string
		organizationIdsIC = append(organizationIdsIC, organizationIdsIIV)
	}

	// items.CollectionFormat: "multi"
	organizationIdsIS := swag.JoinByFormat(organizationIdsIC, "multi")

	return organizationIdsIS
}
