// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteCSPMAzureAccountParams creates a new DeleteCSPMAzureAccountParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteCSPMAzureAccountParams() *DeleteCSPMAzureAccountParams {
	return &DeleteCSPMAzureAccountParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteCSPMAzureAccountParamsWithTimeout creates a new DeleteCSPMAzureAccountParams object
// with the ability to set a timeout on a request.
func NewDeleteCSPMAzureAccountParamsWithTimeout(timeout time.Duration) *DeleteCSPMAzureAccountParams {
	return &DeleteCSPMAzureAccountParams{
		timeout: timeout,
	}
}

// NewDeleteCSPMAzureAccountParamsWithContext creates a new DeleteCSPMAzureAccountParams object
// with the ability to set a context for a request.
func NewDeleteCSPMAzureAccountParamsWithContext(ctx context.Context) *DeleteCSPMAzureAccountParams {
	return &DeleteCSPMAzureAccountParams{
		Context: ctx,
	}
}

// NewDeleteCSPMAzureAccountParamsWithHTTPClient creates a new DeleteCSPMAzureAccountParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteCSPMAzureAccountParamsWithHTTPClient(client *http.Client) *DeleteCSPMAzureAccountParams {
	return &DeleteCSPMAzureAccountParams{
		HTTPClient: client,
	}
}

/*
DeleteCSPMAzureAccountParams contains all the parameters to send to the API endpoint

	for the delete c s p m azure account operation.

	Typically these are written to a http.Request.
*/
type DeleteCSPMAzureAccountParams struct {

	/* Ids.

	   Azure subscription IDs to remove
	*/
	Ids []string

	// RetainTenant.
	RetainTenant *string

	/* TenantIds.

	   Tenant ids to remove
	*/
	TenantIds []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete c s p m azure account params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteCSPMAzureAccountParams) WithDefaults() *DeleteCSPMAzureAccountParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete c s p m azure account params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteCSPMAzureAccountParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete c s p m azure account params
func (o *DeleteCSPMAzureAccountParams) WithTimeout(timeout time.Duration) *DeleteCSPMAzureAccountParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete c s p m azure account params
func (o *DeleteCSPMAzureAccountParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete c s p m azure account params
func (o *DeleteCSPMAzureAccountParams) WithContext(ctx context.Context) *DeleteCSPMAzureAccountParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete c s p m azure account params
func (o *DeleteCSPMAzureAccountParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete c s p m azure account params
func (o *DeleteCSPMAzureAccountParams) WithHTTPClient(client *http.Client) *DeleteCSPMAzureAccountParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete c s p m azure account params
func (o *DeleteCSPMAzureAccountParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the delete c s p m azure account params
func (o *DeleteCSPMAzureAccountParams) WithIds(ids []string) *DeleteCSPMAzureAccountParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the delete c s p m azure account params
func (o *DeleteCSPMAzureAccountParams) SetIds(ids []string) {
	o.Ids = ids
}

// WithRetainTenant adds the retainTenant to the delete c s p m azure account params
func (o *DeleteCSPMAzureAccountParams) WithRetainTenant(retainTenant *string) *DeleteCSPMAzureAccountParams {
	o.SetRetainTenant(retainTenant)
	return o
}

// SetRetainTenant adds the retainTenant to the delete c s p m azure account params
func (o *DeleteCSPMAzureAccountParams) SetRetainTenant(retainTenant *string) {
	o.RetainTenant = retainTenant
}

// WithTenantIds adds the tenantIds to the delete c s p m azure account params
func (o *DeleteCSPMAzureAccountParams) WithTenantIds(tenantIds []string) *DeleteCSPMAzureAccountParams {
	o.SetTenantIds(tenantIds)
	return o
}

// SetTenantIds adds the tenantIds to the delete c s p m azure account params
func (o *DeleteCSPMAzureAccountParams) SetTenantIds(tenantIds []string) {
	o.TenantIds = tenantIds
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteCSPMAzureAccountParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if o.RetainTenant != nil {

		// query param retain_tenant
		var qrRetainTenant string

		if o.RetainTenant != nil {
			qrRetainTenant = *o.RetainTenant
		}
		qRetainTenant := qrRetainTenant
		if qRetainTenant != "" {

			if err := r.SetQueryParam("retain_tenant", qRetainTenant); err != nil {
				return err
			}
		}
	}

	if o.TenantIds != nil {

		// binding items for tenant_ids
		joinedTenantIds := o.bindParamTenantIds(reg)

		// query array param tenant_ids
		if err := r.SetQueryParam("tenant_ids", joinedTenantIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDeleteCSPMAzureAccount binds the parameter ids
func (o *DeleteCSPMAzureAccountParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}

// bindParamDeleteCSPMAzureAccount binds the parameter tenant_ids
func (o *DeleteCSPMAzureAccountParams) bindParamTenantIds(formats strfmt.Registry) []string {
	tenantIdsIR := o.TenantIds

	var tenantIdsIC []string
	for _, tenantIdsIIR := range tenantIdsIR { // explode []string

		tenantIdsIIV := tenantIdsIIR // string as string
		tenantIdsIC = append(tenantIdsIC, tenantIdsIIV)
	}

	// items.CollectionFormat: "multi"
	tenantIdsIS := swag.JoinByFormat(tenantIdsIC, "multi")

	return tenantIdsIS
}
