// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetBehaviorDetectionsParams creates a new GetBehaviorDetectionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetBehaviorDetectionsParams() *GetBehaviorDetectionsParams {
	return &GetBehaviorDetectionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetBehaviorDetectionsParamsWithTimeout creates a new GetBehaviorDetectionsParams object
// with the ability to set a timeout on a request.
func NewGetBehaviorDetectionsParamsWithTimeout(timeout time.Duration) *GetBehaviorDetectionsParams {
	return &GetBehaviorDetectionsParams{
		timeout: timeout,
	}
}

// NewGetBehaviorDetectionsParamsWithContext creates a new GetBehaviorDetectionsParams object
// with the ability to set a context for a request.
func NewGetBehaviorDetectionsParamsWithContext(ctx context.Context) *GetBehaviorDetectionsParams {
	return &GetBehaviorDetectionsParams{
		Context: ctx,
	}
}

// NewGetBehaviorDetectionsParamsWithHTTPClient creates a new GetBehaviorDetectionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetBehaviorDetectionsParamsWithHTTPClient(client *http.Client) *GetBehaviorDetectionsParams {
	return &GetBehaviorDetectionsParams{
		HTTPClient: client,
	}
}

/*
GetBehaviorDetectionsParams contains all the parameters to send to the API endpoint

	for the get behavior detections operation.

	Typically these are written to a http.Request.
*/
type GetBehaviorDetectionsParams struct {

	/* AccountID.

	   Cloud Account ID (e.g.: AWS accountID, Azure subscriptionID)
	*/
	AccountID *string

	/* AwsAccountID.

	   AWS Account ID
	*/
	AwsAccountID *string

	/* AzureSubscriptionID.

	   Azure Subscription ID
	*/
	AzureSubscriptionID *string

	/* AzureTenantID.

	   Azure Tenant ID
	*/
	AzureTenantID *string

	/* CloudProvider.

	   Cloud Provider (e.g.: aws|azure)
	*/
	CloudProvider *string

	/* DateTimeSince.

	   Filter to get all events after this date, in format RFC3339 : e.g. 2006-01-02T15:04:05Z07:00
	*/
	DateTimeSince *string

	/* Limit.

	   The maximum records to return. [1-500]
	*/
	Limit *int64

	/* NextToken.

	   String to get next page of results, is associated with a previous execution of GetBehaviorDetections. Must include all filters from previous execution.
	*/
	NextToken *string

	/* ResourceID.

	   Resource ID
	*/
	ResourceID []string

	/* ResourceUUID.

	   Resource UUID
	*/
	ResourceUUID []string

	/* Service.

	   Cloud Service (e.g. EC2 | EBS | S3)
	*/
	Service *string

	/* Severity.

	   Policy Severity
	*/
	Severity *string

	/* Since.

	   Filter events using a duration string (e.g. 24h)

	   Default: "24h"
	*/
	Since *string

	/* State.

	   State (e.g.: open | closed)
	*/
	State *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get behavior detections params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetBehaviorDetectionsParams) WithDefaults() *GetBehaviorDetectionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get behavior detections params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetBehaviorDetectionsParams) SetDefaults() {
	var (
		sinceDefault = string("24h")
	)

	val := GetBehaviorDetectionsParams{
		Since: &sinceDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithTimeout(timeout time.Duration) *GetBehaviorDetectionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithContext(ctx context.Context) *GetBehaviorDetectionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithHTTPClient(client *http.Client) *GetBehaviorDetectionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountID adds the accountID to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithAccountID(accountID *string) *GetBehaviorDetectionsParams {
	o.SetAccountID(accountID)
	return o
}

// SetAccountID adds the accountId to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetAccountID(accountID *string) {
	o.AccountID = accountID
}

// WithAwsAccountID adds the awsAccountID to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithAwsAccountID(awsAccountID *string) *GetBehaviorDetectionsParams {
	o.SetAwsAccountID(awsAccountID)
	return o
}

// SetAwsAccountID adds the awsAccountId to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetAwsAccountID(awsAccountID *string) {
	o.AwsAccountID = awsAccountID
}

// WithAzureSubscriptionID adds the azureSubscriptionID to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithAzureSubscriptionID(azureSubscriptionID *string) *GetBehaviorDetectionsParams {
	o.SetAzureSubscriptionID(azureSubscriptionID)
	return o
}

// SetAzureSubscriptionID adds the azureSubscriptionId to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetAzureSubscriptionID(azureSubscriptionID *string) {
	o.AzureSubscriptionID = azureSubscriptionID
}

// WithAzureTenantID adds the azureTenantID to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithAzureTenantID(azureTenantID *string) *GetBehaviorDetectionsParams {
	o.SetAzureTenantID(azureTenantID)
	return o
}

// SetAzureTenantID adds the azureTenantId to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetAzureTenantID(azureTenantID *string) {
	o.AzureTenantID = azureTenantID
}

// WithCloudProvider adds the cloudProvider to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithCloudProvider(cloudProvider *string) *GetBehaviorDetectionsParams {
	o.SetCloudProvider(cloudProvider)
	return o
}

// SetCloudProvider adds the cloudProvider to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetCloudProvider(cloudProvider *string) {
	o.CloudProvider = cloudProvider
}

// WithDateTimeSince adds the dateTimeSince to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithDateTimeSince(dateTimeSince *string) *GetBehaviorDetectionsParams {
	o.SetDateTimeSince(dateTimeSince)
	return o
}

// SetDateTimeSince adds the dateTimeSince to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetDateTimeSince(dateTimeSince *string) {
	o.DateTimeSince = dateTimeSince
}

// WithLimit adds the limit to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithLimit(limit *int64) *GetBehaviorDetectionsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithNextToken adds the nextToken to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithNextToken(nextToken *string) *GetBehaviorDetectionsParams {
	o.SetNextToken(nextToken)
	return o
}

// SetNextToken adds the nextToken to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetNextToken(nextToken *string) {
	o.NextToken = nextToken
}

// WithResourceID adds the resourceID to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithResourceID(resourceID []string) *GetBehaviorDetectionsParams {
	o.SetResourceID(resourceID)
	return o
}

// SetResourceID adds the resourceId to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetResourceID(resourceID []string) {
	o.ResourceID = resourceID
}

// WithResourceUUID adds the resourceUUID to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithResourceUUID(resourceUUID []string) *GetBehaviorDetectionsParams {
	o.SetResourceUUID(resourceUUID)
	return o
}

// SetResourceUUID adds the resourceUuid to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetResourceUUID(resourceUUID []string) {
	o.ResourceUUID = resourceUUID
}

// WithService adds the service to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithService(service *string) *GetBehaviorDetectionsParams {
	o.SetService(service)
	return o
}

// SetService adds the service to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetService(service *string) {
	o.Service = service
}

// WithSeverity adds the severity to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithSeverity(severity *string) *GetBehaviorDetectionsParams {
	o.SetSeverity(severity)
	return o
}

// SetSeverity adds the severity to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetSeverity(severity *string) {
	o.Severity = severity
}

// WithSince adds the since to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithSince(since *string) *GetBehaviorDetectionsParams {
	o.SetSince(since)
	return o
}

// SetSince adds the since to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetSince(since *string) {
	o.Since = since
}

// WithState adds the state to the get behavior detections params
func (o *GetBehaviorDetectionsParams) WithState(state *string) *GetBehaviorDetectionsParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the get behavior detections params
func (o *GetBehaviorDetectionsParams) SetState(state *string) {
	o.State = state
}

// WriteToRequest writes these params to a swagger request
func (o *GetBehaviorDetectionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccountID != nil {

		// query param account_id
		var qrAccountID string

		if o.AccountID != nil {
			qrAccountID = *o.AccountID
		}
		qAccountID := qrAccountID
		if qAccountID != "" {

			if err := r.SetQueryParam("account_id", qAccountID); err != nil {
				return err
			}
		}
	}

	if o.AwsAccountID != nil {

		// query param aws_account_id
		var qrAwsAccountID string

		if o.AwsAccountID != nil {
			qrAwsAccountID = *o.AwsAccountID
		}
		qAwsAccountID := qrAwsAccountID
		if qAwsAccountID != "" {

			if err := r.SetQueryParam("aws_account_id", qAwsAccountID); err != nil {
				return err
			}
		}
	}

	if o.AzureSubscriptionID != nil {

		// query param azure_subscription_id
		var qrAzureSubscriptionID string

		if o.AzureSubscriptionID != nil {
			qrAzureSubscriptionID = *o.AzureSubscriptionID
		}
		qAzureSubscriptionID := qrAzureSubscriptionID
		if qAzureSubscriptionID != "" {

			if err := r.SetQueryParam("azure_subscription_id", qAzureSubscriptionID); err != nil {
				return err
			}
		}
	}

	if o.AzureTenantID != nil {

		// query param azure_tenant_id
		var qrAzureTenantID string

		if o.AzureTenantID != nil {
			qrAzureTenantID = *o.AzureTenantID
		}
		qAzureTenantID := qrAzureTenantID
		if qAzureTenantID != "" {

			if err := r.SetQueryParam("azure_tenant_id", qAzureTenantID); err != nil {
				return err
			}
		}
	}

	if o.CloudProvider != nil {

		// query param cloud_provider
		var qrCloudProvider string

		if o.CloudProvider != nil {
			qrCloudProvider = *o.CloudProvider
		}
		qCloudProvider := qrCloudProvider
		if qCloudProvider != "" {

			if err := r.SetQueryParam("cloud_provider", qCloudProvider); err != nil {
				return err
			}
		}
	}

	if o.DateTimeSince != nil {

		// query param date_time_since
		var qrDateTimeSince string

		if o.DateTimeSince != nil {
			qrDateTimeSince = *o.DateTimeSince
		}
		qDateTimeSince := qrDateTimeSince
		if qDateTimeSince != "" {

			if err := r.SetQueryParam("date_time_since", qDateTimeSince); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.NextToken != nil {

		// query param next_token
		var qrNextToken string

		if o.NextToken != nil {
			qrNextToken = *o.NextToken
		}
		qNextToken := qrNextToken
		if qNextToken != "" {

			if err := r.SetQueryParam("next_token", qNextToken); err != nil {
				return err
			}
		}
	}

	if o.ResourceID != nil {

		// binding items for resource_id
		joinedResourceID := o.bindParamResourceID(reg)

		// query array param resource_id
		if err := r.SetQueryParam("resource_id", joinedResourceID...); err != nil {
			return err
		}
	}

	if o.ResourceUUID != nil {

		// binding items for resource_uuid
		joinedResourceUUID := o.bindParamResourceUUID(reg)

		// query array param resource_uuid
		if err := r.SetQueryParam("resource_uuid", joinedResourceUUID...); err != nil {
			return err
		}
	}

	if o.Service != nil {

		// query param service
		var qrService string

		if o.Service != nil {
			qrService = *o.Service
		}
		qService := qrService
		if qService != "" {

			if err := r.SetQueryParam("service", qService); err != nil {
				return err
			}
		}
	}

	if o.Severity != nil {

		// query param severity
		var qrSeverity string

		if o.Severity != nil {
			qrSeverity = *o.Severity
		}
		qSeverity := qrSeverity
		if qSeverity != "" {

			if err := r.SetQueryParam("severity", qSeverity); err != nil {
				return err
			}
		}
	}

	if o.Since != nil {

		// query param since
		var qrSince string

		if o.Since != nil {
			qrSince = *o.Since
		}
		qSince := qrSince
		if qSince != "" {

			if err := r.SetQueryParam("since", qSince); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetBehaviorDetections binds the parameter resource_id
func (o *GetBehaviorDetectionsParams) bindParamResourceID(formats strfmt.Registry) []string {
	resourceIDIR := o.ResourceID

	var resourceIDIC []string
	for _, resourceIDIIR := range resourceIDIR { // explode []string

		resourceIDIIV := resourceIDIIR // string as string
		resourceIDIC = append(resourceIDIC, resourceIDIIV)
	}

	// items.CollectionFormat: "multi"
	resourceIDIS := swag.JoinByFormat(resourceIDIC, "multi")

	return resourceIDIS
}

// bindParamGetBehaviorDetections binds the parameter resource_uuid
func (o *GetBehaviorDetectionsParams) bindParamResourceUUID(formats strfmt.Registry) []string {
	resourceUUIDIR := o.ResourceUUID

	var resourceUUIDIC []string
	for _, resourceUUIDIIR := range resourceUUIDIR { // explode []string

		resourceUUIDIIV := resourceUUIDIIR // string as string
		resourceUUIDIC = append(resourceUUIDIC, resourceUUIDIIV)
	}

	// items.CollectionFormat: "multi"
	resourceUUIDIS := swag.JoinByFormat(resourceUUIDIC, "multi")

	return resourceUUIDIS
}
