// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetCSPMAwsAccountParams creates a new GetCSPMAwsAccountParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetCSPMAwsAccountParams() *GetCSPMAwsAccountParams {
	return &GetCSPMAwsAccountParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetCSPMAwsAccountParamsWithTimeout creates a new GetCSPMAwsAccountParams object
// with the ability to set a timeout on a request.
func NewGetCSPMAwsAccountParamsWithTimeout(timeout time.Duration) *GetCSPMAwsAccountParams {
	return &GetCSPMAwsAccountParams{
		timeout: timeout,
	}
}

// NewGetCSPMAwsAccountParamsWithContext creates a new GetCSPMAwsAccountParams object
// with the ability to set a context for a request.
func NewGetCSPMAwsAccountParamsWithContext(ctx context.Context) *GetCSPMAwsAccountParams {
	return &GetCSPMAwsAccountParams{
		Context: ctx,
	}
}

// NewGetCSPMAwsAccountParamsWithHTTPClient creates a new GetCSPMAwsAccountParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetCSPMAwsAccountParamsWithHTTPClient(client *http.Client) *GetCSPMAwsAccountParams {
	return &GetCSPMAwsAccountParams{
		HTTPClient: client,
	}
}

/*
GetCSPMAwsAccountParams contains all the parameters to send to the API endpoint

	for the get c s p m aws account operation.

	Typically these are written to a http.Request.
*/
type GetCSPMAwsAccountParams struct {

	/* GroupBy.

	   Field to group by.
	*/
	GroupBy *string

	/* IamRoleArns.

	   AWS IAM role ARNs
	*/
	IamRoleArns []string

	/* Ids.

	   AWS account IDs
	*/
	Ids []string

	/* Limit.

	   The maximum records to return. Defaults to 100.

	   Default: 100
	*/
	Limit *int64

	/* Migrated.

	   Only return migrated d4c accounts
	*/
	Migrated *string

	/* Offset.

	   The offset to start retrieving records from
	*/
	Offset *int64

	/* OrganizationIds.

	   AWS organization IDs
	*/
	OrganizationIds []string

	/* ScanType.

	   Type of scan, dry or full, to perform on selected accounts
	*/
	ScanType *string

	/* Status.

	   Account status to filter results by.
	*/
	Status *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get c s p m aws account params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetCSPMAwsAccountParams) WithDefaults() *GetCSPMAwsAccountParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get c s p m aws account params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetCSPMAwsAccountParams) SetDefaults() {
	var (
		limitDefault = int64(100)
	)

	val := GetCSPMAwsAccountParams{
		Limit: &limitDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) WithTimeout(timeout time.Duration) *GetCSPMAwsAccountParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) WithContext(ctx context.Context) *GetCSPMAwsAccountParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) WithHTTPClient(client *http.Client) *GetCSPMAwsAccountParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithGroupBy adds the groupBy to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) WithGroupBy(groupBy *string) *GetCSPMAwsAccountParams {
	o.SetGroupBy(groupBy)
	return o
}

// SetGroupBy adds the groupBy to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) SetGroupBy(groupBy *string) {
	o.GroupBy = groupBy
}

// WithIamRoleArns adds the iamRoleArns to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) WithIamRoleArns(iamRoleArns []string) *GetCSPMAwsAccountParams {
	o.SetIamRoleArns(iamRoleArns)
	return o
}

// SetIamRoleArns adds the iamRoleArns to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) SetIamRoleArns(iamRoleArns []string) {
	o.IamRoleArns = iamRoleArns
}

// WithIds adds the ids to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) WithIds(ids []string) *GetCSPMAwsAccountParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) SetIds(ids []string) {
	o.Ids = ids
}

// WithLimit adds the limit to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) WithLimit(limit *int64) *GetCSPMAwsAccountParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithMigrated adds the migrated to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) WithMigrated(migrated *string) *GetCSPMAwsAccountParams {
	o.SetMigrated(migrated)
	return o
}

// SetMigrated adds the migrated to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) SetMigrated(migrated *string) {
	o.Migrated = migrated
}

// WithOffset adds the offset to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) WithOffset(offset *int64) *GetCSPMAwsAccountParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithOrganizationIds adds the organizationIds to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) WithOrganizationIds(organizationIds []string) *GetCSPMAwsAccountParams {
	o.SetOrganizationIds(organizationIds)
	return o
}

// SetOrganizationIds adds the organizationIds to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) SetOrganizationIds(organizationIds []string) {
	o.OrganizationIds = organizationIds
}

// WithScanType adds the scanType to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) WithScanType(scanType *string) *GetCSPMAwsAccountParams {
	o.SetScanType(scanType)
	return o
}

// SetScanType adds the scanType to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) SetScanType(scanType *string) {
	o.ScanType = scanType
}

// WithStatus adds the status to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) WithStatus(status *string) *GetCSPMAwsAccountParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the get c s p m aws account params
func (o *GetCSPMAwsAccountParams) SetStatus(status *string) {
	o.Status = status
}

// WriteToRequest writes these params to a swagger request
func (o *GetCSPMAwsAccountParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.GroupBy != nil {

		// query param group_by
		var qrGroupBy string

		if o.GroupBy != nil {
			qrGroupBy = *o.GroupBy
		}
		qGroupBy := qrGroupBy
		if qGroupBy != "" {

			if err := r.SetQueryParam("group_by", qGroupBy); err != nil {
				return err
			}
		}
	}

	if o.IamRoleArns != nil {

		// binding items for iam_role_arns
		joinedIamRoleArns := o.bindParamIamRoleArns(reg)

		// query array param iam_role_arns
		if err := r.SetQueryParam("iam_role_arns", joinedIamRoleArns...); err != nil {
			return err
		}
	}

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Migrated != nil {

		// query param migrated
		var qrMigrated string

		if o.Migrated != nil {
			qrMigrated = *o.Migrated
		}
		qMigrated := qrMigrated
		if qMigrated != "" {

			if err := r.SetQueryParam("migrated", qMigrated); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.OrganizationIds != nil {

		// binding items for organization-ids
		joinedOrganizationIds := o.bindParamOrganizationIds(reg)

		// query array param organization-ids
		if err := r.SetQueryParam("organization-ids", joinedOrganizationIds...); err != nil {
			return err
		}
	}

	if o.ScanType != nil {

		// query param scan-type
		var qrScanType string

		if o.ScanType != nil {
			qrScanType = *o.ScanType
		}
		qScanType := qrScanType
		if qScanType != "" {

			if err := r.SetQueryParam("scan-type", qScanType); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetCSPMAwsAccount binds the parameter iam_role_arns
func (o *GetCSPMAwsAccountParams) bindParamIamRoleArns(formats strfmt.Registry) []string {
	iamRoleArnsIR := o.IamRoleArns

	var iamRoleArnsIC []string
	for _, iamRoleArnsIIR := range iamRoleArnsIR { // explode []string

		iamRoleArnsIIV := iamRoleArnsIIR // string as string
		iamRoleArnsIC = append(iamRoleArnsIC, iamRoleArnsIIV)
	}

	// items.CollectionFormat: "multi"
	iamRoleArnsIS := swag.JoinByFormat(iamRoleArnsIC, "multi")

	return iamRoleArnsIS
}

// bindParamGetCSPMAwsAccount binds the parameter ids
func (o *GetCSPMAwsAccountParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}

// bindParamGetCSPMAwsAccount binds the parameter organization-ids
func (o *GetCSPMAwsAccountParams) bindParamOrganizationIds(formats strfmt.Registry) []string {
	organizationIdsIR := o.OrganizationIds

	var organizationIdsIC []string
	for _, organizationIdsIIR := range organizationIdsIR { // explode []string

		organizationIdsIIV := organizationIdsIIR // string as string
		organizationIdsIC = append(organizationIdsIC, organizationIdsIIV)
	}

	// items.CollectionFormat: "multi"
	organizationIdsIS := swag.JoinByFormat(organizationIdsIC, "multi")

	return organizationIdsIS
}
