// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetCSPMAwsAccountReader is a Reader for the GetCSPMAwsAccount structure.
type GetCSPMAwsAccountReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCSPMAwsAccountReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCSPMAwsAccountOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetCSPMAwsAccountMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetCSPMAwsAccountBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetCSPMAwsAccountForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetCSPMAwsAccountTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCSPMAwsAccountInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloud-connect-cspm-aws/entities/account/v1] GetCSPMAwsAccount", response, response.Code())
	}
}

// NewGetCSPMAwsAccountOK creates a GetCSPMAwsAccountOK with default headers values
func NewGetCSPMAwsAccountOK() *GetCSPMAwsAccountOK {
	return &GetCSPMAwsAccountOK{}
}

/*
GetCSPMAwsAccountOK describes a response with status code 200, with default header values.

OK
*/
type GetCSPMAwsAccountOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountResponseV2
}

// IsSuccess returns true when this get c s p m aws account o k response has a 2xx status code
func (o *GetCSPMAwsAccountOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get c s p m aws account o k response has a 3xx status code
func (o *GetCSPMAwsAccountOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m aws account o k response has a 4xx status code
func (o *GetCSPMAwsAccountOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get c s p m aws account o k response has a 5xx status code
func (o *GetCSPMAwsAccountOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m aws account o k response a status code equal to that given
func (o *GetCSPMAwsAccountOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get c s p m aws account o k response
func (o *GetCSPMAwsAccountOK) Code() int {
	return 200
}

func (o *GetCSPMAwsAccountOK) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/account/v1][%d] getCSPMAwsAccountOK  %+v", 200, o.Payload)
}

func (o *GetCSPMAwsAccountOK) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/account/v1][%d] getCSPMAwsAccountOK  %+v", 200, o.Payload)
}

func (o *GetCSPMAwsAccountOK) GetPayload() *models.RegistrationAWSAccountResponseV2 {
	return o.Payload
}

func (o *GetCSPMAwsAccountOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountResponseV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMAwsAccountMultiStatus creates a GetCSPMAwsAccountMultiStatus with default headers values
func NewGetCSPMAwsAccountMultiStatus() *GetCSPMAwsAccountMultiStatus {
	return &GetCSPMAwsAccountMultiStatus{}
}

/*
GetCSPMAwsAccountMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetCSPMAwsAccountMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountResponseV2
}

// IsSuccess returns true when this get c s p m aws account multi status response has a 2xx status code
func (o *GetCSPMAwsAccountMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get c s p m aws account multi status response has a 3xx status code
func (o *GetCSPMAwsAccountMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m aws account multi status response has a 4xx status code
func (o *GetCSPMAwsAccountMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get c s p m aws account multi status response has a 5xx status code
func (o *GetCSPMAwsAccountMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m aws account multi status response a status code equal to that given
func (o *GetCSPMAwsAccountMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get c s p m aws account multi status response
func (o *GetCSPMAwsAccountMultiStatus) Code() int {
	return 207
}

func (o *GetCSPMAwsAccountMultiStatus) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/account/v1][%d] getCSPMAwsAccountMultiStatus  %+v", 207, o.Payload)
}

func (o *GetCSPMAwsAccountMultiStatus) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/account/v1][%d] getCSPMAwsAccountMultiStatus  %+v", 207, o.Payload)
}

func (o *GetCSPMAwsAccountMultiStatus) GetPayload() *models.RegistrationAWSAccountResponseV2 {
	return o.Payload
}

func (o *GetCSPMAwsAccountMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountResponseV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMAwsAccountBadRequest creates a GetCSPMAwsAccountBadRequest with default headers values
func NewGetCSPMAwsAccountBadRequest() *GetCSPMAwsAccountBadRequest {
	return &GetCSPMAwsAccountBadRequest{}
}

/*
GetCSPMAwsAccountBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetCSPMAwsAccountBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountResponseV2
}

// IsSuccess returns true when this get c s p m aws account bad request response has a 2xx status code
func (o *GetCSPMAwsAccountBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m aws account bad request response has a 3xx status code
func (o *GetCSPMAwsAccountBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m aws account bad request response has a 4xx status code
func (o *GetCSPMAwsAccountBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get c s p m aws account bad request response has a 5xx status code
func (o *GetCSPMAwsAccountBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m aws account bad request response a status code equal to that given
func (o *GetCSPMAwsAccountBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get c s p m aws account bad request response
func (o *GetCSPMAwsAccountBadRequest) Code() int {
	return 400
}

func (o *GetCSPMAwsAccountBadRequest) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/account/v1][%d] getCSPMAwsAccountBadRequest  %+v", 400, o.Payload)
}

func (o *GetCSPMAwsAccountBadRequest) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/account/v1][%d] getCSPMAwsAccountBadRequest  %+v", 400, o.Payload)
}

func (o *GetCSPMAwsAccountBadRequest) GetPayload() *models.RegistrationAWSAccountResponseV2 {
	return o.Payload
}

func (o *GetCSPMAwsAccountBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountResponseV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMAwsAccountForbidden creates a GetCSPMAwsAccountForbidden with default headers values
func NewGetCSPMAwsAccountForbidden() *GetCSPMAwsAccountForbidden {
	return &GetCSPMAwsAccountForbidden{}
}

/*
GetCSPMAwsAccountForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetCSPMAwsAccountForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get c s p m aws account forbidden response has a 2xx status code
func (o *GetCSPMAwsAccountForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m aws account forbidden response has a 3xx status code
func (o *GetCSPMAwsAccountForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m aws account forbidden response has a 4xx status code
func (o *GetCSPMAwsAccountForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get c s p m aws account forbidden response has a 5xx status code
func (o *GetCSPMAwsAccountForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m aws account forbidden response a status code equal to that given
func (o *GetCSPMAwsAccountForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get c s p m aws account forbidden response
func (o *GetCSPMAwsAccountForbidden) Code() int {
	return 403
}

func (o *GetCSPMAwsAccountForbidden) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/account/v1][%d] getCSPMAwsAccountForbidden  %+v", 403, o.Payload)
}

func (o *GetCSPMAwsAccountForbidden) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/account/v1][%d] getCSPMAwsAccountForbidden  %+v", 403, o.Payload)
}

func (o *GetCSPMAwsAccountForbidden) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetCSPMAwsAccountForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMAwsAccountTooManyRequests creates a GetCSPMAwsAccountTooManyRequests with default headers values
func NewGetCSPMAwsAccountTooManyRequests() *GetCSPMAwsAccountTooManyRequests {
	return &GetCSPMAwsAccountTooManyRequests{}
}

/*
GetCSPMAwsAccountTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetCSPMAwsAccountTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get c s p m aws account too many requests response has a 2xx status code
func (o *GetCSPMAwsAccountTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m aws account too many requests response has a 3xx status code
func (o *GetCSPMAwsAccountTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m aws account too many requests response has a 4xx status code
func (o *GetCSPMAwsAccountTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get c s p m aws account too many requests response has a 5xx status code
func (o *GetCSPMAwsAccountTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m aws account too many requests response a status code equal to that given
func (o *GetCSPMAwsAccountTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get c s p m aws account too many requests response
func (o *GetCSPMAwsAccountTooManyRequests) Code() int {
	return 429
}

func (o *GetCSPMAwsAccountTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/account/v1][%d] getCSPMAwsAccountTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCSPMAwsAccountTooManyRequests) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/account/v1][%d] getCSPMAwsAccountTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCSPMAwsAccountTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCSPMAwsAccountTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMAwsAccountInternalServerError creates a GetCSPMAwsAccountInternalServerError with default headers values
func NewGetCSPMAwsAccountInternalServerError() *GetCSPMAwsAccountInternalServerError {
	return &GetCSPMAwsAccountInternalServerError{}
}

/*
GetCSPMAwsAccountInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetCSPMAwsAccountInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountResponseV2
}

// IsSuccess returns true when this get c s p m aws account internal server error response has a 2xx status code
func (o *GetCSPMAwsAccountInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m aws account internal server error response has a 3xx status code
func (o *GetCSPMAwsAccountInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m aws account internal server error response has a 4xx status code
func (o *GetCSPMAwsAccountInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get c s p m aws account internal server error response has a 5xx status code
func (o *GetCSPMAwsAccountInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get c s p m aws account internal server error response a status code equal to that given
func (o *GetCSPMAwsAccountInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get c s p m aws account internal server error response
func (o *GetCSPMAwsAccountInternalServerError) Code() int {
	return 500
}

func (o *GetCSPMAwsAccountInternalServerError) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/account/v1][%d] getCSPMAwsAccountInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCSPMAwsAccountInternalServerError) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/account/v1][%d] getCSPMAwsAccountInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCSPMAwsAccountInternalServerError) GetPayload() *models.RegistrationAWSAccountResponseV2 {
	return o.Payload
}

func (o *GetCSPMAwsAccountInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountResponseV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
