// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetCSPMAwsConsoleSetupURLsReader is a Reader for the GetCSPMAwsConsoleSetupURLs structure.
type GetCSPMAwsConsoleSetupURLsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCSPMAwsConsoleSetupURLsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCSPMAwsConsoleSetupURLsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetCSPMAwsConsoleSetupURLsMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetCSPMAwsConsoleSetupURLsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetCSPMAwsConsoleSetupURLsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetCSPMAwsConsoleSetupURLsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCSPMAwsConsoleSetupURLsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1] GetCSPMAwsConsoleSetupURLs", response, response.Code())
	}
}

// NewGetCSPMAwsConsoleSetupURLsOK creates a GetCSPMAwsConsoleSetupURLsOK with default headers values
func NewGetCSPMAwsConsoleSetupURLsOK() *GetCSPMAwsConsoleSetupURLsOK {
	return &GetCSPMAwsConsoleSetupURLsOK{}
}

/*
GetCSPMAwsConsoleSetupURLsOK describes a response with status code 200, with default header values.

OK
*/
type GetCSPMAwsConsoleSetupURLsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountConsoleURL
}

// IsSuccess returns true when this get c s p m aws console setup u r ls o k response has a 2xx status code
func (o *GetCSPMAwsConsoleSetupURLsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get c s p m aws console setup u r ls o k response has a 3xx status code
func (o *GetCSPMAwsConsoleSetupURLsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m aws console setup u r ls o k response has a 4xx status code
func (o *GetCSPMAwsConsoleSetupURLsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get c s p m aws console setup u r ls o k response has a 5xx status code
func (o *GetCSPMAwsConsoleSetupURLsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m aws console setup u r ls o k response a status code equal to that given
func (o *GetCSPMAwsConsoleSetupURLsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get c s p m aws console setup u r ls o k response
func (o *GetCSPMAwsConsoleSetupURLsOK) Code() int {
	return 200
}

func (o *GetCSPMAwsConsoleSetupURLsOK) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1][%d] getCSPMAwsConsoleSetupURLsOK  %+v", 200, o.Payload)
}

func (o *GetCSPMAwsConsoleSetupURLsOK) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1][%d] getCSPMAwsConsoleSetupURLsOK  %+v", 200, o.Payload)
}

func (o *GetCSPMAwsConsoleSetupURLsOK) GetPayload() *models.RegistrationAWSAccountConsoleURL {
	return o.Payload
}

func (o *GetCSPMAwsConsoleSetupURLsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountConsoleURL)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMAwsConsoleSetupURLsMultiStatus creates a GetCSPMAwsConsoleSetupURLsMultiStatus with default headers values
func NewGetCSPMAwsConsoleSetupURLsMultiStatus() *GetCSPMAwsConsoleSetupURLsMultiStatus {
	return &GetCSPMAwsConsoleSetupURLsMultiStatus{}
}

/*
GetCSPMAwsConsoleSetupURLsMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetCSPMAwsConsoleSetupURLsMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountConsoleURL
}

// IsSuccess returns true when this get c s p m aws console setup u r ls multi status response has a 2xx status code
func (o *GetCSPMAwsConsoleSetupURLsMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get c s p m aws console setup u r ls multi status response has a 3xx status code
func (o *GetCSPMAwsConsoleSetupURLsMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m aws console setup u r ls multi status response has a 4xx status code
func (o *GetCSPMAwsConsoleSetupURLsMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get c s p m aws console setup u r ls multi status response has a 5xx status code
func (o *GetCSPMAwsConsoleSetupURLsMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m aws console setup u r ls multi status response a status code equal to that given
func (o *GetCSPMAwsConsoleSetupURLsMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get c s p m aws console setup u r ls multi status response
func (o *GetCSPMAwsConsoleSetupURLsMultiStatus) Code() int {
	return 207
}

func (o *GetCSPMAwsConsoleSetupURLsMultiStatus) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1][%d] getCSPMAwsConsoleSetupURLsMultiStatus  %+v", 207, o.Payload)
}

func (o *GetCSPMAwsConsoleSetupURLsMultiStatus) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1][%d] getCSPMAwsConsoleSetupURLsMultiStatus  %+v", 207, o.Payload)
}

func (o *GetCSPMAwsConsoleSetupURLsMultiStatus) GetPayload() *models.RegistrationAWSAccountConsoleURL {
	return o.Payload
}

func (o *GetCSPMAwsConsoleSetupURLsMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountConsoleURL)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMAwsConsoleSetupURLsBadRequest creates a GetCSPMAwsConsoleSetupURLsBadRequest with default headers values
func NewGetCSPMAwsConsoleSetupURLsBadRequest() *GetCSPMAwsConsoleSetupURLsBadRequest {
	return &GetCSPMAwsConsoleSetupURLsBadRequest{}
}

/*
GetCSPMAwsConsoleSetupURLsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetCSPMAwsConsoleSetupURLsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountConsoleURL
}

// IsSuccess returns true when this get c s p m aws console setup u r ls bad request response has a 2xx status code
func (o *GetCSPMAwsConsoleSetupURLsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m aws console setup u r ls bad request response has a 3xx status code
func (o *GetCSPMAwsConsoleSetupURLsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m aws console setup u r ls bad request response has a 4xx status code
func (o *GetCSPMAwsConsoleSetupURLsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get c s p m aws console setup u r ls bad request response has a 5xx status code
func (o *GetCSPMAwsConsoleSetupURLsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m aws console setup u r ls bad request response a status code equal to that given
func (o *GetCSPMAwsConsoleSetupURLsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get c s p m aws console setup u r ls bad request response
func (o *GetCSPMAwsConsoleSetupURLsBadRequest) Code() int {
	return 400
}

func (o *GetCSPMAwsConsoleSetupURLsBadRequest) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1][%d] getCSPMAwsConsoleSetupURLsBadRequest  %+v", 400, o.Payload)
}

func (o *GetCSPMAwsConsoleSetupURLsBadRequest) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1][%d] getCSPMAwsConsoleSetupURLsBadRequest  %+v", 400, o.Payload)
}

func (o *GetCSPMAwsConsoleSetupURLsBadRequest) GetPayload() *models.RegistrationAWSAccountConsoleURL {
	return o.Payload
}

func (o *GetCSPMAwsConsoleSetupURLsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountConsoleURL)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMAwsConsoleSetupURLsForbidden creates a GetCSPMAwsConsoleSetupURLsForbidden with default headers values
func NewGetCSPMAwsConsoleSetupURLsForbidden() *GetCSPMAwsConsoleSetupURLsForbidden {
	return &GetCSPMAwsConsoleSetupURLsForbidden{}
}

/*
GetCSPMAwsConsoleSetupURLsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetCSPMAwsConsoleSetupURLsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get c s p m aws console setup u r ls forbidden response has a 2xx status code
func (o *GetCSPMAwsConsoleSetupURLsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m aws console setup u r ls forbidden response has a 3xx status code
func (o *GetCSPMAwsConsoleSetupURLsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m aws console setup u r ls forbidden response has a 4xx status code
func (o *GetCSPMAwsConsoleSetupURLsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get c s p m aws console setup u r ls forbidden response has a 5xx status code
func (o *GetCSPMAwsConsoleSetupURLsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m aws console setup u r ls forbidden response a status code equal to that given
func (o *GetCSPMAwsConsoleSetupURLsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get c s p m aws console setup u r ls forbidden response
func (o *GetCSPMAwsConsoleSetupURLsForbidden) Code() int {
	return 403
}

func (o *GetCSPMAwsConsoleSetupURLsForbidden) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1][%d] getCSPMAwsConsoleSetupURLsForbidden  %+v", 403, o.Payload)
}

func (o *GetCSPMAwsConsoleSetupURLsForbidden) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1][%d] getCSPMAwsConsoleSetupURLsForbidden  %+v", 403, o.Payload)
}

func (o *GetCSPMAwsConsoleSetupURLsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCSPMAwsConsoleSetupURLsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMAwsConsoleSetupURLsTooManyRequests creates a GetCSPMAwsConsoleSetupURLsTooManyRequests with default headers values
func NewGetCSPMAwsConsoleSetupURLsTooManyRequests() *GetCSPMAwsConsoleSetupURLsTooManyRequests {
	return &GetCSPMAwsConsoleSetupURLsTooManyRequests{}
}

/*
GetCSPMAwsConsoleSetupURLsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetCSPMAwsConsoleSetupURLsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get c s p m aws console setup u r ls too many requests response has a 2xx status code
func (o *GetCSPMAwsConsoleSetupURLsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m aws console setup u r ls too many requests response has a 3xx status code
func (o *GetCSPMAwsConsoleSetupURLsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m aws console setup u r ls too many requests response has a 4xx status code
func (o *GetCSPMAwsConsoleSetupURLsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get c s p m aws console setup u r ls too many requests response has a 5xx status code
func (o *GetCSPMAwsConsoleSetupURLsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m aws console setup u r ls too many requests response a status code equal to that given
func (o *GetCSPMAwsConsoleSetupURLsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get c s p m aws console setup u r ls too many requests response
func (o *GetCSPMAwsConsoleSetupURLsTooManyRequests) Code() int {
	return 429
}

func (o *GetCSPMAwsConsoleSetupURLsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1][%d] getCSPMAwsConsoleSetupURLsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCSPMAwsConsoleSetupURLsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1][%d] getCSPMAwsConsoleSetupURLsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCSPMAwsConsoleSetupURLsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCSPMAwsConsoleSetupURLsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMAwsConsoleSetupURLsInternalServerError creates a GetCSPMAwsConsoleSetupURLsInternalServerError with default headers values
func NewGetCSPMAwsConsoleSetupURLsInternalServerError() *GetCSPMAwsConsoleSetupURLsInternalServerError {
	return &GetCSPMAwsConsoleSetupURLsInternalServerError{}
}

/*
GetCSPMAwsConsoleSetupURLsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetCSPMAwsConsoleSetupURLsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountConsoleURL
}

// IsSuccess returns true when this get c s p m aws console setup u r ls internal server error response has a 2xx status code
func (o *GetCSPMAwsConsoleSetupURLsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m aws console setup u r ls internal server error response has a 3xx status code
func (o *GetCSPMAwsConsoleSetupURLsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m aws console setup u r ls internal server error response has a 4xx status code
func (o *GetCSPMAwsConsoleSetupURLsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get c s p m aws console setup u r ls internal server error response has a 5xx status code
func (o *GetCSPMAwsConsoleSetupURLsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get c s p m aws console setup u r ls internal server error response a status code equal to that given
func (o *GetCSPMAwsConsoleSetupURLsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get c s p m aws console setup u r ls internal server error response
func (o *GetCSPMAwsConsoleSetupURLsInternalServerError) Code() int {
	return 500
}

func (o *GetCSPMAwsConsoleSetupURLsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1][%d] getCSPMAwsConsoleSetupURLsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCSPMAwsConsoleSetupURLsInternalServerError) String() string {
	return fmt.Sprintf("[GET /cloud-connect-cspm-aws/entities/console-setup-urls/v1][%d] getCSPMAwsConsoleSetupURLsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCSPMAwsConsoleSetupURLsInternalServerError) GetPayload() *models.RegistrationAWSAccountConsoleURL {
	return o.Payload
}

func (o *GetCSPMAwsConsoleSetupURLsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountConsoleURL)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
