// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetCSPMPoliciesDetailsReader is a Reader for the GetCSPMPoliciesDetails structure.
type GetCSPMPoliciesDetailsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCSPMPoliciesDetailsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCSPMPoliciesDetailsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetCSPMPoliciesDetailsMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetCSPMPoliciesDetailsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetCSPMPoliciesDetailsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetCSPMPoliciesDetailsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCSPMPoliciesDetailsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /settings/entities/policy-details/v2] GetCSPMPoliciesDetails", response, response.Code())
	}
}

// NewGetCSPMPoliciesDetailsOK creates a GetCSPMPoliciesDetailsOK with default headers values
func NewGetCSPMPoliciesDetailsOK() *GetCSPMPoliciesDetailsOK {
	return &GetCSPMPoliciesDetailsOK{}
}

/*
GetCSPMPoliciesDetailsOK describes a response with status code 200, with default header values.

OK
*/
type GetCSPMPoliciesDetailsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationPolicyResponseV1
}

// IsSuccess returns true when this get c s p m policies details o k response has a 2xx status code
func (o *GetCSPMPoliciesDetailsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get c s p m policies details o k response has a 3xx status code
func (o *GetCSPMPoliciesDetailsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m policies details o k response has a 4xx status code
func (o *GetCSPMPoliciesDetailsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get c s p m policies details o k response has a 5xx status code
func (o *GetCSPMPoliciesDetailsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m policies details o k response a status code equal to that given
func (o *GetCSPMPoliciesDetailsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get c s p m policies details o k response
func (o *GetCSPMPoliciesDetailsOK) Code() int {
	return 200
}

func (o *GetCSPMPoliciesDetailsOK) Error() string {
	return fmt.Sprintf("[GET /settings/entities/policy-details/v2][%d] getCSPMPoliciesDetailsOK  %+v", 200, o.Payload)
}

func (o *GetCSPMPoliciesDetailsOK) String() string {
	return fmt.Sprintf("[GET /settings/entities/policy-details/v2][%d] getCSPMPoliciesDetailsOK  %+v", 200, o.Payload)
}

func (o *GetCSPMPoliciesDetailsOK) GetPayload() *models.RegistrationPolicyResponseV1 {
	return o.Payload
}

func (o *GetCSPMPoliciesDetailsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationPolicyResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMPoliciesDetailsMultiStatus creates a GetCSPMPoliciesDetailsMultiStatus with default headers values
func NewGetCSPMPoliciesDetailsMultiStatus() *GetCSPMPoliciesDetailsMultiStatus {
	return &GetCSPMPoliciesDetailsMultiStatus{}
}

/*
GetCSPMPoliciesDetailsMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetCSPMPoliciesDetailsMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationPolicyResponseV1
}

// IsSuccess returns true when this get c s p m policies details multi status response has a 2xx status code
func (o *GetCSPMPoliciesDetailsMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get c s p m policies details multi status response has a 3xx status code
func (o *GetCSPMPoliciesDetailsMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m policies details multi status response has a 4xx status code
func (o *GetCSPMPoliciesDetailsMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get c s p m policies details multi status response has a 5xx status code
func (o *GetCSPMPoliciesDetailsMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m policies details multi status response a status code equal to that given
func (o *GetCSPMPoliciesDetailsMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get c s p m policies details multi status response
func (o *GetCSPMPoliciesDetailsMultiStatus) Code() int {
	return 207
}

func (o *GetCSPMPoliciesDetailsMultiStatus) Error() string {
	return fmt.Sprintf("[GET /settings/entities/policy-details/v2][%d] getCSPMPoliciesDetailsMultiStatus  %+v", 207, o.Payload)
}

func (o *GetCSPMPoliciesDetailsMultiStatus) String() string {
	return fmt.Sprintf("[GET /settings/entities/policy-details/v2][%d] getCSPMPoliciesDetailsMultiStatus  %+v", 207, o.Payload)
}

func (o *GetCSPMPoliciesDetailsMultiStatus) GetPayload() *models.RegistrationPolicyResponseV1 {
	return o.Payload
}

func (o *GetCSPMPoliciesDetailsMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationPolicyResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMPoliciesDetailsBadRequest creates a GetCSPMPoliciesDetailsBadRequest with default headers values
func NewGetCSPMPoliciesDetailsBadRequest() *GetCSPMPoliciesDetailsBadRequest {
	return &GetCSPMPoliciesDetailsBadRequest{}
}

/*
GetCSPMPoliciesDetailsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetCSPMPoliciesDetailsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationPolicyResponseV1
}

// IsSuccess returns true when this get c s p m policies details bad request response has a 2xx status code
func (o *GetCSPMPoliciesDetailsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m policies details bad request response has a 3xx status code
func (o *GetCSPMPoliciesDetailsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m policies details bad request response has a 4xx status code
func (o *GetCSPMPoliciesDetailsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get c s p m policies details bad request response has a 5xx status code
func (o *GetCSPMPoliciesDetailsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m policies details bad request response a status code equal to that given
func (o *GetCSPMPoliciesDetailsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get c s p m policies details bad request response
func (o *GetCSPMPoliciesDetailsBadRequest) Code() int {
	return 400
}

func (o *GetCSPMPoliciesDetailsBadRequest) Error() string {
	return fmt.Sprintf("[GET /settings/entities/policy-details/v2][%d] getCSPMPoliciesDetailsBadRequest  %+v", 400, o.Payload)
}

func (o *GetCSPMPoliciesDetailsBadRequest) String() string {
	return fmt.Sprintf("[GET /settings/entities/policy-details/v2][%d] getCSPMPoliciesDetailsBadRequest  %+v", 400, o.Payload)
}

func (o *GetCSPMPoliciesDetailsBadRequest) GetPayload() *models.RegistrationPolicyResponseV1 {
	return o.Payload
}

func (o *GetCSPMPoliciesDetailsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationPolicyResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMPoliciesDetailsForbidden creates a GetCSPMPoliciesDetailsForbidden with default headers values
func NewGetCSPMPoliciesDetailsForbidden() *GetCSPMPoliciesDetailsForbidden {
	return &GetCSPMPoliciesDetailsForbidden{}
}

/*
GetCSPMPoliciesDetailsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetCSPMPoliciesDetailsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get c s p m policies details forbidden response has a 2xx status code
func (o *GetCSPMPoliciesDetailsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m policies details forbidden response has a 3xx status code
func (o *GetCSPMPoliciesDetailsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m policies details forbidden response has a 4xx status code
func (o *GetCSPMPoliciesDetailsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get c s p m policies details forbidden response has a 5xx status code
func (o *GetCSPMPoliciesDetailsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m policies details forbidden response a status code equal to that given
func (o *GetCSPMPoliciesDetailsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get c s p m policies details forbidden response
func (o *GetCSPMPoliciesDetailsForbidden) Code() int {
	return 403
}

func (o *GetCSPMPoliciesDetailsForbidden) Error() string {
	return fmt.Sprintf("[GET /settings/entities/policy-details/v2][%d] getCSPMPoliciesDetailsForbidden  %+v", 403, o.Payload)
}

func (o *GetCSPMPoliciesDetailsForbidden) String() string {
	return fmt.Sprintf("[GET /settings/entities/policy-details/v2][%d] getCSPMPoliciesDetailsForbidden  %+v", 403, o.Payload)
}

func (o *GetCSPMPoliciesDetailsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCSPMPoliciesDetailsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMPoliciesDetailsTooManyRequests creates a GetCSPMPoliciesDetailsTooManyRequests with default headers values
func NewGetCSPMPoliciesDetailsTooManyRequests() *GetCSPMPoliciesDetailsTooManyRequests {
	return &GetCSPMPoliciesDetailsTooManyRequests{}
}

/*
GetCSPMPoliciesDetailsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetCSPMPoliciesDetailsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get c s p m policies details too many requests response has a 2xx status code
func (o *GetCSPMPoliciesDetailsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m policies details too many requests response has a 3xx status code
func (o *GetCSPMPoliciesDetailsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m policies details too many requests response has a 4xx status code
func (o *GetCSPMPoliciesDetailsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get c s p m policies details too many requests response has a 5xx status code
func (o *GetCSPMPoliciesDetailsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m policies details too many requests response a status code equal to that given
func (o *GetCSPMPoliciesDetailsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get c s p m policies details too many requests response
func (o *GetCSPMPoliciesDetailsTooManyRequests) Code() int {
	return 429
}

func (o *GetCSPMPoliciesDetailsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /settings/entities/policy-details/v2][%d] getCSPMPoliciesDetailsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCSPMPoliciesDetailsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /settings/entities/policy-details/v2][%d] getCSPMPoliciesDetailsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCSPMPoliciesDetailsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCSPMPoliciesDetailsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMPoliciesDetailsInternalServerError creates a GetCSPMPoliciesDetailsInternalServerError with default headers values
func NewGetCSPMPoliciesDetailsInternalServerError() *GetCSPMPoliciesDetailsInternalServerError {
	return &GetCSPMPoliciesDetailsInternalServerError{}
}

/*
GetCSPMPoliciesDetailsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetCSPMPoliciesDetailsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationPolicyResponseV1
}

// IsSuccess returns true when this get c s p m policies details internal server error response has a 2xx status code
func (o *GetCSPMPoliciesDetailsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m policies details internal server error response has a 3xx status code
func (o *GetCSPMPoliciesDetailsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m policies details internal server error response has a 4xx status code
func (o *GetCSPMPoliciesDetailsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get c s p m policies details internal server error response has a 5xx status code
func (o *GetCSPMPoliciesDetailsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get c s p m policies details internal server error response a status code equal to that given
func (o *GetCSPMPoliciesDetailsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get c s p m policies details internal server error response
func (o *GetCSPMPoliciesDetailsInternalServerError) Code() int {
	return 500
}

func (o *GetCSPMPoliciesDetailsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /settings/entities/policy-details/v2][%d] getCSPMPoliciesDetailsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCSPMPoliciesDetailsInternalServerError) String() string {
	return fmt.Sprintf("[GET /settings/entities/policy-details/v2][%d] getCSPMPoliciesDetailsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCSPMPoliciesDetailsInternalServerError) GetPayload() *models.RegistrationPolicyResponseV1 {
	return o.Payload
}

func (o *GetCSPMPoliciesDetailsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationPolicyResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
