// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetCSPMScanScheduleReader is a Reader for the GetCSPMScanSchedule structure.
type GetCSPMScanScheduleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCSPMScanScheduleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCSPMScanScheduleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetCSPMScanScheduleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetCSPMScanScheduleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetCSPMScanScheduleTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCSPMScanScheduleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /settings/scan-schedule/v1] GetCSPMScanSchedule", response, response.Code())
	}
}

// NewGetCSPMScanScheduleOK creates a GetCSPMScanScheduleOK with default headers values
func NewGetCSPMScanScheduleOK() *GetCSPMScanScheduleOK {
	return &GetCSPMScanScheduleOK{}
}

/*
GetCSPMScanScheduleOK describes a response with status code 200, with default header values.

OK
*/
type GetCSPMScanScheduleOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationScanScheduleResponseV1
}

// IsSuccess returns true when this get c s p m scan schedule o k response has a 2xx status code
func (o *GetCSPMScanScheduleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get c s p m scan schedule o k response has a 3xx status code
func (o *GetCSPMScanScheduleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m scan schedule o k response has a 4xx status code
func (o *GetCSPMScanScheduleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get c s p m scan schedule o k response has a 5xx status code
func (o *GetCSPMScanScheduleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m scan schedule o k response a status code equal to that given
func (o *GetCSPMScanScheduleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get c s p m scan schedule o k response
func (o *GetCSPMScanScheduleOK) Code() int {
	return 200
}

func (o *GetCSPMScanScheduleOK) Error() string {
	return fmt.Sprintf("[GET /settings/scan-schedule/v1][%d] getCSPMScanScheduleOK  %+v", 200, o.Payload)
}

func (o *GetCSPMScanScheduleOK) String() string {
	return fmt.Sprintf("[GET /settings/scan-schedule/v1][%d] getCSPMScanScheduleOK  %+v", 200, o.Payload)
}

func (o *GetCSPMScanScheduleOK) GetPayload() *models.RegistrationScanScheduleResponseV1 {
	return o.Payload
}

func (o *GetCSPMScanScheduleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationScanScheduleResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMScanScheduleBadRequest creates a GetCSPMScanScheduleBadRequest with default headers values
func NewGetCSPMScanScheduleBadRequest() *GetCSPMScanScheduleBadRequest {
	return &GetCSPMScanScheduleBadRequest{}
}

/*
GetCSPMScanScheduleBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetCSPMScanScheduleBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationScanScheduleResponseV1
}

// IsSuccess returns true when this get c s p m scan schedule bad request response has a 2xx status code
func (o *GetCSPMScanScheduleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m scan schedule bad request response has a 3xx status code
func (o *GetCSPMScanScheduleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m scan schedule bad request response has a 4xx status code
func (o *GetCSPMScanScheduleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get c s p m scan schedule bad request response has a 5xx status code
func (o *GetCSPMScanScheduleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m scan schedule bad request response a status code equal to that given
func (o *GetCSPMScanScheduleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get c s p m scan schedule bad request response
func (o *GetCSPMScanScheduleBadRequest) Code() int {
	return 400
}

func (o *GetCSPMScanScheduleBadRequest) Error() string {
	return fmt.Sprintf("[GET /settings/scan-schedule/v1][%d] getCSPMScanScheduleBadRequest  %+v", 400, o.Payload)
}

func (o *GetCSPMScanScheduleBadRequest) String() string {
	return fmt.Sprintf("[GET /settings/scan-schedule/v1][%d] getCSPMScanScheduleBadRequest  %+v", 400, o.Payload)
}

func (o *GetCSPMScanScheduleBadRequest) GetPayload() *models.RegistrationScanScheduleResponseV1 {
	return o.Payload
}

func (o *GetCSPMScanScheduleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationScanScheduleResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMScanScheduleForbidden creates a GetCSPMScanScheduleForbidden with default headers values
func NewGetCSPMScanScheduleForbidden() *GetCSPMScanScheduleForbidden {
	return &GetCSPMScanScheduleForbidden{}
}

/*
GetCSPMScanScheduleForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetCSPMScanScheduleForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get c s p m scan schedule forbidden response has a 2xx status code
func (o *GetCSPMScanScheduleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m scan schedule forbidden response has a 3xx status code
func (o *GetCSPMScanScheduleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m scan schedule forbidden response has a 4xx status code
func (o *GetCSPMScanScheduleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get c s p m scan schedule forbidden response has a 5xx status code
func (o *GetCSPMScanScheduleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m scan schedule forbidden response a status code equal to that given
func (o *GetCSPMScanScheduleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get c s p m scan schedule forbidden response
func (o *GetCSPMScanScheduleForbidden) Code() int {
	return 403
}

func (o *GetCSPMScanScheduleForbidden) Error() string {
	return fmt.Sprintf("[GET /settings/scan-schedule/v1][%d] getCSPMScanScheduleForbidden  %+v", 403, o.Payload)
}

func (o *GetCSPMScanScheduleForbidden) String() string {
	return fmt.Sprintf("[GET /settings/scan-schedule/v1][%d] getCSPMScanScheduleForbidden  %+v", 403, o.Payload)
}

func (o *GetCSPMScanScheduleForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCSPMScanScheduleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMScanScheduleTooManyRequests creates a GetCSPMScanScheduleTooManyRequests with default headers values
func NewGetCSPMScanScheduleTooManyRequests() *GetCSPMScanScheduleTooManyRequests {
	return &GetCSPMScanScheduleTooManyRequests{}
}

/*
GetCSPMScanScheduleTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetCSPMScanScheduleTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get c s p m scan schedule too many requests response has a 2xx status code
func (o *GetCSPMScanScheduleTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m scan schedule too many requests response has a 3xx status code
func (o *GetCSPMScanScheduleTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m scan schedule too many requests response has a 4xx status code
func (o *GetCSPMScanScheduleTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get c s p m scan schedule too many requests response has a 5xx status code
func (o *GetCSPMScanScheduleTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get c s p m scan schedule too many requests response a status code equal to that given
func (o *GetCSPMScanScheduleTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get c s p m scan schedule too many requests response
func (o *GetCSPMScanScheduleTooManyRequests) Code() int {
	return 429
}

func (o *GetCSPMScanScheduleTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /settings/scan-schedule/v1][%d] getCSPMScanScheduleTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCSPMScanScheduleTooManyRequests) String() string {
	return fmt.Sprintf("[GET /settings/scan-schedule/v1][%d] getCSPMScanScheduleTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCSPMScanScheduleTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCSPMScanScheduleTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCSPMScanScheduleInternalServerError creates a GetCSPMScanScheduleInternalServerError with default headers values
func NewGetCSPMScanScheduleInternalServerError() *GetCSPMScanScheduleInternalServerError {
	return &GetCSPMScanScheduleInternalServerError{}
}

/*
GetCSPMScanScheduleInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetCSPMScanScheduleInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationScanScheduleResponseV1
}

// IsSuccess returns true when this get c s p m scan schedule internal server error response has a 2xx status code
func (o *GetCSPMScanScheduleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get c s p m scan schedule internal server error response has a 3xx status code
func (o *GetCSPMScanScheduleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get c s p m scan schedule internal server error response has a 4xx status code
func (o *GetCSPMScanScheduleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get c s p m scan schedule internal server error response has a 5xx status code
func (o *GetCSPMScanScheduleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get c s p m scan schedule internal server error response a status code equal to that given
func (o *GetCSPMScanScheduleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get c s p m scan schedule internal server error response
func (o *GetCSPMScanScheduleInternalServerError) Code() int {
	return 500
}

func (o *GetCSPMScanScheduleInternalServerError) Error() string {
	return fmt.Sprintf("[GET /settings/scan-schedule/v1][%d] getCSPMScanScheduleInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCSPMScanScheduleInternalServerError) String() string {
	return fmt.Sprintf("[GET /settings/scan-schedule/v1][%d] getCSPMScanScheduleInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCSPMScanScheduleInternalServerError) GetPayload() *models.RegistrationScanScheduleResponseV1 {
	return o.Payload
}

func (o *GetCSPMScanScheduleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationScanScheduleResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
