// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetConfigurationDetectionIDsV2Params creates a new GetConfigurationDetectionIDsV2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetConfigurationDetectionIDsV2Params() *GetConfigurationDetectionIDsV2Params {
	return &GetConfigurationDetectionIDsV2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetConfigurationDetectionIDsV2ParamsWithTimeout creates a new GetConfigurationDetectionIDsV2Params object
// with the ability to set a timeout on a request.
func NewGetConfigurationDetectionIDsV2ParamsWithTimeout(timeout time.Duration) *GetConfigurationDetectionIDsV2Params {
	return &GetConfigurationDetectionIDsV2Params{
		timeout: timeout,
	}
}

// NewGetConfigurationDetectionIDsV2ParamsWithContext creates a new GetConfigurationDetectionIDsV2Params object
// with the ability to set a context for a request.
func NewGetConfigurationDetectionIDsV2ParamsWithContext(ctx context.Context) *GetConfigurationDetectionIDsV2Params {
	return &GetConfigurationDetectionIDsV2Params{
		Context: ctx,
	}
}

// NewGetConfigurationDetectionIDsV2ParamsWithHTTPClient creates a new GetConfigurationDetectionIDsV2Params object
// with the ability to set a custom HTTPClient for a request.
func NewGetConfigurationDetectionIDsV2ParamsWithHTTPClient(client *http.Client) *GetConfigurationDetectionIDsV2Params {
	return &GetConfigurationDetectionIDsV2Params{
		HTTPClient: client,
	}
}

/*
GetConfigurationDetectionIDsV2Params contains all the parameters to send to the API endpoint

	for the get configuration detection i ds v2 operation.

	Typically these are written to a http.Request.
*/
type GetConfigurationDetectionIDsV2Params struct {

	/* Filter.

	     use_current_scan_ids - *use this to get records for latest scans*
	account_name
	account_id
	agent_id
	attack_types
	azure_subscription_id
	cloud_provider
	cloud_service_keyword
	custom_policy_id
	is_managed
	policy_id
	policy_type
	resource_id
	region
	status
	scan_time
	severity
	severity_string

	*/
	Filter *string

	/* Limit.

	   The max number of detections to return

	   Default: 500
	*/
	Limit *int64

	/* NextToken.

	   String to get next page of results. Cannot be combined with any filter except limit.
	*/
	NextToken *string

	/* Offset.

	   Offset returned detections. Cannot be combined with next_token filter
	*/
	Offset *int64

	/* Sort.

	     account_name
	account_id
	attack_types
	azure_subscription_id
	cloud_provider
	cloud_service_keyword
	status
	is_managed
	policy_id
	policy_type
	resource_id
	region
	scan_time
	severity
	severity_string
	timestamp

	     Default: "timestamp|desc"
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get configuration detection i ds v2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetConfigurationDetectionIDsV2Params) WithDefaults() *GetConfigurationDetectionIDsV2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get configuration detection i ds v2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetConfigurationDetectionIDsV2Params) SetDefaults() {
	var (
		limitDefault = int64(500)

		sortDefault = string("timestamp|desc")
	)

	val := GetConfigurationDetectionIDsV2Params{
		Limit: &limitDefault,
		Sort:  &sortDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) WithTimeout(timeout time.Duration) *GetConfigurationDetectionIDsV2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) WithContext(ctx context.Context) *GetConfigurationDetectionIDsV2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) WithHTTPClient(client *http.Client) *GetConfigurationDetectionIDsV2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) WithFilter(filter *string) *GetConfigurationDetectionIDsV2Params {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) WithLimit(limit *int64) *GetConfigurationDetectionIDsV2Params {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithNextToken adds the nextToken to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) WithNextToken(nextToken *string) *GetConfigurationDetectionIDsV2Params {
	o.SetNextToken(nextToken)
	return o
}

// SetNextToken adds the nextToken to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) SetNextToken(nextToken *string) {
	o.NextToken = nextToken
}

// WithOffset adds the offset to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) WithOffset(offset *int64) *GetConfigurationDetectionIDsV2Params {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) WithSort(sort *string) *GetConfigurationDetectionIDsV2Params {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the get configuration detection i ds v2 params
func (o *GetConfigurationDetectionIDsV2Params) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *GetConfigurationDetectionIDsV2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.NextToken != nil {

		// query param next_token
		var qrNextToken string

		if o.NextToken != nil {
			qrNextToken = *o.NextToken
		}
		qNextToken := qrNextToken
		if qNextToken != "" {

			if err := r.SetQueryParam("next_token", qNextToken); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
