// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetConfigurationDetectionsParams creates a new GetConfigurationDetectionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetConfigurationDetectionsParams() *GetConfigurationDetectionsParams {
	return &GetConfigurationDetectionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetConfigurationDetectionsParamsWithTimeout creates a new GetConfigurationDetectionsParams object
// with the ability to set a timeout on a request.
func NewGetConfigurationDetectionsParamsWithTimeout(timeout time.Duration) *GetConfigurationDetectionsParams {
	return &GetConfigurationDetectionsParams{
		timeout: timeout,
	}
}

// NewGetConfigurationDetectionsParamsWithContext creates a new GetConfigurationDetectionsParams object
// with the ability to set a context for a request.
func NewGetConfigurationDetectionsParamsWithContext(ctx context.Context) *GetConfigurationDetectionsParams {
	return &GetConfigurationDetectionsParams{
		Context: ctx,
	}
}

// NewGetConfigurationDetectionsParamsWithHTTPClient creates a new GetConfigurationDetectionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetConfigurationDetectionsParamsWithHTTPClient(client *http.Client) *GetConfigurationDetectionsParams {
	return &GetConfigurationDetectionsParams{
		HTTPClient: client,
	}
}

/*
GetConfigurationDetectionsParams contains all the parameters to send to the API endpoint

	for the get configuration detections operation.

	Typically these are written to a http.Request.
*/
type GetConfigurationDetectionsParams struct {

	/* AccountID.

	   AWS account ID or GCP Project Number or Azure subscription ID
	*/
	AccountID *string

	/* AzureSubscriptionID.

	   Azure Subscription ID
	*/
	AzureSubscriptionID *string

	/* AzureTenantID.

	   Azure Tenant ID
	*/
	AzureTenantID *string

	/* CloudProvider.

	   Cloud Provider (e.g.: aws|azure|gcp)
	*/
	CloudProvider *string

	/* Limit.

	   The maximum records to return. [1-500]
	*/
	Limit *int64

	/* NextToken.

	   String to get next page of results, is associated with a previous execution of GetConfigurationDetections. Cannot be combined with any filter except limit.
	*/
	NextToken *string

	/* Region.

	   Cloud Provider Region
	*/
	Region *string

	/* Service.

	   Cloud Service (e.g.: EBS|EC2|S3 etc.)
	*/
	Service *string

	/* Severity.

	   Policy Severity
	*/
	Severity *string

	/* Status.

	   Status (e.g.: new|reoccurring|all)
	*/
	Status *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get configuration detections params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetConfigurationDetectionsParams) WithDefaults() *GetConfigurationDetectionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get configuration detections params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetConfigurationDetectionsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithTimeout(timeout time.Duration) *GetConfigurationDetectionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithContext(ctx context.Context) *GetConfigurationDetectionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithHTTPClient(client *http.Client) *GetConfigurationDetectionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountID adds the accountID to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithAccountID(accountID *string) *GetConfigurationDetectionsParams {
	o.SetAccountID(accountID)
	return o
}

// SetAccountID adds the accountId to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetAccountID(accountID *string) {
	o.AccountID = accountID
}

// WithAzureSubscriptionID adds the azureSubscriptionID to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithAzureSubscriptionID(azureSubscriptionID *string) *GetConfigurationDetectionsParams {
	o.SetAzureSubscriptionID(azureSubscriptionID)
	return o
}

// SetAzureSubscriptionID adds the azureSubscriptionId to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetAzureSubscriptionID(azureSubscriptionID *string) {
	o.AzureSubscriptionID = azureSubscriptionID
}

// WithAzureTenantID adds the azureTenantID to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithAzureTenantID(azureTenantID *string) *GetConfigurationDetectionsParams {
	o.SetAzureTenantID(azureTenantID)
	return o
}

// SetAzureTenantID adds the azureTenantId to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetAzureTenantID(azureTenantID *string) {
	o.AzureTenantID = azureTenantID
}

// WithCloudProvider adds the cloudProvider to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithCloudProvider(cloudProvider *string) *GetConfigurationDetectionsParams {
	o.SetCloudProvider(cloudProvider)
	return o
}

// SetCloudProvider adds the cloudProvider to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetCloudProvider(cloudProvider *string) {
	o.CloudProvider = cloudProvider
}

// WithLimit adds the limit to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithLimit(limit *int64) *GetConfigurationDetectionsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithNextToken adds the nextToken to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithNextToken(nextToken *string) *GetConfigurationDetectionsParams {
	o.SetNextToken(nextToken)
	return o
}

// SetNextToken adds the nextToken to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetNextToken(nextToken *string) {
	o.NextToken = nextToken
}

// WithRegion adds the region to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithRegion(region *string) *GetConfigurationDetectionsParams {
	o.SetRegion(region)
	return o
}

// SetRegion adds the region to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetRegion(region *string) {
	o.Region = region
}

// WithService adds the service to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithService(service *string) *GetConfigurationDetectionsParams {
	o.SetService(service)
	return o
}

// SetService adds the service to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetService(service *string) {
	o.Service = service
}

// WithSeverity adds the severity to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithSeverity(severity *string) *GetConfigurationDetectionsParams {
	o.SetSeverity(severity)
	return o
}

// SetSeverity adds the severity to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetSeverity(severity *string) {
	o.Severity = severity
}

// WithStatus adds the status to the get configuration detections params
func (o *GetConfigurationDetectionsParams) WithStatus(status *string) *GetConfigurationDetectionsParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the get configuration detections params
func (o *GetConfigurationDetectionsParams) SetStatus(status *string) {
	o.Status = status
}

// WriteToRequest writes these params to a swagger request
func (o *GetConfigurationDetectionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccountID != nil {

		// query param account_id
		var qrAccountID string

		if o.AccountID != nil {
			qrAccountID = *o.AccountID
		}
		qAccountID := qrAccountID
		if qAccountID != "" {

			if err := r.SetQueryParam("account_id", qAccountID); err != nil {
				return err
			}
		}
	}

	if o.AzureSubscriptionID != nil {

		// query param azure_subscription_id
		var qrAzureSubscriptionID string

		if o.AzureSubscriptionID != nil {
			qrAzureSubscriptionID = *o.AzureSubscriptionID
		}
		qAzureSubscriptionID := qrAzureSubscriptionID
		if qAzureSubscriptionID != "" {

			if err := r.SetQueryParam("azure_subscription_id", qAzureSubscriptionID); err != nil {
				return err
			}
		}
	}

	if o.AzureTenantID != nil {

		// query param azure_tenant_id
		var qrAzureTenantID string

		if o.AzureTenantID != nil {
			qrAzureTenantID = *o.AzureTenantID
		}
		qAzureTenantID := qrAzureTenantID
		if qAzureTenantID != "" {

			if err := r.SetQueryParam("azure_tenant_id", qAzureTenantID); err != nil {
				return err
			}
		}
	}

	if o.CloudProvider != nil {

		// query param cloud_provider
		var qrCloudProvider string

		if o.CloudProvider != nil {
			qrCloudProvider = *o.CloudProvider
		}
		qCloudProvider := qrCloudProvider
		if qCloudProvider != "" {

			if err := r.SetQueryParam("cloud_provider", qCloudProvider); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.NextToken != nil {

		// query param next_token
		var qrNextToken string

		if o.NextToken != nil {
			qrNextToken = *o.NextToken
		}
		qNextToken := qrNextToken
		if qNextToken != "" {

			if err := r.SetQueryParam("next_token", qNextToken); err != nil {
				return err
			}
		}
	}

	if o.Region != nil {

		// query param region
		var qrRegion string

		if o.Region != nil {
			qrRegion = *o.Region
		}
		qRegion := qrRegion
		if qRegion != "" {

			if err := r.SetQueryParam("region", qRegion); err != nil {
				return err
			}
		}
	}

	if o.Service != nil {

		// query param service
		var qrService string

		if o.Service != nil {
			qrService = *o.Service
		}
		qService := qrService
		if qService != "" {

			if err := r.SetQueryParam("service", qService); err != nil {
				return err
			}
		}
	}

	if o.Severity != nil {

		// query param severity
		var qrSeverity string

		if o.Severity != nil {
			qrSeverity = *o.Severity
		}
		qSeverity := qrSeverity
		if qSeverity != "" {

			if err := r.SetQueryParam("severity", qSeverity); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
