// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewUpdateCSPMAzureAccountClientIDParams creates a new UpdateCSPMAzureAccountClientIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateCSPMAzureAccountClientIDParams() *UpdateCSPMAzureAccountClientIDParams {
	return &UpdateCSPMAzureAccountClientIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateCSPMAzureAccountClientIDParamsWithTimeout creates a new UpdateCSPMAzureAccountClientIDParams object
// with the ability to set a timeout on a request.
func NewUpdateCSPMAzureAccountClientIDParamsWithTimeout(timeout time.Duration) *UpdateCSPMAzureAccountClientIDParams {
	return &UpdateCSPMAzureAccountClientIDParams{
		timeout: timeout,
	}
}

// NewUpdateCSPMAzureAccountClientIDParamsWithContext creates a new UpdateCSPMAzureAccountClientIDParams object
// with the ability to set a context for a request.
func NewUpdateCSPMAzureAccountClientIDParamsWithContext(ctx context.Context) *UpdateCSPMAzureAccountClientIDParams {
	return &UpdateCSPMAzureAccountClientIDParams{
		Context: ctx,
	}
}

// NewUpdateCSPMAzureAccountClientIDParamsWithHTTPClient creates a new UpdateCSPMAzureAccountClientIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateCSPMAzureAccountClientIDParamsWithHTTPClient(client *http.Client) *UpdateCSPMAzureAccountClientIDParams {
	return &UpdateCSPMAzureAccountClientIDParams{
		HTTPClient: client,
	}
}

/*
UpdateCSPMAzureAccountClientIDParams contains all the parameters to send to the API endpoint

	for the update c s p m azure account client ID operation.

	Typically these are written to a http.Request.
*/
type UpdateCSPMAzureAccountClientIDParams struct {

	/* ID.

	   ClientID to use for the Service Principal associated with the customer's Azure account
	*/
	ID string

	/* TenantID.

	   Tenant ID to update client ID for. Required if multiple tenants are registered.
	*/
	TenantID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update c s p m azure account client ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateCSPMAzureAccountClientIDParams) WithDefaults() *UpdateCSPMAzureAccountClientIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update c s p m azure account client ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateCSPMAzureAccountClientIDParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update c s p m azure account client ID params
func (o *UpdateCSPMAzureAccountClientIDParams) WithTimeout(timeout time.Duration) *UpdateCSPMAzureAccountClientIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update c s p m azure account client ID params
func (o *UpdateCSPMAzureAccountClientIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update c s p m azure account client ID params
func (o *UpdateCSPMAzureAccountClientIDParams) WithContext(ctx context.Context) *UpdateCSPMAzureAccountClientIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update c s p m azure account client ID params
func (o *UpdateCSPMAzureAccountClientIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update c s p m azure account client ID params
func (o *UpdateCSPMAzureAccountClientIDParams) WithHTTPClient(client *http.Client) *UpdateCSPMAzureAccountClientIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update c s p m azure account client ID params
func (o *UpdateCSPMAzureAccountClientIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the update c s p m azure account client ID params
func (o *UpdateCSPMAzureAccountClientIDParams) WithID(id string) *UpdateCSPMAzureAccountClientIDParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the update c s p m azure account client ID params
func (o *UpdateCSPMAzureAccountClientIDParams) SetID(id string) {
	o.ID = id
}

// WithTenantID adds the tenantID to the update c s p m azure account client ID params
func (o *UpdateCSPMAzureAccountClientIDParams) WithTenantID(tenantID *string) *UpdateCSPMAzureAccountClientIDParams {
	o.SetTenantID(tenantID)
	return o
}

// SetTenantID adds the tenantId to the update c s p m azure account client ID params
func (o *UpdateCSPMAzureAccountClientIDParams) SetTenantID(tenantID *string) {
	o.TenantID = tenantID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateCSPMAzureAccountClientIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param id
	qrID := o.ID
	qID := qrID
	if qID != "" {

		if err := r.SetQueryParam("id", qID); err != nil {
			return err
		}
	}

	if o.TenantID != nil {

		// query param tenant-id
		var qrTenantID string

		if o.TenantID != nil {
			qrTenantID = *o.TenantID
		}
		qTenantID := qrTenantID
		if qTenantID != "" {

			if err := r.SetQueryParam("tenant-id", qTenantID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
