// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewUpdateCSPMAzureTenantDefaultSubscriptionIDParams creates a new UpdateCSPMAzureTenantDefaultSubscriptionIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateCSPMAzureTenantDefaultSubscriptionIDParams() *UpdateCSPMAzureTenantDefaultSubscriptionIDParams {
	return &UpdateCSPMAzureTenantDefaultSubscriptionIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateCSPMAzureTenantDefaultSubscriptionIDParamsWithTimeout creates a new UpdateCSPMAzureTenantDefaultSubscriptionIDParams object
// with the ability to set a timeout on a request.
func NewUpdateCSPMAzureTenantDefaultSubscriptionIDParamsWithTimeout(timeout time.Duration) *UpdateCSPMAzureTenantDefaultSubscriptionIDParams {
	return &UpdateCSPMAzureTenantDefaultSubscriptionIDParams{
		timeout: timeout,
	}
}

// NewUpdateCSPMAzureTenantDefaultSubscriptionIDParamsWithContext creates a new UpdateCSPMAzureTenantDefaultSubscriptionIDParams object
// with the ability to set a context for a request.
func NewUpdateCSPMAzureTenantDefaultSubscriptionIDParamsWithContext(ctx context.Context) *UpdateCSPMAzureTenantDefaultSubscriptionIDParams {
	return &UpdateCSPMAzureTenantDefaultSubscriptionIDParams{
		Context: ctx,
	}
}

// NewUpdateCSPMAzureTenantDefaultSubscriptionIDParamsWithHTTPClient creates a new UpdateCSPMAzureTenantDefaultSubscriptionIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateCSPMAzureTenantDefaultSubscriptionIDParamsWithHTTPClient(client *http.Client) *UpdateCSPMAzureTenantDefaultSubscriptionIDParams {
	return &UpdateCSPMAzureTenantDefaultSubscriptionIDParams{
		HTTPClient: client,
	}
}

/*
UpdateCSPMAzureTenantDefaultSubscriptionIDParams contains all the parameters to send to the API endpoint

	for the update c s p m azure tenant default subscription ID operation.

	Typically these are written to a http.Request.
*/
type UpdateCSPMAzureTenantDefaultSubscriptionIDParams struct {

	/* SubscriptionID.

	   Default Subscription ID to patch for all subscriptions belonged to a tenant.
	*/
	SubscriptionID string

	/* TenantID.

	   Tenant ID to update client ID for. Required if multiple tenants are registered.
	*/
	TenantID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update c s p m azure tenant default subscription ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) WithDefaults() *UpdateCSPMAzureTenantDefaultSubscriptionIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update c s p m azure tenant default subscription ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update c s p m azure tenant default subscription ID params
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) WithTimeout(timeout time.Duration) *UpdateCSPMAzureTenantDefaultSubscriptionIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update c s p m azure tenant default subscription ID params
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update c s p m azure tenant default subscription ID params
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) WithContext(ctx context.Context) *UpdateCSPMAzureTenantDefaultSubscriptionIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update c s p m azure tenant default subscription ID params
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update c s p m azure tenant default subscription ID params
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) WithHTTPClient(client *http.Client) *UpdateCSPMAzureTenantDefaultSubscriptionIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update c s p m azure tenant default subscription ID params
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithSubscriptionID adds the subscriptionID to the update c s p m azure tenant default subscription ID params
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) WithSubscriptionID(subscriptionID string) *UpdateCSPMAzureTenantDefaultSubscriptionIDParams {
	o.SetSubscriptionID(subscriptionID)
	return o
}

// SetSubscriptionID adds the subscriptionId to the update c s p m azure tenant default subscription ID params
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) SetSubscriptionID(subscriptionID string) {
	o.SubscriptionID = subscriptionID
}

// WithTenantID adds the tenantID to the update c s p m azure tenant default subscription ID params
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) WithTenantID(tenantID *string) *UpdateCSPMAzureTenantDefaultSubscriptionIDParams {
	o.SetTenantID(tenantID)
	return o
}

// SetTenantID adds the tenantId to the update c s p m azure tenant default subscription ID params
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) SetTenantID(tenantID *string) {
	o.TenantID = tenantID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateCSPMAzureTenantDefaultSubscriptionIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param subscription_id
	qrSubscriptionID := o.SubscriptionID
	qSubscriptionID := qrSubscriptionID
	if qSubscriptionID != "" {

		if err := r.SetQueryParam("subscription_id", qSubscriptionID); err != nil {
			return err
		}
	}

	if o.TenantID != nil {

		// query param tenant-id
		var qrTenantID string

		if o.TenantID != nil {
			qrTenantID = *o.TenantID
		}
		qTenantID := qrTenantID
		if qTenantID != "" {

			if err := r.SetQueryParam("tenant-id", qTenantID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
