// Code generated by go-swagger; DO NOT EDIT.

package cspm_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateCSPMPolicySettingsReader is a Reader for the UpdateCSPMPolicySettings structure.
type UpdateCSPMPolicySettingsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateCSPMPolicySettingsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateCSPMPolicySettingsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewUpdateCSPMPolicySettingsMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateCSPMPolicySettingsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateCSPMPolicySettingsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateCSPMPolicySettingsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateCSPMPolicySettingsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /settings/entities/policy/v1] UpdateCSPMPolicySettings", response, response.Code())
	}
}

// NewUpdateCSPMPolicySettingsOK creates a UpdateCSPMPolicySettingsOK with default headers values
func NewUpdateCSPMPolicySettingsOK() *UpdateCSPMPolicySettingsOK {
	return &UpdateCSPMPolicySettingsOK{}
}

/*
UpdateCSPMPolicySettingsOK describes a response with status code 200, with default header values.

OK
*/
type UpdateCSPMPolicySettingsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationPolicySettingsResponseV1
}

// IsSuccess returns true when this update c s p m policy settings o k response has a 2xx status code
func (o *UpdateCSPMPolicySettingsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update c s p m policy settings o k response has a 3xx status code
func (o *UpdateCSPMPolicySettingsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update c s p m policy settings o k response has a 4xx status code
func (o *UpdateCSPMPolicySettingsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update c s p m policy settings o k response has a 5xx status code
func (o *UpdateCSPMPolicySettingsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update c s p m policy settings o k response a status code equal to that given
func (o *UpdateCSPMPolicySettingsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update c s p m policy settings o k response
func (o *UpdateCSPMPolicySettingsOK) Code() int {
	return 200
}

func (o *UpdateCSPMPolicySettingsOK) Error() string {
	return fmt.Sprintf("[PATCH /settings/entities/policy/v1][%d] updateCSPMPolicySettingsOK  %+v", 200, o.Payload)
}

func (o *UpdateCSPMPolicySettingsOK) String() string {
	return fmt.Sprintf("[PATCH /settings/entities/policy/v1][%d] updateCSPMPolicySettingsOK  %+v", 200, o.Payload)
}

func (o *UpdateCSPMPolicySettingsOK) GetPayload() *models.RegistrationPolicySettingsResponseV1 {
	return o.Payload
}

func (o *UpdateCSPMPolicySettingsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationPolicySettingsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCSPMPolicySettingsMultiStatus creates a UpdateCSPMPolicySettingsMultiStatus with default headers values
func NewUpdateCSPMPolicySettingsMultiStatus() *UpdateCSPMPolicySettingsMultiStatus {
	return &UpdateCSPMPolicySettingsMultiStatus{}
}

/*
UpdateCSPMPolicySettingsMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type UpdateCSPMPolicySettingsMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationPolicySettingsResponseV1
}

// IsSuccess returns true when this update c s p m policy settings multi status response has a 2xx status code
func (o *UpdateCSPMPolicySettingsMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update c s p m policy settings multi status response has a 3xx status code
func (o *UpdateCSPMPolicySettingsMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update c s p m policy settings multi status response has a 4xx status code
func (o *UpdateCSPMPolicySettingsMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this update c s p m policy settings multi status response has a 5xx status code
func (o *UpdateCSPMPolicySettingsMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this update c s p m policy settings multi status response a status code equal to that given
func (o *UpdateCSPMPolicySettingsMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the update c s p m policy settings multi status response
func (o *UpdateCSPMPolicySettingsMultiStatus) Code() int {
	return 207
}

func (o *UpdateCSPMPolicySettingsMultiStatus) Error() string {
	return fmt.Sprintf("[PATCH /settings/entities/policy/v1][%d] updateCSPMPolicySettingsMultiStatus  %+v", 207, o.Payload)
}

func (o *UpdateCSPMPolicySettingsMultiStatus) String() string {
	return fmt.Sprintf("[PATCH /settings/entities/policy/v1][%d] updateCSPMPolicySettingsMultiStatus  %+v", 207, o.Payload)
}

func (o *UpdateCSPMPolicySettingsMultiStatus) GetPayload() *models.RegistrationPolicySettingsResponseV1 {
	return o.Payload
}

func (o *UpdateCSPMPolicySettingsMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationPolicySettingsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCSPMPolicySettingsBadRequest creates a UpdateCSPMPolicySettingsBadRequest with default headers values
func NewUpdateCSPMPolicySettingsBadRequest() *UpdateCSPMPolicySettingsBadRequest {
	return &UpdateCSPMPolicySettingsBadRequest{}
}

/*
UpdateCSPMPolicySettingsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateCSPMPolicySettingsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationPolicySettingsResponseV1
}

// IsSuccess returns true when this update c s p m policy settings bad request response has a 2xx status code
func (o *UpdateCSPMPolicySettingsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update c s p m policy settings bad request response has a 3xx status code
func (o *UpdateCSPMPolicySettingsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update c s p m policy settings bad request response has a 4xx status code
func (o *UpdateCSPMPolicySettingsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update c s p m policy settings bad request response has a 5xx status code
func (o *UpdateCSPMPolicySettingsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update c s p m policy settings bad request response a status code equal to that given
func (o *UpdateCSPMPolicySettingsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update c s p m policy settings bad request response
func (o *UpdateCSPMPolicySettingsBadRequest) Code() int {
	return 400
}

func (o *UpdateCSPMPolicySettingsBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /settings/entities/policy/v1][%d] updateCSPMPolicySettingsBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateCSPMPolicySettingsBadRequest) String() string {
	return fmt.Sprintf("[PATCH /settings/entities/policy/v1][%d] updateCSPMPolicySettingsBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateCSPMPolicySettingsBadRequest) GetPayload() *models.RegistrationPolicySettingsResponseV1 {
	return o.Payload
}

func (o *UpdateCSPMPolicySettingsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationPolicySettingsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCSPMPolicySettingsForbidden creates a UpdateCSPMPolicySettingsForbidden with default headers values
func NewUpdateCSPMPolicySettingsForbidden() *UpdateCSPMPolicySettingsForbidden {
	return &UpdateCSPMPolicySettingsForbidden{}
}

/*
UpdateCSPMPolicySettingsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateCSPMPolicySettingsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update c s p m policy settings forbidden response has a 2xx status code
func (o *UpdateCSPMPolicySettingsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update c s p m policy settings forbidden response has a 3xx status code
func (o *UpdateCSPMPolicySettingsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update c s p m policy settings forbidden response has a 4xx status code
func (o *UpdateCSPMPolicySettingsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update c s p m policy settings forbidden response has a 5xx status code
func (o *UpdateCSPMPolicySettingsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update c s p m policy settings forbidden response a status code equal to that given
func (o *UpdateCSPMPolicySettingsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update c s p m policy settings forbidden response
func (o *UpdateCSPMPolicySettingsForbidden) Code() int {
	return 403
}

func (o *UpdateCSPMPolicySettingsForbidden) Error() string {
	return fmt.Sprintf("[PATCH /settings/entities/policy/v1][%d] updateCSPMPolicySettingsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateCSPMPolicySettingsForbidden) String() string {
	return fmt.Sprintf("[PATCH /settings/entities/policy/v1][%d] updateCSPMPolicySettingsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateCSPMPolicySettingsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateCSPMPolicySettingsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCSPMPolicySettingsTooManyRequests creates a UpdateCSPMPolicySettingsTooManyRequests with default headers values
func NewUpdateCSPMPolicySettingsTooManyRequests() *UpdateCSPMPolicySettingsTooManyRequests {
	return &UpdateCSPMPolicySettingsTooManyRequests{}
}

/*
UpdateCSPMPolicySettingsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateCSPMPolicySettingsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update c s p m policy settings too many requests response has a 2xx status code
func (o *UpdateCSPMPolicySettingsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update c s p m policy settings too many requests response has a 3xx status code
func (o *UpdateCSPMPolicySettingsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update c s p m policy settings too many requests response has a 4xx status code
func (o *UpdateCSPMPolicySettingsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update c s p m policy settings too many requests response has a 5xx status code
func (o *UpdateCSPMPolicySettingsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update c s p m policy settings too many requests response a status code equal to that given
func (o *UpdateCSPMPolicySettingsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update c s p m policy settings too many requests response
func (o *UpdateCSPMPolicySettingsTooManyRequests) Code() int {
	return 429
}

func (o *UpdateCSPMPolicySettingsTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /settings/entities/policy/v1][%d] updateCSPMPolicySettingsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateCSPMPolicySettingsTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /settings/entities/policy/v1][%d] updateCSPMPolicySettingsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateCSPMPolicySettingsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateCSPMPolicySettingsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCSPMPolicySettingsInternalServerError creates a UpdateCSPMPolicySettingsInternalServerError with default headers values
func NewUpdateCSPMPolicySettingsInternalServerError() *UpdateCSPMPolicySettingsInternalServerError {
	return &UpdateCSPMPolicySettingsInternalServerError{}
}

/*
UpdateCSPMPolicySettingsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UpdateCSPMPolicySettingsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationPolicySettingsResponseV1
}

// IsSuccess returns true when this update c s p m policy settings internal server error response has a 2xx status code
func (o *UpdateCSPMPolicySettingsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update c s p m policy settings internal server error response has a 3xx status code
func (o *UpdateCSPMPolicySettingsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update c s p m policy settings internal server error response has a 4xx status code
func (o *UpdateCSPMPolicySettingsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update c s p m policy settings internal server error response has a 5xx status code
func (o *UpdateCSPMPolicySettingsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update c s p m policy settings internal server error response a status code equal to that given
func (o *UpdateCSPMPolicySettingsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update c s p m policy settings internal server error response
func (o *UpdateCSPMPolicySettingsInternalServerError) Code() int {
	return 500
}

func (o *UpdateCSPMPolicySettingsInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /settings/entities/policy/v1][%d] updateCSPMPolicySettingsInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateCSPMPolicySettingsInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /settings/entities/policy/v1][%d] updateCSPMPolicySettingsInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateCSPMPolicySettingsInternalServerError) GetPayload() *models.RegistrationPolicySettingsResponseV1 {
	return o.Payload
}

func (o *UpdateCSPMPolicySettingsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationPolicySettingsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
