// Code generated by go-swagger; DO NOT EDIT.

package custom_ioa

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateRuleReader is a Reader for the CreateRule structure.
type CreateRuleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateRuleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreateRuleCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewCreateRuleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewCreateRuleNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateRuleTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /ioarules/entities/rules/v1] create-rule", response, response.Code())
	}
}

// NewCreateRuleCreated creates a CreateRuleCreated with default headers values
func NewCreateRuleCreated() *CreateRuleCreated {
	return &CreateRuleCreated{}
}

/*
CreateRuleCreated describes a response with status code 201, with default header values.

OK
*/
type CreateRuleCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.APIRulesResponse
}

// IsSuccess returns true when this create rule created response has a 2xx status code
func (o *CreateRuleCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create rule created response has a 3xx status code
func (o *CreateRuleCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create rule created response has a 4xx status code
func (o *CreateRuleCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create rule created response has a 5xx status code
func (o *CreateRuleCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create rule created response a status code equal to that given
func (o *CreateRuleCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create rule created response
func (o *CreateRuleCreated) Code() int {
	return 201
}

func (o *CreateRuleCreated) Error() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/v1][%d] createRuleCreated  %+v", 201, o.Payload)
}

func (o *CreateRuleCreated) String() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/v1][%d] createRuleCreated  %+v", 201, o.Payload)
}

func (o *CreateRuleCreated) GetPayload() *models.APIRulesResponse {
	return o.Payload
}

func (o *CreateRuleCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.APIRulesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRuleForbidden creates a CreateRuleForbidden with default headers values
func NewCreateRuleForbidden() *CreateRuleForbidden {
	return &CreateRuleForbidden{}
}

/*
CreateRuleForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateRuleForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create rule forbidden response has a 2xx status code
func (o *CreateRuleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create rule forbidden response has a 3xx status code
func (o *CreateRuleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create rule forbidden response has a 4xx status code
func (o *CreateRuleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create rule forbidden response has a 5xx status code
func (o *CreateRuleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create rule forbidden response a status code equal to that given
func (o *CreateRuleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create rule forbidden response
func (o *CreateRuleForbidden) Code() int {
	return 403
}

func (o *CreateRuleForbidden) Error() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/v1][%d] createRuleForbidden  %+v", 403, o.Payload)
}

func (o *CreateRuleForbidden) String() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/v1][%d] createRuleForbidden  %+v", 403, o.Payload)
}

func (o *CreateRuleForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateRuleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRuleNotFound creates a CreateRuleNotFound with default headers values
func NewCreateRuleNotFound() *CreateRuleNotFound {
	return &CreateRuleNotFound{}
}

/*
CreateRuleNotFound describes a response with status code 404, with default header values.

Not Found
*/
type CreateRuleNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create rule not found response has a 2xx status code
func (o *CreateRuleNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create rule not found response has a 3xx status code
func (o *CreateRuleNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create rule not found response has a 4xx status code
func (o *CreateRuleNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this create rule not found response has a 5xx status code
func (o *CreateRuleNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this create rule not found response a status code equal to that given
func (o *CreateRuleNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the create rule not found response
func (o *CreateRuleNotFound) Code() int {
	return 404
}

func (o *CreateRuleNotFound) Error() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/v1][%d] createRuleNotFound  %+v", 404, o.Payload)
}

func (o *CreateRuleNotFound) String() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/v1][%d] createRuleNotFound  %+v", 404, o.Payload)
}

func (o *CreateRuleNotFound) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateRuleNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRuleTooManyRequests creates a CreateRuleTooManyRequests with default headers values
func NewCreateRuleTooManyRequests() *CreateRuleTooManyRequests {
	return &CreateRuleTooManyRequests{}
}

/*
CreateRuleTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateRuleTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create rule too many requests response has a 2xx status code
func (o *CreateRuleTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create rule too many requests response has a 3xx status code
func (o *CreateRuleTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create rule too many requests response has a 4xx status code
func (o *CreateRuleTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create rule too many requests response has a 5xx status code
func (o *CreateRuleTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create rule too many requests response a status code equal to that given
func (o *CreateRuleTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create rule too many requests response
func (o *CreateRuleTooManyRequests) Code() int {
	return 429
}

func (o *CreateRuleTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/v1][%d] createRuleTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateRuleTooManyRequests) String() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/v1][%d] createRuleTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateRuleTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateRuleTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
