// Code generated by go-swagger; DO NOT EDIT.

package custom_ioa

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new custom ioa API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for custom ioa API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CreateRule(params *CreateRuleParams, opts ...ClientOption) (*CreateRuleCreated, error)

	CreateRuleGroupMixin0(params *CreateRuleGroupMixin0Params, opts ...ClientOption) (*CreateRuleGroupMixin0Created, error)

	DeleteRuleGroupsMixin0(params *DeleteRuleGroupsMixin0Params, opts ...ClientOption) (*DeleteRuleGroupsMixin0OK, error)

	DeleteRules(params *DeleteRulesParams, opts ...ClientOption) (*DeleteRulesOK, error)

	GetPatterns(params *GetPatternsParams, opts ...ClientOption) (*GetPatternsOK, error)

	GetPlatformsMixin0(params *GetPlatformsMixin0Params, opts ...ClientOption) (*GetPlatformsMixin0OK, error)

	GetRuleGroupsMixin0(params *GetRuleGroupsMixin0Params, opts ...ClientOption) (*GetRuleGroupsMixin0OK, error)

	GetRuleTypes(params *GetRuleTypesParams, opts ...ClientOption) (*GetRuleTypesOK, error)

	GetRulesGet(params *GetRulesGetParams, opts ...ClientOption) (*GetRulesGetOK, error)

	GetRulesMixin0(params *GetRulesMixin0Params, opts ...ClientOption) (*GetRulesMixin0OK, error)

	QueryPatterns(params *QueryPatternsParams, opts ...ClientOption) (*QueryPatternsOK, error)

	QueryPlatformsMixin0(params *QueryPlatformsMixin0Params, opts ...ClientOption) (*QueryPlatformsMixin0OK, error)

	QueryRuleGroupsFull(params *QueryRuleGroupsFullParams, opts ...ClientOption) (*QueryRuleGroupsFullOK, error)

	QueryRuleGroupsMixin0(params *QueryRuleGroupsMixin0Params, opts ...ClientOption) (*QueryRuleGroupsMixin0OK, error)

	QueryRuleTypes(params *QueryRuleTypesParams, opts ...ClientOption) (*QueryRuleTypesOK, error)

	QueryRulesMixin0(params *QueryRulesMixin0Params, opts ...ClientOption) (*QueryRulesMixin0OK, error)

	UpdateRuleGroupMixin0(params *UpdateRuleGroupMixin0Params, opts ...ClientOption) (*UpdateRuleGroupMixin0OK, error)

	UpdateRules(params *UpdateRulesParams, opts ...ClientOption) (*UpdateRulesOK, error)

	Validate(params *ValidateParams, opts ...ClientOption) (*ValidateOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CreateRule creates a rule within a rule group returns the rule
*/
func (a *Client) CreateRule(params *CreateRuleParams, opts ...ClientOption) (*CreateRuleCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateRuleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "create-rule",
		Method:             "POST",
		PathPattern:        "/ioarules/entities/rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateRuleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateRuleCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for create-rule: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateRuleGroupMixin0 creates a rule group for a platform with a name and an optional description returns the rule group
*/
func (a *Client) CreateRuleGroupMixin0(params *CreateRuleGroupMixin0Params, opts ...ClientOption) (*CreateRuleGroupMixin0Created, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateRuleGroupMixin0Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "create-rule-groupMixin0",
		Method:             "POST",
		PathPattern:        "/ioarules/entities/rule-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateRuleGroupMixin0Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateRuleGroupMixin0Created)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for create-rule-groupMixin0: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteRuleGroupsMixin0 deletes rule groups by ID
*/
func (a *Client) DeleteRuleGroupsMixin0(params *DeleteRuleGroupsMixin0Params, opts ...ClientOption) (*DeleteRuleGroupsMixin0OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteRuleGroupsMixin0Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "delete-rule-groupsMixin0",
		Method:             "DELETE",
		PathPattern:        "/ioarules/entities/rule-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteRuleGroupsMixin0Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteRuleGroupsMixin0OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for delete-rule-groupsMixin0: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteRules deletes rules from a rule group by ID
*/
func (a *Client) DeleteRules(params *DeleteRulesParams, opts ...ClientOption) (*DeleteRulesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteRulesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "delete-rules",
		Method:             "DELETE",
		PathPattern:        "/ioarules/entities/rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteRulesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteRulesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for delete-rules: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetPatterns gets pattern severities by ID
*/
func (a *Client) GetPatterns(params *GetPatternsParams, opts ...ClientOption) (*GetPatternsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetPatternsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-patterns",
		Method:             "GET",
		PathPattern:        "/ioarules/entities/pattern-severities/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetPatternsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetPatternsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-patterns: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetPlatformsMixin0 gets platforms by ID
*/
func (a *Client) GetPlatformsMixin0(params *GetPlatformsMixin0Params, opts ...ClientOption) (*GetPlatformsMixin0OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetPlatformsMixin0Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-platformsMixin0",
		Method:             "GET",
		PathPattern:        "/ioarules/entities/platforms/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetPlatformsMixin0Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetPlatformsMixin0OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-platformsMixin0: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetRuleGroupsMixin0 gets rule groups by ID
*/
func (a *Client) GetRuleGroupsMixin0(params *GetRuleGroupsMixin0Params, opts ...ClientOption) (*GetRuleGroupsMixin0OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRuleGroupsMixin0Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-rule-groupsMixin0",
		Method:             "GET",
		PathPattern:        "/ioarules/entities/rule-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetRuleGroupsMixin0Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRuleGroupsMixin0OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-rule-groupsMixin0: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetRuleTypes gets rule types by ID
*/
func (a *Client) GetRuleTypes(params *GetRuleTypesParams, opts ...ClientOption) (*GetRuleTypesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRuleTypesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-rule-types",
		Method:             "GET",
		PathPattern:        "/ioarules/entities/rule-types/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetRuleTypesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRuleTypesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-rule-types: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetRulesGet gets rules by ID and optionally with cid and or version in the following format cid ID version
*/
func (a *Client) GetRulesGet(params *GetRulesGetParams, opts ...ClientOption) (*GetRulesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRulesGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-rules-get",
		Method:             "POST",
		PathPattern:        "/ioarules/entities/rules/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetRulesGetReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRulesGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-rules-get: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetRulesMixin0 gets rules by ID and optionally with cid and or version in the following format cid ID version the max number of i ds is constrained by URL size
*/
func (a *Client) GetRulesMixin0(params *GetRulesMixin0Params, opts ...ClientOption) (*GetRulesMixin0OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRulesMixin0Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-rulesMixin0",
		Method:             "GET",
		PathPattern:        "/ioarules/entities/rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetRulesMixin0Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRulesMixin0OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-rulesMixin0: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryPatterns gets all pattern severity i ds
*/
func (a *Client) QueryPatterns(params *QueryPatternsParams, opts ...ClientOption) (*QueryPatternsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryPatternsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-patterns",
		Method:             "GET",
		PathPattern:        "/ioarules/queries/pattern-severities/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryPatternsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryPatternsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-patterns: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryPlatformsMixin0 gets all platform i ds
*/
func (a *Client) QueryPlatformsMixin0(params *QueryPlatformsMixin0Params, opts ...ClientOption) (*QueryPlatformsMixin0OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryPlatformsMixin0Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-platformsMixin0",
		Method:             "GET",
		PathPattern:        "/ioarules/queries/platforms/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryPlatformsMixin0Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryPlatformsMixin0OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-platformsMixin0: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryRuleGroupsFull finds all rule groups matching the query with optional filter
*/
func (a *Client) QueryRuleGroupsFull(params *QueryRuleGroupsFullParams, opts ...ClientOption) (*QueryRuleGroupsFullOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryRuleGroupsFullParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-rule-groups-full",
		Method:             "GET",
		PathPattern:        "/ioarules/queries/rule-groups-full/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryRuleGroupsFullReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryRuleGroupsFullOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-rule-groups-full: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryRuleGroupsMixin0 finds all rule group i ds matching the query with optional filter
*/
func (a *Client) QueryRuleGroupsMixin0(params *QueryRuleGroupsMixin0Params, opts ...ClientOption) (*QueryRuleGroupsMixin0OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryRuleGroupsMixin0Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-rule-groupsMixin0",
		Method:             "GET",
		PathPattern:        "/ioarules/queries/rule-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryRuleGroupsMixin0Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryRuleGroupsMixin0OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-rule-groupsMixin0: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryRuleTypes gets all rule type i ds
*/
func (a *Client) QueryRuleTypes(params *QueryRuleTypesParams, opts ...ClientOption) (*QueryRuleTypesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryRuleTypesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-rule-types",
		Method:             "GET",
		PathPattern:        "/ioarules/queries/rule-types/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryRuleTypesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryRuleTypesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-rule-types: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryRulesMixin0 finds all rule i ds matching the query with optional filter
*/
func (a *Client) QueryRulesMixin0(params *QueryRulesMixin0Params, opts ...ClientOption) (*QueryRulesMixin0OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryRulesMixin0Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-rulesMixin0",
		Method:             "GET",
		PathPattern:        "/ioarules/queries/rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryRulesMixin0Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryRulesMixin0OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-rulesMixin0: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateRuleGroupMixin0 updates a rule group the following properties can be modified name description enabled
*/
func (a *Client) UpdateRuleGroupMixin0(params *UpdateRuleGroupMixin0Params, opts ...ClientOption) (*UpdateRuleGroupMixin0OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateRuleGroupMixin0Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "update-rule-groupMixin0",
		Method:             "PATCH",
		PathPattern:        "/ioarules/entities/rule-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateRuleGroupMixin0Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateRuleGroupMixin0OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for update-rule-groupMixin0: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateRules updates rules within a rule group return the updated rules
*/
func (a *Client) UpdateRules(params *UpdateRulesParams, opts ...ClientOption) (*UpdateRulesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateRulesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "update-rules",
		Method:             "PATCH",
		PathPattern:        "/ioarules/entities/rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateRulesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateRulesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for update-rules: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
Validate validates field values and checks for matches if a test string is provided
*/
func (a *Client) Validate(params *ValidateParams, opts ...ClientOption) (*ValidateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewValidateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "validate",
		Method:             "POST",
		PathPattern:        "/ioarules/entities/rules/validate/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ValidateReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ValidateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for validate: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
