// Code generated by go-swagger; DO NOT EDIT.

package custom_ioa

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetPatternsReader is a Reader for the GetPatterns structure.
type GetPatternsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetPatternsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetPatternsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetPatternsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetPatternsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /ioarules/entities/pattern-severities/v1] get-patterns", response, response.Code())
	}
}

// NewGetPatternsOK creates a GetPatternsOK with default headers values
func NewGetPatternsOK() *GetPatternsOK {
	return &GetPatternsOK{}
}

/*
GetPatternsOK describes a response with status code 200, with default header values.

OK
*/
type GetPatternsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.APIPatternsResponse
}

// IsSuccess returns true when this get patterns o k response has a 2xx status code
func (o *GetPatternsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get patterns o k response has a 3xx status code
func (o *GetPatternsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get patterns o k response has a 4xx status code
func (o *GetPatternsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get patterns o k response has a 5xx status code
func (o *GetPatternsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get patterns o k response a status code equal to that given
func (o *GetPatternsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get patterns o k response
func (o *GetPatternsOK) Code() int {
	return 200
}

func (o *GetPatternsOK) Error() string {
	return fmt.Sprintf("[GET /ioarules/entities/pattern-severities/v1][%d] getPatternsOK  %+v", 200, o.Payload)
}

func (o *GetPatternsOK) String() string {
	return fmt.Sprintf("[GET /ioarules/entities/pattern-severities/v1][%d] getPatternsOK  %+v", 200, o.Payload)
}

func (o *GetPatternsOK) GetPayload() *models.APIPatternsResponse {
	return o.Payload
}

func (o *GetPatternsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.APIPatternsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPatternsForbidden creates a GetPatternsForbidden with default headers values
func NewGetPatternsForbidden() *GetPatternsForbidden {
	return &GetPatternsForbidden{}
}

/*
GetPatternsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetPatternsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get patterns forbidden response has a 2xx status code
func (o *GetPatternsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get patterns forbidden response has a 3xx status code
func (o *GetPatternsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get patterns forbidden response has a 4xx status code
func (o *GetPatternsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get patterns forbidden response has a 5xx status code
func (o *GetPatternsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get patterns forbidden response a status code equal to that given
func (o *GetPatternsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get patterns forbidden response
func (o *GetPatternsForbidden) Code() int {
	return 403
}

func (o *GetPatternsForbidden) Error() string {
	return fmt.Sprintf("[GET /ioarules/entities/pattern-severities/v1][%d] getPatternsForbidden  %+v", 403, o.Payload)
}

func (o *GetPatternsForbidden) String() string {
	return fmt.Sprintf("[GET /ioarules/entities/pattern-severities/v1][%d] getPatternsForbidden  %+v", 403, o.Payload)
}

func (o *GetPatternsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetPatternsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPatternsTooManyRequests creates a GetPatternsTooManyRequests with default headers values
func NewGetPatternsTooManyRequests() *GetPatternsTooManyRequests {
	return &GetPatternsTooManyRequests{}
}

/*
GetPatternsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetPatternsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get patterns too many requests response has a 2xx status code
func (o *GetPatternsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get patterns too many requests response has a 3xx status code
func (o *GetPatternsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get patterns too many requests response has a 4xx status code
func (o *GetPatternsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get patterns too many requests response has a 5xx status code
func (o *GetPatternsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get patterns too many requests response a status code equal to that given
func (o *GetPatternsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get patterns too many requests response
func (o *GetPatternsTooManyRequests) Code() int {
	return 429
}

func (o *GetPatternsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /ioarules/entities/pattern-severities/v1][%d] getPatternsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetPatternsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /ioarules/entities/pattern-severities/v1][%d] getPatternsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetPatternsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetPatternsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
