// Code generated by go-swagger; DO NOT EDIT.

package custom_ioa

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetRuleTypesParams creates a new GetRuleTypesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetRuleTypesParams() *GetRuleTypesParams {
	return &GetRuleTypesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetRuleTypesParamsWithTimeout creates a new GetRuleTypesParams object
// with the ability to set a timeout on a request.
func NewGetRuleTypesParamsWithTimeout(timeout time.Duration) *GetRuleTypesParams {
	return &GetRuleTypesParams{
		timeout: timeout,
	}
}

// NewGetRuleTypesParamsWithContext creates a new GetRuleTypesParams object
// with the ability to set a context for a request.
func NewGetRuleTypesParamsWithContext(ctx context.Context) *GetRuleTypesParams {
	return &GetRuleTypesParams{
		Context: ctx,
	}
}

// NewGetRuleTypesParamsWithHTTPClient creates a new GetRuleTypesParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetRuleTypesParamsWithHTTPClient(client *http.Client) *GetRuleTypesParams {
	return &GetRuleTypesParams{
		HTTPClient: client,
	}
}

/*
GetRuleTypesParams contains all the parameters to send to the API endpoint

	for the get rule types operation.

	Typically these are written to a http.Request.
*/
type GetRuleTypesParams struct {

	/* Ids.

	   The IDs of the entities
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get rule types params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetRuleTypesParams) WithDefaults() *GetRuleTypesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get rule types params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetRuleTypesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get rule types params
func (o *GetRuleTypesParams) WithTimeout(timeout time.Duration) *GetRuleTypesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get rule types params
func (o *GetRuleTypesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get rule types params
func (o *GetRuleTypesParams) WithContext(ctx context.Context) *GetRuleTypesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get rule types params
func (o *GetRuleTypesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get rule types params
func (o *GetRuleTypesParams) WithHTTPClient(client *http.Client) *GetRuleTypesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get rule types params
func (o *GetRuleTypesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get rule types params
func (o *GetRuleTypesParams) WithIds(ids []string) *GetRuleTypesParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get rule types params
func (o *GetRuleTypesParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetRuleTypesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetRuleTypes binds the parameter ids
func (o *GetRuleTypesParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
