// Code generated by go-swagger; DO NOT EDIT.

package custom_ioa

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryPatternsParams creates a new QueryPatternsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryPatternsParams() *QueryPatternsParams {
	return &QueryPatternsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryPatternsParamsWithTimeout creates a new QueryPatternsParams object
// with the ability to set a timeout on a request.
func NewQueryPatternsParamsWithTimeout(timeout time.Duration) *QueryPatternsParams {
	return &QueryPatternsParams{
		timeout: timeout,
	}
}

// NewQueryPatternsParamsWithContext creates a new QueryPatternsParams object
// with the ability to set a context for a request.
func NewQueryPatternsParamsWithContext(ctx context.Context) *QueryPatternsParams {
	return &QueryPatternsParams{
		Context: ctx,
	}
}

// NewQueryPatternsParamsWithHTTPClient creates a new QueryPatternsParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryPatternsParamsWithHTTPClient(client *http.Client) *QueryPatternsParams {
	return &QueryPatternsParams{
		HTTPClient: client,
	}
}

/*
QueryPatternsParams contains all the parameters to send to the API endpoint

	for the query patterns operation.

	Typically these are written to a http.Request.
*/
type QueryPatternsParams struct {

	/* Limit.

	   Number of IDs to return
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return IDs
	*/
	Offset *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query patterns params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryPatternsParams) WithDefaults() *QueryPatternsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query patterns params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryPatternsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query patterns params
func (o *QueryPatternsParams) WithTimeout(timeout time.Duration) *QueryPatternsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query patterns params
func (o *QueryPatternsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query patterns params
func (o *QueryPatternsParams) WithContext(ctx context.Context) *QueryPatternsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query patterns params
func (o *QueryPatternsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query patterns params
func (o *QueryPatternsParams) WithHTTPClient(client *http.Client) *QueryPatternsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query patterns params
func (o *QueryPatternsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLimit adds the limit to the query patterns params
func (o *QueryPatternsParams) WithLimit(limit *int64) *QueryPatternsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query patterns params
func (o *QueryPatternsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query patterns params
func (o *QueryPatternsParams) WithOffset(offset *string) *QueryPatternsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query patterns params
func (o *QueryPatternsParams) SetOffset(offset *string) {
	o.Offset = offset
}

// WriteToRequest writes these params to a swagger request
func (o *QueryPatternsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
