// Code generated by go-swagger; DO NOT EDIT.

package custom_ioa

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryPatternsReader is a Reader for the QueryPatterns structure.
type QueryPatternsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryPatternsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryPatternsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewQueryPatternsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryPatternsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /ioarules/queries/pattern-severities/v1] query-patterns", response, response.Code())
	}
}

// NewQueryPatternsOK creates a QueryPatternsOK with default headers values
func NewQueryPatternsOK() *QueryPatternsOK {
	return &QueryPatternsOK{}
}

/*
QueryPatternsOK describes a response with status code 200, with default header values.

OK
*/
type QueryPatternsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query patterns o k response has a 2xx status code
func (o *QueryPatternsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query patterns o k response has a 3xx status code
func (o *QueryPatternsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query patterns o k response has a 4xx status code
func (o *QueryPatternsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query patterns o k response has a 5xx status code
func (o *QueryPatternsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query patterns o k response a status code equal to that given
func (o *QueryPatternsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query patterns o k response
func (o *QueryPatternsOK) Code() int {
	return 200
}

func (o *QueryPatternsOK) Error() string {
	return fmt.Sprintf("[GET /ioarules/queries/pattern-severities/v1][%d] queryPatternsOK  %+v", 200, o.Payload)
}

func (o *QueryPatternsOK) String() string {
	return fmt.Sprintf("[GET /ioarules/queries/pattern-severities/v1][%d] queryPatternsOK  %+v", 200, o.Payload)
}

func (o *QueryPatternsOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryPatternsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryPatternsForbidden creates a QueryPatternsForbidden with default headers values
func NewQueryPatternsForbidden() *QueryPatternsForbidden {
	return &QueryPatternsForbidden{}
}

/*
QueryPatternsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryPatternsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query patterns forbidden response has a 2xx status code
func (o *QueryPatternsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query patterns forbidden response has a 3xx status code
func (o *QueryPatternsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query patterns forbidden response has a 4xx status code
func (o *QueryPatternsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query patterns forbidden response has a 5xx status code
func (o *QueryPatternsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query patterns forbidden response a status code equal to that given
func (o *QueryPatternsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query patterns forbidden response
func (o *QueryPatternsForbidden) Code() int {
	return 403
}

func (o *QueryPatternsForbidden) Error() string {
	return fmt.Sprintf("[GET /ioarules/queries/pattern-severities/v1][%d] queryPatternsForbidden  %+v", 403, o.Payload)
}

func (o *QueryPatternsForbidden) String() string {
	return fmt.Sprintf("[GET /ioarules/queries/pattern-severities/v1][%d] queryPatternsForbidden  %+v", 403, o.Payload)
}

func (o *QueryPatternsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryPatternsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryPatternsTooManyRequests creates a QueryPatternsTooManyRequests with default headers values
func NewQueryPatternsTooManyRequests() *QueryPatternsTooManyRequests {
	return &QueryPatternsTooManyRequests{}
}

/*
QueryPatternsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryPatternsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query patterns too many requests response has a 2xx status code
func (o *QueryPatternsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query patterns too many requests response has a 3xx status code
func (o *QueryPatternsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query patterns too many requests response has a 4xx status code
func (o *QueryPatternsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query patterns too many requests response has a 5xx status code
func (o *QueryPatternsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query patterns too many requests response a status code equal to that given
func (o *QueryPatternsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query patterns too many requests response
func (o *QueryPatternsTooManyRequests) Code() int {
	return 429
}

func (o *QueryPatternsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /ioarules/queries/pattern-severities/v1][%d] queryPatternsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryPatternsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /ioarules/queries/pattern-severities/v1][%d] queryPatternsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryPatternsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryPatternsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
