// Code generated by go-swagger; DO NOT EDIT.

package custom_ioa

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryRuleTypesParams creates a new QueryRuleTypesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryRuleTypesParams() *QueryRuleTypesParams {
	return &QueryRuleTypesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryRuleTypesParamsWithTimeout creates a new QueryRuleTypesParams object
// with the ability to set a timeout on a request.
func NewQueryRuleTypesParamsWithTimeout(timeout time.Duration) *QueryRuleTypesParams {
	return &QueryRuleTypesParams{
		timeout: timeout,
	}
}

// NewQueryRuleTypesParamsWithContext creates a new QueryRuleTypesParams object
// with the ability to set a context for a request.
func NewQueryRuleTypesParamsWithContext(ctx context.Context) *QueryRuleTypesParams {
	return &QueryRuleTypesParams{
		Context: ctx,
	}
}

// NewQueryRuleTypesParamsWithHTTPClient creates a new QueryRuleTypesParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryRuleTypesParamsWithHTTPClient(client *http.Client) *QueryRuleTypesParams {
	return &QueryRuleTypesParams{
		HTTPClient: client,
	}
}

/*
QueryRuleTypesParams contains all the parameters to send to the API endpoint

	for the query rule types operation.

	Typically these are written to a http.Request.
*/
type QueryRuleTypesParams struct {

	/* Limit.

	   Number of IDs to return
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return IDs
	*/
	Offset *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query rule types params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryRuleTypesParams) WithDefaults() *QueryRuleTypesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query rule types params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryRuleTypesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query rule types params
func (o *QueryRuleTypesParams) WithTimeout(timeout time.Duration) *QueryRuleTypesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query rule types params
func (o *QueryRuleTypesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query rule types params
func (o *QueryRuleTypesParams) WithContext(ctx context.Context) *QueryRuleTypesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query rule types params
func (o *QueryRuleTypesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query rule types params
func (o *QueryRuleTypesParams) WithHTTPClient(client *http.Client) *QueryRuleTypesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query rule types params
func (o *QueryRuleTypesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLimit adds the limit to the query rule types params
func (o *QueryRuleTypesParams) WithLimit(limit *int64) *QueryRuleTypesParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query rule types params
func (o *QueryRuleTypesParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query rule types params
func (o *QueryRuleTypesParams) WithOffset(offset *string) *QueryRuleTypesParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query rule types params
func (o *QueryRuleTypesParams) SetOffset(offset *string) {
	o.Offset = offset
}

// WriteToRequest writes these params to a swagger request
func (o *QueryRuleTypesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
