// Code generated by go-swagger; DO NOT EDIT.

package custom_ioa

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// ValidateReader is a Reader for the Validate structure.
type ValidateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ValidateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewValidateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewValidateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewValidateNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewValidateTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /ioarules/entities/rules/validate/v1] validate", response, response.Code())
	}
}

// NewValidateOK creates a ValidateOK with default headers values
func NewValidateOK() *ValidateOK {
	return &ValidateOK{}
}

/*
ValidateOK describes a response with status code 200, with default header values.

OK
*/
type ValidateOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.APIValidationResponseV1
}

// IsSuccess returns true when this validate o k response has a 2xx status code
func (o *ValidateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this validate o k response has a 3xx status code
func (o *ValidateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this validate o k response has a 4xx status code
func (o *ValidateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this validate o k response has a 5xx status code
func (o *ValidateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this validate o k response a status code equal to that given
func (o *ValidateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the validate o k response
func (o *ValidateOK) Code() int {
	return 200
}

func (o *ValidateOK) Error() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/validate/v1][%d] validateOK  %+v", 200, o.Payload)
}

func (o *ValidateOK) String() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/validate/v1][%d] validateOK  %+v", 200, o.Payload)
}

func (o *ValidateOK) GetPayload() *models.APIValidationResponseV1 {
	return o.Payload
}

func (o *ValidateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.APIValidationResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewValidateForbidden creates a ValidateForbidden with default headers values
func NewValidateForbidden() *ValidateForbidden {
	return &ValidateForbidden{}
}

/*
ValidateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ValidateForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this validate forbidden response has a 2xx status code
func (o *ValidateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this validate forbidden response has a 3xx status code
func (o *ValidateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this validate forbidden response has a 4xx status code
func (o *ValidateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this validate forbidden response has a 5xx status code
func (o *ValidateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this validate forbidden response a status code equal to that given
func (o *ValidateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the validate forbidden response
func (o *ValidateForbidden) Code() int {
	return 403
}

func (o *ValidateForbidden) Error() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/validate/v1][%d] validateForbidden  %+v", 403, o.Payload)
}

func (o *ValidateForbidden) String() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/validate/v1][%d] validateForbidden  %+v", 403, o.Payload)
}

func (o *ValidateForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ValidateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewValidateNotFound creates a ValidateNotFound with default headers values
func NewValidateNotFound() *ValidateNotFound {
	return &ValidateNotFound{}
}

/*
ValidateNotFound describes a response with status code 404, with default header values.

Not Found
*/
type ValidateNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this validate not found response has a 2xx status code
func (o *ValidateNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this validate not found response has a 3xx status code
func (o *ValidateNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this validate not found response has a 4xx status code
func (o *ValidateNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this validate not found response has a 5xx status code
func (o *ValidateNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this validate not found response a status code equal to that given
func (o *ValidateNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the validate not found response
func (o *ValidateNotFound) Code() int {
	return 404
}

func (o *ValidateNotFound) Error() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/validate/v1][%d] validateNotFound  %+v", 404, o.Payload)
}

func (o *ValidateNotFound) String() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/validate/v1][%d] validateNotFound  %+v", 404, o.Payload)
}

func (o *ValidateNotFound) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ValidateNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewValidateTooManyRequests creates a ValidateTooManyRequests with default headers values
func NewValidateTooManyRequests() *ValidateTooManyRequests {
	return &ValidateTooManyRequests{}
}

/*
ValidateTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type ValidateTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this validate too many requests response has a 2xx status code
func (o *ValidateTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this validate too many requests response has a 3xx status code
func (o *ValidateTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this validate too many requests response has a 4xx status code
func (o *ValidateTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this validate too many requests response has a 5xx status code
func (o *ValidateTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this validate too many requests response a status code equal to that given
func (o *ValidateTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the validate too many requests response
func (o *ValidateTooManyRequests) Code() int {
	return 429
}

func (o *ValidateTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/validate/v1][%d] validateTooManyRequests  %+v", 429, o.Payload)
}

func (o *ValidateTooManyRequests) String() string {
	return fmt.Sprintf("[POST /ioarules/entities/rules/validate/v1][%d] validateTooManyRequests  %+v", 429, o.Payload)
}

func (o *ValidateTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ValidateTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
