// Code generated by go-swagger; DO NOT EDIT.

package d4c_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateD4CGcpAccountReader is a Reader for the CreateD4CGcpAccount structure.
type CreateD4CGcpAccountReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateD4CGcpAccountReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreateD4CGcpAccountCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewCreateD4CGcpAccountMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateD4CGcpAccountBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateD4CGcpAccountForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateD4CGcpAccountTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateD4CGcpAccountInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /cloud-connect-gcp/entities/account/v1] CreateD4CGcpAccount", response, response.Code())
	}
}

// NewCreateD4CGcpAccountCreated creates a CreateD4CGcpAccountCreated with default headers values
func NewCreateD4CGcpAccountCreated() *CreateD4CGcpAccountCreated {
	return &CreateD4CGcpAccountCreated{}
}

/*
CreateD4CGcpAccountCreated describes a response with status code 201, with default header values.

Created
*/
type CreateD4CGcpAccountCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationGCPAccountResponseV1
}

// IsSuccess returns true when this create d4 c gcp account created response has a 2xx status code
func (o *CreateD4CGcpAccountCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create d4 c gcp account created response has a 3xx status code
func (o *CreateD4CGcpAccountCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create d4 c gcp account created response has a 4xx status code
func (o *CreateD4CGcpAccountCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create d4 c gcp account created response has a 5xx status code
func (o *CreateD4CGcpAccountCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create d4 c gcp account created response a status code equal to that given
func (o *CreateD4CGcpAccountCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create d4 c gcp account created response
func (o *CreateD4CGcpAccountCreated) Code() int {
	return 201
}

func (o *CreateD4CGcpAccountCreated) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-gcp/entities/account/v1][%d] createD4CGcpAccountCreated  %+v", 201, o.Payload)
}

func (o *CreateD4CGcpAccountCreated) String() string {
	return fmt.Sprintf("[POST /cloud-connect-gcp/entities/account/v1][%d] createD4CGcpAccountCreated  %+v", 201, o.Payload)
}

func (o *CreateD4CGcpAccountCreated) GetPayload() *models.RegistrationGCPAccountResponseV1 {
	return o.Payload
}

func (o *CreateD4CGcpAccountCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationGCPAccountResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateD4CGcpAccountMultiStatus creates a CreateD4CGcpAccountMultiStatus with default headers values
func NewCreateD4CGcpAccountMultiStatus() *CreateD4CGcpAccountMultiStatus {
	return &CreateD4CGcpAccountMultiStatus{}
}

/*
CreateD4CGcpAccountMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type CreateD4CGcpAccountMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationGCPAccountResponseV1
}

// IsSuccess returns true when this create d4 c gcp account multi status response has a 2xx status code
func (o *CreateD4CGcpAccountMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create d4 c gcp account multi status response has a 3xx status code
func (o *CreateD4CGcpAccountMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create d4 c gcp account multi status response has a 4xx status code
func (o *CreateD4CGcpAccountMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this create d4 c gcp account multi status response has a 5xx status code
func (o *CreateD4CGcpAccountMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this create d4 c gcp account multi status response a status code equal to that given
func (o *CreateD4CGcpAccountMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the create d4 c gcp account multi status response
func (o *CreateD4CGcpAccountMultiStatus) Code() int {
	return 207
}

func (o *CreateD4CGcpAccountMultiStatus) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-gcp/entities/account/v1][%d] createD4CGcpAccountMultiStatus  %+v", 207, o.Payload)
}

func (o *CreateD4CGcpAccountMultiStatus) String() string {
	return fmt.Sprintf("[POST /cloud-connect-gcp/entities/account/v1][%d] createD4CGcpAccountMultiStatus  %+v", 207, o.Payload)
}

func (o *CreateD4CGcpAccountMultiStatus) GetPayload() *models.RegistrationGCPAccountResponseV1 {
	return o.Payload
}

func (o *CreateD4CGcpAccountMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationGCPAccountResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateD4CGcpAccountBadRequest creates a CreateD4CGcpAccountBadRequest with default headers values
func NewCreateD4CGcpAccountBadRequest() *CreateD4CGcpAccountBadRequest {
	return &CreateD4CGcpAccountBadRequest{}
}

/*
CreateD4CGcpAccountBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreateD4CGcpAccountBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationGCPAccountResponseV1
}

// IsSuccess returns true when this create d4 c gcp account bad request response has a 2xx status code
func (o *CreateD4CGcpAccountBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create d4 c gcp account bad request response has a 3xx status code
func (o *CreateD4CGcpAccountBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create d4 c gcp account bad request response has a 4xx status code
func (o *CreateD4CGcpAccountBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create d4 c gcp account bad request response has a 5xx status code
func (o *CreateD4CGcpAccountBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create d4 c gcp account bad request response a status code equal to that given
func (o *CreateD4CGcpAccountBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create d4 c gcp account bad request response
func (o *CreateD4CGcpAccountBadRequest) Code() int {
	return 400
}

func (o *CreateD4CGcpAccountBadRequest) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-gcp/entities/account/v1][%d] createD4CGcpAccountBadRequest  %+v", 400, o.Payload)
}

func (o *CreateD4CGcpAccountBadRequest) String() string {
	return fmt.Sprintf("[POST /cloud-connect-gcp/entities/account/v1][%d] createD4CGcpAccountBadRequest  %+v", 400, o.Payload)
}

func (o *CreateD4CGcpAccountBadRequest) GetPayload() *models.RegistrationGCPAccountResponseV1 {
	return o.Payload
}

func (o *CreateD4CGcpAccountBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationGCPAccountResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateD4CGcpAccountForbidden creates a CreateD4CGcpAccountForbidden with default headers values
func NewCreateD4CGcpAccountForbidden() *CreateD4CGcpAccountForbidden {
	return &CreateD4CGcpAccountForbidden{}
}

/*
CreateD4CGcpAccountForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateD4CGcpAccountForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create d4 c gcp account forbidden response has a 2xx status code
func (o *CreateD4CGcpAccountForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create d4 c gcp account forbidden response has a 3xx status code
func (o *CreateD4CGcpAccountForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create d4 c gcp account forbidden response has a 4xx status code
func (o *CreateD4CGcpAccountForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create d4 c gcp account forbidden response has a 5xx status code
func (o *CreateD4CGcpAccountForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create d4 c gcp account forbidden response a status code equal to that given
func (o *CreateD4CGcpAccountForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create d4 c gcp account forbidden response
func (o *CreateD4CGcpAccountForbidden) Code() int {
	return 403
}

func (o *CreateD4CGcpAccountForbidden) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-gcp/entities/account/v1][%d] createD4CGcpAccountForbidden  %+v", 403, o.Payload)
}

func (o *CreateD4CGcpAccountForbidden) String() string {
	return fmt.Sprintf("[POST /cloud-connect-gcp/entities/account/v1][%d] createD4CGcpAccountForbidden  %+v", 403, o.Payload)
}

func (o *CreateD4CGcpAccountForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateD4CGcpAccountForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateD4CGcpAccountTooManyRequests creates a CreateD4CGcpAccountTooManyRequests with default headers values
func NewCreateD4CGcpAccountTooManyRequests() *CreateD4CGcpAccountTooManyRequests {
	return &CreateD4CGcpAccountTooManyRequests{}
}

/*
CreateD4CGcpAccountTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateD4CGcpAccountTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create d4 c gcp account too many requests response has a 2xx status code
func (o *CreateD4CGcpAccountTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create d4 c gcp account too many requests response has a 3xx status code
func (o *CreateD4CGcpAccountTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create d4 c gcp account too many requests response has a 4xx status code
func (o *CreateD4CGcpAccountTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create d4 c gcp account too many requests response has a 5xx status code
func (o *CreateD4CGcpAccountTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create d4 c gcp account too many requests response a status code equal to that given
func (o *CreateD4CGcpAccountTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create d4 c gcp account too many requests response
func (o *CreateD4CGcpAccountTooManyRequests) Code() int {
	return 429
}

func (o *CreateD4CGcpAccountTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-gcp/entities/account/v1][%d] createD4CGcpAccountTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateD4CGcpAccountTooManyRequests) String() string {
	return fmt.Sprintf("[POST /cloud-connect-gcp/entities/account/v1][%d] createD4CGcpAccountTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateD4CGcpAccountTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateD4CGcpAccountTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateD4CGcpAccountInternalServerError creates a CreateD4CGcpAccountInternalServerError with default headers values
func NewCreateD4CGcpAccountInternalServerError() *CreateD4CGcpAccountInternalServerError {
	return &CreateD4CGcpAccountInternalServerError{}
}

/*
CreateD4CGcpAccountInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CreateD4CGcpAccountInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationGCPAccountResponseV1
}

// IsSuccess returns true when this create d4 c gcp account internal server error response has a 2xx status code
func (o *CreateD4CGcpAccountInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create d4 c gcp account internal server error response has a 3xx status code
func (o *CreateD4CGcpAccountInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create d4 c gcp account internal server error response has a 4xx status code
func (o *CreateD4CGcpAccountInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create d4 c gcp account internal server error response has a 5xx status code
func (o *CreateD4CGcpAccountInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create d4 c gcp account internal server error response a status code equal to that given
func (o *CreateD4CGcpAccountInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create d4 c gcp account internal server error response
func (o *CreateD4CGcpAccountInternalServerError) Code() int {
	return 500
}

func (o *CreateD4CGcpAccountInternalServerError) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-gcp/entities/account/v1][%d] createD4CGcpAccountInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateD4CGcpAccountInternalServerError) String() string {
	return fmt.Sprintf("[POST /cloud-connect-gcp/entities/account/v1][%d] createD4CGcpAccountInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateD4CGcpAccountInternalServerError) GetPayload() *models.RegistrationGCPAccountResponseV1 {
	return o.Payload
}

func (o *CreateD4CGcpAccountInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationGCPAccountResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
