// Code generated by go-swagger; DO NOT EDIT.

package d4c_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateDiscoverCloudAzureAccountReader is a Reader for the CreateDiscoverCloudAzureAccount structure.
type CreateDiscoverCloudAzureAccountReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateDiscoverCloudAzureAccountReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreateDiscoverCloudAzureAccountCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewCreateDiscoverCloudAzureAccountMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateDiscoverCloudAzureAccountBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateDiscoverCloudAzureAccountForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateDiscoverCloudAzureAccountTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateDiscoverCloudAzureAccountInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /cloud-connect-azure/entities/account/v1] CreateDiscoverCloudAzureAccount", response, response.Code())
	}
}

// NewCreateDiscoverCloudAzureAccountCreated creates a CreateDiscoverCloudAzureAccountCreated with default headers values
func NewCreateDiscoverCloudAzureAccountCreated() *CreateDiscoverCloudAzureAccountCreated {
	return &CreateDiscoverCloudAzureAccountCreated{}
}

/*
CreateDiscoverCloudAzureAccountCreated describes a response with status code 201, with default header values.

Created
*/
type CreateDiscoverCloudAzureAccountCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureAccountResponseV1
}

// IsSuccess returns true when this create discover cloud azure account created response has a 2xx status code
func (o *CreateDiscoverCloudAzureAccountCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create discover cloud azure account created response has a 3xx status code
func (o *CreateDiscoverCloudAzureAccountCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create discover cloud azure account created response has a 4xx status code
func (o *CreateDiscoverCloudAzureAccountCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create discover cloud azure account created response has a 5xx status code
func (o *CreateDiscoverCloudAzureAccountCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create discover cloud azure account created response a status code equal to that given
func (o *CreateDiscoverCloudAzureAccountCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create discover cloud azure account created response
func (o *CreateDiscoverCloudAzureAccountCreated) Code() int {
	return 201
}

func (o *CreateDiscoverCloudAzureAccountCreated) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-azure/entities/account/v1][%d] createDiscoverCloudAzureAccountCreated  %+v", 201, o.Payload)
}

func (o *CreateDiscoverCloudAzureAccountCreated) String() string {
	return fmt.Sprintf("[POST /cloud-connect-azure/entities/account/v1][%d] createDiscoverCloudAzureAccountCreated  %+v", 201, o.Payload)
}

func (o *CreateDiscoverCloudAzureAccountCreated) GetPayload() *models.RegistrationAzureAccountResponseV1 {
	return o.Payload
}

func (o *CreateDiscoverCloudAzureAccountCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureAccountResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateDiscoverCloudAzureAccountMultiStatus creates a CreateDiscoverCloudAzureAccountMultiStatus with default headers values
func NewCreateDiscoverCloudAzureAccountMultiStatus() *CreateDiscoverCloudAzureAccountMultiStatus {
	return &CreateDiscoverCloudAzureAccountMultiStatus{}
}

/*
CreateDiscoverCloudAzureAccountMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type CreateDiscoverCloudAzureAccountMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureAccountResponseV1
}

// IsSuccess returns true when this create discover cloud azure account multi status response has a 2xx status code
func (o *CreateDiscoverCloudAzureAccountMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create discover cloud azure account multi status response has a 3xx status code
func (o *CreateDiscoverCloudAzureAccountMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create discover cloud azure account multi status response has a 4xx status code
func (o *CreateDiscoverCloudAzureAccountMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this create discover cloud azure account multi status response has a 5xx status code
func (o *CreateDiscoverCloudAzureAccountMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this create discover cloud azure account multi status response a status code equal to that given
func (o *CreateDiscoverCloudAzureAccountMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the create discover cloud azure account multi status response
func (o *CreateDiscoverCloudAzureAccountMultiStatus) Code() int {
	return 207
}

func (o *CreateDiscoverCloudAzureAccountMultiStatus) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-azure/entities/account/v1][%d] createDiscoverCloudAzureAccountMultiStatus  %+v", 207, o.Payload)
}

func (o *CreateDiscoverCloudAzureAccountMultiStatus) String() string {
	return fmt.Sprintf("[POST /cloud-connect-azure/entities/account/v1][%d] createDiscoverCloudAzureAccountMultiStatus  %+v", 207, o.Payload)
}

func (o *CreateDiscoverCloudAzureAccountMultiStatus) GetPayload() *models.RegistrationAzureAccountResponseV1 {
	return o.Payload
}

func (o *CreateDiscoverCloudAzureAccountMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureAccountResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateDiscoverCloudAzureAccountBadRequest creates a CreateDiscoverCloudAzureAccountBadRequest with default headers values
func NewCreateDiscoverCloudAzureAccountBadRequest() *CreateDiscoverCloudAzureAccountBadRequest {
	return &CreateDiscoverCloudAzureAccountBadRequest{}
}

/*
CreateDiscoverCloudAzureAccountBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreateDiscoverCloudAzureAccountBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureAccountResponseV1
}

// IsSuccess returns true when this create discover cloud azure account bad request response has a 2xx status code
func (o *CreateDiscoverCloudAzureAccountBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create discover cloud azure account bad request response has a 3xx status code
func (o *CreateDiscoverCloudAzureAccountBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create discover cloud azure account bad request response has a 4xx status code
func (o *CreateDiscoverCloudAzureAccountBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create discover cloud azure account bad request response has a 5xx status code
func (o *CreateDiscoverCloudAzureAccountBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create discover cloud azure account bad request response a status code equal to that given
func (o *CreateDiscoverCloudAzureAccountBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create discover cloud azure account bad request response
func (o *CreateDiscoverCloudAzureAccountBadRequest) Code() int {
	return 400
}

func (o *CreateDiscoverCloudAzureAccountBadRequest) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-azure/entities/account/v1][%d] createDiscoverCloudAzureAccountBadRequest  %+v", 400, o.Payload)
}

func (o *CreateDiscoverCloudAzureAccountBadRequest) String() string {
	return fmt.Sprintf("[POST /cloud-connect-azure/entities/account/v1][%d] createDiscoverCloudAzureAccountBadRequest  %+v", 400, o.Payload)
}

func (o *CreateDiscoverCloudAzureAccountBadRequest) GetPayload() *models.RegistrationAzureAccountResponseV1 {
	return o.Payload
}

func (o *CreateDiscoverCloudAzureAccountBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureAccountResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateDiscoverCloudAzureAccountForbidden creates a CreateDiscoverCloudAzureAccountForbidden with default headers values
func NewCreateDiscoverCloudAzureAccountForbidden() *CreateDiscoverCloudAzureAccountForbidden {
	return &CreateDiscoverCloudAzureAccountForbidden{}
}

/*
CreateDiscoverCloudAzureAccountForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateDiscoverCloudAzureAccountForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create discover cloud azure account forbidden response has a 2xx status code
func (o *CreateDiscoverCloudAzureAccountForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create discover cloud azure account forbidden response has a 3xx status code
func (o *CreateDiscoverCloudAzureAccountForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create discover cloud azure account forbidden response has a 4xx status code
func (o *CreateDiscoverCloudAzureAccountForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create discover cloud azure account forbidden response has a 5xx status code
func (o *CreateDiscoverCloudAzureAccountForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create discover cloud azure account forbidden response a status code equal to that given
func (o *CreateDiscoverCloudAzureAccountForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create discover cloud azure account forbidden response
func (o *CreateDiscoverCloudAzureAccountForbidden) Code() int {
	return 403
}

func (o *CreateDiscoverCloudAzureAccountForbidden) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-azure/entities/account/v1][%d] createDiscoverCloudAzureAccountForbidden  %+v", 403, o.Payload)
}

func (o *CreateDiscoverCloudAzureAccountForbidden) String() string {
	return fmt.Sprintf("[POST /cloud-connect-azure/entities/account/v1][%d] createDiscoverCloudAzureAccountForbidden  %+v", 403, o.Payload)
}

func (o *CreateDiscoverCloudAzureAccountForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateDiscoverCloudAzureAccountForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateDiscoverCloudAzureAccountTooManyRequests creates a CreateDiscoverCloudAzureAccountTooManyRequests with default headers values
func NewCreateDiscoverCloudAzureAccountTooManyRequests() *CreateDiscoverCloudAzureAccountTooManyRequests {
	return &CreateDiscoverCloudAzureAccountTooManyRequests{}
}

/*
CreateDiscoverCloudAzureAccountTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateDiscoverCloudAzureAccountTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create discover cloud azure account too many requests response has a 2xx status code
func (o *CreateDiscoverCloudAzureAccountTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create discover cloud azure account too many requests response has a 3xx status code
func (o *CreateDiscoverCloudAzureAccountTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create discover cloud azure account too many requests response has a 4xx status code
func (o *CreateDiscoverCloudAzureAccountTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create discover cloud azure account too many requests response has a 5xx status code
func (o *CreateDiscoverCloudAzureAccountTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create discover cloud azure account too many requests response a status code equal to that given
func (o *CreateDiscoverCloudAzureAccountTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create discover cloud azure account too many requests response
func (o *CreateDiscoverCloudAzureAccountTooManyRequests) Code() int {
	return 429
}

func (o *CreateDiscoverCloudAzureAccountTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-azure/entities/account/v1][%d] createDiscoverCloudAzureAccountTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateDiscoverCloudAzureAccountTooManyRequests) String() string {
	return fmt.Sprintf("[POST /cloud-connect-azure/entities/account/v1][%d] createDiscoverCloudAzureAccountTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateDiscoverCloudAzureAccountTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateDiscoverCloudAzureAccountTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateDiscoverCloudAzureAccountInternalServerError creates a CreateDiscoverCloudAzureAccountInternalServerError with default headers values
func NewCreateDiscoverCloudAzureAccountInternalServerError() *CreateDiscoverCloudAzureAccountInternalServerError {
	return &CreateDiscoverCloudAzureAccountInternalServerError{}
}

/*
CreateDiscoverCloudAzureAccountInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CreateDiscoverCloudAzureAccountInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureAccountResponseV1
}

// IsSuccess returns true when this create discover cloud azure account internal server error response has a 2xx status code
func (o *CreateDiscoverCloudAzureAccountInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create discover cloud azure account internal server error response has a 3xx status code
func (o *CreateDiscoverCloudAzureAccountInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create discover cloud azure account internal server error response has a 4xx status code
func (o *CreateDiscoverCloudAzureAccountInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create discover cloud azure account internal server error response has a 5xx status code
func (o *CreateDiscoverCloudAzureAccountInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create discover cloud azure account internal server error response a status code equal to that given
func (o *CreateDiscoverCloudAzureAccountInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create discover cloud azure account internal server error response
func (o *CreateDiscoverCloudAzureAccountInternalServerError) Code() int {
	return 500
}

func (o *CreateDiscoverCloudAzureAccountInternalServerError) Error() string {
	return fmt.Sprintf("[POST /cloud-connect-azure/entities/account/v1][%d] createDiscoverCloudAzureAccountInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateDiscoverCloudAzureAccountInternalServerError) String() string {
	return fmt.Sprintf("[POST /cloud-connect-azure/entities/account/v1][%d] createDiscoverCloudAzureAccountInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateDiscoverCloudAzureAccountInternalServerError) GetPayload() *models.RegistrationAzureAccountResponseV1 {
	return o.Payload
}

func (o *CreateDiscoverCloudAzureAccountInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureAccountResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
