// Code generated by go-swagger; DO NOT EDIT.

package d4c_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteD4CAwsAccountParams creates a new DeleteD4CAwsAccountParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteD4CAwsAccountParams() *DeleteD4CAwsAccountParams {
	return &DeleteD4CAwsAccountParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteD4CAwsAccountParamsWithTimeout creates a new DeleteD4CAwsAccountParams object
// with the ability to set a timeout on a request.
func NewDeleteD4CAwsAccountParamsWithTimeout(timeout time.Duration) *DeleteD4CAwsAccountParams {
	return &DeleteD4CAwsAccountParams{
		timeout: timeout,
	}
}

// NewDeleteD4CAwsAccountParamsWithContext creates a new DeleteD4CAwsAccountParams object
// with the ability to set a context for a request.
func NewDeleteD4CAwsAccountParamsWithContext(ctx context.Context) *DeleteD4CAwsAccountParams {
	return &DeleteD4CAwsAccountParams{
		Context: ctx,
	}
}

// NewDeleteD4CAwsAccountParamsWithHTTPClient creates a new DeleteD4CAwsAccountParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteD4CAwsAccountParamsWithHTTPClient(client *http.Client) *DeleteD4CAwsAccountParams {
	return &DeleteD4CAwsAccountParams{
		HTTPClient: client,
	}
}

/*
DeleteD4CAwsAccountParams contains all the parameters to send to the API endpoint

	for the delete d4 c aws account operation.

	Typically these are written to a http.Request.
*/
type DeleteD4CAwsAccountParams struct {

	/* Ids.

	   AWS account IDs to remove
	*/
	Ids []string

	/* OrganizationIds.

	   AWS organization IDs to remove
	*/
	OrganizationIds []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete d4 c aws account params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteD4CAwsAccountParams) WithDefaults() *DeleteD4CAwsAccountParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete d4 c aws account params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteD4CAwsAccountParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete d4 c aws account params
func (o *DeleteD4CAwsAccountParams) WithTimeout(timeout time.Duration) *DeleteD4CAwsAccountParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete d4 c aws account params
func (o *DeleteD4CAwsAccountParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete d4 c aws account params
func (o *DeleteD4CAwsAccountParams) WithContext(ctx context.Context) *DeleteD4CAwsAccountParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete d4 c aws account params
func (o *DeleteD4CAwsAccountParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete d4 c aws account params
func (o *DeleteD4CAwsAccountParams) WithHTTPClient(client *http.Client) *DeleteD4CAwsAccountParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete d4 c aws account params
func (o *DeleteD4CAwsAccountParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the delete d4 c aws account params
func (o *DeleteD4CAwsAccountParams) WithIds(ids []string) *DeleteD4CAwsAccountParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the delete d4 c aws account params
func (o *DeleteD4CAwsAccountParams) SetIds(ids []string) {
	o.Ids = ids
}

// WithOrganizationIds adds the organizationIds to the delete d4 c aws account params
func (o *DeleteD4CAwsAccountParams) WithOrganizationIds(organizationIds []string) *DeleteD4CAwsAccountParams {
	o.SetOrganizationIds(organizationIds)
	return o
}

// SetOrganizationIds adds the organizationIds to the delete d4 c aws account params
func (o *DeleteD4CAwsAccountParams) SetOrganizationIds(organizationIds []string) {
	o.OrganizationIds = organizationIds
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteD4CAwsAccountParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if o.OrganizationIds != nil {

		// binding items for organization-ids
		joinedOrganizationIds := o.bindParamOrganizationIds(reg)

		// query array param organization-ids
		if err := r.SetQueryParam("organization-ids", joinedOrganizationIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDeleteD4CAwsAccount binds the parameter ids
func (o *DeleteD4CAwsAccountParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}

// bindParamDeleteD4CAwsAccount binds the parameter organization-ids
func (o *DeleteD4CAwsAccountParams) bindParamOrganizationIds(formats strfmt.Registry) []string {
	organizationIdsIR := o.OrganizationIds

	var organizationIdsIC []string
	for _, organizationIdsIIR := range organizationIdsIR { // explode []string

		organizationIdsIIV := organizationIdsIIR // string as string
		organizationIdsIC = append(organizationIdsIC, organizationIdsIIV)
	}

	// items.CollectionFormat: "multi"
	organizationIdsIS := swag.JoinByFormat(organizationIdsIC, "multi")

	return organizationIdsIS
}
