// Code generated by go-swagger; DO NOT EDIT.

package d4c_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetD4CAwsAccountParams creates a new GetD4CAwsAccountParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetD4CAwsAccountParams() *GetD4CAwsAccountParams {
	return &GetD4CAwsAccountParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetD4CAwsAccountParamsWithTimeout creates a new GetD4CAwsAccountParams object
// with the ability to set a timeout on a request.
func NewGetD4CAwsAccountParamsWithTimeout(timeout time.Duration) *GetD4CAwsAccountParams {
	return &GetD4CAwsAccountParams{
		timeout: timeout,
	}
}

// NewGetD4CAwsAccountParamsWithContext creates a new GetD4CAwsAccountParams object
// with the ability to set a context for a request.
func NewGetD4CAwsAccountParamsWithContext(ctx context.Context) *GetD4CAwsAccountParams {
	return &GetD4CAwsAccountParams{
		Context: ctx,
	}
}

// NewGetD4CAwsAccountParamsWithHTTPClient creates a new GetD4CAwsAccountParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetD4CAwsAccountParamsWithHTTPClient(client *http.Client) *GetD4CAwsAccountParams {
	return &GetD4CAwsAccountParams{
		HTTPClient: client,
	}
}

/*
GetD4CAwsAccountParams contains all the parameters to send to the API endpoint

	for the get d4 c aws account operation.

	Typically these are written to a http.Request.
*/
type GetD4CAwsAccountParams struct {

	/* Ids.

	   AWS account IDs
	*/
	Ids []string

	/* Limit.

	   The maximum records to return. Defaults to 100.

	   Default: 100
	*/
	Limit *int64

	/* Migrated.

	   Only return migrated d4c accounts
	*/
	Migrated *string

	/* Offset.

	   The offset to start retrieving records from
	*/
	Offset *int64

	/* OrganizationIds.

	   AWS organization IDs
	*/
	OrganizationIds []string

	/* ScanType.

	   Type of scan, dry or full, to perform on selected accounts
	*/
	ScanType *string

	/* Status.

	   Account status to filter results by.
	*/
	Status *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get d4 c aws account params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetD4CAwsAccountParams) WithDefaults() *GetD4CAwsAccountParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get d4 c aws account params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetD4CAwsAccountParams) SetDefaults() {
	var (
		limitDefault = int64(100)
	)

	val := GetD4CAwsAccountParams{
		Limit: &limitDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) WithTimeout(timeout time.Duration) *GetD4CAwsAccountParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) WithContext(ctx context.Context) *GetD4CAwsAccountParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) WithHTTPClient(client *http.Client) *GetD4CAwsAccountParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) WithIds(ids []string) *GetD4CAwsAccountParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) SetIds(ids []string) {
	o.Ids = ids
}

// WithLimit adds the limit to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) WithLimit(limit *int64) *GetD4CAwsAccountParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithMigrated adds the migrated to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) WithMigrated(migrated *string) *GetD4CAwsAccountParams {
	o.SetMigrated(migrated)
	return o
}

// SetMigrated adds the migrated to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) SetMigrated(migrated *string) {
	o.Migrated = migrated
}

// WithOffset adds the offset to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) WithOffset(offset *int64) *GetD4CAwsAccountParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithOrganizationIds adds the organizationIds to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) WithOrganizationIds(organizationIds []string) *GetD4CAwsAccountParams {
	o.SetOrganizationIds(organizationIds)
	return o
}

// SetOrganizationIds adds the organizationIds to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) SetOrganizationIds(organizationIds []string) {
	o.OrganizationIds = organizationIds
}

// WithScanType adds the scanType to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) WithScanType(scanType *string) *GetD4CAwsAccountParams {
	o.SetScanType(scanType)
	return o
}

// SetScanType adds the scanType to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) SetScanType(scanType *string) {
	o.ScanType = scanType
}

// WithStatus adds the status to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) WithStatus(status *string) *GetD4CAwsAccountParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the get d4 c aws account params
func (o *GetD4CAwsAccountParams) SetStatus(status *string) {
	o.Status = status
}

// WriteToRequest writes these params to a swagger request
func (o *GetD4CAwsAccountParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Migrated != nil {

		// query param migrated
		var qrMigrated string

		if o.Migrated != nil {
			qrMigrated = *o.Migrated
		}
		qMigrated := qrMigrated
		if qMigrated != "" {

			if err := r.SetQueryParam("migrated", qMigrated); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.OrganizationIds != nil {

		// binding items for organization-ids
		joinedOrganizationIds := o.bindParamOrganizationIds(reg)

		// query array param organization-ids
		if err := r.SetQueryParam("organization-ids", joinedOrganizationIds...); err != nil {
			return err
		}
	}

	if o.ScanType != nil {

		// query param scan-type
		var qrScanType string

		if o.ScanType != nil {
			qrScanType = *o.ScanType
		}
		qScanType := qrScanType
		if qScanType != "" {

			if err := r.SetQueryParam("scan-type", qScanType); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetD4CAwsAccount binds the parameter ids
func (o *GetD4CAwsAccountParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}

// bindParamGetD4CAwsAccount binds the parameter organization-ids
func (o *GetD4CAwsAccountParams) bindParamOrganizationIds(formats strfmt.Registry) []string {
	organizationIdsIR := o.OrganizationIds

	var organizationIdsIC []string
	for _, organizationIdsIIR := range organizationIdsIR { // explode []string

		organizationIdsIIV := organizationIdsIIR // string as string
		organizationIdsIC = append(organizationIdsIC, organizationIdsIIV)
	}

	// items.CollectionFormat: "multi"
	organizationIdsIS := swag.JoinByFormat(organizationIdsIC, "multi")

	return organizationIdsIS
}
