// Code generated by go-swagger; DO NOT EDIT.

package d4c_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetD4CAwsAccountReader is a Reader for the GetD4CAwsAccount structure.
type GetD4CAwsAccountReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetD4CAwsAccountReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetD4CAwsAccountOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetD4CAwsAccountMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetD4CAwsAccountBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetD4CAwsAccountForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetD4CAwsAccountTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetD4CAwsAccountInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloud-connect-aws/entities/account/v2] GetD4CAwsAccount", response, response.Code())
	}
}

// NewGetD4CAwsAccountOK creates a GetD4CAwsAccountOK with default headers values
func NewGetD4CAwsAccountOK() *GetD4CAwsAccountOK {
	return &GetD4CAwsAccountOK{}
}

/*
GetD4CAwsAccountOK describes a response with status code 200, with default header values.

OK
*/
type GetD4CAwsAccountOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountResponseV2
}

// IsSuccess returns true when this get d4 c aws account o k response has a 2xx status code
func (o *GetD4CAwsAccountOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get d4 c aws account o k response has a 3xx status code
func (o *GetD4CAwsAccountOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get d4 c aws account o k response has a 4xx status code
func (o *GetD4CAwsAccountOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get d4 c aws account o k response has a 5xx status code
func (o *GetD4CAwsAccountOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get d4 c aws account o k response a status code equal to that given
func (o *GetD4CAwsAccountOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get d4 c aws account o k response
func (o *GetD4CAwsAccountOK) Code() int {
	return 200
}

func (o *GetD4CAwsAccountOK) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/account/v2][%d] getD4CAwsAccountOK  %+v", 200, o.Payload)
}

func (o *GetD4CAwsAccountOK) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/account/v2][%d] getD4CAwsAccountOK  %+v", 200, o.Payload)
}

func (o *GetD4CAwsAccountOK) GetPayload() *models.RegistrationAWSAccountResponseV2 {
	return o.Payload
}

func (o *GetD4CAwsAccountOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountResponseV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetD4CAwsAccountMultiStatus creates a GetD4CAwsAccountMultiStatus with default headers values
func NewGetD4CAwsAccountMultiStatus() *GetD4CAwsAccountMultiStatus {
	return &GetD4CAwsAccountMultiStatus{}
}

/*
GetD4CAwsAccountMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetD4CAwsAccountMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountResponseV2
}

// IsSuccess returns true when this get d4 c aws account multi status response has a 2xx status code
func (o *GetD4CAwsAccountMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get d4 c aws account multi status response has a 3xx status code
func (o *GetD4CAwsAccountMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get d4 c aws account multi status response has a 4xx status code
func (o *GetD4CAwsAccountMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get d4 c aws account multi status response has a 5xx status code
func (o *GetD4CAwsAccountMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get d4 c aws account multi status response a status code equal to that given
func (o *GetD4CAwsAccountMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get d4 c aws account multi status response
func (o *GetD4CAwsAccountMultiStatus) Code() int {
	return 207
}

func (o *GetD4CAwsAccountMultiStatus) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/account/v2][%d] getD4CAwsAccountMultiStatus  %+v", 207, o.Payload)
}

func (o *GetD4CAwsAccountMultiStatus) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/account/v2][%d] getD4CAwsAccountMultiStatus  %+v", 207, o.Payload)
}

func (o *GetD4CAwsAccountMultiStatus) GetPayload() *models.RegistrationAWSAccountResponseV2 {
	return o.Payload
}

func (o *GetD4CAwsAccountMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountResponseV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetD4CAwsAccountBadRequest creates a GetD4CAwsAccountBadRequest with default headers values
func NewGetD4CAwsAccountBadRequest() *GetD4CAwsAccountBadRequest {
	return &GetD4CAwsAccountBadRequest{}
}

/*
GetD4CAwsAccountBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetD4CAwsAccountBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountResponseV2
}

// IsSuccess returns true when this get d4 c aws account bad request response has a 2xx status code
func (o *GetD4CAwsAccountBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get d4 c aws account bad request response has a 3xx status code
func (o *GetD4CAwsAccountBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get d4 c aws account bad request response has a 4xx status code
func (o *GetD4CAwsAccountBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get d4 c aws account bad request response has a 5xx status code
func (o *GetD4CAwsAccountBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get d4 c aws account bad request response a status code equal to that given
func (o *GetD4CAwsAccountBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get d4 c aws account bad request response
func (o *GetD4CAwsAccountBadRequest) Code() int {
	return 400
}

func (o *GetD4CAwsAccountBadRequest) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/account/v2][%d] getD4CAwsAccountBadRequest  %+v", 400, o.Payload)
}

func (o *GetD4CAwsAccountBadRequest) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/account/v2][%d] getD4CAwsAccountBadRequest  %+v", 400, o.Payload)
}

func (o *GetD4CAwsAccountBadRequest) GetPayload() *models.RegistrationAWSAccountResponseV2 {
	return o.Payload
}

func (o *GetD4CAwsAccountBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountResponseV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetD4CAwsAccountForbidden creates a GetD4CAwsAccountForbidden with default headers values
func NewGetD4CAwsAccountForbidden() *GetD4CAwsAccountForbidden {
	return &GetD4CAwsAccountForbidden{}
}

/*
GetD4CAwsAccountForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetD4CAwsAccountForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get d4 c aws account forbidden response has a 2xx status code
func (o *GetD4CAwsAccountForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get d4 c aws account forbidden response has a 3xx status code
func (o *GetD4CAwsAccountForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get d4 c aws account forbidden response has a 4xx status code
func (o *GetD4CAwsAccountForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get d4 c aws account forbidden response has a 5xx status code
func (o *GetD4CAwsAccountForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get d4 c aws account forbidden response a status code equal to that given
func (o *GetD4CAwsAccountForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get d4 c aws account forbidden response
func (o *GetD4CAwsAccountForbidden) Code() int {
	return 403
}

func (o *GetD4CAwsAccountForbidden) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/account/v2][%d] getD4CAwsAccountForbidden  %+v", 403, o.Payload)
}

func (o *GetD4CAwsAccountForbidden) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/account/v2][%d] getD4CAwsAccountForbidden  %+v", 403, o.Payload)
}

func (o *GetD4CAwsAccountForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetD4CAwsAccountForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetD4CAwsAccountTooManyRequests creates a GetD4CAwsAccountTooManyRequests with default headers values
func NewGetD4CAwsAccountTooManyRequests() *GetD4CAwsAccountTooManyRequests {
	return &GetD4CAwsAccountTooManyRequests{}
}

/*
GetD4CAwsAccountTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetD4CAwsAccountTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get d4 c aws account too many requests response has a 2xx status code
func (o *GetD4CAwsAccountTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get d4 c aws account too many requests response has a 3xx status code
func (o *GetD4CAwsAccountTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get d4 c aws account too many requests response has a 4xx status code
func (o *GetD4CAwsAccountTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get d4 c aws account too many requests response has a 5xx status code
func (o *GetD4CAwsAccountTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get d4 c aws account too many requests response a status code equal to that given
func (o *GetD4CAwsAccountTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get d4 c aws account too many requests response
func (o *GetD4CAwsAccountTooManyRequests) Code() int {
	return 429
}

func (o *GetD4CAwsAccountTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/account/v2][%d] getD4CAwsAccountTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetD4CAwsAccountTooManyRequests) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/account/v2][%d] getD4CAwsAccountTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetD4CAwsAccountTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetD4CAwsAccountTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetD4CAwsAccountInternalServerError creates a GetD4CAwsAccountInternalServerError with default headers values
func NewGetD4CAwsAccountInternalServerError() *GetD4CAwsAccountInternalServerError {
	return &GetD4CAwsAccountInternalServerError{}
}

/*
GetD4CAwsAccountInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetD4CAwsAccountInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountResponseV2
}

// IsSuccess returns true when this get d4 c aws account internal server error response has a 2xx status code
func (o *GetD4CAwsAccountInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get d4 c aws account internal server error response has a 3xx status code
func (o *GetD4CAwsAccountInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get d4 c aws account internal server error response has a 4xx status code
func (o *GetD4CAwsAccountInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get d4 c aws account internal server error response has a 5xx status code
func (o *GetD4CAwsAccountInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get d4 c aws account internal server error response a status code equal to that given
func (o *GetD4CAwsAccountInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get d4 c aws account internal server error response
func (o *GetD4CAwsAccountInternalServerError) Code() int {
	return 500
}

func (o *GetD4CAwsAccountInternalServerError) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/account/v2][%d] getD4CAwsAccountInternalServerError  %+v", 500, o.Payload)
}

func (o *GetD4CAwsAccountInternalServerError) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/account/v2][%d] getD4CAwsAccountInternalServerError  %+v", 500, o.Payload)
}

func (o *GetD4CAwsAccountInternalServerError) GetPayload() *models.RegistrationAWSAccountResponseV2 {
	return o.Payload
}

func (o *GetD4CAwsAccountInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountResponseV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
